/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.common;

import java.util.List;
import java.util.Objects;
import net.brnbrd.delightful.Util;
import net.brnbrd.delightful.common.DelightfulConfig;
import net.brnbrd.delightful.common.block.DelightfulBlocks;
import net.brnbrd.delightful.common.block.SlicedMelonBlock;
import net.brnbrd.delightful.common.block.SlicedPumpkinBlock;
import net.brnbrd.delightful.common.item.DelightfulItems;
import net.brnbrd.delightful.common.item.FurnaceFuelItem;
import net.brnbrd.delightful.compat.Mods;
import net.brnbrd.delightful.data.tags.DelightfulItemTags;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vectorwing.farmersdelight.common.block.PieBlock;
import vectorwing.farmersdelight.common.registry.ModBlocks;

public class ForgeEvents {
    @SubscribeEvent
    void burnTime(FurnaceFuelBurnTimeEvent e) {
        Item item = e.getItemStack().m_41720_();
        if (item instanceof FurnaceFuelItem) {
            FurnaceFuelItem fuel = (FurnaceFuelItem)item;
            e.setBurnTime(fuel.getFuelTime());
        }
    }

    @SubscribeEvent
    void onWanderingTrader(WandererTradesEvent e) {
        List trades = e.getGenericTrades();
        if (Util.enabled(DelightfulItems.SALMONBERRIES) && Util.enabled(DelightfulItems.SALMONBERRY_PIPS)) {
            trades.add((ent, r) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 1), Util.gs(DelightfulItems.SALMONBERRY_PIPS), 5, 1, 1.0f));
        }
        if (Util.enabled(DelightfulItems.CANTALOUPE) && Util.enabled(DelightfulItems.CANTALOUPE_SLICE)) {
            trades.add((ent, r) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 2), new ItemStack((ItemLike)DelightfulItems.CANTALOUPE_SLICE.get(), 8), 5, 1, 1.0f));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    void onInteract(PlayerInteractEvent.RightClickBlock e) {
        Level world = e.getLevel();
        BlockPos pos = e.getPos();
        if (e.getItemStack().m_204117_(DelightfulItemTags.SCAVENGING_TOOLS)) {
            BlockState current = world.m_8055_(pos);
            boolean client = world.m_5776_();
            if (current.m_60734_() == Blocks.f_50186_) {
                SlicedMelonBlock sliced = (SlicedMelonBlock)DelightfulBlocks.SLICED_MELON.get();
                this.slice(sliced.m_49966_(), sliced.getSliceItem(), world, pos, SoundEvents.f_11716_, e, client);
            } else if (current.m_60734_() == Blocks.f_50133_ && !e.getEntity().m_6047_()) {
                SlicedPumpkinBlock sliced = (SlicedPumpkinBlock)DelightfulBlocks.SLICED_PUMPKIN.get();
                this.slice(sliced.m_49966_(), sliced.getSliceItem(), world, pos, SoundEvents.f_11716_, e, client);
            } else if (Mods.loaded("frozenup", "frozen_delight") && Util.name(current.m_60734_()).equals("truffle_cake")) {
                int currentBites = (Integer)current.m_61143_((Property)BlockStateProperties.f_61412_);
                ItemStack slice = Objects.requireNonNull(Util.item("frozen_delight", "truffle_cake_slice")).m_7968_();
                if (currentBites >= 3) {
                    world.m_7471_(pos, false);
                    world.m_142346_((Entity)e.getEntity(), GameEvent.f_157794_, pos);
                    Util.dropOrGive(slice, world, pos, e.getEntity());
                    world.m_5594_(null, pos, SoundEvents.f_12642_, SoundSource.PLAYERS, 0.8f, 0.8f);
                    e.getEntity().m_21120_(e.getHand()).m_41622_(1, (LivingEntity)e.getEntity(), onBroken -> {});
                    e.setCancellationResult(InteractionResult.m_19078_((boolean)client));
                    e.setCanceled(true);
                    return;
                }
                this.slice((BlockState)current.m_61124_((Property)BlockStateProperties.f_61412_, (Comparable)Integer.valueOf(currentBites + 1)), slice, world, pos, SoundEvents.f_12642_, e, client);
            }
        }
    }

    @SubscribeEvent
    void onPieOverhaul(PlayerInteractEvent.RightClickBlock e) {
        ItemStack stack = e.getItemStack();
        if (!stack.m_41619_() && !e.getLevel().m_8055_(e.getHitVec().m_82425_()).m_60713_((Block)ModBlocks.CUTTING_BOARD.get())) {
            if (((Boolean)DelightfulConfig.PUMPKIN_PIE_OVERHAUL.get()).booleanValue() && stack.m_150930_(Items.f_42687_)) {
                this.tryPlacePie((PieBlock)DelightfulBlocks.PUMPKIN_PIE.get(), e);
                return;
            }
            this.ifTryPlace(stack, "ars_nouveau", "source_berry_pie", "source_berry_pie_slice", (PieBlock)DelightfulBlocks.SOURCE_BERRY_PIE.get(), e);
            this.ifTryPlace(stack, "byg", "blueberry_pie", "blueberry_pie_slice", (PieBlock)DelightfulBlocks.BLUEBERRY_PIE.get(), e);
            this.ifTryPlace(stack, "byg", "crimson_berry_pie", "crimson_berry_pie_slice", (PieBlock)DelightfulBlocks.CRIMSON_BERRY_PIE.get(), e);
            this.ifTryPlace(stack, "byg", "green_apple_pie", "green_apple_pie_slice", (PieBlock)DelightfulBlocks.GREEN_APPLE_PIE.get(), e);
            this.ifTryPlace(stack, "byg", "nightshade_berry_pie", "nightshade_berry_pie_slice", (PieBlock)DelightfulBlocks.NIGHTSHADE_BERRY_PIE.get(), e);
        }
    }

    void slice(BlockState block, ItemStack slice, Level world, BlockPos pos, SoundEvent sound, PlayerInteractEvent.RightClickBlock e, boolean client) {
        if (!client) {
            world.m_7731_(pos, block, 2);
            Util.dropOrGive(slice, world, pos, e.getEntity());
            world.m_5594_(null, pos, sound, SoundSource.PLAYERS, 0.8f, 0.8f);
            e.getEntity().m_21120_(e.getHand()).m_41622_(1, (LivingEntity)e.getEntity(), onBroken -> {});
        }
        e.setCancellationResult(InteractionResult.m_19078_((boolean)client));
        e.setCanceled(true);
    }

    void tryPlacePie(PieBlock pie, PlayerInteractEvent.RightClickBlock e) {
        e.setUseItem(Event.Result.DENY);
        e.setUseBlock(Event.Result.DENY);
        if (!e.isCanceled() && this.placePie(pie, new BlockPlaceContext(e.getEntity(), e.getHand(), e.getEntity().m_21120_(e.getHand()), e.getHitVec()))) {
            e.setCancellationResult(InteractionResult.m_19078_((boolean)e.getLevel().m_5776_()));
            e.setCanceled(true);
        }
    }

    boolean placePie(PieBlock pie, BlockPlaceContext context) {
        if (context.m_7059_() && context.m_43725_().m_8055_(context.m_8083_().m_7495_()).m_60767_().m_76333_() && pie.m_5573_(context) != null) {
            BlockState piestate = pie.m_5573_(context);
            if (!context.m_43723_().m_150110_().f_35937_) {
                context.m_43722_().m_41774_(1);
            }
            context.m_43725_().m_7731_(context.m_8083_(), piestate, 2);
            piestate.m_60734_().m_6402_(context.m_43725_(), context.m_8083_(), piestate, (LivingEntity)context.m_43723_(), context.m_43722_());
            context.m_43725_().m_220407_(GameEvent.f_157797_, context.m_8083_(), GameEvent.Context.m_223719_((Entity)context.m_43723_(), (BlockState)piestate));
            context.m_43725_().m_5594_(null, context.m_8083_(), SoundEvents.f_12642_, SoundSource.PLAYERS, 0.8f, 0.8f);
            return true;
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    void onPieOverhaul(PlayerInteractEvent.RightClickItem e) {
        if (this.isCompatPie(e.getItemStack())) {
            e.setCancellationResult(InteractionResult.FAIL);
            e.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    void onPieTooltip(ItemTooltipEvent e) {
        BlockItem b;
        ItemStack stack = e.getItemStack();
        Item item = stack.m_41720_();
        if (item instanceof BlockItem && (b = (BlockItem)item).m_40614_() instanceof PieBlock || this.isCompatPie(stack) || this.isBerryPieOrMuffin(stack)) {
            MutableComponent desc = Component.m_237115_((String)"delightful.placeable.desc").m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC);
            e.getToolTip().add(desc);
        }
    }

    boolean isPie(ItemStack stack, String modid, String pie, String slice) {
        return Mods.loaded(modid) && Util.enabled(slice) && stack.m_150930_(Util.item(modid, pie));
    }

    void ifTryPlace(ItemStack stack, String modid, String pie, String slice, PieBlock pieBlock, PlayerInteractEvent.RightClickBlock e) {
        if (this.isPie(stack, modid, pie, slice)) {
            this.tryPlacePie(pieBlock, e);
        }
    }

    boolean isCompatPie(ItemStack stack) {
        return stack.m_150930_(Items.f_42687_) && (Boolean)DelightfulConfig.PUMPKIN_PIE_OVERHAUL.get() != false || this.isPie(stack, "ars_nouveau", "source_berry_pie", "source_berry_pie_slice") || this.isPie(stack, "byg", "blueberry_pie", "blueberry_pie_slice") || this.isPie(stack, "byg", "crimson_berry_pie", "crimson_berry_pie_slice") || this.isPie(stack, "byg", "green_apple_pie", "green_apple_pie_slice") || this.isPie(stack, "byg", "nightshade_berry_pie", "nightshade_berry_pie_slice");
    }

    boolean isBerryPieOrMuffin(ItemStack stack) {
        return Mods.loaded("wildberries") && (stack.m_204117_(Util.it("wildberries", "berry_pies")) || stack.m_204117_(Util.it("wildberries", "berry_muffins")));
    }
}

