/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.common.network;

import fr.raksrinana.fallingtree.common.FallingTreeCommon;
import fr.raksrinana.fallingtree.common.config.enums.BreakMode;
import fr.raksrinana.fallingtree.common.network.ConfigurationPacket;
import fr.raksrinana.fallingtree.common.wrapper.IFriendlyByteBuf;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PacketUtils {
    private static final Logger log = LogManager.getLogger(PacketUtils.class);
    private final FallingTreeCommon<?> mod;

    @NotNull
    public ConfigurationPacket createConfigurationPacket() {
        return ConfigurationPacket.builder().speedMultiplicand(this.mod.getConfiguration().getTools().getSpeedMultiplicand()).forceToolUsage(this.mod.getConfiguration().getTools().isForceToolUsage()).breakMode(this.mod.getConfiguration().getTrees().getBreakMode()).build();
    }

    public void onClientConfigurationPacket(@NotNull ConfigurationPacket packet) {
        log.info("Received FT configuration packet from server, setting up proxy config values");
        this.mod.getProxyConfiguration().getTools().setSpeedMultiplicand(packet.getSpeedMultiplicand());
        this.mod.getProxyConfiguration().getTools().setForceToolUsage(packet.isForceToolUsage());
        this.mod.getProxyConfiguration().getTrees().setBreakMode(packet.getBreakMode());
    }

    public void encodeConfigurationPacket(@NotNull ConfigurationPacket packet, @NotNull IFriendlyByteBuf buf) {
        buf.writeDouble(packet.getSpeedMultiplicand());
        buf.writeBoolean(packet.isForceToolUsage());
        buf.writeInteger(packet.getBreakMode().ordinal());
    }

    public void onClientDisconnect() {
        log.info("Disconnected from server, resetting proxy config values");
        this.mod.getProxyConfiguration().reset();
    }

    @NotNull
    public ConfigurationPacket decodeConfigurationPacket(@NotNull IFriendlyByteBuf buf) {
        return ConfigurationPacket.builder().speedMultiplicand(buf.readDouble()).forceToolUsage(buf.readBoolean()).breakMode(BreakMode.values()[buf.readInteger()]).build();
    }

    public PacketUtils(FallingTreeCommon<?> mod) {
        this.mod = mod;
    }
}

