/*
 * Decompiled with CFR 0.152.
 */
package net.yezon.theabyss.world.inventory;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.common.Mod;
import net.yezon.theabyss.init.TheabyssModBlocks;
import net.yezon.theabyss.init.TheabyssModMenus;
import net.yezon.theabyss.recipes.AllRecipeTypes;
import net.yezon.theabyss.recipes.impl.MortarAndPestleRecipe;
import net.yezon.theabyss.utils.ContainerAndScreenUtils;
import net.yezon.theabyss.utils.RecipeUtils;
import net.yezon.theabyss.world.inventory.TheAbyssContainerMenu;

@Mod.EventBusSubscriber
public class MortarMenu
extends TheAbyssContainerMenu {
    public static final int CONTAINER_SIZE = 5;
    private final ContainerLevelAccess access;
    private final SimpleContainer craftingContainer;
    private final SimpleContainer resultContainer;
    private final Player player;

    public MortarMenu(int id, Inventory inv) {
        this(id, inv, ContainerLevelAccess.f_39287_);
    }

    public MortarMenu(int id, Inventory inv, ContainerLevelAccess access) {
        super((MenuType)TheabyssModMenus.MORTAR.get(), id);
        this.access = access;
        this.player = inv.f_35978_;
        this.craftingContainer = new SimpleContainer(5){

            public void m_6596_() {
                MortarMenu.this.m_6199_((Container)this);
            }
        };
        this.resultContainer = new SimpleContainer(1){

            public void m_6596_() {
            }
        };
        this.addCraftingSlot(0, 56, 25);
        this.addCraftingSlot(1, 38, 43);
        this.addCraftingSlot(2, 56, 43);
        this.addCraftingSlot(3, 74, 43);
        this.addCraftingSlot(4, 56, 61);
        super.m_38897_(new Slot((Container)this.resultContainer, 0, 134, 43){

            public boolean m_5857_(ItemStack pStack) {
                return false;
            }

            public void m_142406_(Player pPlayer, ItemStack pStack) {
                this.resultTaken();
                super.m_6654_();
            }

            protected void m_7169_(ItemStack pStack, int pAmount) {
            }

            private void resultTaken() {
                TheAbyssContainerMenu.onResultSlotTaken((Container)MortarMenu.this.craftingContainer);
            }
        });
        ContainerAndScreenUtils.addPlayerInventorySlots(this, inv, 8, 101);
    }

    public void m_6199_(Container pContainer) {
        this.access.m_39292_((level, pos) -> this.gridUpdate((Level)level, this.player));
    }

    private void addCraftingSlot(int index, int x, int y) {
        super.m_38897_(new Slot((Container)this.craftingContainer, index, x, y));
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(pPlayer);
        this.access.m_39292_((level, pos) -> this.gridUpdate((Level)level, pPlayer));
    }

    public void gridUpdate(Level level, Player player) {
        if (!level.m_5776_()) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack item = ItemStack.f_41583_;
            MortarAndPestleRecipe recipe = (MortarAndPestleRecipe)RecipeUtils.getRecipeFor(level, AllRecipeTypes.MORTAR_AND_PESTLE, this.craftingContainer);
            if (recipe != null) {
                item = recipe.m_5874_((Container)this.craftingContainer);
            }
            this.resultContainer.m_6836_(0, item);
            super.m_150404_(5, item);
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(this.f_38840_, super.m_182425_(), 5, item));
        }
    }

    public boolean m_6875_(Player player) {
        return MortarMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)TheabyssModBlocks.MORTAR_AND_PESTLE.get()));
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < 6) {
                if (!this.m_38903_(itemstack1, 6, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (!this.m_38903_(itemstack1, 0, 6, false)) {
                if (index < 33 ? !this.m_38903_(itemstack1, 33, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 6, 33, false)) {
                    return ItemStack.f_41583_;
                }
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemstack1);
        }
        return itemstack;
    }
}

