/*
 * Decompiled with CFR 0.152.
 */
package net.yezon.theabyss.utils;

import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.yezon.theabyss.TheabyssMod;
import org.apache.logging.log4j.Logger;

public class DebugUtils {
    private static final Logger LOGGER = TheabyssMod.LOGGER;

    public static void printStackTraceToLog(Throwable exception) {
        LOGGER.error("Exception caught !", exception);
    }

    public static void printStackTrace(StackTraceElement ... traces) {
        LOGGER.info("-------------");
        for (StackTraceElement trace : traces) {
            LOGGER.info(trace.toString());
        }
        LOGGER.info("-------------");
    }

    public static void dumpRecipeInfo(List<Recipe<?>> recipes) {
        TreeMap<RecipeType, Integer> dumpInfo = new TreeMap<RecipeType, Integer>(Comparator.comparing(Object::toString));
        LOGGER.info("----- Recipe Packet Info -----");
        for (Recipe<?> recipe : recipes) {
            dumpInfo.putIfAbsent(recipe.m_6671_(), 1);
            dumpInfo.computeIfPresent(recipe.m_6671_(), (recipeType, integer) -> integer + 1);
        }
        dumpInfo.forEach((recipeType, integer) -> LOGGER.info("Type {} - Loaded {} recipes", (Object)recipeType.toString(), integer));
        LOGGER.info("------------------------------");
    }
}

