/*
 * Decompiled with CFR 0.152.
 */
package net.yezon.theabyss.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModList;
import net.yezon.theabyss.block.entity.base.AbyssContainerBlockEntity;
import net.yezon.theabyss.block.entity.base.TickableBlockEntity;
import net.yezon.theabyss.client.gui.base.TheAbyssContainerScreen;
import net.yezon.theabyss.recipes.AbyssRecipeType;
import net.yezon.theabyss.recipes.RecipeDisplayData;
import net.yezon.theabyss.utils.AccessibleMenuProvider;
import net.yezon.theabyss.world.inventory.TheAbyssContainerMenu;

public class ContainerAndScreenUtils {
    public static final int FONT_COLOR = -6684724;

    private ContainerAndScreenUtils() {
    }

    public static void drawRightText(PoseStack poseStack, AbstractContainerScreen<?> screen, int cornerX, int cornerY) {
        ContainerAndScreenUtils.drawRightText(poseStack, screen.getMinecraft().f_91062_, screen.m_96636_(), cornerX, cornerY);
    }

    public static void drawRightText(PoseStack poseStack, Font fontDrawer, Component component, int cornerX, int cornerY) {
        FormattedCharSequence visualText = component.m_7532_();
        int titleLength = fontDrawer.m_92724_(visualText);
        fontDrawer.m_92877_(poseStack, visualText, (float)(cornerX - titleLength), (float)cornerY, -6684724);
    }

    public static void drawGuiItem(AbstractContainerScreen<?> screen, ItemLike icon, int x, int y) {
        screen.getMinecraft().m_91291_().m_115123_(new ItemStack(icon), screen.getGuiLeft() + x, screen.getGuiTop() + y);
    }

    public static ContainerLevelAccess createLevelAccess(@Nullable BlockEntity blockEntity) {
        return blockEntity == null ? ContainerLevelAccess.f_39287_ : (blockEntity.m_58904_() != null ? ContainerLevelAccess.m_39289_((Level)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_()) : ContainerLevelAccess.f_39287_);
    }

    public static void drawRecipeViewBox(AbstractContainerScreen<?> screen, PoseStack poseStack, AbyssRecipeType recipeType, int uOffset, int vOffset) {
        RecipeDisplayData.RecipeViewHolder holder = recipeType.getDisplayData().recipeViewArea();
        if (holder != null) {
            ContainerAndScreenUtils.drawRecipeViewBox(screen, poseStack, holder.x(), holder.y(), uOffset, vOffset, holder.width(), holder.height());
        }
    }

    public static void drawRecipeViewBox(AbstractContainerScreen<?> screen, PoseStack poseStack, int x, int y, int uOffset, int vOffset, int width, int height) {
        boolean isJeiInstalled = ModList.get().isLoaded("jei");
        if (isJeiInstalled) {
            int xPos = screen.getGuiLeft() + x;
            int yPos = screen.getGuiTop() + y;
            screen.m_93228_(poseStack, xPos, yPos, uOffset, vOffset, width, height);
            ContainerAndScreenUtils.drawGuiItem(screen, (ItemLike)Items.f_42750_, x + 2, y + 2);
        }
    }

    @Deprecated
    public static <T extends AbyssContainerBlockEntity> InteractionResult tryOpenContainer(Level pLevel, Player pPlayer, BlockPos pos, BlockState state, BiFunction<BlockPos, BlockState, T> containerProvider) {
        if (!pLevel.m_5776_()) {
            pPlayer.m_5893_((MenuProvider)containerProvider.apply(pos, state));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public static <T extends BlockEntity> BlockEntityTicker<T> getSidedTicker(Level pLevel) {
        return pLevel.m_5776_() ? TickableBlockEntity::staticClientTick : TickableBlockEntity::staticServerTick;
    }

    public static Slot createFilteredSlot(Container container, int index, int x, int y, final Predicate<ItemStack> filtered) {
        return new Slot(container, index, x, y){

            public boolean m_5857_(ItemStack pStack) {
                return filtered.test(pStack);
            }
        };
    }

    public static Slot createResultSlot(Container container, int index, int x, int y) {
        return new Slot(container, index, x, y){

            public boolean m_5857_(ItemStack pStack) {
                return false;
            }
        };
    }

    public static void addPlayerInventorySlots(TheAbyssContainerMenu menu, Inventory inv, int x, int y) {
        int si;
        for (si = 0; si < 3; ++si) {
            for (int sj = 0; sj < 9; ++sj) {
                menu.m_38897_(new Slot((Container)inv, sj + (si + 1) * 9, x + sj * 18, y + si * 18));
            }
        }
        for (si = 0; si < 9; ++si) {
            menu.m_38897_(new Slot((Container)inv, si, x + si * 18, y + 58));
        }
        menu.setInventoryLabel(x, y - 10);
    }

    public static <T extends AbstractContainerMenu> MenuProvider createMenuProvider(final Component displayName, final ContainerLevelAccess access, final AccessibleMenuProvider<T> menuProvider) {
        return new MenuProvider(){

            public Component m_5446_() {
                return displayName;
            }

            public T m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
                return menuProvider.createMenu(pContainerId, pPlayerInventory, access);
            }
        };
    }

    public static void setupContainerScreen(AbstractContainerScreen<?> screen, PoseStack poseStack, ResourceLocation resourceLocation, int width, int height) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)resourceLocation);
        screen.m_93228_(poseStack, screen.getGuiLeft(), screen.getGuiTop(), 0, 0, width, height);
        if (screen instanceof TheAbyssContainerScreen) {
            TheAbyssContainerScreen containerScreen = (TheAbyssContainerScreen)screen;
            containerScreen.setTitleLabelCornerPosition(width);
        }
    }
}

