/*
 * Decompiled with CFR 0.152.
 */
package net.yezon.theabyss.recipes;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.yezon.theabyss.TheabyssMod;
import net.yezon.theabyss.recipes.AllRecipeTypes;
import net.yezon.theabyss.recipes.RecipeDisplayData;

public class AbyssRecipeType {
    public static final DeferredRegister<RecipeType<?>> TYPE_REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)"theabyss");
    public static final DeferredRegister<RecipeSerializer<?>> SERIALIZER_REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"theabyss");
    private final ResourceLocation id;
    private final RecipeDisplayData data;
    private final RegistryObject<RecipeType<Recipe<Container>>> recipeType;
    private final Class<? extends Recipe<Container>> recipeClass;
    private final Component recipeTitle;
    private final RegistryObject<RecipeSerializer<? extends Recipe<Container>>> serializer;

    public AbyssRecipeType(String name, Supplier<RecipeSerializer<? extends Recipe<Container>>> serializer, Class<? extends Recipe<Container>> recipeClass, Component recipeTitle, RecipeDisplayData displayData) {
        this.id = new ResourceLocation("theabyss", name);
        this.recipeType = TYPE_REGISTRY.register(name, () -> RecipeType.simple((ResourceLocation)this.getId()));
        this.recipeClass = recipeClass;
        this.recipeTitle = recipeTitle;
        this.serializer = SERIALIZER_REGISTRY.register(name, serializer);
        this.data = displayData;
        AllRecipeTypes.ALL_RECIPE_TYPES.add(this);
    }

    public static void registerBus(IEventBus bus) {
        TYPE_REGISTRY.register(bus);
        SERIALIZER_REGISTRY.register(bus);
        AllRecipeTypes.staticInit();
    }

    public final RecipeType<Recipe<Container>> getVanillaType() {
        return (RecipeType)this.recipeType.get();
    }

    public final RecipeSerializer<? extends Recipe<Container>> getSerializer() {
        return (RecipeSerializer)this.serializer.get();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public RecipeDisplayData getDisplayData() {
        return this.data;
    }

    public Class<? extends Recipe<Container>> getRecipeClass() {
        return this.recipeClass;
    }

    public Component getRecipeTitle() {
        return this.recipeTitle;
    }

    public List<Recipe<Container>> getAllRecipes(Level level) {
        List list = level.m_7465_().m_44013_(this.getVanillaType());
        TheabyssMod.LOGGER.info("Gathering [{}] recipes for type [{}]", (Object)list.size(), (Object)this.getId());
        return list;
    }
}

