/*
 * Decompiled with CFR 0.152.
 */
package net.yezon.theabyss.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.yezon.theabyss.TheabyssMod;
import net.yezon.theabyss.eventhandlers.GiveRingOfFartEventHandler;
import net.yezon.theabyss.eventhandlers.GiveRingOfFireworkEventHandler;
import net.yezon.theabyss.eventhandlers.PXCreativeEventHandler;
import net.yezon.theabyss.eventhandlers.PXOpSwordEventHandler;
import net.yezon.theabyss.eventhandlers.PXSpectatorEventHandler;
import net.yezon.theabyss.eventhandlers.PXSurvivalEventHandler;
import net.yezon.theabyss.eventhandlers.PatreonDeathParticleEventHandler;
import net.yezon.theabyss.eventhandlers.PatreonFireworkOnJoinEventHandler;
import net.yezon.theabyss.eventhandlers.PatreonGetDisc1EventHandler;
import net.yezon.theabyss.eventhandlers.PatreonGetDisc2EventHandler;
import net.yezon.theabyss.eventhandlers.PatreonWalkParticlesEventHandler;
import net.yezon.theabyss.world.inventory.PatreonScreenMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PatreonScreenButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public PatreonScreenButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public PatreonScreenButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(PatreonScreenButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(PatreonScreenButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            PatreonScreenButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = PatreonScreenMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            PatreonGetDisc1EventHandler.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 1) {
            PatreonGetDisc2EventHandler.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            PatreonFireworkOnJoinEventHandler.execute((Entity)entity);
        }
        if (buttonID == 3) {
            PatreonDeathParticleEventHandler.execute((Entity)entity);
        }
        if (buttonID == 4) {
            GiveRingOfFireworkEventHandler.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 5) {
            PatreonWalkParticlesEventHandler.execute((Entity)entity);
        }
        if (buttonID == 6) {
            GiveRingOfFartEventHandler.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 7) {
            PXCreativeEventHandler.execute((Entity)entity);
        }
        if (buttonID == 8) {
            PXSurvivalEventHandler.execute((Entity)entity);
        }
        if (buttonID == 9) {
            PXSpectatorEventHandler.execute((Entity)entity);
        }
        if (buttonID == 10) {
            PXOpSwordEventHandler.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        TheabyssMod.addNetworkMessage(PatreonScreenButtonMessage.class, PatreonScreenButtonMessage::buffer, PatreonScreenButtonMessage::new, PatreonScreenButtonMessage::handler);
    }
}

