/*
 * Decompiled with CFR 0.152.
 */
package net.yezon.theabyss.data.recipes.recipebuilders;

import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.yezon.theabyss.TheabyssMod;
import net.yezon.theabyss.data.recipes.recipebuilders.TheAbyssRecipeBuilder;
import net.yezon.theabyss.init.TheabyssModBlocks;
import net.yezon.theabyss.recipes.AllRecipeTypes;
import net.yezon.theabyss.recipes.impl.ArcaneStationRecipe;
import net.yezon.theabyss.utils.RecipeUtils;

public class ArcaneCraftingRecipeBuilder
extends TheAbyssRecipeBuilder {
    private final ArcaneStationRecipe.RecipeMode shape;
    private final List<Ingredient> ingredients;
    private final Ingredient center;

    public ArcaneCraftingRecipeBuilder(ArcaneStationRecipe.RecipeMode shape, List<Ingredient> ingredients, Ingredient center, ItemStack result) {
        super(result, AllRecipeTypes.ARCANE_CRAFTING);
        this.shape = shape;
        this.ingredients = ingredients;
        this.center = center;
        super.m_126132_("on_arcane_table_crafted", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)TheabyssModBlocks.ARCANE_WORKBENCH.get()}));
    }

    public static void buildHalf(Consumer<FinishedRecipe> finishedRecipe, @Nullable ResourceLocation recipeId, ItemStack result, ItemLike center, ItemLike ingredient1, ItemLike ingredient2) {
        ResourceLocation alternativeId = TheabyssMod.location((recipeId != null ? recipeId.m_135815_() : RecipeUtils.getItemId(result).m_135815_()) + "_mirrored");
        ArcaneCraftingRecipeBuilder.build(finishedRecipe, alternativeId, result, center, ArcaneStationRecipe.RecipeMode.HALF, ingredient2, ingredient1);
        ArcaneCraftingRecipeBuilder.build(finishedRecipe, recipeId, result, center, ArcaneStationRecipe.RecipeMode.HALF, ingredient1, ingredient2);
    }

    public static void buildFullCircle(Consumer<FinishedRecipe> consumer, @Nullable ResourceLocation recipeId, ItemStack result, ItemLike center, ItemLike ingredient) {
        ArcaneCraftingRecipeBuilder.build(consumer, recipeId, result, center, ArcaneStationRecipe.RecipeMode.FILL, ingredient);
    }

    public static void buildTwoInputs(Consumer<FinishedRecipe> finishedRecipe, @Nullable ResourceLocation recipeId, ItemStack result, ItemLike center, ItemLike ingredient1, ItemLike ingredient2) {
        ResourceLocation alternativeId = TheabyssMod.location((recipeId != null ? recipeId.m_135815_() : RecipeUtils.getItemId(result).m_135815_()) + "_mirrored");
        ArcaneCraftingRecipeBuilder.build(finishedRecipe, alternativeId, result, center, ArcaneStationRecipe.RecipeMode.TWO_INGREDIENTS, ingredient2, ingredient1);
        ArcaneCraftingRecipeBuilder.build(finishedRecipe, recipeId, result, center, ArcaneStationRecipe.RecipeMode.TWO_INGREDIENTS, ingredient1, ingredient2);
    }

    public static void build(Consumer<FinishedRecipe> consumer, @Nullable ResourceLocation recipeId, ItemStack result, ItemLike center, ItemLike ... ingredients) {
        ArcaneCraftingRecipeBuilder.build(consumer, recipeId, result, center, ArcaneStationRecipe.RecipeMode.NONE, ingredients);
    }

    private static void build(Consumer<FinishedRecipe> consumer, @Nullable ResourceLocation recipeId, ItemStack result, ItemLike center, ArcaneStationRecipe.RecipeMode shape, ItemLike ... ingredients) {
        ArcaneCraftingRecipeBuilder recipeBuilder = new ArcaneCraftingRecipeBuilder(shape, Arrays.stream(ingredients).map(xva$0 -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{xva$0})).toList(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{center}), result);
        ArcaneCraftingRecipeBuilder.saveRecipe(recipeBuilder, consumer, recipeId);
    }

    @Override
    protected void toJson(JsonObject jsonObject) {
        jsonObject.add("core", this.center.m_43942_());
        this.shape.toJson(jsonObject, this.ingredients);
    }
}

