/*
 * Decompiled with CFR 0.152.
 */
package net.yezon.theabyss.compat.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.yezon.theabyss.TheabyssMod;
import net.yezon.theabyss.recipes.AbyssRecipeType;
import net.yezon.theabyss.recipes.RecipeDisplayData;
import oshi.util.tuples.Pair;

public class TheAbyssRecipeCategory
implements IRecipeCategory<Recipe<Container>> {
    public static final Map<AbyssRecipeType, TheAbyssRecipeCategory> CATEGORY_MAP = new HashMap<AbyssRecipeType, TheAbyssRecipeCategory>();
    private final RecipeType<Recipe<Container>> jeiRecipeType;
    private final AbyssRecipeType abyssRecipeType;
    private final IDrawableStatic background;
    private final IDrawable icon;
    private final List<Pair<Integer, Integer>> ingredientMapping;
    private final RecipeDisplayData recipeViewData;
    @Nullable
    private final IDrawableAnimated drawableAnimated;
    private int animateOffsetX = 0;
    private int animateOffsetY = 0;

    public TheAbyssRecipeCategory(IGuiHelper guiHelper, AbyssRecipeType abyssRecipeType) {
        this.jeiRecipeType = new RecipeType(abyssRecipeType.getId(), abyssRecipeType.getRecipeClass());
        this.abyssRecipeType = abyssRecipeType;
        this.recipeViewData = abyssRecipeType.getDisplayData();
        this.background = guiHelper.createDrawable(abyssRecipeType.getDisplayData().jeiPngName(), 0, 0, this.recipeViewData.width(), this.recipeViewData.height());
        this.icon = guiHelper.createDrawableItemStack(new ItemStack(this.recipeViewData.tabIcon().get()));
        this.ingredientMapping = this.recipeViewData.ingredientMapping();
        if (abyssRecipeType.getDisplayData().animatedDrawable() != null) {
            RecipeDisplayData.AnimatedDrawableBuilder builder = abyssRecipeType.getDisplayData().animatedDrawable();
            IDrawableStatic drawableStatic = guiHelper.createDrawable(abyssRecipeType.getDisplayData().jeiPngName(), builder.u(), builder.v(), builder.width(), builder.height());
            this.drawableAnimated = guiHelper.createAnimatedDrawable(drawableStatic, builder.tickPerCycle(), TheAbyssRecipeCategory.startDirection(builder.from()), builder.inverted());
            this.animateOffsetX = builder.x();
            this.animateOffsetY = builder.y();
        } else {
            this.drawableAnimated = null;
        }
        CATEGORY_MAP.put(abyssRecipeType, this);
        TheabyssMod.LOGGER.info("Registering JEI recipe tab for [{}]", (Object)abyssRecipeType.getId());
    }

    private static IDrawableAnimated.StartDirection startDirection(RecipeDisplayData.AnimatedDrawableBuilder.StartFrom from) {
        return IDrawableAnimated.StartDirection.valueOf((String)from.name().toUpperCase(Locale.ROOT));
    }

    public void draw(Recipe<Container> recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        if (this.drawableAnimated != null) {
            this.drawableAnimated.draw(stack, this.animateOffsetX, this.animateOffsetY);
        }
    }

    public RecipeType<Recipe<Container>> getRecipeType() {
        return this.jeiRecipeType;
    }

    public Component getTitle() {
        return this.abyssRecipeType.getRecipeTitle();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, Recipe<Container> recipe, IFocusGroup focuses) {
        for (int i = 0; i < this.ingredientMapping.size(); ++i) {
            Pair<Integer, Integer> position = this.ingredientMapping.get(i);
            builder.addSlot(RecipeIngredientRole.INPUT, ((Integer)position.getA()).intValue(), ((Integer)position.getB()).intValue()).addIngredients((Ingredient)recipe.m_7527_().get(i));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, this.recipeViewData.resultX(), this.recipeViewData.resultY()).addItemStack(recipe.m_8043_());
    }
}

