/*
 * Decompiled with CFR 0.152.
 */
package net.yezon.theabyss.compat.jei;

import java.util.function.Supplier;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.yezon.theabyss.TheabyssMod;
import net.yezon.theabyss.compat.jei.TheAbyssRecipeCategory;
import net.yezon.theabyss.recipes.AbyssRecipeType;
import net.yezon.theabyss.recipes.AllRecipeTypes;
import net.yezon.theabyss.recipes.RecipeDisplayData;

@JeiPlugin
public class TheAbyssJeiPlugin
implements IModPlugin {
    public static final ResourceLocation PLUGIN_ID = TheabyssMod.location("jei_recipes_plugin");
    private final Supplier<ClientLevel> clientLevel = () -> Minecraft.m_91087_().f_91073_;

    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories((IRecipeCategory[])AllRecipeTypes.ALL_RECIPE_TYPES.stream().map(abyssRecipeType -> new TheAbyssRecipeCategory(helper, (AbyssRecipeType)abyssRecipeType)).toArray(TheAbyssRecipeCategory[]::new));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        AllRecipeTypes.ALL_RECIPE_TYPES.forEach(recipeType -> registration.addRecipes(this.getJeiType((AbyssRecipeType)recipeType), recipeType.getAllRecipes((Level)this.clientLevel.get())));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        AllRecipeTypes.ALL_RECIPE_TYPES.forEach(recipeType -> registration.addRecipeCatalyst(new ItemStack(recipeType.getDisplayData().tabIcon().get()), new RecipeType[]{TheAbyssRecipeCategory.CATEGORY_MAP.get(recipeType).getRecipeType()}));
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        for (AbyssRecipeType recipeType : AllRecipeTypes.ALL_RECIPE_TYPES) {
            RecipeType<Recipe<Container>> jeiRecipeType = this.getJeiType(recipeType);
            RecipeDisplayData.RecipeViewHolder holder = recipeType.getDisplayData().recipeViewArea();
            if (holder != null) {
                TheabyssMod.LOGGER.info("Adding recipe view  holder to [{}]", (Object)recipeType.getId());
                registration.addRecipeClickArea(holder.screenClass(), holder.x(), holder.y(), holder.width(), holder.height(), new RecipeType[]{jeiRecipeType});
                continue;
            }
            TheabyssMod.LOGGER.warn("There is no recipe view holder for [{}]", (Object)recipeType.getId());
        }
    }

    private RecipeType<Recipe<Container>> getJeiType(AbyssRecipeType recipeType) {
        return TheAbyssRecipeCategory.CATEGORY_MAP.get(recipeType).getRecipeType();
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        AllRecipeTypes.ALL_RECIPE_TYPES.forEach(recipeType -> {
            RecipeDisplayData.RecipeTransferHolder<? extends AbstractContainerMenu> holder = recipeType.getDisplayData().recipeTransferHolder();
            registration.addRecipeTransferHandler(holder.menuClass(), holder.menuType().get(), this.getJeiType((AbyssRecipeType)recipeType), holder.recipeSlotStart(), holder.recipeSlotCount(), holder.inventorySlotStart(), holder.inventorySlotCount());
        });
    }
}

