/*
 * Decompiled with CFR 0.152.
 */
package cech12.usefulhats.item;

import cech12.usefulhats.UsefulHatsUtils;
import cech12.usefulhats.config.ServerConfig;
import cech12.usefulhats.item.AbstractHatItem;
import cech12.usefulhats.item.HatArmorMaterial;
import cech12.usefulhats.item.IEquipmentChangeListener;
import cech12.usefulhats.item.IItemFishedListener;
import cech12.usefulhats.item.ILivingDropsListener;
import cech12.usefulhats.item.IUsefulHatModelOwner;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;

public class LuckyHatItem
extends AbstractHatItem
implements IItemFishedListener,
ILivingDropsListener,
IEquipmentChangeListener,
IUsefulHatModelOwner {
    private static final int LUCK_DURATION = 219;
    private static final int UNLUCK_AMPLIFIER = 0;
    private static final int UNLUCK_DURATION = 200;

    public LuckyHatItem() {
        super(HatArmorMaterial.LUCKY, LuckyHatItem.rawColorFromRGB(72, 242, 0), ServerConfig.LUCKY_HAT_DAMAGE_ENABLED);
        this.addAllowedEnchantment(Enchantments.f_44953_);
        this.addAllowedEnchantment(Enchantments.f_44982_);
    }

    private boolean isLuckOrUnluckCausedByOtherSource(Player player, ItemStack stack) {
        return this.isEffectCausedByOtherSource((LivingEntity)player, MobEffects.f_19621_, 219, this.getLuckAmplifier(stack)) || this.isEffectCausedByOtherSource((LivingEntity)player, MobEffects.f_19590_, 200, 0);
    }

    private boolean hasHatRelatedItemInHand(Player player) {
        for (ItemStack item : player.m_6167_()) {
            if (!item.canPerformAction(ToolActions.AXE_DIG) && !(item.m_41720_() instanceof FishingRodItem) && !item.canPerformAction(ToolActions.SWORD_SWEEP)) continue;
            return true;
        }
        return false;
    }

    private int getEffectLevel(ItemStack stack) {
        return 1 + EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44982_, (ItemStack)stack) + EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44953_, (ItemStack)stack);
    }

    private int getLuckAmplifier(ItemStack stack) {
        return this.getEffectLevel(stack) - 1;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)Component.m_237110_((String)"item.usefulhats.lucky_hat.desc.luck", (Object[])new Object[]{UsefulHatsUtils.getRomanNumber(this.getEffectLevel(stack), false)}).m_130940_(ChatFormatting.BLUE));
        if (((Boolean)ServerConfig.LUCKY_HAT_UNLUCK_ENABLED.get()).booleanValue()) {
            tooltip.add((Component)Component.m_237115_((String)"item.usefulhats.lucky_hat.desc.unluck").m_130940_(ChatFormatting.RED));
        }
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        if (!world.f_46443_) {
            if (!UsefulHatsUtils.getEquippedHatItemStacks((LivingEntity)player).contains(stack)) {
                return;
            }
            if (this.isLuckOrUnluckCausedByOtherSource(player, stack)) {
                return;
            }
            int luckAmplifier = this.getLuckAmplifier(stack);
            if (this.hasHatRelatedItemInHand(player) && player.m_21124_(MobEffects.f_19590_) == null) {
                if (player.m_21124_(MobEffects.f_19621_) == null || player.f_19797_ % 19 == 0) {
                    this.addEffect((LivingEntity)player, MobEffects.f_19621_, 219, luckAmplifier);
                }
            } else {
                this.removeEffect((LivingEntity)player, MobEffects.f_19621_, 219, luckAmplifier);
            }
        }
    }

    @Override
    public void onItemFishedListener(ItemFishedEvent event, ItemStack headSlotItemStack) {
        Player player = event.getEntity();
        if (this.isLuckOrUnluckCausedByOtherSource(player, headSlotItemStack)) {
            return;
        }
        if (!event.isCanceled() && this.hasHatRelatedItemInHand(event.getEntity())) {
            this.damageHatItemByOne(headSlotItemStack, event.getEntity());
            if (((Boolean)ServerConfig.LUCKY_HAT_UNLUCK_ENABLED.get()).booleanValue()) {
                this.removeEffect((LivingEntity)player, MobEffects.f_19621_, 219, this.getLuckAmplifier(headSlotItemStack));
                this.addEffect((LivingEntity)player, MobEffects.f_19590_, 200, 0);
            }
        }
    }

    @Override
    public void onLivingDropsEvent(LivingDropsEvent event, Player dropReason, ItemStack headSlotItemStack) {
        if (this.isLuckOrUnluckCausedByOtherSource(dropReason, headSlotItemStack)) {
            return;
        }
        if (!event.isCanceled() && this.hasHatRelatedItemInHand(dropReason)) {
            this.damageHatItemByOne(headSlotItemStack, dropReason);
            if (((Boolean)ServerConfig.LUCKY_HAT_UNLUCK_ENABLED.get()).booleanValue()) {
                this.removeEffect((LivingEntity)dropReason, MobEffects.f_19621_, 219, this.getLuckAmplifier(headSlotItemStack));
                this.addEffect((LivingEntity)dropReason, MobEffects.f_19590_, 200, 0);
            }
        }
    }

    @Override
    public void onUnequippedHatItem(LivingEntity entity, ItemStack oldStack) {
        this.removeEffect(entity, MobEffects.f_19621_, 219, this.getLuckAmplifier(oldStack));
    }
}

