/*
 * Decompiled with CFR 0.152.
 */
package cech12.usefulhats.init;

import cech12.usefulhats.UsefulHatsUtils;
import cech12.usefulhats.client.CurioRenderer;
import cech12.usefulhats.compat.CuriosMod;
import cech12.usefulhats.item.AquanautHelmetItem;
import cech12.usefulhats.item.BunnyEarsItem;
import cech12.usefulhats.item.ChoppingHatItem;
import cech12.usefulhats.item.EnderHelmetItem;
import cech12.usefulhats.item.HaloItem;
import cech12.usefulhats.item.IAttackTargetChanger;
import cech12.usefulhats.item.IBreakSpeedChanger;
import cech12.usefulhats.item.IEquipmentChangeListener;
import cech12.usefulhats.item.IGameOverlayRenderer;
import cech12.usefulhats.item.IItemFishedListener;
import cech12.usefulhats.item.IItemUseListener;
import cech12.usefulhats.item.ILivingDropsListener;
import cech12.usefulhats.item.IMobEntityChanger;
import cech12.usefulhats.item.IRightClickListener;
import cech12.usefulhats.item.LuckyHatItem;
import cech12.usefulhats.item.MiningHatItem;
import cech12.usefulhats.item.MushroomHatItem;
import cech12.usefulhats.item.PostmanHatItem;
import cech12.usefulhats.item.ShulkerHelmetItem;
import cech12.usefulhats.item.StockingCapItem;
import cech12.usefulhats.item.StrawHatItem;
import cech12.usefulhats.item.WingHelmetItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.event.CurioChangeEvent;

@Mod.EventBusSubscriber(modid="usefulhats", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"usefulhats");
    public static final RegistryObject<Item> AQUANAUT_HELMET = ITEMS.register("aquanaut_helmet", AquanautHelmetItem::new);
    public static final RegistryObject<Item> BUNNY_EARS = ITEMS.register("bunny_ears", BunnyEarsItem::new);
    public static final RegistryObject<Item> CHOPPING_HAT = ITEMS.register("chopping_hat", ChoppingHatItem::new);
    public static final RegistryObject<Item> ENDER_HELMET = ITEMS.register("ender_helmet", EnderHelmetItem::new);
    public static final RegistryObject<Item> HALO = ITEMS.register("halo", HaloItem::new);
    public static final RegistryObject<Item> LUCKY_HAT = ITEMS.register("lucky_hat", LuckyHatItem::new);
    public static final RegistryObject<Item> MINING_HAT = ITEMS.register("mining_hat", MiningHatItem::new);
    public static final RegistryObject<Item> MUSHROOM_HAT = ITEMS.register("mushroom_hat", MushroomHatItem::new);
    public static final RegistryObject<Item> POSTMAN_HAT = ITEMS.register("postman_hat", PostmanHatItem::new);
    public static final RegistryObject<Item> SHULKER_HELMET = ITEMS.register("shulker_helmet", ShulkerHelmetItem::new);
    public static final RegistryObject<Item> STOCKING_CAP = ITEMS.register("stocking_cap", StockingCapItem::new);
    public static final RegistryObject<Item> STRAW_HAT = ITEMS.register("straw_hat", StrawHatItem::new);
    public static final RegistryObject<Item> WING_HELMET = ITEMS.register("wing_helmet", WingHelmetItem::new);

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerColors(RegisterColorHandlersEvent.Item event) {
        ItemColors itemcolors = event.getItemColors();
        for (RegistryObject item : ITEMS.getEntries()) {
            itemcolors.m_92689_((itemStack, layer) -> layer > 0 ? -1 : ((DyeableLeatherItem)itemStack.m_41720_()).m_41121_(itemStack), new ItemLike[]{(ItemLike)item.get()});
        }
    }

    public static void addEventListeners() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, ModItems::onBreakSpeedEvent);
        MinecraftForge.EVENT_BUS.addListener(ModItems::onBreakEvent);
        MinecraftForge.EVENT_BUS.addListener(ModItems::onEntityJoinWorldEvent);
        MinecraftForge.EVENT_BUS.addListener(ModItems::onItemFishedEvent);
        MinecraftForge.EVENT_BUS.addListener(ModItems::onLivingDropsEvent);
        MinecraftForge.EVENT_BUS.addListener(ModItems::onLivingEquipmentChangeEvent);
        MinecraftForge.EVENT_BUS.addListener(ModItems::onLivingChangeTargetEvent);
        MinecraftForge.EVENT_BUS.addListener(ModItems::onLivingUseItemEvent);
        MinecraftForge.EVENT_BUS.addListener(ModItems::onRightClickItemEvent);
        if (CuriosMod.isLoaded()) {
            MinecraftForge.EVENT_BUS.addListener(ModItems::onCuriosEquipmentChangeEvent);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setupClient() {
        if (CuriosMod.isLoaded()) {
            for (RegistryObject item : ITEMS.getEntries()) {
                CuriosRendererRegistry.register((Item)((Item)item.get()), CurioRenderer::getInstance);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("aquanaut_helmet_overlay", (gui, mStack, partialTicks, screenWidth, screenHeight) -> {
            if (Minecraft.m_91405_()) {
                gui.setupOverlayRenderState(true, false);
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91074_ != null && mc.f_91066_.m_92176_().m_90612_()) {
                    for (ItemStack headSlotItemStack : UsefulHatsUtils.getEquippedHatItemStacks((LivingEntity)mc.f_91074_)) {
                        for (RegistryObject itemRegistryObject : ITEMS.getEntries()) {
                            Item item = (Item)itemRegistryObject.get();
                            if (!(item instanceof IGameOverlayRenderer) || item != headSlotItemStack.m_41720_()) continue;
                            ((IGameOverlayRenderer)item).onRenderGameOverlay(screenWidth, screenHeight, partialTicks);
                        }
                    }
                }
            }
        });
    }

    private static void onBreakSpeedEvent(PlayerEvent.BreakSpeed event) {
        for (ItemStack headSlotItemStack : UsefulHatsUtils.getEquippedHatItemStacks((LivingEntity)event.getEntity())) {
            for (RegistryObject itemRegistryObject : ITEMS.getEntries()) {
                Item item = (Item)itemRegistryObject.get();
                if (!(item instanceof IBreakSpeedChanger) || headSlotItemStack.m_41720_() != item) continue;
                ((IBreakSpeedChanger)item).onBreakSpeedEvent(event, headSlotItemStack);
            }
        }
    }

    private static void onBreakEvent(BlockEvent.BreakEvent event) {
        for (ItemStack headSlotItemStack : UsefulHatsUtils.getEquippedHatItemStacks((LivingEntity)event.getPlayer())) {
            for (RegistryObject itemRegistryObject : ITEMS.getEntries()) {
                Item item = (Item)itemRegistryObject.get();
                if (!(item instanceof IBreakSpeedChanger) || headSlotItemStack.m_41720_() != item) continue;
                ((IBreakSpeedChanger)item).onBreakEvent(event, headSlotItemStack);
            }
        }
    }

    private static void onEntityJoinWorldEvent(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Mob) {
            Mob entity2 = (Mob)entity;
            for (RegistryObject itemRegistryObject : ITEMS.getEntries()) {
                Item item = (Item)itemRegistryObject.get();
                if (!(item instanceof IMobEntityChanger)) continue;
                ((IMobEntityChanger)item).onEntityJoinWorldEvent(entity2, event);
            }
        }
    }

    private static void onItemFishedEvent(ItemFishedEvent event) {
        for (ItemStack headSlotItemStack : UsefulHatsUtils.getEquippedHatItemStacks((LivingEntity)event.getEntity())) {
            for (RegistryObject itemRegistryObject : ITEMS.getEntries()) {
                Item item = (Item)itemRegistryObject.get();
                if (!(item instanceof IItemFishedListener) || headSlotItemStack.m_41720_() != item) continue;
                ((IItemFishedListener)item).onItemFishedListener(event, headSlotItemStack);
            }
        }
    }

    private static void onLivingDropsEvent(LivingDropsEvent event) {
        Entity entity = event.getSource().m_7640_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (ItemStack headSlotItemStack : UsefulHatsUtils.getEquippedHatItemStacks((LivingEntity)player)) {
                for (RegistryObject itemRegistryObject : ITEMS.getEntries()) {
                    Item item = (Item)itemRegistryObject.get();
                    if (!(item instanceof ILivingDropsListener) || item != headSlotItemStack.m_41720_()) continue;
                    ((ILivingDropsListener)item).onLivingDropsEvent(event, player, headSlotItemStack);
                }
            }
        }
    }

    private static void onLivingUseItemEvent(LivingEntityUseItemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            for (ItemStack headSlotItemStack : UsefulHatsUtils.getEquippedHatItemStacks((LivingEntity)player)) {
                for (RegistryObject itemRegistryObject : ITEMS.getEntries()) {
                    Item item = (Item)itemRegistryObject.get();
                    if (!(item instanceof IItemUseListener) || item != headSlotItemStack.m_41720_()) continue;
                    ((IItemUseListener)item).onItemUseEvent(event, player, headSlotItemStack);
                }
            }
        }
    }

    private static void onEquipmentChanged(LivingEntity entity, ItemStack fromItemStack, ItemStack toItemStack) {
        Item toItem;
        Item fromItem = fromItemStack.m_41720_();
        if (fromItem != (toItem = toItemStack.m_41720_()) && (fromItem instanceof IEquipmentChangeListener || toItem instanceof IEquipmentChangeListener)) {
            for (RegistryObject itemRegistryObject : ITEMS.getEntries()) {
                Item item = (Item)itemRegistryObject.get();
                if (!(item instanceof IEquipmentChangeListener)) continue;
                if (fromItem == item) {
                    ((IEquipmentChangeListener)item).onUnequippedHatItem(entity, fromItemStack);
                    continue;
                }
                if (toItem != item) continue;
                ((IEquipmentChangeListener)item).onEquippedHatItem(entity, toItemStack);
            }
        }
    }

    private static void onLivingEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        if (event.getSlot() == EquipmentSlot.HEAD) {
            ModItems.onEquipmentChanged(event.getEntity(), event.getFrom(), event.getTo());
        }
    }

    private static void onCuriosEquipmentChangeEvent(CurioChangeEvent event) {
        ModItems.onEquipmentChanged(event.getEntity(), event.getFrom(), event.getTo());
    }

    private static void onLivingChangeTargetEvent(LivingChangeTargetEvent event) {
        Object object = event.getEntity();
        if (object instanceof Mob) {
            Mob mob = (Mob)object;
            object = event.getNewTarget();
            if (object instanceof Player) {
                Player player = (Player)object;
                for (ItemStack headSlotItemStack : UsefulHatsUtils.getEquippedHatItemStacks((LivingEntity)player)) {
                    for (RegistryObject itemRegistryObject : ITEMS.getEntries()) {
                        Item item = (Item)itemRegistryObject.get();
                        if (!(item instanceof IAttackTargetChanger) || item != headSlotItemStack.m_41720_() || !((IAttackTargetChanger)item).avoidMobChangingTarget(headSlotItemStack, mob, player)) continue;
                        event.setCanceled(true);
                        return;
                    }
                }
            }
        }
    }

    private static void onRightClickItemEvent(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        for (ItemStack headSlotItemStack : UsefulHatsUtils.getEquippedHatItemStacks((LivingEntity)player)) {
            for (RegistryObject itemRegistryObject : ITEMS.getEntries()) {
                Item item = (Item)itemRegistryObject.get();
                if (!(item instanceof IRightClickListener) || item != headSlotItemStack.m_41720_()) continue;
                ((IRightClickListener)item).onRightClickItemEvent(event, headSlotItemStack);
            }
        }
    }
}

