/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.TFChestBlock;
import twilightforest.entity.EnforcedHomePoint;
import twilightforest.entity.IBreathAttacker;
import twilightforest.entity.TFPart;
import twilightforest.entity.ai.goal.HoverBeamGoal;
import twilightforest.entity.ai.goal.HoverSummonGoal;
import twilightforest.entity.ai.goal.HoverThenDropGoal;
import twilightforest.entity.boss.SnowQueenIceShield;
import twilightforest.entity.monster.IceCrystal;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDamageSources;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFParticleType;
import twilightforest.init.TFSounds;
import twilightforest.loot.TFLootTables;
import twilightforest.util.EntityUtil;
import twilightforest.util.WorldUtil;
import twilightforest.world.registration.TFGenerationSettings;

public class SnowQueen
extends Monster
implements IBreathAttacker,
EnforcedHomePoint {
    private static final int MAX_SUMMONS = 6;
    private static final EntityDataAccessor<Boolean> BEAM_FLAG = SynchedEntityData.m_135353_(SnowQueen.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> PHASE_FLAG = SynchedEntityData.m_135353_(SnowQueen.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS);
    private static final int MAX_DAMAGE_WHILE_BEAMING = 25;
    private static final float BREATH_DAMAGE = 4.0f;
    public final SnowQueenIceShield[] iceArray = new SnowQueenIceShield[7];
    private int summonsRemaining = 0;
    private int successfulDrops;
    private int maxDrops;
    private int damageWhileBeaming;
    private final List<ServerPlayer> hurtBy = new ArrayList<ServerPlayer>();

    public SnowQueen(EntityType<? extends SnowQueen> type, Level world) {
        super(type, world);
        for (int i = 0; i < this.iceArray.length; ++i) {
            this.iceArray[i] = new SnowQueenIceShield(this);
        }
        this.setCurrentPhase(Phase.SUMMON);
        this.f_21364_ = 317;
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, true);
        this.m_20242_(true);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new HoverSummonGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new HoverThenDropGoal(this, 80, 20));
        this.f_21345_.m_25352_(3, (Goal)new HoverBeamGoal(this, 80, 100));
        this.addRestrictionGoals((PathfinderMob)this, this.f_21345_);
        this.f_21345_.m_25352_(6, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public boolean m_6094_() {
        return false;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22280_, 0.23).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22278_, 0.75);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(BEAM_FLAG, (Object)false);
        this.m_20088_().m_135372_(PHASE_FLAG, (Object)0);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)TFSounds.SNOW_QUEEN_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)TFSounds.SNOW_QUEEN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TFSounds.SNOW_QUEEN_DEATH.get();
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().m_5776_()) {
            this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        } else {
            this.spawnParticles();
        }
    }

    private void spawnParticles() {
        for (int i = 0; i < 3; ++i) {
            float px = (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.3f;
            float py = this.m_20192_() + (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.5f;
            float pz = (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.3f;
            this.m_9236_().m_7106_((ParticleOptions)TFParticleType.SNOW_GUARDIAN.get(), this.f_19790_ + (double)px, this.f_19791_ + (double)py, this.f_19792_ + (double)pz, 0.0, 0.0, 0.0);
        }
        if (this.getCurrentPhase() == Phase.DROP) {
            for (SnowQueenIceShield ice : this.iceArray) {
                float px = (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.5f;
                float py = (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.5f;
                float pz = (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.5f;
                this.m_9236_().m_7106_((ParticleOptions)TFParticleType.SNOW_WARNING.get(), ((Entity)ice).f_19790_ + (double)px, ((Entity)ice).f_19791_ + (double)py, ((Entity)ice).f_19792_ + (double)pz, 0.0, 0.0, 0.0);
            }
        }
        if (this.isBreathing() && this.m_6084_()) {
            Vec3 look = this.m_20154_();
            double dist = 0.5;
            double px = this.m_20185_() + look.m_7096_() * dist;
            double py = this.m_20186_() + (double)1.7f + look.m_7098_() * dist;
            double pz = this.m_20189_() + look.m_7094_() * dist;
            for (int i = 0; i < 10; ++i) {
                double dx = look.m_7096_();
                double dy = 0.0;
                double dz = look.m_7094_();
                double spread = 2.0 + this.m_217043_().m_188500_() * 2.5;
                double velocity = 2.0 + this.m_217043_().m_188500_() * 0.15;
                dx += this.m_217043_().m_188583_() * 0.0075 * spread;
                dy += this.m_217043_().m_188583_() * 0.0075 * spread;
                dz += this.m_217043_().m_188583_() * 0.0075 * spread;
                this.m_9236_().m_7106_((ParticleOptions)TFParticleType.ICE_BEAM.get(), px, py, pz, dx *= velocity, dy *= velocity, dz *= velocity);
            }
        }
    }

    public void m_8119_() {
        this.m_20334_(this.m_20184_().m_7096_(), this.m_20184_().m_7098_() - 0.05, this.m_20184_().m_7094_());
        super.m_8119_();
        for (int i = 0; i < this.iceArray.length; ++i) {
            this.iceArray[i].m_8119_();
            if (i < this.iceArray.length - 1) {
                Vec3 blockPos = this.getIceShieldPosition(i);
                this.iceArray[i].m_6034_(blockPos.m_7096_(), blockPos.m_7098_(), blockPos.m_7094_());
            } else {
                this.iceArray[i].m_6034_(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_());
            }
            this.iceArray[i].m_146922_(this.getIceShieldAngle(i));
            if (this.m_9236_().m_5776_()) continue;
            this.applyShieldCollisions((Entity)this.iceArray[i]);
        }
        if (this.f_20919_ > 0) {
            for (int k = 0; k < 5; ++k) {
                double d = this.m_217043_().m_188583_() * 0.02;
                double d1 = this.m_217043_().m_188583_() * 0.02;
                double d2 = this.m_217043_().m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)(this.m_217043_().m_188499_() ? ParticleTypes.f_123813_ : ParticleTypes.f_123759_), this.m_20185_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + (double)(this.m_217043_().m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d, d1, d2);
            }
        }
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
            if (this.m_21534_() != BlockPos.f_121853_) {
                this.m_9236_().m_46597_(this.m_21534_(), ((Block)TFBlocks.SNOW_QUEEN_BOSS_SPAWNER.get()).m_49966_());
            }
            this.m_146870_();
        } else {
            super.m_6043_();
        }
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        if (!this.m_9236_().m_5776_()) {
            TFGenerationSettings.markStructureConquered(this.m_9236_(), this.m_20183_(), TFLandmark.ICE_TOWER);
            for (ServerPlayer player : this.hurtBy) {
                TFAdvancements.HURT_BOSS.trigger(player, (Entity)this);
            }
            TFLootTables.entityDropsIntoContainer((LivingEntity)this, this.m_7771_(true, cause).m_78975_(LootContextParamSets.f_81415_), ((TFChestBlock)((Object)TFBlocks.TWILIGHT_OAK_CHEST.get())).m_49966_(), EntityUtil.bossChestLocation((Mob)this));
        }
    }

    protected boolean m_6125_() {
        return false;
    }

    private void applyShieldCollisions(Entity collider) {
        List list = this.m_9236_().m_45933_(collider, collider.m_20191_().m_82377_((double)-0.2f, (double)-0.2f, (double)-0.2f));
        for (Entity collided : list) {
            if (!collided.m_6094_()) continue;
            this.applyShieldCollision(collider, collided);
        }
    }

    private void applyShieldCollision(Entity collider, Entity collided) {
        if (collided != this) {
            collided.m_7334_(collider);
            if (collided instanceof LivingEntity && this.m_7327_(collided)) {
                Vec3 motion = collided.m_20184_();
                collided.m_20334_(motion.m_7096_(), motion.m_7098_() + 0.4, motion.m_7094_());
                this.m_5496_((SoundEvent)TFSounds.SNOW_QUEEN_ATTACK.get(), 1.0f, 1.0f);
            }
        }
    }

    public boolean m_7327_(Entity entity) {
        if (this.getCurrentPhase() == Phase.DROP) {
            return entity.m_6469_(TFDamageSources.SQUISH, (float)this.m_21133_(Attributes.f_22281_));
        }
        return super.m_7327_(entity);
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.getCurrentPhase() == Phase.SUMMON && this.getSummonsRemaining() == 0 && this.countMyMinions() <= 0) {
            this.setCurrentPhase(Phase.DROP);
        }
        if (this.getCurrentPhase() == Phase.DROP && this.successfulDrops >= this.maxDrops) {
            this.setCurrentPhase(Phase.BEAM);
        }
        if (this.getCurrentPhase() == Phase.BEAM && this.damageWhileBeaming >= 25) {
            this.setCurrentPhase(Phase.SUMMON);
        }
    }

    public boolean m_6469_(DamageSource source, float damage) {
        ServerPlayer player;
        Entity entity;
        boolean result = super.m_6469_(source, damage);
        if (result && this.getCurrentPhase() == Phase.BEAM) {
            this.damageWhileBeaming = (int)((float)this.damageWhileBeaming + damage);
        }
        if ((entity = source.m_7639_()) instanceof ServerPlayer && !this.hurtBy.contains(player = (ServerPlayer)entity)) {
            this.hurtBy.add(player);
        }
        return result;
    }

    private Vec3 getIceShieldPosition(int idx) {
        return this.getIceShieldPosition(this.getIceShieldAngle(idx), 1.0f);
    }

    private float getIceShieldAngle(int idx) {
        return 60.0f * (float)idx + (float)this.f_19797_ * 5.0f;
    }

    private Vec3 getIceShieldPosition(float angle, float distance) {
        double dx = Math.cos((double)angle * Math.PI / 180.0) * (double)distance;
        double dz = Math.sin((double)angle * Math.PI / 180.0) * (double)distance;
        return new Vec3(this.m_20185_() + dx, this.m_20186_() + this.getShieldYOffset(), this.m_20189_() + dz);
    }

    private double getShieldYOffset() {
        return 0.1f;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource cause) {
        return false;
    }

    public void destroyBlocksInAABB(AABB box) {
        if (ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
            for (BlockPos pos : WorldUtil.getAllInBB(box)) {
                BlockState state = this.m_9236_().m_8055_(pos);
                if (state.m_60734_() != Blocks.f_50126_ && state.m_60734_() != Blocks.f_50354_) continue;
                this.m_9236_().m_46961_(pos, false);
                this.m_146850_(GameEvent.f_157794_);
            }
        }
    }

    @Override
    public boolean isBreathing() {
        return (Boolean)this.f_19804_.m_135370_(BEAM_FLAG);
    }

    @Override
    public void setBreathing(boolean flag) {
        this.f_19804_.m_135381_(BEAM_FLAG, (Object)flag);
    }

    public Phase getCurrentPhase() {
        return Phase.values()[(Byte)this.f_19804_.m_135370_(PHASE_FLAG)];
    }

    public void setCurrentPhase(Phase currentPhase) {
        this.f_19804_.m_135381_(PHASE_FLAG, (Object)((byte)currentPhase.ordinal()));
        if (currentPhase == Phase.SUMMON) {
            this.setSummonsRemaining(6);
        }
        if (currentPhase == Phase.DROP) {
            this.successfulDrops = 0;
            this.maxDrops = 2 + this.m_217043_().m_188503_(3);
        }
        if (currentPhase == Phase.BEAM) {
            this.damageWhileBeaming = 0;
        }
    }

    public int getSummonsRemaining() {
        return this.summonsRemaining;
    }

    public void setSummonsRemaining(int summonsRemaining) {
        this.summonsRemaining = summonsRemaining;
    }

    public void summonMinionAt(LivingEntity targetedEntity) {
        IceCrystal minion = new IceCrystal(this.m_9236_());
        minion.m_19890_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
        this.m_9236_().m_7967_((Entity)minion);
        for (int i = 0; i < 100; ++i) {
            double attemptZ;
            double attemptY;
            double attemptX;
            if (this.m_21534_() != BlockPos.f_121853_) {
                BlockPos home = this.m_21534_();
                attemptX = (double)home.m_123341_() + this.m_217043_().m_188583_() * 3.0;
                attemptY = (double)home.m_123342_() + this.m_217043_().m_188583_() * 2.0;
                attemptZ = (double)home.m_123343_() + this.m_217043_().m_188583_() * 3.0;
            } else {
                attemptX = targetedEntity.m_20185_() + this.m_217043_().m_188583_() * 6.0;
                attemptY = targetedEntity.m_20186_() + this.m_217043_().m_188583_() * 8.0;
                attemptZ = targetedEntity.m_20189_() + this.m_217043_().m_188583_() * 6.0;
            }
            if (!minion.m_20984_(attemptX, attemptY, attemptZ, true)) continue;
            this.m_146852_(GameEvent.f_157810_, (Entity)minion);
            break;
        }
        minion.m_6710_(targetedEntity);
        minion.setToDieIn30Seconds();
        --this.summonsRemaining;
    }

    public int countMyMinions() {
        return this.m_9236_().m_45976_(IceCrystal.class, new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20185_() + 1.0, this.m_20186_() + 1.0, this.m_20189_() + 1.0).m_82377_(32.0, 16.0, 32.0)).size();
    }

    public void incrementSuccessfulDrops() {
        ++this.successfulDrops;
    }

    @Override
    public void doBreathAttack(Entity target) {
        target.m_6469_(TFDamageSources.CHILLING_BREATH, 4.0f);
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public void m_7380_(CompoundTag compound) {
        this.saveHomePointToNbt(compound);
        super.m_7380_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.loadHomePointFromNbt(compound, 20);
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    protected float m_6108_() {
        return 1.0f;
    }

    public boolean m_6072_() {
        return false;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        TFPart.assignPartIDs((Entity)this);
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.iceArray;
    }

    @Override
    public BlockPos getRestrictionCenter() {
        return this.m_21534_();
    }

    @Override
    public void setRestriction(BlockPos pos, int dist) {
        this.m_21446_(pos, dist);
    }

    public static enum Phase {
        SUMMON,
        DROP,
        BEAM;

    }
}

