/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.tileentity;

import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.ChestType;
import twilightforest.TwilightForestMod;
import twilightforest.block.entity.TwilightChestEntity;
import twilightforest.init.TFBlocks;

public class TwilightChestRenderer<T extends TwilightChestEntity>
extends ChestRenderer<T> {
    public static final Map<Block, EnumMap<ChestType, Material>> MATERIALS;

    public TwilightChestRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected Material getMaterial(T blockEntity, ChestType chestType) {
        EnumMap<ChestType, Material> b = MATERIALS.get(blockEntity.m_58900_().m_60734_());
        if (b == null) {
            return super.getMaterial(blockEntity, chestType);
        }
        Material material = b.get(chestType);
        return material != null ? material : super.getMaterial(blockEntity, chestType);
    }

    private static EnumMap<ChestType, Material> chestMaterial(String type) {
        EnumMap<ChestType, Material> map = new EnumMap<ChestType, Material>(ChestType.class);
        map.put(ChestType.SINGLE, new Material(Sheets.f_110740_, TwilightForestMod.prefix("model/chest/" + type + "/" + type)));
        map.put(ChestType.LEFT, new Material(Sheets.f_110740_, TwilightForestMod.prefix("model/chest/" + type + "/left")));
        map.put(ChestType.RIGHT, new Material(Sheets.f_110740_, TwilightForestMod.prefix("model/chest/" + type + "/right")));
        return map;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)((Block)TFBlocks.TWILIGHT_OAK_CHEST.get()), TwilightChestRenderer.chestMaterial("twilight"));
        builder.put((Object)((Block)TFBlocks.CANOPY_CHEST.get()), TwilightChestRenderer.chestMaterial("canopy"));
        builder.put((Object)((Block)TFBlocks.MANGROVE_CHEST.get()), TwilightChestRenderer.chestMaterial("mangrove"));
        builder.put((Object)((Block)TFBlocks.DARKWOOD_CHEST.get()), TwilightChestRenderer.chestMaterial("darkwood"));
        builder.put((Object)((Block)TFBlocks.TIME_CHEST.get()), TwilightChestRenderer.chestMaterial("time"));
        builder.put((Object)((Block)TFBlocks.TRANSFORMATION_CHEST.get()), TwilightChestRenderer.chestMaterial("trans"));
        builder.put((Object)((Block)TFBlocks.MINING_CHEST.get()), TwilightChestRenderer.chestMaterial("mining"));
        builder.put((Object)((Block)TFBlocks.SORTING_CHEST.get()), TwilightChestRenderer.chestMaterial("sort"));
        MATERIALS = builder.build();
        ModelBakery.f_119234_.addAll(MATERIALS.values().stream().flatMap(e -> e.values().stream()).collect(Collectors.toList()));
    }
}

