/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.utils;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.structure.DungeonDesigner;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;

public class DungeonGenData {
    public ItemStack keyItem;
    public BlockPos returnPoint;
    public String returnDimension;
    public int dungeonTheme = -1;
    public DungeonDesigner.DungeonType dungeonType = DungeonDesigner.DungeonType.BASIC;

    DungeonGenData() {
    }

    public static DungeonGenData Create() {
        return new DungeonGenData();
    }

    public DungeonGenData setKeyItem(ItemStack stack) {
        this.keyItem = stack;
        return this;
    }

    public DungeonGenData setReturnPoint(BlockPos returnPoint, String returnDimension) {
        this.returnPoint = returnPoint;
        this.returnDimension = returnDimension;
        return this;
    }

    public DungeonGenData setTheme(int themeNum) {
        this.dungeonTheme = themeNum;
        if (this.dungeonTheme > DungeonConfig.themeSettings.size() && this.dungeonType != DungeonDesigner.DungeonType.TELEPORTER_HUB) {
            DimDungeons.logMessageError("DIMDUNGEONS ERROR: attempting to build a dungeon with a theme number greater than the number of themes defined in the config. The theme will be ignored.");
            this.dungeonTheme = 0;
        }
        return this;
    }

    public DungeonGenData setDungeonType(DungeonDesigner.DungeonType type) {
        this.dungeonType = type;
        return this;
    }
}

