/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.item;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.item.BaseItemKey;
import com.catastrophe573.dimdungeons.item.ItemRegistrar;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemBlankThemeKey
extends BaseItemKey {
    public static final String REG_NAME = "item_blank_theme_key";

    public ItemBlankThemeKey() {
        super(new Item.Properties().m_41497_(Rarity.COMMON));
    }

    public static int getTheme(ItemStack stack) {
        CompoundTag itemData = stack.m_41783_();
        if (itemData == null) {
            return 0;
        }
        return itemData.m_128441_("theme") ? itemData.m_128451_("theme") : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component m_7626_(ItemStack stack) {
        int theme = 0;
        if (stack.m_41782_()) {
            theme = ItemBlankThemeKey.getTheme(stack);
            String start = I18n.m_118938_((String)"item.dimdungeons.item_blank_theme_key", (Object[])new Object[0]);
            String place = I18n.m_118938_((String)("npart.dimdungeons.theme_" + theme), (Object[])new Object[0]);
            return Component.m_237115_((String)(start + " (" + place + ")"));
        }
        return Component.m_237110_((String)this.m_5671_(stack), (Object[])new Object[0]);
    }

    @Override
    public void performActivationRitual(Player player, ItemStack itemstack, Level worldIn, BlockPos pos) {
        worldIn.m_5594_((Player)null, pos, SoundEvents.f_11736_, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (player == null) {
            DimDungeons.logMessageError("Somehow activated a blank advanced key without a player present. Do not do this.");
            return;
        }
        if (!worldIn.f_46443_) {
            int slot = player.m_150109_().m_36030_(itemstack);
            int theme = ItemBlankThemeKey.getTheme(itemstack);
            if (theme < 1) {
                theme = worldIn.m_213780_().m_188503_(DungeonConfig.themeSettings.size()) + 1;
            }
            itemstack.m_41774_(1);
            ItemStack newkey = new ItemStack((ItemLike)ItemRegistrar.ITEM_PORTAL_KEY.get());
            this.activateKeyLevel1(worldIn.m_7654_(), newkey, theme);
            if (!player.m_150109_().m_36040_(slot, newkey) && !player.m_36356_(newkey)) {
                player.m_36176_(newkey, false);
            }
        }
        this.createActivationParticleEffects(worldIn, pos);
    }
}

