/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.dimension;

import com.catastrophe573.dimdungeons.structure.DungeonPlacement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class DungeonChunkGenerator
extends ChunkGenerator {
    public static final Codec<FlatLevelSource> myCodec = RecordCodecBuilder.create(p_204551_ -> DungeonChunkGenerator.m_208005_((RecordCodecBuilder.Instance)p_204551_).and((App)FlatLevelGeneratorSettings.f_70347_.fieldOf("settings").forGetter(FlatLevelSource::m_64191_)).apply((Applicative)p_204551_, p_204551_.stable(FlatLevelSource::new)));
    private final FlatLevelGeneratorSettings settings;

    public DungeonChunkGenerator(Registry<StructureSet> p_209099_, FlatLevelGeneratorSettings p_209100_) {
        super(p_209099_, p_209100_.m_209810_(), (BiomeSource)new FixedBiomeSource(p_209100_.m_204921_()));
        this.settings = p_209100_;
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return myCodec;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ChunkGenerator withSeed(long p_230349_1_) {
        return this;
    }

    public FlatLevelGeneratorSettings settings() {
        return this.settings;
    }

    public int getBaseHeight(int x, int z, Heightmap.Types heightmapType) {
        List ablockstate = this.settings.m_161917_();
        for (int i = ablockstate.size() - 1; i >= 0; --i) {
            BlockState blockstate = (BlockState)ablockstate.get(i);
            if (blockstate == null || !heightmapType.m_64299_().test(blockstate)) continue;
            return i + 1;
        }
        return 0;
    }

    public NoiseColumn getBaseColumn(int p_158270_, int p_158271_, LevelHeightAccessor p_158272_) {
        return new NoiseColumn(p_158272_.m_141937_(), (BlockState[])this.settings.m_161917_().stream().limit(p_158272_.m_141928_()).map(p_64189_ -> p_64189_ == null ? Blocks.f_50016_.m_49966_() : p_64189_).toArray(BlockState[]::new));
    }

    public void makeBase(ChunkAccess chunkIn) {
        block9: {
            int z;
            int x;
            block8: {
                x = chunkIn.m_7697_().f_45578_;
                z = chunkIn.m_7697_().f_45579_;
                if (!DungeonPlacement.isDungeonChunk(x, z)) break block8;
                for (int px = 0; px < 16; ++px) {
                    for (int py = 1; py < 255; ++py) {
                        for (int pz = 0; pz < 16; ++pz) {
                            if (py < 2) {
                                chunkIn.m_6978_(new BlockPos(px, py, pz), Blocks.f_50752_.m_49966_(), false);
                                continue;
                            }
                            if (py >= 50) continue;
                            if (DungeonPlacement.isEntranceChunk(x, z)) {
                                chunkIn.m_6978_(new BlockPos(px, py, pz), Blocks.f_50730_.m_49966_(), false);
                                continue;
                            }
                            chunkIn.m_6978_(new BlockPos(px, py, pz), Blocks.f_50062_.m_49966_(), false);
                        }
                    }
                }
                break block9;
            }
            if (x % 16 != 0 && z % 16 != 0) break block9;
            for (int px = 0; px < 16; ++px) {
                for (int py = 1; py < 255; ++py) {
                    for (int pz = 0; pz < 16; ++pz) {
                        chunkIn.m_6978_(new BlockPos(px, py, pz), Blocks.f_50375_.m_49966_(), false);
                    }
                }
            }
        }
    }

    public void m_223164_(RegistryAccess p_223165_, RandomState p_223166_, StructureManager p_223167_, ChunkAccess p_223168_, StructureTemplateManager p_223169_, long p_223170_) {
    }

    public void m_6929_(WorldGenRegion p_62167_) {
    }

    public int m_142062_() {
        return -63;
    }

    public int m_6331_() {
        return 384;
    }

    public int m_6337_() {
        return -64;
    }

    public void m_213679_(WorldGenRegion p_223043_, long p_223044_, RandomState p_223045_, BiomeManager p_223046_, StructureManager p_223047_, ChunkAccess p_223048_, GenerationStep.Carving p_223049_) {
    }

    public void m_214194_(WorldGenRegion p_223050_, StructureManager p_223051_, RandomState p_223052_, ChunkAccess p_223053_) {
    }

    public CompletableFuture<ChunkAccess> m_213974_(Executor p_223209_, Blender p_223210_, RandomState p_223211_, StructureManager p_223212_, ChunkAccess p_223213_) {
        this.makeBase(p_223213_);
        return CompletableFuture.completedFuture(p_223213_);
    }

    public int m_214096_(int x, int z, Heightmap.Types p_223034_, LevelHeightAccessor p_223035_, RandomState p_223036_) {
        return this.getBaseHeight(x, z, p_223034_);
    }

    public NoiseColumn m_214184_(int p_223028_, int p_223029_, LevelHeightAccessor p_223030_, RandomState p_223031_) {
        return new NoiseColumn(p_223030_.m_141937_(), (BlockState[])this.settings.m_161917_().stream().limit(p_223030_.m_141928_()).map(p_204549_ -> p_204549_ == null ? Blocks.f_50016_.m_49966_() : p_204549_).toArray(BlockState[]::new));
    }

    public void m_213600_(List<String> p_223175_, RandomState p_223176_, BlockPos p_223177_) {
        p_223175_.add("Dungeon Room: TODO maybe print dungeon room here");
    }
}

