/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.block;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.block.BlockGoldPortal;
import com.catastrophe573.dimdungeons.block.BlockRegistrar;
import com.catastrophe573.dimdungeons.block.TileEntityGoldPortal;
import com.catastrophe573.dimdungeons.block.TileEntityPortalKeyhole;
import com.catastrophe573.dimdungeons.item.BaseItemKey;
import com.catastrophe573.dimdungeons.item.ItemBuildKey;
import com.catastrophe573.dimdungeons.item.ItemPortalKey;
import com.catastrophe573.dimdungeons.structure.DungeonDesigner;
import com.catastrophe573.dimdungeons.structure.DungeonPlacement;
import com.catastrophe573.dimdungeons.utils.DungeonGenData;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockPortalKeyhole
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty FILLED = BooleanProperty.m_61465_((String)"filled");
    public static final BooleanProperty LIT = BooleanProperty.m_61465_((String)"lit");
    public static final BooleanProperty IS_BUILDING = BooleanProperty.m_61465_((String)"is_building");
    public static final String REG_NAME = "block_portal_keyhole";

    public BlockPortalKeyhole() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(3.0f).m_155956_(1200.0f).m_60918_(SoundType.f_56743_));
        this.m_49959_(this.getMyCustomDefaultState());
    }

    public BlockState getMyCustomDefaultState() {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)FILLED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)IS_BUILDING, (Comparable)Boolean.valueOf(false));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.f_46443_) {
            return null;
        }
        if (((Boolean)state.m_61143_((Property)IS_BUILDING)).booleanValue() && type == BlockRegistrar.BE_PORTAL_KEYHOLE.get()) {
            return type == BlockRegistrar.BE_PORTAL_KEYHOLE.get() ? TileEntityPortalKeyhole::tick : null;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        boolean hasPortalBlockBelow = worldIn.m_8055_(pos.m_7495_()).m_60734_() == BlockRegistrar.BLOCK_GOLD_PORTAL.get();
        Direction enumfacing = (Direction)stateIn.m_61143_((Property)FACING);
        double d0 = (double)pos.m_123341_() + 0.5;
        double d1 = (double)pos.m_123342_() + rand.m_188500_() * 6.0 / 16.0;
        double d2 = (double)pos.m_123343_() + 0.5;
        double d4 = rand.m_188500_() * 0.6 - 0.3;
        if (((Boolean)stateIn.m_61143_((Property)LIT)).booleanValue() && hasPortalBlockBelow) {
            if (rand.m_188500_() < 0.1 && DungeonConfig.playPortalSounds) {
                worldIn.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, SoundEvents.f_12286_, SoundSource.BLOCKS, 1.0f, 2.5f, false);
            }
            if (DungeonConfig.showParticles) {
                switch (enumfacing) {
                    case WEST: {
                        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123760_, d0 - 0.52, d1, d2 + d4, -1.0, 1.0, 0.0);
                        break;
                    }
                    case EAST: {
                        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123760_, d0 + 0.52, d1, d2 + d4, 1.0, 1.0, 0.0);
                        break;
                    }
                    case NORTH: {
                        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123760_, d0 + d4, d1, d2 - 0.52, 0.0, 1.0, -1.0);
                        break;
                    }
                    default: {
                        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123760_, d0 + d4, d1, d2 + 0.52, 0.0, 1.0, 1.0);
                    }
                }
            }
        }
        if (((Boolean)stateIn.m_61143_((Property)IS_BUILDING)).booleanValue()) {
            if (DungeonConfig.playPortalSounds) {
                float randomPitch = worldIn.m_213780_().m_188501_() * 2.0f;
                worldIn.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, SoundEvents.f_11859_, SoundSource.BLOCKS, 0.7f, randomPitch, false);
            }
            if (DungeonConfig.showParticles) {
                switch (enumfacing) {
                    case WEST: {
                        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123815_, d0 - 0.12, d1 + 1.5, d2 + d4, 0.0, 0.0, 0.23);
                        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123815_, d0 - 0.12, d1 + 1.5, d2 + d4, 0.0, 0.0, -0.23);
                        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0 + d4, d1 + 0.5, d2 - 0.12, -0.08, 0.0, 0.0);
                        break;
                    }
                    case EAST: {
                        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123815_, d0 + 0.12, d1 + 1.5, d2 + d4, 0.0, 0.0, 0.23);
                        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123815_, d0 + 0.12, d1 + 1.5, d2 + d4, 0.0, 0.0, -0.23);
                        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0 + d4, d1 + 0.5, d2 - 0.12, 0.08, 0.0, 0.0);
                        break;
                    }
                    case NORTH: {
                        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123815_, d0 + d4, d1 + 1.5, d2 - 0.12, 0.23, 0.0, 0.0);
                        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123815_, d0 + d4, d1 + 1.5, d2 - 0.12, -0.23, 0.0, 0.0);
                        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0 - 0.12, d1 + 0.5, d2 + d4, 0.0, 0.0, -0.08);
                        break;
                    }
                    default: {
                        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123815_, d0 + d4, d1 + 1.5, d2 + 0.12, 0.23, 0.0, 0.0);
                        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123815_, d0 + d4, d1 + 1.5, d2 + 0.12, -0.23, 0.0, 0.0);
                        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0 - 0.12, d1 + 0.5, d2 + d4, 0.0, 0.0, 0.08);
                    }
                }
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack playerItem = player.m_21120_(handIn);
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        TileEntityPortalKeyhole myEntity = (TileEntityPortalKeyhole)tileEntity;
        if (myEntity != null) {
            ItemStack insideItem = myEntity.getObjectInserted();
            if (insideItem.m_41619_()) {
                if (!playerItem.m_41619_()) {
                    boolean is_building = false;
                    myEntity.setContents(playerItem.m_41777_());
                    if (playerItem.m_41720_() instanceof ItemPortalKey && !worldIn.f_46443_ && BlockPortalKeyhole.isOkayToSpawnPortalBlocks(worldIn, pos, state, myEntity)) {
                        key = (ItemPortalKey)playerItem.m_41720_();
                        long buildX = key.getDungeonTopLeftX(playerItem);
                        long buildZ = key.getDungeonTopLeftZ(playerItem);
                        long entranceX = buildX + 128L;
                        long entranceZ = buildZ + 176L;
                        DungeonGenData genData = DungeonGenData.Create().setKeyItem(playerItem).setDungeonType(key.getDungeonType(playerItem)).setTheme(key.getDungeonTheme(playerItem)).setReturnPoint(BlockPortalKeyhole.getReturnPoint(state, pos), DungeonUtils.serializeDimensionKey((ResourceKey<Level>)worldIn.m_46472_()));
                        if (this.shouldBuildDungeon(playerItem)) {
                            if (!DungeonUtils.dungeonAlreadyExistsHere(worldIn, entranceX, entranceZ)) {
                                playerItem.m_41783_().m_128379_("built", true);
                                myEntity.setContents(playerItem.m_41777_());
                                DungeonPlacement.beginDesignAndBuild(DungeonUtils.getDungeonWorld(worldIn.m_7654_()), buildX, buildZ, genData);
                            }
                            is_building = true;
                        } else {
                            is_building = true;
                        }
                    } else if (playerItem.m_41720_() instanceof ItemBuildKey && !worldIn.f_46443_ && BlockPortalKeyhole.isOkayToSpawnPortalBlocks(worldIn, pos, state, myEntity)) {
                        key = (ItemBuildKey)playerItem.m_41720_();
                        long buildX = ((ItemBuildKey)key).getDungeonTopLeftX(playerItem);
                        long buildZ = ((ItemBuildKey)key).getDungeonTopLeftZ(playerItem);
                        DungeonGenData genData = DungeonGenData.Create().setKeyItem(playerItem).setReturnPoint(BlockPortalKeyhole.getReturnPoint(state, pos), DungeonUtils.serializeDimensionKey((ResourceKey<Level>)worldIn.m_46472_()));
                        if (key.isActivated(playerItem) && !((ItemBuildKey)key).isPlotBuilt(playerItem) && !DungeonUtils.personalPortalAlreadyExistsHere(worldIn, buildX, buildZ)) {
                            DimDungeons.logMessageInfo("DIMENSIONAL DUNGEONS: building a new personal dimension.");
                            playerItem.m_41783_().m_128379_("built", true);
                            myEntity.setContents(playerItem.m_41777_());
                            DungeonUtils.buildSuperflatPersonalSpace(buildX, buildZ, player.m_20194_());
                        }
                        is_building = false;
                        DungeonUtils.openPortalAfterBuild(worldIn, pos, genData, myEntity);
                    }
                    BlockState newBlockState = (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))).m_61124_((Property)FILLED, (Comparable)Boolean.valueOf(myEntity.isFilled()))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(myEntity.isActivated()))).m_61124_((Property)IS_BUILDING, (Comparable)Boolean.valueOf(is_building));
                    worldIn.m_46597_(pos, newBlockState);
                    playerItem.m_41774_(1);
                    worldIn.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, SoundEvents.f_12524_, SoundSource.BLOCKS, 0.7f, 1.2f, false);
                    return InteractionResult.SUCCESS;
                }
            } else {
                ItemPortalKey key;
                if (playerItem.m_41619_()) {
                    player.m_21008_(handIn, insideItem);
                } else if (!player.m_36356_(insideItem)) {
                    player.m_36176_(insideItem, false);
                }
                if (insideItem.m_41720_() instanceof ItemPortalKey && !worldIn.f_46443_ && (key = (ItemPortalKey)insideItem.m_41720_()).getDungeonType(insideItem) == DungeonDesigner.DungeonType.TELEPORTER_HUB && key.getDungeonTheme(insideItem) != 0) {
                    float entranceX = key.getWarpX(insideItem);
                    float entranceZ = key.getWarpZ(insideItem);
                    DungeonGenData genData = DungeonGenData.Create();
                    genData.setDungeonType(DungeonDesigner.DungeonType.TELEPORTER_HUB);
                    genData.setTheme(key.getDungeonTheme(insideItem));
                    DungeonUtils.reprogramTeleporterHubDoorway(worldIn, (long)entranceX, (long)entranceZ, genData, Direction.NORTH, true);
                }
                myEntity.removeContents();
                worldIn.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, SoundEvents.f_12523_, SoundSource.BLOCKS, 0.7f, 0.8f, false);
                BlockState newBlockState = (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))).m_61124_((Property)FILLED, (Comparable)Boolean.valueOf(myEntity.isFilled()))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(myEntity.isActivated()))).m_61124_((Property)IS_BUILDING, (Comparable)Boolean.valueOf(false));
                worldIn.m_7731_(pos, newBlockState, 3);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public static void addGoldenPortalBlock(Level worldIn, BlockPos pos, ItemStack keyStack, Direction.Axis axis) {
        BaseItemKey key;
        worldIn.m_46597_(pos, (BlockState)((Block)BlockRegistrar.BLOCK_GOLD_PORTAL.get()).m_49966_().m_61124_(BlockGoldPortal.AXIS, (Comparable)axis));
        TileEntityGoldPortal te = (TileEntityGoldPortal)worldIn.m_7702_(pos);
        if (te != null && te instanceof TileEntityGoldPortal && (key = (BaseItemKey)keyStack.m_41720_()) != null) {
            if (key instanceof ItemPortalKey) {
                ItemPortalKey keyItem = (ItemPortalKey)keyStack.m_41720_();
                Direction enterFacing = Direction.NORTH;
                if (keyItem.getDungeonType(keyStack) == DungeonDesigner.DungeonType.TELEPORTER_HUB) {
                    enterFacing = BlockPortalKeyhole.getTeleporterHubEntranceDirection(keyItem.getDungeonTheme(keyStack));
                }
                te.setDestination(key.getWarpX(keyStack), 55.1, key.getWarpZ(keyStack), DungeonUtils.serializeDimensionKey(DimDungeons.DUNGEON_DIMENSION), enterFacing);
            } else if (key instanceof ItemBuildKey) {
                te.setDestination(key.getWarpX(keyStack), 51.1, key.getWarpZ(keyStack), DungeonUtils.serializeDimensionKey(DimDungeons.BUILD_DIMENSION), Direction.NORTH);
            }
        }
    }

    public static Direction getTeleporterHubEntranceDirection(int doornum) {
        Direction exitDirection = Direction.NORTH;
        if (doornum == 2 || doornum == 3) {
            exitDirection = Direction.EAST;
        }
        if (doornum == 4 || doornum == 5) {
            exitDirection = Direction.SOUTH;
        }
        if (doornum == 6 || doornum == 7) {
            exitDirection = Direction.WEST;
        }
        return exitDirection;
    }

    public static BlockPos getReturnPoint(BlockState state, BlockPos pos) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        switch (dir) {
            case WEST: {
                return pos.m_122024_().m_6625_(2);
            }
            case EAST: {
                return pos.m_122029_().m_6625_(2);
            }
            case NORTH: {
                return pos.m_122012_().m_6625_(2);
            }
            case SOUTH: {
                return pos.m_122019_().m_6625_(2);
            }
        }
        return pos.m_6625_(2);
    }

    public static boolean isOkayToSpawnPortalBlocks(Level worldIn, BlockPos pos, BlockState state, TileEntityPortalKeyhole myEntity) {
        Block b1 = worldIn.m_8055_(pos.m_7495_()).m_60734_();
        Block b2 = worldIn.m_8055_(pos.m_6625_(2)).m_60734_();
        if (b1 != Blocks.f_50016_ && b1 != BlockRegistrar.BLOCK_GOLD_PORTAL.get()) {
            return false;
        }
        if (b2 != Blocks.f_50016_ && b2 != BlockRegistrar.BLOCK_GOLD_PORTAL.get()) {
            return false;
        }
        ItemStack item = myEntity.getObjectInserted();
        if (item.m_41720_() instanceof BaseItemKey) {
            BaseItemKey key = (BaseItemKey)item.m_41720_();
            return key.isActivated(item);
        }
        return false;
    }

    protected boolean shouldBuildDungeon(ItemStack stack) {
        ItemPortalKey key;
        if (stack.m_41720_() instanceof ItemPortalKey && (key = (ItemPortalKey)stack.m_41720_()).isActivated(stack)) {
            return !key.isDungeonBuilt(stack);
        }
        return false;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState retval = this.getMyCustomDefaultState();
        return (BlockState)retval.m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)FACING, (Comparable)placer.m_6350_().m_122424_()), 2);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (state.m_60734_() != newState.m_60734_()) {
            if (tileentity instanceof TileEntityPortalKeyhole) {
                ItemStack item = ((TileEntityPortalKeyhole)tileentity).getObjectInserted();
                if (!item.m_41619_()) {
                    Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)item);
                }
                worldIn.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
            worldIn.m_46747_(pos);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        if (((Boolean)blockState.m_61143_((Property)IS_BUILDING)).booleanValue()) {
            return 3;
        }
        if (((Boolean)blockState.m_61143_((Property)LIT)).booleanValue()) {
            return 2;
        }
        return (Boolean)blockState.m_61143_((Property)FILLED) != false ? 1 : 0;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)mirrorIn.m_54848_((Direction)state.m_61143_((Property)FACING)));
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, FILLED, LIT, IS_BUILDING});
    }

    public int predictPortalError(Level worldIn, Player playerIn) {
        return 0;
    }

    public static void checkForProblemsAndLiterallySpeakToPlayer(Level worldIn, BlockPos pos, BlockState state, TileEntityPortalKeyhole tileEntity, Player player, boolean dungeonExistsHere) {
        BlockState b;
        int i;
        ItemPortalKey key;
        if (worldIn.f_46443_ || player == null) {
            return;
        }
        ItemStack item = tileEntity.getObjectInserted();
        int keyLevel = 0;
        if (item.m_41720_() instanceof ItemPortalKey) {
            key = (ItemPortalKey)item.m_41720_();
            if (!key.isActivated(item)) {
                BlockPortalKeyhole.speakLiterallyToPlayerAboutProblems(worldIn, player, 1, null);
                return;
            }
        } else {
            return;
        }
        keyLevel = key.getKeyLevel(item);
        if (!BlockPortalKeyhole.isOkayToSpawnPortalBlocks(worldIn, pos, state, tileEntity)) {
            BlockPortalKeyhole.speakLiterallyToPlayerAboutProblems(worldIn, player, 2, null);
            return;
        }
        ArrayList<BlockState> blocks = state.m_61143_((Property)FACING) == Direction.WEST || state.m_61143_((Property)FACING) == Direction.EAST ? BlockGoldPortal.getPortalFrameMaterialsNorthSouth((LevelAccessor)worldIn, pos) : BlockGoldPortal.getPortalFrameMaterialsWestEast((LevelAccessor)worldIn, pos);
        for (i = 0; i < 5; ++i) {
            b = blocks.get(i);
            if (b.m_60795_()) {
                BlockPortalKeyhole.speakLiterallyToPlayerAboutProblems(worldIn, player, 3, null);
                return;
            }
            if (BlockGoldPortal.isValidPortalFrameBlock(b.m_60734_())) continue;
            BlockPortalKeyhole.speakLiterallyToPlayerAboutProblems(worldIn, player, 4, b);
            return;
        }
        for (i = 5; i < 9; ++i) {
            b = blocks.get(i);
            if (b.m_60795_()) {
                BlockPortalKeyhole.speakLiterallyToPlayerAboutProblems(worldIn, player, 5, null);
                return;
            }
            if (BlockGoldPortal.isValidPortalFrameBlock(b.m_60734_())) continue;
            BlockPortalKeyhole.speakLiterallyToPlayerAboutProblems(worldIn, player, 6, b);
            return;
        }
        for (i = 9; i < 11; ++i) {
            b = blocks.get(i);
            if (b.m_60734_() == BlockRegistrar.BLOCK_GILDED_PORTAL.get()) continue;
            BlockPortalKeyhole.speakLiterallyToPlayerAboutProblems(worldIn, player, 7, b);
            return;
        }
        if (!dungeonExistsHere) {
            BlockPortalKeyhole.speakLiterallyToPlayerAboutProblems(worldIn, player, 11, null);
            return;
        }
        if (keyLevel < 2) {
            return;
        }
        for (i = 11; i < 13; ++i) {
            b = blocks.get(i);
            if (b.m_60734_() == BlockRegistrar.BLOCK_PORTAL_CROWN.get()) continue;
            BlockPortalKeyhole.speakLiterallyToPlayerAboutProblems(worldIn, player, 8, null);
            return;
        }
        BlockState leftSpireA = blocks.get(13);
        BlockState leftSpireB = blocks.get(14);
        BlockState rightSpireA = blocks.get(15);
        BlockState rightSpireB = blocks.get(16);
        if (leftSpireA.m_60734_() != Blocks.f_50430_ && leftSpireA.m_60734_() != Blocks.f_50388_ && leftSpireB.m_60734_() != Blocks.f_50430_ && leftSpireB.m_60734_() != Blocks.f_50388_) {
            BlockPortalKeyhole.speakLiterallyToPlayerAboutProblems(worldIn, player, 9, null);
            return;
        }
        if (rightSpireA.m_60734_() != Blocks.f_50430_ && rightSpireA.m_60734_() != Blocks.f_50388_ && rightSpireB.m_60734_() != Blocks.f_50430_ && rightSpireB.m_60734_() != Blocks.f_50388_) {
            BlockPortalKeyhole.speakLiterallyToPlayerAboutProblems(worldIn, player, 9, null);
            return;
        }
    }

    public static void speakLiterallyToPlayerAboutProblems(Level worldIn, Player playerIn, int problemID, @Nullable BlockState problemBlock) {
        MutableComponent text1 = Component.m_237115_((String)Component.m_237115_((String)("error.dimdungeons.portal_error_" + problemID)).getString());
        if (problemBlock != null) {
            String blockName = problemBlock.m_60734_().m_49954_().getString();
            text1 = Component.m_237113_((String)(Component.m_237115_((String)("error.dimdungeons.portal_error_" + problemID)).getString() + blockName + "."));
        }
        text1.m_130948_(text1.m_7383_().m_131155_(Boolean.valueOf(true)));
        text1.m_130948_(text1.m_7383_().m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.BLUE)));
        playerIn.m_5661_((Component)text1, true);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileEntityPortalKeyhole(pos, state);
    }
}

