/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.structures;

import com.google.common.collect.Queues;
import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.mixin.world.SinglePoolElementAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.world.StructurePoolAccessor;
import com.telepathicgrunt.the_bumblezone.utils.BoxOctree;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.mutable.MutableObject;

public class OptimizedJigsawManager {
    public static Optional<Structure.GenerationStub> assembleJigsawStructure(Structure.GenerationContext context, Holder<StructureTemplatePool> startPoolHolder, int size, ResourceLocation structureID, BlockPos startPos, boolean doBoundaryAdjustments, Optional<Heightmap.Types> heightmapType, int maxDistanceFromCenter, BiConsumer<StructurePiecesBuilder, List<PoolElementStructurePiece>> structureBoundsAdjuster) {
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        random.m_190068_(context.f_226627_(), context.f_226628_().f_45578_, context.f_226628_().f_45579_);
        StructureTemplatePool startPool = (StructureTemplatePool)startPoolHolder.m_203334_();
        if (startPool.m_210590_() == 0) {
            Bumblezone.LOGGER.warn("Bumblezone: Empty or nonexistent start pool in structure: {}  Crash is imminent", (Object)structureID);
            throw new RuntimeException("Bumblezone: Empty or nonexistent start pool in structure: " + structureID + " Crash is imminent");
        }
        StructurePoolElement startPieceBlueprint = startPool.m_227355_((RandomSource)random);
        if (startPieceBlueprint == EmptyPoolElement.f_210175_) {
            return Optional.empty();
        }
        if (!context.f_226630_().test(context.f_226622_().m_62218_().m_203407_(QuartPos.m_175400_((int)startPos.m_123341_()), QuartPos.m_175400_((int)startPos.m_123342_()), QuartPos.m_175400_((int)startPos.m_123343_()), context.f_226624_().m_224579_()))) {
            return Optional.empty();
        }
        Rotation rotation = Rotation.m_221990_((RandomSource)random);
        PoolElementStructurePiece startPiece = new PoolElementStructurePiece(context.f_226625_(), startPieceBlueprint, startPos, startPieceBlueprint.m_210540_(), rotation, startPieceBlueprint.m_214015_(context.f_226625_(), startPos, rotation));
        BoundingBox pieceBoundingBox = startPiece.m_73547_();
        int pieceCenterX = (pieceBoundingBox.m_162399_() + pieceBoundingBox.m_162395_()) / 2;
        int pieceCenterZ = (pieceBoundingBox.m_162401_() + pieceBoundingBox.m_162398_()) / 2;
        int pieceCenterY = startPos.m_123342_();
        if (heightmapType.isPresent()) {
            if ((pieceCenterY += GeneralUtils.getLowestLand(context.f_226622_(), context.f_226624_(), startPos, context.f_226629_(), true, heightmapType.get() == Heightmap.Types.OCEAN_FLOOR_WG).m_123342_()) >= GeneralUtils.getMaxTerrainLimit(context.f_226622_()) - pieceBoundingBox.m_162400_()) {
                return Optional.empty();
            }
            if (pieceCenterY <= context.f_226622_().m_142062_()) {
                return Optional.empty();
            }
        }
        int yAdjustment = pieceBoundingBox.m_162396_() + startPiece.m_72647_();
        startPiece.m_6324_(0, pieceCenterY - yAdjustment, 0);
        int finalPieceCenterY = pieceCenterY;
        Registry jigsawPoolRegistry = context.f_226621_().m_175515_(Registry.f_122884_);
        return Optional.of(new Structure.GenerationStub(new BlockPos(pieceCenterX, pieceCenterY, pieceCenterZ), structurePiecesBuilder -> {
            ArrayList<PoolElementStructurePiece> components = new ArrayList<PoolElementStructurePiece>();
            components.add(startPiece);
            components.clear();
            components.add(startPiece);
            if (size > 0) {
                AABB axisAlignedBB = new AABB((double)(pieceCenterX - maxDistanceFromCenter), (double)(finalPieceCenterY - (maxDistanceFromCenter + 40)), (double)(pieceCenterZ - maxDistanceFromCenter), (double)(pieceCenterX + maxDistanceFromCenter + 1), (double)(finalPieceCenterY + (maxDistanceFromCenter + 120)), (double)(pieceCenterZ + maxDistanceFromCenter + 1));
                BoxOctree boxOctree = new BoxOctree(axisAlignedBB);
                boxOctree.addBox(AABB.m_82321_((BoundingBox)pieceBoundingBox));
                Entry startPieceEntry = new Entry(startPiece, (MutableObject<BoxOctree>)new MutableObject((Object)boxOctree), finalPieceCenterY + 80, 0);
                Assembler assembler = new Assembler((Registry<StructureTemplatePool>)jigsawPoolRegistry, size, context, components, (RandomSource)random);
                assembler.availablePieces.addLast(startPieceEntry);
                while (!assembler.availablePieces.isEmpty()) {
                    Entry entry = assembler.availablePieces.removeFirst();
                    assembler.generatePiece(entry.piece, entry.boxOctreeMutableObject, entry.topYLimit, entry.depth, doBoundaryAdjustments, context.f_226629_());
                }
            }
            components.forEach(arg_0 -> ((StructurePiecesBuilder)structurePiecesBuilder).m_142679_(arg_0));
            structureBoundsAdjuster.accept((StructurePiecesBuilder)structurePiecesBuilder, (List<PoolElementStructurePiece>)components);
            if (structurePiecesBuilder.m_192798_().m_162400_() > context.f_226629_().m_151558_()) {
                structurePiecesBuilder.m_192796_();
                return;
            }
            if (components.isEmpty()) {
                return;
            }
            BlockPos structureCenter = ((PoolElementStructurePiece)components.get(0)).m_73547_().m_162394_();
            int xOffset = startPos.m_123341_() - structureCenter.m_123341_();
            int zOffset = startPos.m_123343_() - structureCenter.m_123343_();
            for (StructurePiece structurePiece : components) {
                structurePiece.m_6324_(xOffset, 0, zOffset);
            }
        }));
    }

    public record Entry(PoolElementStructurePiece piece, MutableObject<BoxOctree> boxOctreeMutableObject, int topYLimit, int depth) {
    }

    public static final class Assembler {
        private final Registry<StructureTemplatePool> poolRegistry;
        private final int maxDepth;
        private final ChunkGenerator chunkGenerator;
        private final RandomState randomState;
        private final StructureTemplateManager structureTemplateManager;
        private final List<? super PoolElementStructurePiece> structurePieces;
        private final RandomSource random;
        public final Deque<Entry> availablePieces = Queues.newArrayDeque();

        public Assembler(Registry<StructureTemplatePool> poolRegistry, int maxDepth, Structure.GenerationContext context, List<? super PoolElementStructurePiece> structurePieces, RandomSource random) {
            this.poolRegistry = poolRegistry;
            this.maxDepth = maxDepth;
            this.chunkGenerator = context.f_226622_();
            this.randomState = context.f_226624_();
            this.structureTemplateManager = context.f_226625_();
            this.structurePieces = structurePieces;
            this.random = random;
        }

        public void generatePiece(PoolElementStructurePiece piece, MutableObject<BoxOctree> boxOctree, int minY, int depth, boolean doBoundaryAdjustments, LevelHeightAccessor heightLimitView) {
            StructurePoolElement pieceBlueprint = piece.m_209918_();
            BlockPos piecePos = piece.m_72646_();
            Rotation pieceRotation = piece.m_6830_();
            BoundingBox pieceBoundingBox = piece.m_73547_();
            int pieceMinY = pieceBoundingBox.m_162396_();
            MutableObject<BoxOctree> parentOctree = new MutableObject<BoxOctree>();
            List pieceJigsawBlocks = pieceBlueprint.m_213638_(this.structureTemplateManager, piecePos, pieceRotation, this.random);
            for (StructureTemplate.StructureBlockInfo jigsawBlock : pieceJigsawBlocks) {
                StructurePoolElement generatedPiece;
                int targetPieceBoundsTop;
                MutableObject<BoxOctree> octreeToUse;
                Direction direction = JigsawBlock.m_54250_((BlockState)jigsawBlock.f_74676_);
                BlockPos jigsawBlockPos = jigsawBlock.f_74675_;
                BlockPos jigsawBlockTargetPos = jigsawBlockPos.m_121945_(direction);
                ResourceLocation jigsawBlockPool = new ResourceLocation(jigsawBlock.f_74677_.m_128461_("pool"));
                Optional poolOptional = this.poolRegistry.m_6612_(jigsawBlockPool);
                if (!poolOptional.isPresent() || ((StructureTemplatePool)poolOptional.get()).m_210590_() == 0 && !Objects.equals(jigsawBlockPool, Pools.f_127186_.m_135782_())) {
                    Bumblezone.LOGGER.warn("Bumblezone: Empty or nonexistent pool: {} which is being called from {}", (Object)jigsawBlockPool, pieceBlueprint instanceof SinglePoolElement ? ((SinglePoolElementAccessor)pieceBlueprint).getTemplate().left().get() : "not a SinglePoolElement class");
                    continue;
                }
                ResourceLocation jigsawBlockFallback = ((StructureTemplatePool)poolOptional.get()).m_210573_();
                Optional fallbackOptional = this.poolRegistry.m_6612_(jigsawBlockFallback);
                if (!fallbackOptional.isPresent() || ((StructureTemplatePool)fallbackOptional.get()).m_210590_() == 0 && !Objects.equals(jigsawBlockFallback, Pools.f_127186_.m_135782_())) {
                    Bumblezone.LOGGER.warn("Bumblezone: Empty or nonexistent pool: {} which is being called from {}", (Object)jigsawBlockFallback, pieceBlueprint instanceof SinglePoolElement ? ((SinglePoolElementAccessor)pieceBlueprint).getTemplate().left().get() : "not a SinglePoolElement class");
                    continue;
                }
                boolean isTargetInsideCurrentPiece = pieceBoundingBox.m_71051_((Vec3i)jigsawBlockTargetPos);
                if (isTargetInsideCurrentPiece) {
                    octreeToUse = parentOctree;
                    targetPieceBoundsTop = pieceMinY;
                    if (parentOctree.getValue() == null) {
                        parentOctree.setValue((Object)new BoxOctree(AABB.m_82321_((BoundingBox)pieceBoundingBox)));
                    }
                } else {
                    octreeToUse = boxOctree;
                    targetPieceBoundsTop = minY;
                }
                if (depth != this.maxDepth && (generatedPiece = this.processList(new ArrayList<Pair<StructurePoolElement, Integer>>(((StructurePoolAccessor)poolOptional.get()).getRawTemplates()), doBoundaryAdjustments, jigsawBlock, jigsawBlockTargetPos, pieceMinY, jigsawBlockPos, octreeToUse, piece, depth, targetPieceBoundsTop, heightLimitView)) != null) continue;
                this.processList(new ArrayList<Pair<StructurePoolElement, Integer>>(((StructurePoolAccessor)fallbackOptional.get()).getRawTemplates()), doBoundaryAdjustments, jigsawBlock, jigsawBlockTargetPos, pieceMinY, jigsawBlockPos, octreeToUse, piece, depth, targetPieceBoundsTop, heightLimitView);
            }
        }

        private StructurePoolElement processList(List<Pair<StructurePoolElement, Integer>> candidatePieces, boolean doBoundaryAdjustments, StructureTemplate.StructureBlockInfo jigsawBlock, BlockPos jigsawBlockTargetPos, int pieceMinY, BlockPos jigsawBlockPos, MutableObject<BoxOctree> boxOctreeMutableObject, PoolElementStructurePiece piece, int depth, int targetPieceBoundsTop, LevelHeightAccessor heightLimitView) {
            StructureTemplatePool.Projection piecePlacementBehavior = piece.m_209918_().m_210539_();
            boolean isPieceRigid = piecePlacementBehavior == StructureTemplatePool.Projection.RIGID;
            int jigsawBlockRelativeY = jigsawBlockPos.m_123342_() - pieceMinY;
            int surfaceHeight = -1;
            int totalCount = candidatePieces.stream().mapToInt(Pair::getSecond).reduce(0, Integer::sum);
            while (candidatePieces.size() > 0) {
                StructurePoolElement candidatePiece;
                Pair<StructurePoolElement, Integer> chosenPiecePair = candidatePieces.get(0);
                int chosenWeight = this.random.m_188503_(totalCount) + 1;
                for (Pair<StructurePoolElement, Integer> candidate : candidatePieces) {
                    if ((chosenWeight -= ((Integer)candidate.getSecond()).intValue()) > 0) continue;
                    chosenPiecePair = candidate;
                    break;
                }
                if ((candidatePiece = (StructurePoolElement)chosenPiecePair.getFirst()) == EmptyPoolElement.f_210175_) {
                    return null;
                }
                for (Rotation rotation : Rotation.m_221992_((RandomSource)this.random)) {
                    List candidateJigsawBlocks = candidatePiece.m_213638_(this.structureTemplateManager, BlockPos.f_121853_, rotation, this.random);
                    BoundingBox tempCandidateBoundingBox = candidatePiece.m_214015_(this.structureTemplateManager, BlockPos.f_121853_, rotation);
                    int candidateHeightAdjustments = doBoundaryAdjustments && tempCandidateBoundingBox.m_71057_() <= 16 ? candidateJigsawBlocks.stream().mapToInt(pieceCandidateJigsawBlock -> {
                        if (!tempCandidateBoundingBox.m_71051_((Vec3i)pieceCandidateJigsawBlock.f_74675_.m_121945_(JigsawBlock.m_54250_((BlockState)pieceCandidateJigsawBlock.f_74676_)))) {
                            return 0;
                        }
                        ResourceLocation candidateTargetPool = new ResourceLocation(pieceCandidateJigsawBlock.f_74677_.m_128461_("pool"));
                        Optional candidateTargetPoolOptional = this.poolRegistry.m_6612_(candidateTargetPool);
                        Optional<Integer> candidateTargetFallbackOptional = candidateTargetPoolOptional.flatMap(p_242843_1_ -> this.poolRegistry.m_6612_(p_242843_1_.m_210573_()));
                        int tallestCandidateTargetPoolPieceHeight = candidateTargetPoolOptional.map(p_242842_1_ -> p_242842_1_.m_227357_(this.structureTemplateManager)).orElse(0);
                        int tallestCandidateTargetFallbackPieceHeight = candidateTargetFallbackOptional.map(p_242840_1_ -> p_242840_1_.m_227357_(this.structureTemplateManager)).orElse(0);
                        return Math.max(tallestCandidateTargetPoolPieceHeight, tallestCandidateTargetFallbackPieceHeight);
                    }).max().orElse(0) : 0;
                    for (StructureTemplate.StructureBlockInfo candidateJigsawBlock : candidateJigsawBlocks) {
                        int candidateJigsawBlockY;
                        int adjustedCandidatePieceMinY;
                        if (!GeneralUtils.canJigsawsAttach(jigsawBlock, candidateJigsawBlock)) continue;
                        BlockPos candidateJigsawBlockPos = candidateJigsawBlock.f_74675_;
                        BlockPos candidateJigsawBlockRelativePos = new BlockPos(jigsawBlockTargetPos.m_123341_() - candidateJigsawBlockPos.m_123341_(), jigsawBlockTargetPos.m_123342_() - candidateJigsawBlockPos.m_123342_(), jigsawBlockTargetPos.m_123343_() - candidateJigsawBlockPos.m_123343_());
                        BoundingBox candidateBoundingBox = candidatePiece.m_214015_(this.structureTemplateManager, candidateJigsawBlockRelativePos, rotation);
                        StructureTemplatePool.Projection candidatePlacementBehavior = candidatePiece.m_210539_();
                        boolean isCandidateRigid = candidatePlacementBehavior == StructureTemplatePool.Projection.RIGID;
                        int candidateJigsawBlockRelativeY = candidateJigsawBlockPos.m_123342_();
                        int candidateJigsawYOffsetNeeded = jigsawBlockRelativeY - candidateJigsawBlockRelativeY + JigsawBlock.m_54250_((BlockState)jigsawBlock.f_74676_).m_122430_();
                        if (isPieceRigid && isCandidateRigid) {
                            adjustedCandidatePieceMinY = pieceMinY + candidateJigsawYOffsetNeeded;
                        } else {
                            if (surfaceHeight == -1) {
                                surfaceHeight = this.chunkGenerator.m_223221_(jigsawBlockPos.m_123341_(), jigsawBlockPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, heightLimitView, this.randomState);
                            }
                            adjustedCandidatePieceMinY = surfaceHeight - candidateJigsawBlockRelativeY;
                        }
                        int candidatePieceYOffsetNeeded = adjustedCandidatePieceMinY - candidateBoundingBox.m_162396_();
                        BoundingBox adjustedCandidateBoundingBox = candidateBoundingBox.m_71045_(0, candidatePieceYOffsetNeeded, 0);
                        BlockPos adjustedCandidateJigsawBlockRelativePos = candidateJigsawBlockRelativePos.m_7918_(0, candidatePieceYOffsetNeeded, 0);
                        if (candidateHeightAdjustments > 0) {
                            int k2 = Math.max(candidateHeightAdjustments + 1, adjustedCandidateBoundingBox.m_162400_() - adjustedCandidateBoundingBox.m_162396_());
                            adjustedCandidateBoundingBox.m_162371_(new BlockPos(adjustedCandidateBoundingBox.m_162395_(), adjustedCandidateBoundingBox.m_162396_() + k2, adjustedCandidateBoundingBox.m_162398_()));
                        }
                        AABB axisAlignedBB = AABB.m_82321_((BoundingBox)adjustedCandidateBoundingBox);
                        AABB axisAlignedBBDeflated = axisAlignedBB.m_82406_(0.25);
                        boolean validBounds = false;
                        if (((BoxOctree)boxOctreeMutableObject.getValue()).boundaryContains(axisAlignedBBDeflated) && !((BoxOctree)boxOctreeMutableObject.getValue()).intersectsAnyBox(axisAlignedBBDeflated)) {
                            ((BoxOctree)boxOctreeMutableObject.getValue()).addBox(axisAlignedBB);
                            validBounds = true;
                        }
                        if (!validBounds) continue;
                        int newPieceGroundLevelDelta = piece.m_72647_();
                        int groundLevelDelta = isCandidateRigid ? newPieceGroundLevelDelta - candidateJigsawYOffsetNeeded : candidatePiece.m_210540_();
                        PoolElementStructurePiece newPiece = new PoolElementStructurePiece(this.structureTemplateManager, candidatePiece, adjustedCandidateJigsawBlockRelativePos, groundLevelDelta, rotation, adjustedCandidateBoundingBox);
                        if (isPieceRigid) {
                            candidateJigsawBlockY = pieceMinY + jigsawBlockRelativeY;
                        } else if (isCandidateRigid) {
                            candidateJigsawBlockY = adjustedCandidatePieceMinY + candidateJigsawBlockRelativeY;
                        } else {
                            if (surfaceHeight == -1) {
                                surfaceHeight = this.chunkGenerator.m_223221_(jigsawBlockPos.m_123341_(), jigsawBlockPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, heightLimitView, this.randomState);
                            }
                            candidateJigsawBlockY = surfaceHeight + candidateJigsawYOffsetNeeded / 2;
                        }
                        piece.m_209916_(new JigsawJunction(jigsawBlockTargetPos.m_123341_(), candidateJigsawBlockY - jigsawBlockRelativeY + newPieceGroundLevelDelta, jigsawBlockTargetPos.m_123343_(), candidateJigsawYOffsetNeeded, candidatePlacementBehavior));
                        newPiece.m_209916_(new JigsawJunction(jigsawBlockPos.m_123341_(), candidateJigsawBlockY - candidateJigsawBlockRelativeY + groundLevelDelta, jigsawBlockPos.m_123343_(), -candidateJigsawYOffsetNeeded, piecePlacementBehavior));
                        this.structurePieces.add((PoolElementStructurePiece)newPiece);
                        if (depth + 1 <= this.maxDepth) {
                            this.availablePieces.addLast(new Entry(newPiece, boxOctreeMutableObject, targetPieceBoundsTop, depth + 1));
                        }
                        return candidatePiece;
                    }
                }
                totalCount -= ((Integer)chosenPiecePair.getSecond()).intValue();
                candidatePieces.remove(chosenPiecePair);
            }
            return null;
        }
    }
}

