/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class TagReplaceProcessor
extends StructureProcessor {
    public static final Codec<TagReplaceProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Registry.f_122824_.m_194605_().fieldOf("input_block").forGetter(config -> config.inputBlock), (App)TagKey.m_203877_((ResourceKey)Registry.f_122901_).fieldOf("output_block_tag").forGetter(config -> config.outputBlockTag), (App)TagKey.m_203877_((ResourceKey)Registry.f_122901_).fieldOf("blacklisted_output_block_tag").forGetter(config -> config.blacklistedOutputBlockTag), (App)Codec.BOOL.fieldOf("double_tall_flower").orElse((Object)false).forGetter(config -> config.doubleTallFlower), (App)Codec.BOOL.fieldOf("same_throughout_piece").orElse((Object)false).forGetter(config -> config.sameThroughoutPiece), (App)Codec.INT.fieldOf("seed_random_addition").orElse((Object)0).forGetter(config -> config.seedRandomAddition)).apply((Applicative)instance, instance.stable(TagReplaceProcessor::new)));
    private final Block inputBlock;
    private final TagKey<Block> outputBlockTag;
    private final TagKey<Block> blacklistedOutputBlockTag;
    private final boolean doubleTallFlower;
    private final boolean sameThroughoutPiece;
    private final int seedRandomAddition;

    public TagReplaceProcessor(Block inputBlock, TagKey<Block> outputBlockTag, TagKey<Block> blacklistedOutputBlockTag, boolean doubleTallFlower, boolean sameThroughoutPiece, int seedRandomAddition) {
        this.inputBlock = inputBlock;
        this.outputBlockTag = outputBlockTag;
        this.blacklistedOutputBlockTag = blacklistedOutputBlockTag;
        this.doubleTallFlower = doubleTallFlower;
        this.sameThroughoutPiece = sameThroughoutPiece;
        this.seedRandomAddition = seedRandomAddition;
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader worldReader, BlockPos pos, BlockPos pos2, StructureTemplate.StructureBlockInfo infoIn1, StructureTemplate.StructureBlockInfo infoIn2, StructurePlaceSettings settings) {
        Optional optionalBlocks;
        StructureTemplate.StructureBlockInfo returnInfo = infoIn2;
        if (infoIn2.f_74676_.m_60734_() == this.inputBlock && settings.m_74409_() != null && settings.m_74409_().m_71051_((Vec3i)infoIn2.f_74675_) && (optionalBlocks = Registry.f_122824_.m_203431_(this.outputBlockTag)).isPresent()) {
            RandomSource randomSource = this.sameThroughoutPiece ? settings.m_230326_(pos.m_6630_(this.seedRandomAddition)) : settings.m_230326_(infoIn2.f_74675_);
            List<Object> blockList = GeneralUtils.getListOfNonDummyBlocks(optionalBlocks).stream().filter(block -> !block.m_49966_().m_204336_(this.blacklistedOutputBlockTag)).toList();
            if (this.doubleTallFlower) {
                blockList = blockList.stream().filter(f -> f instanceof TallFlowerBlock).collect(Collectors.toList());
            }
            if (blockList.size() > 0) {
                BlockState newBlockState = blockList.get(randomSource.m_188503_(blockList.size())).m_49966_();
                for (Property property : infoIn2.f_74676_.m_61147_()) {
                    if (!newBlockState.m_61138_(property)) continue;
                    newBlockState = this.getStateWithProperty(newBlockState, infoIn2.f_74676_, property);
                }
                if (this.doubleTallFlower) {
                    returnInfo = new StructureTemplate.StructureBlockInfo(infoIn2.f_74675_, newBlockState, infoIn2.f_74677_);
                } else {
                    if (newBlockState.m_60734_() instanceof MultifaceBlock) {
                        for (Direction direction : Direction.values()) {
                            BooleanProperty faceProperty = MultifaceBlock.m_153933_((Direction)direction);
                            if (!newBlockState.m_61138_((Property)faceProperty)) continue;
                            newBlockState = (BlockState)newBlockState.m_61124_((Property)faceProperty, (Comparable)Boolean.valueOf(direction == Direction.DOWN));
                        }
                    }
                    ChunkAccess chunk = worldReader.m_46865_(infoIn2.f_74675_);
                    BlockState oldBlockstate = chunk.m_8055_(infoIn2.f_74675_);
                    BlockState belowOldBlockstate = chunk.m_8055_(infoIn2.f_74675_.m_7495_());
                    chunk.m_6978_(infoIn2.f_74675_, Blocks.f_50016_.m_49966_(), false);
                    chunk.m_6978_(infoIn2.f_74675_.m_7495_(), Blocks.f_50440_.m_49966_(), false);
                    if (newBlockState.m_60710_(worldReader, infoIn2.f_74675_)) {
                        returnInfo = new StructureTemplate.StructureBlockInfo(infoIn2.f_74675_, newBlockState, infoIn2.f_74677_);
                    }
                    chunk.m_6978_(infoIn2.f_74675_, oldBlockstate, false);
                    chunk.m_6978_(infoIn2.f_74675_.m_7495_(), belowOldBlockstate, false);
                }
            }
        }
        return returnInfo;
    }

    private <T extends Comparable<T>> BlockState getStateWithProperty(BlockState state, BlockState stateToCopy, Property<T> property) {
        return (BlockState)state.m_61124_(property, stateToCopy.m_61143_(property));
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)BzProcessors.TAG_REPLACE_PROCESSOR.get();
    }
}

