/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.dimension;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.capabilities.BzCapabilities;
import com.telepathicgrunt.the_bumblezone.entities.EntityTeleportationBackend;
import com.telepathicgrunt.the_bumblezone.modinit.BzDimension;
import com.telepathicgrunt.the_bumblezone.utils.ThreadExecutor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;

public class BzWorldSavedData
extends SavedData {
    private static final String TELEPORTATION_DATA = "the_bumblezoneteleportation";
    private static final BzWorldSavedData CLIENT_DUMMY = new BzWorldSavedData(null);
    private static final List<QueuedEntityData> QUEUED_ENTITIES_TO_TELEPORT = new ArrayList<QueuedEntityData>();

    public BzWorldSavedData(CompoundTag tag) {
    }

    public static BzWorldSavedData get(Level world) {
        if (!(world instanceof ServerLevel)) {
            return CLIENT_DUMMY;
        }
        DimensionDataStorage storage = ((ServerLevel)world).m_8895_();
        return (BzWorldSavedData)storage.m_164858_(BzWorldSavedData::new, TELEPORTATION_DATA);
    }

    public CompoundTag m_7176_(CompoundTag data) {
        return null;
    }

    public static void queueEntityToTeleport(Entity entity, ResourceKey<Level> destination) {
        if (!BzWorldSavedData.isEntityQueuedToTeleportAlready(entity)) {
            QUEUED_ENTITIES_TO_TELEPORT.add(new QueuedEntityData(entity, destination));
        }
    }

    public static boolean isEntityQueuedToTeleportAlready(Entity entity) {
        return QUEUED_ENTITIES_TO_TELEPORT.stream().anyMatch(entry -> entry.getEntity().equals((Object)entity));
    }

    public static void worldTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.level.m_5776_()) {
            BzWorldSavedData.tick((ServerLevel)event.level);
        }
    }

    public static void tick(ServerLevel world) {
        if (QUEUED_ENTITIES_TO_TELEPORT.size() == 0) {
            return;
        }
        HashSet<Entity> teleportedEntities = new HashSet<Entity>();
        for (QueuedEntityData entry2 : QUEUED_ENTITIES_TO_TELEPORT) {
            Entity entity;
            if (!entry2.getIsCurrentTeleporting()) {
                ServerPlayer serverPlayer;
                Entity entity2;
                entry2.setIsCurrentTeleporting(true);
                ResourceKey<Level> destinationKey = entry2.getDestination();
                if (destinationKey.equals(BzDimension.BZ_WORLD_KEY)) {
                    entity2 = entry2.getEntity();
                    if (entity2 instanceof ServerPlayer) {
                        serverPlayer = (ServerPlayer)entity2;
                        serverPlayer.m_5661_((Component)Component.m_237115_((String)"system.the_bumblezone.teleporting_into_bz"), true);
                    }
                    ThreadExecutor.dimensionDestinationSearch(world.m_7654_(), () -> {
                        try {
                            ServerLevel bumblezoneWorld = world.m_7654_().m_129880_(BzDimension.BZ_WORLD_KEY);
                            return Optional.of(EntityTeleportationBackend.getBzCoordinate(entry2.getEntity(), world, bumblezoneWorld));
                        }
                        catch (Throwable e) {
                            Bumblezone.LOGGER.error("Bumblezone: Failed to teleport entity. Error:");
                            Bumblezone.LOGGER.error((Object)e);
                            return Optional.empty();
                        }
                    }).thenOnServerThread(entry2::setDestinationPosFound);
                    continue;
                }
                entity2 = entry2.getEntity();
                if (entity2 instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)entity2;
                    serverPlayer.m_5661_((Component)Component.m_237115_((String)"system.the_bumblezone.teleporting_out_of_bz"), true);
                }
                ThreadExecutor.dimensionDestinationSearch(world.m_7654_(), () -> {
                    try {
                        ServerLevel destination = world.m_6018_().m_7654_().m_129880_(destinationKey);
                        return Optional.of(EntityTeleportationBackend.destPostFromOutOfBoundsTeleport(entry2.getEntity(), destination));
                    }
                    catch (Throwable e) {
                        Bumblezone.LOGGER.error("Bumblezone: Failed to teleport entity. Error:");
                        Bumblezone.LOGGER.error((Object)e);
                        return Optional.empty();
                    }
                }).thenOnServerThread(entry2::setDestinationPosFound);
                continue;
            }
            if (entry2.getDestinationPosFound() == null || teleportedEntities.contains(entity = entry2.getEntity())) continue;
            ResourceKey<Level> destinationKey = entry2.getDestination();
            ServerLevel destination = world.m_6018_().m_7654_().m_129880_(destinationKey);
            if (entry2.getDestinationPosFound().isPresent()) {
                Vec3 destinationPos = entry2.getDestinationPosFound().get();
                if (destinationKey.equals(BzDimension.BZ_WORLD_KEY)) {
                    BzWorldSavedData.enteringBumblezone(entity, destinationPos, teleportedEntities);
                    continue;
                }
                if (entity.m_6688_() != null) {
                    BzWorldSavedData.exitingBumblezone(entity.m_6688_(), destinationPos, destination, teleportedEntities);
                    continue;
                }
                BzWorldSavedData.exitingBumblezone(entity, destinationPos, destination, teleportedEntities);
                continue;
            }
            teleportedEntities.add(entity);
            if (!(entity instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.m_5661_((Component)Component.m_237115_((String)"system.the_bumblezone.failed_teleporting"), false);
            Bumblezone.LOGGER.error("Bumblezone: Failed to teleport entity. Aborting teleportation. Please retry. Entity: {}-{} Pos: {} Destination: {}", (Object)entity.getClass().getSimpleName(), (Object)entity.m_7755_(), (Object)entity.m_20182_(), destinationKey);
        }
        QUEUED_ENTITIES_TO_TELEPORT.removeIf(entry -> teleportedEntities.contains(entry.getEntity()));
    }

    public static void enteringBumblezone(Entity entity, Vec3 destinationPosFound, Set<Entity> teleportedEntities) {
        if (!entity.f_19853_.m_5776_()) {
            MinecraftServer minecraftServer = entity.m_20194_();
            ServerLevel bumblezoneWorld = minecraftServer.m_129880_(BzDimension.BZ_WORLD_KEY);
            BlockPos blockPos = new BlockPos(destinationPosFound);
            if (bumblezoneWorld != null && bumblezoneWorld.m_8055_(blockPos.m_7494_()).m_60828_((BlockGetter)bumblezoneWorld, blockPos.m_7494_())) {
                bumblezoneWorld.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
                bumblezoneWorld.m_46597_(blockPos.m_7494_(), Blocks.f_50016_.m_49966_());
                bumblezoneWorld.m_46597_(blockPos.m_7495_(), Blocks.f_50720_.m_49966_());
                bumblezoneWorld.m_46597_(blockPos.m_7494_().m_7494_(), Blocks.f_50720_.m_49966_());
                bumblezoneWorld.m_46597_(blockPos.m_122012_(), Blocks.f_50720_.m_49966_());
                bumblezoneWorld.m_46597_(blockPos.m_122024_(), Blocks.f_50720_.m_49966_());
                bumblezoneWorld.m_46597_(blockPos.m_122029_(), Blocks.f_50720_.m_49966_());
                bumblezoneWorld.m_46597_(blockPos.m_122019_(), Blocks.f_50720_.m_49966_());
                bumblezoneWorld.m_46597_(blockPos.m_122012_().m_7494_(), Blocks.f_50720_.m_49966_());
                bumblezoneWorld.m_46597_(blockPos.m_122024_().m_7494_(), Blocks.f_50720_.m_49966_());
                bumblezoneWorld.m_46597_(blockPos.m_122029_().m_7494_(), Blocks.f_50720_.m_49966_());
                bumblezoneWorld.m_46597_(blockPos.m_122019_().m_7494_(), Blocks.f_50720_.m_49966_());
            }
            entity.getCapability(BzCapabilities.ENTITY_POS_AND_DIM_CAPABILITY).ifPresent(capability -> {
                capability.setNonBZPos(entity.m_20182_());
                capability.setNonBZDim(entity.f_19853_.m_46472_().m_135782_());
                if (bumblezoneWorld == null) {
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer playerEntity = (ServerPlayer)entity;
                        Bumblezone.LOGGER.log(org.apache.logging.log4j.Level.INFO, "Bumblezone: Please restart the server. The Bumblezone dimension hasn't been made yet due to this bug: https://bugs.mojang.com/browse/MC-195468. A restart will fix this.");
                        MutableComponent message = Component.m_237110_((String)"system.the_bumblezone.missing_dimension", (Object[])new Object[]{Component.m_237115_((String)"system.the_bumblezone.missing_dimension_link").m_130940_(ChatFormatting.RED)});
                        playerEntity.m_5661_((Component)message, false);
                    }
                    teleportedEntities.add(entity);
                    return;
                }
                Entity baseVehicle = entity.m_20201_();
                BzWorldSavedData.teleportEntityAndAssignToVehicle(baseVehicle, null, bumblezoneWorld, destinationPosFound, teleportedEntities);
                ((ServerLevel)entity.f_19853_).m_8886_();
                bumblezoneWorld.m_8886_();
            });
        }
    }

    public static void exitingBumblezone(Entity entity, Vec3 destinationPosition, ServerLevel destination, Set<Entity> teleportedEntities) {
        BlockPos destBlockPos = new BlockPos(destinationPosition);
        if (destination.m_8055_(destBlockPos.m_7494_()).m_60828_((BlockGetter)destination, destBlockPos.m_7494_())) {
            destination.m_7731_(destBlockPos, Blocks.f_50016_.m_49966_(), 3);
            destination.m_7731_(destBlockPos.m_7494_(), Blocks.f_50016_.m_49966_(), 3);
        }
        Entity baseVehicle = entity.m_20201_();
        BzWorldSavedData.teleportEntityAndAssignToVehicle(baseVehicle, null, destination, destinationPosition, teleportedEntities);
        ((ServerLevel)entity.f_19853_).m_8886_();
        destination.m_8886_();
    }

    private static void teleportEntityAndAssignToVehicle(Entity entity, Entity vehicle, ServerLevel destination, Vec3 destinationPosition, Set<Entity> teleportedEntities) {
        Entity teleportedEntity;
        List passengers = entity.m_20197_();
        entity.m_20153_();
        entity.m_20091_();
        if (destination.m_46472_().equals(BzDimension.BZ_WORLD_KEY)) {
            entity.getCapability(BzCapabilities.ENTITY_POS_AND_DIM_CAPABILITY).ifPresent(capability -> {
                capability.setNonBZPos(entity.m_20182_());
                capability.setNonBZDim(entity.f_19853_.m_46472_().m_135782_());
            });
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (serverPlayer.m_5803_()) {
                serverPlayer.m_6145_(true, true);
            }
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundRespawnPacket(destination.m_220362_(), destination.m_46472_(), BiomeManager.m_47877_((long)destination.m_7328_()), serverPlayer.f_8941_.m_9290_(), serverPlayer.f_8941_.m_9293_(), destination.m_46659_(), destination.m_8584_(), true, serverPlayer.m_219759_()));
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundChangeDifficultyPacket(destination.m_46791_(), destination.m_6106_().m_5474_()));
            serverPlayer.m_8999_(destination, destinationPosition.f_82479_, destinationPosition.f_82480_ + (double)0.1f, destinationPosition.f_82481_, serverPlayer.m_146908_(), serverPlayer.m_146909_());
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundPlayerAbilitiesPacket(serverPlayer.m_150110_()));
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundLevelEventPacket(1032, BlockPos.f_121853_, 0, false));
            serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 20, 100, false, false, false));
            teleportedEntity = destination.m_46003_(serverPlayer.m_20148_());
        } else {
            Entity newEntity = entity;
            if ((newEntity = newEntity.m_6095_().m_20615_((Level)destination)) == null) {
                return;
            }
            newEntity.m_20361_(entity);
            newEntity.m_7678_(destinationPosition.f_82479_, destinationPosition.f_82480_, destinationPosition.f_82481_, entity.m_146908_(), entity.m_146909_());
            destination.m_143334_(newEntity);
            teleportedEntity = newEntity;
            entity.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
        }
        if (teleportedEntity != null) {
            teleportedEntities.add(entity);
            ChunkPos chunkpos = new ChunkPos(new BlockPos(destinationPosition.f_82479_, destinationPosition.f_82480_, destinationPosition.f_82481_));
            destination.m_7726_().m_8387_(TicketType.f_9448_, chunkpos, 1, (Object)entity.m_19879_());
            if (vehicle != null) {
                teleportedEntity.m_20329_(vehicle);
            }
            if (teleportedEntity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)teleportedEntity;
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                    for (MobEffectInstance effectInstance : livingEntity.m_21220_()) {
                        serverPlayer.f_8906_.m_9829_((Packet)new ClientboundUpdateMobEffectPacket(serverPlayer.m_19879_(), effectInstance));
                    }
                } else {
                    BzWorldSavedData.reAddStatusEffect(livingEntity);
                }
            }
            passengers.forEach(passenger -> BzWorldSavedData.teleportEntityAndAssignToVehicle(passenger, teleportedEntity, destination, destinationPosition, teleportedEntities));
        }
    }

    private static void reAddStatusEffect(LivingEntity livingEntity) {
        ArrayList effectInstanceList = new ArrayList(livingEntity.m_21220_());
        for (int i = effectInstanceList.size() - 1; i >= 0; --i) {
            MobEffectInstance effectInstance = (MobEffectInstance)effectInstanceList.get(i);
            if (effectInstance == null) continue;
            livingEntity.m_21195_(effectInstance.m_19544_());
            livingEntity.m_7292_(new MobEffectInstance(effectInstance.m_19544_(), effectInstance.m_19557_(), effectInstance.m_19564_(), effectInstance.m_19571_(), effectInstance.m_19572_(), effectInstance.m_19575_()));
        }
    }

    private static final class QueuedEntityData {
        private final Entity entity;
        private final ResourceKey<Level> destination;
        private boolean isCurrentTeleporting = false;
        private Optional<Vec3> destinationPosFound = null;

        public QueuedEntityData(Entity entity, ResourceKey<Level> destination) {
            this.entity = entity;
            this.destination = destination;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public ResourceKey<Level> getDestination() {
            return this.destination;
        }

        public Optional<Vec3> getDestinationPosFound() {
            return this.destinationPosFound;
        }

        public void setDestinationPosFound(Optional<Vec3> destinationPosFound) {
            this.destinationPosFound = destinationPosFound;
        }

        public boolean getIsCurrentTeleporting() {
            return this.isCurrentTeleporting;
        }

        public void setIsCurrentTeleporting(boolean isCurrentTeleporting) {
            this.isCurrentTeleporting = isCurrentTeleporting;
        }
    }
}

