/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.utils;

import com.google.common.collect.Lists;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.registries.ForgeRegistries;

public class EnchantmentUtils {
    public static int getPlayerXP(Player player) {
        return (int)((float)EnchantmentUtils.getExperienceForLevel(player.f_36078_) + player.f_36080_ * (float)player.m_36323_());
    }

    public static void addPlayerXP(Player player, int amount) {
        int experience;
        player.f_36079_ = experience = EnchantmentUtils.getPlayerXP(player) + amount;
        player.f_36078_ = EnchantmentUtils.getLevelForExperience(experience);
        int expForLevel = EnchantmentUtils.getExperienceForLevel(player.f_36078_);
        player.f_36080_ = (float)(experience - expForLevel) / (float)player.m_36323_();
    }

    public static int xpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    private static int sum(int n, int a0, int d) {
        return n * (2 * a0 + (n - 1) * d) / 2;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level <= 15) {
            return EnchantmentUtils.sum(level, 7, 2);
        }
        if (level <= 30) {
            return 315 + EnchantmentUtils.sum(level - 15, 37, 5);
        }
        return 1395 + EnchantmentUtils.sum(level - 30, 112, 9);
    }

    public static int getXpToNextLevel(int level) {
        int levelXP = EnchantmentUtils.getLevelForExperience(level);
        int nextXP = EnchantmentUtils.getExperienceForLevel(level + 1);
        return nextXP - levelXP;
    }

    public static int getLevelForExperience(int targetXp) {
        int level = 0;
        int xpToNextLevel;
        while (targetXp >= (xpToNextLevel = EnchantmentUtils.xpBarCap(level))) {
            ++level;
            targetXp -= xpToNextLevel;
        }
        return level;
    }

    public static float getPower(Level world, BlockPos position) {
        float power = 0.0f;
        for (int deltaZ = -1; deltaZ <= 1; ++deltaZ) {
            for (int deltaX = -1; deltaX <= 1; ++deltaX) {
                if (deltaZ == 0 && deltaX == 0 || !world.m_46859_(position.m_7918_(deltaX, 0, deltaZ)) || !world.m_46859_(position.m_7918_(deltaX, 1, deltaZ))) continue;
                power += EnchantmentUtils.getEnchantPower(world, position.m_7918_(deltaX * 2, 0, deltaZ * 2));
                power += EnchantmentUtils.getEnchantPower(world, position.m_7918_(deltaX * 2, 1, deltaZ * 2));
                if (deltaX == 0 || deltaZ == 0) continue;
                power += EnchantmentUtils.getEnchantPower(world, position.m_7918_(deltaX * 2, 0, deltaZ));
                power += EnchantmentUtils.getEnchantPower(world, position.m_7918_(deltaX * 2, 1, deltaZ));
                power += EnchantmentUtils.getEnchantPower(world, position.m_7918_(deltaX, 0, deltaZ * 2));
                power += EnchantmentUtils.getEnchantPower(world, position.m_7918_(deltaX, 1, deltaZ * 2));
            }
        }
        return power;
    }

    static float getEnchantPower(Level world, BlockPos pos) {
        return world.m_8055_(pos).getEnchantPowerBonus((LevelReader)world, pos);
    }

    public static void addAllBooks(Enchantment enchantment, List<ItemStack> items) {
        for (int i = enchantment.m_44702_(); i <= enchantment.m_6586_(); ++i) {
            items.add(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, i)));
        }
    }

    public static List<EnchantmentInstance> allAllowedEnchantsWithoutMaxLimit(int level, ItemStack stack, int xpTier) {
        ArrayList list = Lists.newArrayList();
        boolean bookFlag = stack.m_150930_(Items.f_42517_) || stack.m_150930_(Items.f_42690_);
        boolean allowTreasure = xpTier == 7;
        Map<Enchantment, Integer> existingEnchantments = EnchantmentUtils.getEnchantmentsOnBook(stack);
        block0: for (Enchantment enchantment : Registry.f_122825_) {
            boolean forceAllowed = Objects.requireNonNull(ForgeRegistries.ENCHANTMENTS.tags()).getTag(BzTags.FORCED_ALLOWED_CRYSTALLINE_FLOWER_ENCHANTMENTS).contains((Object)enchantment);
            boolean disallowed = Objects.requireNonNull(ForgeRegistries.ENCHANTMENTS.tags()).getTag(BzTags.DISALLOWED_CRYSTALLINE_FLOWER_ENCHANTMENTS).contains((Object)enchantment);
            if (!forceAllowed && disallowed) continue;
            int minLevelAllowed = enchantment.m_44702_();
            if (existingEnchantments.containsKey(enchantment)) {
                minLevelAllowed = Math.max(minLevelAllowed, existingEnchantments.get(enchantment) + 1);
            }
            if (enchantment.m_6591_() && !allowTreasure || !forceAllowed && !enchantment.m_6592_() || !enchantment.canApplyAtEnchantingTable(stack) && (!bookFlag || !enchantment.isAllowedOnBooks())) continue;
            for (int i = enchantment.m_6586_(); i > minLevelAllowed - 1; --i) {
                EnchantmentInstance enchantmentInstance;
                if (!forceAllowed && level < enchantment.m_6183_(i) || xpTier <= EnchantmentUtils.getEnchantmentTierCost(enchantmentInstance = new EnchantmentInstance(enchantment, i))) continue;
                list.add(enchantmentInstance);
                continue block0;
            }
        }
        list.sort(EnchantmentUtils::compareEnchantments);
        return list;
    }

    public static Map<Enchantment, Integer> getEnchantmentsOnBook(ItemStack itemStack) {
        ListTag listtag = EnchantedBookItem.m_41163_((ItemStack)itemStack);
        Object2IntOpenHashMap existingEnchants = new Object2IntOpenHashMap();
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            ResourceLocation resourcelocation1 = EnchantmentHelper.m_182446_((CompoundTag)compoundtag);
            if (resourcelocation1 == null) continue;
            existingEnchants.put(Objects.requireNonNull((Enchantment)Registry.f_122825_.m_7745_(resourcelocation1)), EnchantmentHelper.m_182438_((CompoundTag)compoundtag));
        }
        return existingEnchants;
    }

    public static int getEnchantmentTierCost(EnchantmentInstance enchantmentInstance) {
        return EnchantmentUtils.getEnchantmentTierCost(enchantmentInstance.f_44948_, enchantmentInstance.f_44947_.m_6183_(2), enchantmentInstance.f_44947_.m_6591_(), enchantmentInstance.f_44947_.m_6589_());
    }

    public static int getEnchantmentTierCost(int level, int minCost, boolean isTreasureOnly, boolean isCurse) {
        int cost = 0;
        cost += minCost / 10;
        cost = (int)((float)cost + (float)level / 1.5f);
        if (isTreasureOnly) {
            cost += 2;
        }
        if (isCurse) {
            cost -= 3;
        }
        return Math.max(1, Math.min(6, cost += ((Integer)BzGeneralConfigs.crystallineFlowerExtraTierCost.get()).intValue()));
    }

    public static int compareEnchantments(EnchantmentInstance enchantment1, EnchantmentInstance enchantment2) {
        ResourceKey resourceKey1 = (ResourceKey)Registry.f_122825_.m_7854_((Object)enchantment2.f_44947_).get();
        ResourceKey resourceKey2 = (ResourceKey)Registry.f_122825_.m_7854_((Object)enchantment1.f_44947_).get();
        int ret = resourceKey2.m_135782_().m_135815_().compareTo(resourceKey1.m_135782_().m_135815_());
        if (ret == 0) {
            ret = enchantment2.f_44948_ - enchantment1.f_44948_;
        }
        return ret;
    }
}

