/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.packets;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.QueensTradeManager;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.RandomizeTradeRowInput;
import com.telepathicgrunt.the_bumblezone.packets.MessageHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public record QueenRandomizerTradesSyncPacket(List<RandomizeTradeRowInput> recipeViewerRandomizerTrades) {
    public static Gson gson = new GsonBuilder().create();

    public static void sendToClient(ServerPlayer entity, List<RandomizeTradeRowInput> recipeViewerRandomizerTrades) {
        MessageHandler.DEFAULT_CHANNEL.send(PacketDistributor.PLAYER.with(() -> entity), (Object)new QueenRandomizerTradesSyncPacket(recipeViewerRandomizerTrades));
    }

    public static QueenRandomizerTradesSyncPacket parse(FriendlyByteBuf buf) {
        ArrayList<RandomizeTradeRowInput> parsedData = new ArrayList<RandomizeTradeRowInput>();
        CompoundTag data = buf.m_130261_();
        if (data == null) {
            Bumblezone.LOGGER.error("Queen Randomizer Trade packet is empty??? Wtf???");
            return new QueenRandomizerTradesSyncPacket(parsedData);
        }
        ListTag tagList = data.m_128437_("randomize_trades", 8);
        for (int i = 0; i < tagList.size(); ++i) {
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(tagList.m_128778_(i)));
            RandomizeTradeRowInput wantEntry = new RandomizeTradeRowInput(Optional.of(tagKey));
            parsedData.add(wantEntry);
        }
        return new QueenRandomizerTradesSyncPacket(parsedData);
    }

    public static void compose(QueenRandomizerTradesSyncPacket pkt, FriendlyByteBuf buf) {
        CompoundTag data = new CompoundTag();
        ListTag listTag = new ListTag();
        for (int i = 0; i < pkt.recipeViewerRandomizerTrades().size(); ++i) {
            listTag.add((Object)StringTag.m_129297_((String)pkt.recipeViewerRandomizerTrades().get(i).tagKey().get().f_203868_().toString()));
        }
        data.m_128365_("randomize_trades", (Tag)listTag);
        buf.m_130079_(data);
    }

    public static class Handler {
        public static void handle(QueenRandomizerTradesSyncPacket pkt, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerRandomizerTrades = pkt.recipeViewerRandomizerTrades();
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

