/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.packets;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.QueensTradeManager;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.WeightedTradeResult;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.MainTradeRowInput;
import com.telepathicgrunt.the_bumblezone.packets.MessageHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public record QueenMainTradesSyncPacket(List<Pair<MainTradeRowInput, WeightedRandomList<WeightedTradeResult>>> recipeViewerMainTrades) {
    public static Gson gson = new GsonBuilder().create();

    public static void sendToClient(ServerPlayer entity, List<Pair<MainTradeRowInput, WeightedRandomList<WeightedTradeResult>>> recipeViewerMainTrades) {
        MessageHandler.DEFAULT_CHANNEL.send(PacketDistributor.PLAYER.with(() -> entity), (Object)new QueenMainTradesSyncPacket(recipeViewerMainTrades));
    }

    public static QueenMainTradesSyncPacket parse(FriendlyByteBuf buf) {
        ArrayList<Pair<MainTradeRowInput, WeightedRandomList<WeightedTradeResult>>> parsedData = new ArrayList<Pair<MainTradeRowInput, WeightedRandomList<WeightedTradeResult>>>();
        CompoundTag data = buf.m_130261_();
        if (data == null) {
            Bumblezone.LOGGER.error("Queen Main Trade packet is empty??? Wtf???");
            return new QueenMainTradesSyncPacket(parsedData);
        }
        ListTag tagList = data.m_128437_("main_trades", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag tradeCompound = tagList.m_128728_(i);
            CompoundTag firstHalf = tradeCompound.m_128469_("input");
            ListTag secondHalf = tradeCompound.m_128437_("output", 10);
            DataResult dataResult1 = MainTradeRowInput.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)firstHalf);
            dataResult1.error().ifPresent(e -> Bumblezone.LOGGER.error("Failed to parse Queen Main Trade packet entry (first half): {}", (Object)e.toString()));
            DataResult dataResult2 = WeightedRandomList.m_146333_(WeightedTradeResult.CODEC).parse((DynamicOps)NbtOps.f_128958_, (Object)secondHalf);
            dataResult2.error().ifPresent(e -> Bumblezone.LOGGER.error("Failed to parse Queen Main Trade packet entry (second half): {}", (Object)e.toString()));
            dataResult1.result().ifPresent(input -> dataResult2.result().ifPresent(output -> parsedData.add(Pair.of((Object)input, (Object)output))));
        }
        return new QueenMainTradesSyncPacket(parsedData);
    }

    public static void compose(QueenMainTradesSyncPacket pkt, FriendlyByteBuf buf) {
        CompoundTag data = new CompoundTag();
        ListTag listTag = new ListTag();
        for (Pair<MainTradeRowInput, WeightedRandomList<WeightedTradeResult>> tradeRow : pkt.recipeViewerMainTrades()) {
            CompoundTag pairData = new CompoundTag();
            DataResult dataResult1 = MainTradeRowInput.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)((MainTradeRowInput)tradeRow.getFirst()));
            dataResult1.error().ifPresent(e -> Bumblezone.LOGGER.error("Failed to encode Queen Main Trade packet entry (first half): {}", (Object)e.toString()));
            dataResult1.result().ifPresent(r -> pairData.m_128365_("input", r));
            DataResult dataResult = WeightedRandomList.m_146333_(WeightedTradeResult.CODEC).encodeStart((DynamicOps)NbtOps.f_128958_, (Object)((WeightedRandomList)tradeRow.getSecond()));
            dataResult.error().ifPresent(e -> Bumblezone.LOGGER.error("Failed to encode Queen Main Trade packet entry (second half): {}", (Object)e.toString()));
            dataResult.result().ifPresent(r -> pairData.m_128365_("output", r));
            listTag.add((Object)pairData);
        }
        data.m_128365_("main_trades", (Tag)listTag);
        buf.m_130079_(data);
    }

    public static class Handler {
        public static void handle(QueenMainTradesSyncPacket pkt, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerMainTrades = pkt.recipeViewerMainTrades();
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

