/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;

public class DrawableResource
implements IDrawableStatic {
    private final ResourceLocation resourceLocation;
    private final int textureWidth;
    private final int textureHeight;
    private final int u;
    private final int v;
    private final int width;
    private final int height;
    private final int paddingTop;
    private final int paddingBottom;
    private final int paddingLeft;
    private final int paddingRight;

    public DrawableResource(ResourceLocation resourceLocation, int u, int v, int width, int height, int paddingTop, int paddingBottom, int paddingLeft, int paddingRight, int textureWidth, int textureHeight) {
        this.resourceLocation = resourceLocation;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.u = u;
        this.v = v;
        this.width = width;
        this.height = height;
        this.paddingTop = paddingTop;
        this.paddingBottom = paddingBottom;
        this.paddingLeft = paddingLeft;
        this.paddingRight = paddingRight;
    }

    public int getWidth() {
        return this.width + this.paddingLeft + this.paddingRight;
    }

    public int getHeight() {
        return this.height + this.paddingTop + this.paddingBottom;
    }

    public void draw(PoseStack poseStack, int xOffset, int yOffset) {
        this.draw(poseStack, xOffset, yOffset, 0, 0, 0, 0);
    }

    public void draw(PoseStack poseStack, int xOffset, int yOffset, int maskTop, int maskBottom, int maskLeft, int maskRight) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.resourceLocation);
        int x = xOffset + this.paddingLeft + maskLeft;
        int y = yOffset + this.paddingTop + maskTop;
        int u = this.u + maskLeft;
        int v = this.v + maskTop;
        int width = this.width - maskRight - maskLeft;
        int height = this.height - maskBottom - maskTop;
        float f = 1.0f / (float)this.textureWidth;
        float f1 = 1.0f / (float)this.textureHeight;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        bufferbuilder.m_85982_(matrix, (float)x, (float)(y + height), 0.0f).m_7421_((float)u * f, ((float)v + (float)height) * f1).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)(x + width), (float)(y + height), 0.0f).m_7421_(((float)u + (float)width) * f, ((float)v + (float)height) * f1).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)(x + width), (float)y, 0.0f).m_7421_(((float)u + (float)width) * f, (float)v * f1).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)x, (float)y, 0.0f).m_7421_((float)u * f, (float)v * f1).m_5752_();
        tessellator.m_85914_();
    }
}

