/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.QueensTradeManager;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.WeightedTradeResult;
import com.telepathicgrunt.the_bumblezone.items.recipes.IncenseCandleRecipe;
import com.telepathicgrunt.the_bumblezone.modcompat.FakeIncenseCandleRecipeCreator;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.MainTradeRowInput;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.RandomizeTradeRowInput;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.rei.QueenRandomizerTradesREICategory;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.rei.QueenTradesREICategory;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.rei.REIQueenRandomizerTradesInfo;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.rei.REIQueenTradesInfo;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.screens.CrystallineFlowerScreen;
import java.util.List;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.screen.OverlayDecider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.forge.REIPluginClient;
import me.shedaniel.rei.plugin.client.BuiltinClientPlugin;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;

@REIPluginClient
public class REICompat
implements REIClientPlugin {
    public static final CategoryIdentifier<REIQueenTradesInfo> QUEEN_TRADES = CategoryIdentifier.of((String)"the_bumblezone", (String)"queen_trades");
    public static final CategoryIdentifier<REIQueenRandomizerTradesInfo> QUEEN_RANDOMIZE_TRADES = CategoryIdentifier.of((String)"the_bumblezone", (String)"queen_color_randomizer_trades");

    public void registerDisplays(DisplayRegistry registry) {
        BzItems.CUSTOM_CREATIVE_TAB_ITEMS.forEach(item -> REICompat.addInfo((Item)item.get()));
        REICompat.addInfo((Item)BzItems.PILE_OF_POLLEN.get());
        REICompat.addInfo((Fluid)BzFluids.SUGAR_WATER_FLUID.get());
        REICompat.addInfo((Fluid)BzFluids.ROYAL_JELLY_FLUID.get());
        REICompat.addInfo((Fluid)BzFluids.HONEY_FLUID.get());
        registry.getRecipeManager().m_44043_(new ResourceLocation("the_bumblezone", "incense_candle_from_super_candles")).ifPresent(recipe -> REICompat.registerExtraRecipes(recipe, registry, true));
        registry.getRecipeManager().m_44043_(new ResourceLocation("the_bumblezone", "incense_candle")).ifPresent(recipe -> REICompat.registerExtraRecipes(recipe, registry, false));
        if (!QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerMainTrades.isEmpty()) {
            for (Pair<MainTradeRowInput, WeightedRandomList<WeightedTradeResult>> trade : QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerMainTrades) {
                for (WeightedTradeResult weightedTradeResult : ((WeightedRandomList)trade.getSecond()).m_146338_()) {
                    List<ItemStack> rewardCollection = weightedTradeResult.getItems().stream().map(e -> new ItemStack((ItemLike)e, weightedTradeResult.count)).toList();
                    registry.add((Display)new REIQueenTradesInfo(((MainTradeRowInput)trade.getFirst()).tagKey().isPresent() ? EntryIngredients.ofItemTag(((MainTradeRowInput)trade.getFirst()).tagKey().get()) : EntryIngredients.of((ItemLike)((MainTradeRowInput)trade.getFirst()).item()), (TagKey<Item>)((TagKey)((MainTradeRowInput)trade.getFirst()).tagKey().orElse(null)), EntryIngredients.ofItemStacks(rewardCollection), (TagKey<Item>)((TagKey)weightedTradeResult.tagKey.orElse(null)), weightedTradeResult.xpReward, weightedTradeResult.weight, weightedTradeResult.getTotalWeight()), QUEEN_TRADES);
                }
            }
        }
        if (!QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerRandomizerTrades.isEmpty()) {
            for (RandomizeTradeRowInput tradeEntry : QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerRandomizerTrades) {
                List<ItemStack> randomizeStack = tradeEntry.getWantItems().m_203614_().map(e -> ((Item)e.m_203334_()).m_7968_()).toList();
                for (ItemStack input : randomizeStack) {
                    registry.add((Display)new REIQueenRandomizerTradesInfo(EntryIngredients.of((ItemStack)input), EntryIngredients.ofItemStacks(randomizeStack), (TagKey<Item>)((TagKey)tradeEntry.tagKey().orElse(null)), 1, randomizeStack.size()), QUEEN_RANDOMIZE_TRADES);
                }
            }
        }
    }

    private static void addInfo(Item item) {
        BuiltinClientPlugin.getInstance().registerInformation(EntryStacks.of((ItemLike)item), (Component)Component.m_237115_((String)Registry.f_122827_.m_7981_((Object)item).toString()), text -> {
            text.add(Component.m_237115_((String)("the_bumblezone." + Registry.f_122827_.m_7981_((Object)item).m_135815_() + ".description")));
            return text;
        });
    }

    private static void addInfo(Fluid fluid) {
        BuiltinClientPlugin.getInstance().registerInformation(EntryStacks.of((Fluid)fluid, (long)1L), (Component)Component.m_237115_((String)Registry.f_122822_.m_7981_((Object)fluid).toString()), text -> {
            text.add(Component.m_237115_((String)("the_bumblezone." + Registry.f_122822_.m_7981_((Object)fluid).m_135815_() + ".description")));
            return text;
        });
    }

    private static void registerExtraRecipes(Recipe<?> baseRecipe, DisplayRegistry registry, boolean oneRecipeOnly) {
        if (baseRecipe instanceof IncenseCandleRecipe) {
            IncenseCandleRecipe incenseCandleRecipe = (IncenseCandleRecipe)baseRecipe;
            List<CraftingRecipe> extraRecipes = FakeIncenseCandleRecipeCreator.constructFakeRecipes(incenseCandleRecipe, oneRecipeOnly);
            extraRecipes.forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
        }
    }

    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new QueenTradesREICategory());
        registry.add((DisplayCategory)new QueenRandomizerTradesREICategory());
        registry.addWorkstations(QUEEN_TRADES, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)BzItems.BEE_QUEEN_SPAWN_EGG.get()))});
        registry.addWorkstations(QUEEN_RANDOMIZE_TRADES, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)BzItems.BEE_QUEEN_SPAWN_EGG.get()))});
    }

    public void registerScreens(ScreenRegistry registry) {
        registry.registerDecider(new OverlayDecider(){

            public <R extends Screen> boolean isHandingScreen(Class<R> screen) {
                return true;
            }

            public <R extends Screen> InteractionResult shouldScreenBeOverlaid(R screen) {
                return screen.getClass() == CrystallineFlowerScreen.class ? InteractionResult.FAIL : InteractionResult.PASS;
            }
        });
    }
}

