/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.mixin.blocks.DispenserBlockInvoker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ProductiveBeesDispenseBehavior;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehiveAbstract;
import cy.jdkdigital.productivebees.common.block.ConfigurableCombBlock;
import cy.jdkdigital.productivebees.common.block.ExpansionBox;
import cy.jdkdigital.productivebees.common.block.entity.CombBlockBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.state.properties.VerticalHive;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;

public class ProductiveBeesCompat {
    private static final Lazy<List<String>> SPIDER_DUNGEON_HONEYCOMBS = Lazy.of(() -> BeeReloadListener.INSTANCE.getData().entrySet().stream().filter(e -> {
        CompoundTag tag = (CompoundTag)e.getValue();
        int primary = tag.m_128451_("primaryColor");
        return ((List)BzModCompatibilityConfigs.allowedCombsForDungeons.get()).contains(e.getKey()) && tag.m_128471_("createComb") && (ProductiveBeesCompat.colorsAreClose(new Color(106, 127, 0), new Color(primary), 150) || ProductiveBeesCompat.colorsAreClose(new Color(129, 198, 0), new Color(primary), 150) || ProductiveBeesCompat.colorsAreClose(new Color(34, 45, 0), new Color(primary), 150));
    }).map(Map.Entry::getKey).toList());
    private static final Lazy<List<String>> BEE_DUNGEON_HONEYCOMBS = Lazy.of(() -> BeeReloadListener.INSTANCE.getData().entrySet().stream().filter(e -> {
        CompoundTag tag = (CompoundTag)e.getValue();
        return ((List)BzModCompatibilityConfigs.allowedCombsForDungeons.get()).contains(e.getKey()) && tag.m_128471_("createComb") && !((List)SPIDER_DUNGEON_HONEYCOMBS.get()).contains(e.getKey());
    }).map(Map.Entry::getKey).toList());
    private static final Lazy<List<String>> ORE_HONEYCOMBS = Lazy.of(() -> BeeReloadListener.INSTANCE.getData().entrySet().stream().filter(e -> ((List)BzModCompatibilityConfigs.allowedCombsAsOres.get()).contains(e.getKey()) && ((CompoundTag)e.getValue()).m_128471_("createComb")).map(Map.Entry::getKey).toList());
    private static final Lazy<List<String>> ALL_BEES = Lazy.of(() -> BeeReloadListener.INSTANCE.getData().keySet().stream().filter(e -> ((List)BzModCompatibilityConfigs.allowedBees.get()).contains(e)).toList());
    public static final TagKey<Block> SOLITARY_OVERWORLD_NESTS_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation("productivebees", "solitary_overworld_nests"));
    protected static Item BEE_CAGE;
    protected static Item STURDY_BEE_CAGE;

    public static void setupCompat() {
        BEE_CAGE = (Item)Registry.f_122827_.m_7745_(new ResourceLocation("productivebees", "bee_cage"));
        STURDY_BEE_CAGE = (Item)Registry.f_122827_.m_7745_(new ResourceLocation("productivebees", "sturdy_bee_cage"));
        if (BEE_CAGE != Items.f_41852_ && ((Boolean)BzModCompatibilityConfigs.allowProductiveBeesBeeCageRevivingEmptyBroodBlock.get()).booleanValue()) {
            ProductiveBeesDispenseBehavior.DEFAULT_BEE_CAGED_DISPENSE_BEHAVIOR = ((DispenserBlockInvoker)Blocks.f_50061_).invokeGetDispenseMethod(new ItemStack((ItemLike)BEE_CAGE));
            DispenserBlock.m_52672_((ItemLike)BEE_CAGE, (DispenseItemBehavior)new ProductiveBeesDispenseBehavior());
        }
        if (STURDY_BEE_CAGE != Items.f_41852_ && ((Boolean)BzModCompatibilityConfigs.allowProductiveBeesBeeCageRevivingEmptyBroodBlock.get()).booleanValue()) {
            ProductiveBeesDispenseBehavior.DEFAULT_STURDY_BEE_CAGED_DISPENSE_BEHAVIOR = ((DispenserBlockInvoker)Blocks.f_50061_).invokeGetDispenseMethod(new ItemStack((ItemLike)STURDY_BEE_CAGE));
            DispenserBlock.m_52672_((ItemLike)STURDY_BEE_CAGE, (DispenseItemBehavior)new ProductiveBeesDispenseBehavior());
        }
        ModChecker.productiveBeesPresent = true;
    }

    private static boolean colorsAreClose(Color a, Color z, int threshold) {
        int b;
        int g;
        int r = a.getRed() - z.getRed();
        return r * r + (g = a.getGreen() - z.getGreen()) * g + (b = a.getBlue() - z.getBlue()) * b <= threshold * threshold;
    }

    public static boolean PBIsExpandedBeehiveBlock(BlockState block) {
        if (block.m_60734_() instanceof ExpansionBox && block.m_61143_((Property)AdvancedBeehive.EXPANDED) != VerticalHive.NONE) {
            return true;
        }
        if (block.m_204336_(SOLITARY_OVERWORLD_NESTS_TAG)) {
            return true;
        }
        return block.m_60734_() instanceof AdvancedBeehiveAbstract;
    }

    public static boolean PBMobSpawnEvent(LivingSpawnEvent.CheckSpawn event, boolean isChild) {
        if (((List)ALL_BEES.get()).size() == 0 || event.getSpawnReason() == MobSpawnType.DISPENSER && !((Boolean)BzModCompatibilityConfigs.allowProductiveBeesSpawnFromDispenserFedBroodBlock.get()).booleanValue()) {
            return false;
        }
        Mob entity = event.getEntity();
        LevelAccessor world = event.getLevel();
        ConfigurableBee productiveBeeEntity = (ConfigurableBee)((EntityType)ModEntities.CONFIGURABLE_BEE.get()).m_20615_(entity.f_19853_);
        if (productiveBeeEntity == null) {
            return false;
        }
        BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)entity.m_20183_());
        productiveBeeEntity.m_7678_((double)((float)blockpos.m_123341_() + 0.5f), (double)((float)blockpos.m_123342_() + 0.5f), (double)((float)blockpos.m_123343_() + 0.5f), productiveBeeEntity.m_217043_().m_188501_() * 360.0f, 0.0f);
        productiveBeeEntity.m_6863_(isChild);
        CompoundTag newTag = new CompoundTag();
        newTag.m_128359_("type", (String)((List)ALL_BEES.get()).get(productiveBeeEntity.m_217043_().m_188503_(((List)ALL_BEES.get()).size())));
        productiveBeeEntity.m_6518_((ServerLevelAccessor)world, world.m_6436_(productiveBeeEntity.m_20183_()), event.getSpawnReason(), null, newTag);
        productiveBeeEntity.setBeeType(newTag.m_128461_("type"));
        world.m_7967_((Entity)productiveBeeEntity);
        return true;
    }

    public static boolean PBIsConfigurableComb(Block block) {
        return block instanceof ConfigurableCombBlock;
    }

    public static void placeConfigurableCombBlockEntity(BlockPos.MutableBlockPos blockposMutable, ChunkAccess cachedChunk, String nbt, OreConfiguration.TargetBlockState targetBlockState, Block combBlock) {
        if (nbt != null) {
            cachedChunk.m_6978_((BlockPos)blockposMutable, targetBlockState.f_161033_, false);
            CombBlockBlockEntity be = (CombBlockBlockEntity)((ConfigurableCombBlock)combBlock).m_142194_((BlockPos)blockposMutable, targetBlockState.f_161033_);
            be.setType(nbt);
            cachedChunk.m_142169_((BlockEntity)be);
        }
    }

    public static String PBGetRandomCombType(RandomSource random) {
        if (!((Boolean)BzModCompatibilityConfigs.spawnProductiveBeesHoneycombVariants.get()).booleanValue() || ((List)ORE_HONEYCOMBS.get()).size() == 0) {
            return null;
        }
        return (String)((List)ORE_HONEYCOMBS.get()).get(random.m_188503_(((List)ORE_HONEYCOMBS.get()).size()));
    }

    public static StructureTemplate.StructureBlockInfo PBGetRottenedHoneycomb(BlockPos worldPos, RandomSource random) {
        if (!((Boolean)BzModCompatibilityConfigs.spawnProductiveBeesHoneycombVariants.get()).booleanValue() || ((List)SPIDER_DUNGEON_HONEYCOMBS.get()).size() == 0) {
            return null;
        }
        CompoundTag newTag = new CompoundTag();
        newTag.m_128359_("type", (String)((List)SPIDER_DUNGEON_HONEYCOMBS.get()).get(random.m_188503_(((List)SPIDER_DUNGEON_HONEYCOMBS.get()).size())));
        return new StructureTemplate.StructureBlockInfo(worldPos, ((Block)ModBlocks.CONFIGURABLE_COMB.get()).m_49966_(), newTag);
    }

    public static StructureTemplate.StructureBlockInfo PBGetRandomHoneycomb(BlockPos worldPos, RandomSource random) {
        if (!((Boolean)BzModCompatibilityConfigs.spawnProductiveBeesHoneycombVariants.get()).booleanValue() || ((List)BEE_DUNGEON_HONEYCOMBS.get()).size() == 0) {
            return null;
        }
        CompoundTag newTag = new CompoundTag();
        newTag.m_128359_("type", (String)((List)BEE_DUNGEON_HONEYCOMBS.get()).get(random.m_188503_(((List)BEE_DUNGEON_HONEYCOMBS.get()).size())));
        return new StructureTemplate.StructureBlockInfo(worldPos, ((Block)ModBlocks.CONFIGURABLE_COMB.get()).m_49966_(), newTag);
    }

    public static boolean isFilledBeeCageItem(ItemStack stack) {
        return !stack.m_41619_() && (stack.m_150930_(BEE_CAGE) || stack.m_150930_(STURDY_BEE_CAGE)) && !stack.m_41619_() && stack.m_41782_() && stack.m_41784_().m_128441_("entity");
    }

    public static boolean isFilledBabyBeeCageItem(ItemStack stack) {
        return ProductiveBeesCompat.isFilledBeeCageItem(stack) && stack.m_41784_().m_128451_("Age") < 0;
    }

    public static InteractionResult beeCageInteract(ItemStack itemstack, Player playerEntity, InteractionHand playerHand) {
        if (ProductiveBeesCompat.isFilledBeeCageItem(itemstack) && !playerEntity.m_6047_()) {
            GeneralUtils.givePlayerItem(playerEntity, playerHand, itemstack.m_150930_(STURDY_BEE_CAGE) ? STURDY_BEE_CAGE.m_7968_() : BEE_CAGE.m_7968_(), true, true);
            return ProductiveBeesCompat.isFilledBabyBeeCageItem(itemstack) ? InteractionResult.CONSUME_PARTIAL : InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }
}

