/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modinit.BzDimension;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import pokecube.api.data.PokedexEntry;
import pokecube.api.data.spawns.SpawnBiomeMatcher;
import pokecube.api.entity.pokemob.IPokemob;
import pokecube.api.entity.pokemob.PokemobCaps;
import pokecube.core.PokecubeCore;
import pokecube.core.database.Database;
import pokecube.core.entity.pokemobs.helper.PokemobBase;
import thut.api.maths.Vector3;

public class PokecubeCompat {
    private static final List<PokedexEntry> BABY_POKECUBE_POKEMON_LIST = new ArrayList<PokedexEntry>();
    private static final List<PokedexEntry> POKECUBE_POKEMON_LIST = new ArrayList<PokedexEntry>();

    public static void setupCompat() {
        BABY_POKECUBE_POKEMON_LIST.add(Database.getEntry((String)"Combee"));
        BABY_POKECUBE_POKEMON_LIST.add(Database.getEntry((String)"Weedle"));
        BABY_POKECUBE_POKEMON_LIST.add(Database.getEntry((String)"Cutiefly"));
        POKECUBE_POKEMON_LIST.addAll(BABY_POKECUBE_POKEMON_LIST);
        POKECUBE_POKEMON_LIST.add(Database.getEntry((String)"Ribombee"));
        POKECUBE_POKEMON_LIST.add(Database.getEntry((String)"Vespiquen"));
        POKECUBE_POKEMON_LIST.add(Database.getEntry((String)"Kakuna"));
        POKECUBE_POKEMON_LIST.add(Database.getEntry((String)"Beedrill"));
        ModChecker.pokecubePresent = true;
    }

    public static boolean PCMobSpawnEvent(LivingSpawnEvent.CheckSpawn event, boolean isChild) {
        List<PokedexEntry> pokemonListToUse;
        List<PokedexEntry> list = pokemonListToUse = isChild ? BABY_POKECUBE_POKEMON_LIST : POKECUBE_POKEMON_LIST;
        if (pokemonListToUse.size() == 0) {
            Bumblezone.LOGGER.warn("Error! List of POKECUBE_POKEMON_LIST is empty! Cannot spawn their bees. Please let TelepathicGrunt (The Bumblezone dev) know about this!");
            return false;
        }
        Mob entity = event.getEntity();
        LevelAccessor world = event.getLevel();
        if (world instanceof WorldGenRegion) {
            return false;
        }
        PokedexEntry pokemonDatabase = pokemonListToUse.get(world.m_213780_().m_188503_(pokemonListToUse.size()));
        PokedexEntry.SpawnData spawn = pokemonDatabase.getSpawnData();
        if (spawn == null) {
            return false;
        }
        Mob pokemon = PokecubeCore.createPokemob((PokedexEntry)pokemonDatabase, (Level)entity.f_19853_);
        if (pokemon == null) {
            return false;
        }
        pokemon.m_21153_(pokemon.m_21233_());
        pokemon.m_6863_(isChild);
        BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)entity.m_20183_());
        ChunkAccess chunkAccess = world.m_46865_((BlockPos)blockpos);
        if (!isChild) {
            BlockState currentState = chunkAccess.m_8055_((BlockPos)blockpos);
            while (!currentState.m_60815_() && currentState.m_60819_().m_76178_() && blockpos.m_123342_() > world.m_141937_()) {
                blockpos.m_122173_(Direction.DOWN);
                currentState = chunkAccess.m_8055_((BlockPos)blockpos);
            }
            blockpos.m_122173_(Direction.UP);
        }
        pokemon.m_7678_((double)((float)blockpos.m_123341_() + 0.5f), (double)((float)blockpos.m_123342_() + 0.5f), (double)((float)blockpos.m_123343_() + 0.5f), world.m_213780_().m_188501_() * 360.0f, 0.0f);
        IPokemob pokemob = PokemobCaps.getPokemobFor((ICapabilityProvider)pokemon);
        if (!isChild) {
            try {
                SpawnBiomeMatcher spawnMatcher = spawn.getMatcher((ServerLevel)world, Vector3.entity((Entity)pokemon), null);
                pokemob.spawnInit(spawnMatcher.spawnRule);
            }
            catch (Exception e) {
                e.addSuppressed(new RuntimeException("Mob: " + pokemob.getDisplayName() + ", Position: " + blockpos + ", Dimension: " + ((ServerLevel)world).m_46472_().m_135782_()));
                Bumblezone.LOGGER.log(org.apache.logging.log4j.Level.ERROR, (Object)e);
            }
        } else {
            pokemob.setExp(0, false);
        }
        pokemon.m_6518_((ServerLevelAccessor)world, world.m_6436_(pokemon.m_20183_()), event.getSpawnReason(), null, null);
        world.m_7967_((Entity)pokemon);
        return true;
    }

    public static void PCAddProtectionForBeeMobs(Entity entity) {
        if (((Boolean)BzModCompatibilityConfigs.beePokemonGetsProtectionEffect.get()).booleanValue() && entity instanceof PokemobBase) {
            PokemobBase pokemobBase = (PokemobBase)entity;
            if (POKECUBE_POKEMON_LIST.contains(pokemobBase.pokemobCap.getPokedexEntry()) && entity.f_19853_.m_46472_().equals(BzDimension.BZ_WORLD_KEY)) {
                pokemobBase.m_7292_(new MobEffectInstance((MobEffect)BzEffects.PROTECTION_OF_THE_HIVE.get(), 0x7FFFFFFA, 0, true, false));
            }
        }
    }
}

