/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.modcompat.ArsElementalCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.ArsNouveauCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.BackpackedCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.BeekeeperCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.BuzzierBeesCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.CuriosCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.DragonEnchantsCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.FriendsAndFoesCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.GoodallCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.JonnTrophiesCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.PokecubeCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.PotionOfBeesCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.ProductiveBeesCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.ProjectileDamageAttributeCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.QuarkCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.ResourcefulBeesCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.TwilightForestCompat;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.logging.log4j.Level;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class ModChecker {
    public static boolean productiveBeesPresent = false;
    public static boolean resourcefulBeesPresent = false;
    public static boolean buzzierBeesPresent = false;
    public static boolean pokecubePresent = false;
    public static boolean friendsAndFoesPresent = false;
    public static boolean beekeeperPresent = false;
    public static boolean quarkPresent = false;
    public static boolean potionOfBeesPresent = false;
    public static boolean arsNouveauPresent = false;
    public static boolean arsElementalPresent = false;
    public static boolean twilightForestPresent = false;
    public static boolean dragonEnchantsPresent = false;
    public static boolean curiosPresent = false;
    public static boolean goodallPresent = false;
    public static boolean backpackedPresent = false;
    public static boolean jonnTrophiesPresent = false;
    public static boolean projectileDamageAttributePresent = false;

    public static void setupModCompat() {
        String modid = "";
        try {
            modid = "pokecube_mobs";
            ModChecker.loadupModCompat(modid, () -> PokecubeCompat.setupCompat());
            modid = "productivebees";
            ModChecker.loadupModCompat(modid, () -> ProductiveBeesCompat.setupCompat());
            modid = "friendsandfoes";
            ModChecker.loadupModCompat(modid, () -> FriendsAndFoesCompat.setupCompat());
            modid = "bk";
            ModChecker.loadupModCompat(modid, () -> BeekeeperCompat.setupCompat());
            modid = "quark";
            ModChecker.loadupModCompat(modid, () -> QuarkCompat.setupCompat());
            modid = "buzzier_bees";
            ModChecker.loadupModCompat(modid, () -> BuzzierBeesCompat.setupCompat());
            modid = "resourcefulbees";
            ModChecker.loadupModCompat(modid, () -> ResourcefulBeesCompat.setupCompat());
            modid = "potionofbees";
            ModChecker.loadupModCompat(modid, () -> PotionOfBeesCompat.setupCompat());
            modid = "ars_nouveau";
            ModChecker.loadupModCompat(modid, () -> ArsNouveauCompat.setupCompat());
            modid = "ars_elemental";
            ModChecker.loadupModCompat(modid, () -> ArsElementalCompat.setupCompat());
            modid = "twilightforest";
            ModChecker.loadupModCompat(modid, () -> TwilightForestCompat.setupCompat());
            modid = "dragonenchants";
            ModChecker.loadupModCompat(modid, () -> DragonEnchantsCompat.setupCompat());
            modid = "curios";
            ModChecker.loadupModCompat(modid, () -> CuriosCompat.setupCompat());
            modid = "goodall";
            ModChecker.loadupModCompat(modid, () -> GoodallCompat.setupCompat());
            modid = "backpacked";
            ModChecker.loadupModCompat(modid, () -> BackpackedCompat.setupCompat());
            modid = "trophymanager";
            ModChecker.loadupModCompat(modid, () -> JonnTrophiesCompat.setupCompat());
            modid = "projectile_damage";
            ModChecker.loadupModCompat(modid, () -> ProjectileDamageAttributeCompat.setupCompat());
        }
        catch (Throwable e) {
            ModChecker.printErrorToLogs("classloading " + modid + " and so, mod compat done afterwards broke");
            e.printStackTrace();
        }
    }

    private static void loadupModCompat(String modid, Runnable runnable) {
        try {
            if (ModList.get().isLoaded(modid)) {
                runnable.run();
            }
        }
        catch (Throwable e) {
            ModChecker.printErrorToLogs(modid);
            e.printStackTrace();
        }
    }

    private static void printErrorToLogs(String currentModID) {
        Bumblezone.LOGGER.log(Level.ERROR, "  ------------------------------------------------NOTICE-------------------------------------------------------------------------\n\n  ERROR: Something broke when trying to add mod compatibility with %s. Please let The Bumblezone developer (TelepathicGrunt) know about this!\n\n  ------------------------------------------------NOTICE-------------------------------------------------------------------------\n".formatted(currentModID));
    }

    private static boolean isNotOutdated(String currentModID, String minVersion, boolean checkQualifierInstead) {
        if (!ModList.get().isLoaded(currentModID)) {
            return true;
        }
        IModInfo modInfo = ((ModContainer)ModList.get().getModContainerById(currentModID).get()).getModInfo();
        ArtifactVersion modVersion = modInfo.getVersion();
        if (checkQualifierInstead && modVersion.getQualifier() != null) {
            modVersion = new DefaultArtifactVersion(modVersion.getQualifier());
        }
        if (modVersion.compareTo((Object)new DefaultArtifactVersion(minVersion)) < 0) {
            Bumblezone.LOGGER.log(Level.INFO, "------------------------------------------------NOTICE-------------------------------------------------------------------------");
            Bumblezone.LOGGER.log(Level.INFO, " ");
            Bumblezone.LOGGER.log(Level.INFO, "BUMBLEZONE: You're using a version of " + modInfo.getDisplayName() + " that is outdated. Please update " + modInfo.getDisplayName() + " to the latest version of that mod to enable compat with Bumblezone again.");
            Bumblezone.LOGGER.log(Level.INFO, " ");
            Bumblezone.LOGGER.log(Level.INFO, "------------------------------------------------NOTICE-------------------------------------------------------------------------");
            return false;
        }
        return true;
    }
}

