/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.QueensTradeManager;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.WeightedTradeResult;
import com.telepathicgrunt.the_bumblezone.items.recipes.IncenseCandleRecipe;
import com.telepathicgrunt.the_bumblezone.modcompat.FakeIncenseCandleRecipeCreator;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.MainTradeRowInput;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.RandomizeTradeRowInput;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.jei.JEIQueenRandomizerTradesInfo;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.jei.JEIQueenTradesInfo;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.jei.QueenRandomizeTradesJEICategory;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.jei.QueenTradesJEICategory;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class JEIIntegration
implements IModPlugin {
    public static final RecipeType<JEIQueenTradesInfo> QUEEN_TRADES = RecipeType.create((String)"the_bumblezone", (String)"queen_trades", JEIQueenTradesInfo.class);
    public static final RecipeType<JEIQueenRandomizerTradesInfo> QUEEN_RANDOMIZE_TRADES = RecipeType.create((String)"the_bumblezone", (String)"queen_color_randomizer_trades", JEIQueenRandomizerTradesInfo.class);

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("the_bumblezone", "jei_plugin");
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (ModList.get().isLoaded("roughlyenoughitems")) {
            return;
        }
        BzItems.CUSTOM_CREATIVE_TAB_ITEMS.forEach(item -> JEIIntegration.addInfo(registration, (Item)item.get()));
        JEIIntegration.addInfo(registration, (Item)BzItems.PILE_OF_POLLEN.get());
        JEIIntegration.addInfo(registration, (Fluid)BzFluids.SUGAR_WATER_FLUID.get());
        JEIIntegration.addInfo(registration, (Fluid)BzFluids.ROYAL_JELLY_FLUID.get());
        JEIIntegration.addInfo(registration, (Fluid)BzFluids.HONEY_FLUID.get());
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        level.m_7465_().m_44043_(new ResourceLocation("the_bumblezone", "incense_candle_from_super_candles")).ifPresent(recipe -> JEIIntegration.registerExtraRecipes(recipe, registration, true));
        level.m_7465_().m_44043_(new ResourceLocation("the_bumblezone", "incense_candle")).ifPresent(recipe -> JEIIntegration.registerExtraRecipes(recipe, registration, false));
        LinkedList<JEIQueenTradesInfo> trades = new LinkedList<JEIQueenTradesInfo>();
        if (!QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerMainTrades.isEmpty()) {
            for (Pair<MainTradeRowInput, WeightedRandomList<WeightedTradeResult>> trade : QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerMainTrades) {
                for (WeightedTradeResult weightedTradeResult : ((WeightedRandomList)trade.getSecond()).m_146338_()) {
                    trades.add(new JEIQueenTradesInfo((MainTradeRowInput)trade.getFirst(), weightedTradeResult));
                }
            }
        }
        registration.addRecipes(QUEEN_TRADES, trades);
        LinkedList<JEIQueenRandomizerTradesInfo> randomizerTrades = new LinkedList<JEIQueenRandomizerTradesInfo>();
        if (!QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerRandomizerTrades.isEmpty()) {
            for (RandomizeTradeRowInput tradeEntry : QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerRandomizerTrades) {
                List<ItemStack> randomizeStack = tradeEntry.getWantItems().m_203614_().map(e -> ((Item)e.m_203334_()).m_7968_()).toList();
                for (ItemStack input : randomizeStack) {
                    randomizerTrades.add(new JEIQueenRandomizerTradesInfo(input, (TagKey<Item>)((TagKey)tradeEntry.tagKey().orElse(null)), randomizeStack));
                }
            }
        }
        registration.addRecipes(QUEEN_RANDOMIZE_TRADES, randomizerTrades);
    }

    private static void addInfo(IRecipeRegistration registration, Item item) {
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)item), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)("the_bumblezone." + ForgeRegistries.ITEMS.getKey((Object)item).m_135815_() + ".description"))});
    }

    private static void addInfo(IRecipeRegistration registration, Fluid fluid) {
        registration.addIngredientInfo((Object)new FluidStack(fluid, 1), (IIngredientType)ForgeTypes.FLUID_STACK, new Component[]{Component.m_237115_((String)("the_bumblezone." + ForgeRegistries.FLUIDS.getKey((Object)fluid).m_135815_() + ".description"))});
    }

    private static void registerExtraRecipes(Recipe<?> baseRecipe, IRecipeRegistration registration, boolean oneRecipeOnly) {
        if (baseRecipe instanceof IncenseCandleRecipe) {
            IncenseCandleRecipe incenseCandleRecipe = (IncenseCandleRecipe)baseRecipe;
            List<CraftingRecipe> extraRecipes = FakeIncenseCandleRecipeCreator.constructFakeRecipes(incenseCandleRecipe, oneRecipeOnly);
            registration.addRecipes(RecipeTypes.CRAFTING, extraRecipes);
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new QueenTradesJEICategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new QueenRandomizeTradesJEICategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(((Item)BzItems.BEE_QUEEN_SPAWN_EGG.get()).m_7968_(), new RecipeType[]{QUEEN_TRADES});
        registration.addRecipeCatalyst(((Item)BzItems.BEE_QUEEN_SPAWN_EGG.get()).m_7968_(), new RecipeType[]{QUEEN_RANDOMIZE_TRADES});
    }
}

