/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.telepathicgrunt.the_bumblezone.items.recipes.IncenseCandleRecipe;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.SplashPotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.registries.ForgeRegistries;

public class FakeIncenseCandleRecipeCreator {
    public static List<CraftingRecipe> constructFakeRecipes(IncenseCandleRecipe incenseCandleRecipe, boolean oneRecipeOnly) {
        ArrayList<CraftingRecipe> extraRecipes = new ArrayList<CraftingRecipe>();
        int currentRecipe = 0;
        HashSet effects = new HashSet();
        ArrayList<Potion> potions = new ArrayList<Potion>();
        for (Potion potion : Registry.f_122828_) {
            if (oneRecipeOnly && potions.size() > 0) break;
            if (potion.m_43488_().stream().allMatch(e -> effects.contains(e.m_19544_()) || Registry.f_122823_.m_206081_((ResourceKey)Registry.f_122823_.m_7854_((Object)e.m_19544_()).orElseThrow()).m_203656_(BzTags.DISALLOWED_INCENSE_CANDLE_EFFECTS))) continue;
            potion.m_43488_().forEach(e -> effects.add(e.m_19544_()));
            potions.add(potion);
        }
        potions.sort(Comparator.comparingInt(a -> a.m_43488_().size()));
        for (Potion potion : potions) {
            if (potion.m_43488_().stream().allMatch(e -> Objects.requireNonNull(ForgeRegistries.MOB_EFFECTS.tags()).getTag(BzTags.DISALLOWED_INCENSE_CANDLE_EFFECTS).contains((Object)e.m_19544_()))) continue;
            FakeIncenseCandleRecipeCreator.addRecipeIfValid(extraRecipes, FakeIncenseCandleRecipeCreator.getFakeShapedRecipe(incenseCandleRecipe, potion, Items.f_42589_.m_7968_(), currentRecipe));
            FakeIncenseCandleRecipeCreator.addRecipeIfValid(extraRecipes, FakeIncenseCandleRecipeCreator.getFakeShapedRecipe(incenseCandleRecipe, potion, Items.f_42736_.m_7968_(), ++currentRecipe));
            FakeIncenseCandleRecipeCreator.addRecipeIfValid(extraRecipes, FakeIncenseCandleRecipeCreator.getFakeShapedRecipe(incenseCandleRecipe, potion, Items.f_42739_.m_7968_(), ++currentRecipe));
            ++currentRecipe;
        }
        return extraRecipes;
    }

    private static void addRecipeIfValid(List<CraftingRecipe> extraRecipes, ShapedRecipe recipe) {
        if (!recipe.m_8043_().m_41619_()) {
            extraRecipes.add((CraftingRecipe)recipe);
        }
    }

    private static ShapedRecipe getFakeShapedRecipe(IncenseCandleRecipe recipe, Potion potion, ItemStack potionItem, int currentRecipe) {
        ItemStack potionStack = PotionUtils.m_43549_((ItemStack)potionItem, (Potion)potion);
        ArrayList<Ingredient> fakedShapedIngredientsMutable = new ArrayList<Ingredient>();
        for (int i = 0; i < 9; ++i) {
            fakedShapedIngredientsMutable.add(Ingredient.f_43901_);
        }
        int currentShapedIndex = 0;
        int shapedRecipeSize = recipe.getShapedRecipeItems().size();
        for (int x = 0; x < recipe.getRecipeWidth(); ++x) {
            for (int z = 0; z < recipe.getRecipeHeight(); ++z) {
                if (currentShapedIndex >= shapedRecipeSize) continue;
                Ingredient ingredient = (Ingredient)recipe.getShapedRecipeItems().get(currentShapedIndex);
                fakedShapedIngredientsMutable.set(x + z * 3, ingredient);
                ++currentShapedIndex;
            }
        }
        int currentShapelessIndex = 0;
        int shapelessRecipeSize = recipe.getShapelessRecipeItems().size();
        for (int i = 0; i < 9; ++i) {
            Ingredient ingredient = (Ingredient)fakedShapedIngredientsMutable.get(i);
            if (!ingredient.m_43947_()) continue;
            if (currentShapelessIndex >= shapelessRecipeSize) {
                fakedShapedIngredientsMutable.set(i, Ingredient.m_43927_((ItemStack[])new ItemStack[]{potionStack}));
                break;
            }
            fakedShapedIngredientsMutable.set(i, (Ingredient)recipe.getShapelessRecipeItems().get(currentShapelessIndex));
            ++currentShapelessIndex;
        }
        NonNullList fakedShapedIngredients = NonNullList.m_122779_();
        fakedShapedIngredients.addAll(fakedShapedIngredientsMutable);
        return new ShapedRecipe(new ResourceLocation("the_bumblezone", recipe.m_6423_().m_135815_() + "_" + currentRecipe), "the_bumblezone", 3, 3, fakedShapedIngredients, FakeIncenseCandleRecipeCreator.createResultStack(recipe, potionStack));
    }

    private static ItemStack createResultStack(IncenseCandleRecipe recipe, ItemStack potionStack) {
        ArrayList effects = new ArrayList();
        AtomicInteger maxDuration = new AtomicInteger();
        AtomicInteger amplifier = new AtomicInteger();
        AtomicInteger potionEffectsFound = new AtomicInteger();
        PotionUtils.m_43547_((ItemStack)potionStack).forEach(me -> {
            effects.add(me.m_19544_());
            maxDuration.addAndGet(me.m_19544_().m_8093_() ? 200 : me.m_19557_());
            amplifier.addAndGet(me.m_19564_() + 1);
            potionEffectsFound.getAndIncrement();
        });
        if (effects.isEmpty()) {
            return ItemStack.f_41583_;
        }
        HashSet setPicker = new HashSet(effects);
        MobEffect chosenEffect = (MobEffect)setPicker.stream().toList().get(new Random().nextInt(setPicker.size()));
        if (chosenEffect == null) {
            return ItemStack.f_41583_;
        }
        IncenseCandleRecipe.balanceStats(chosenEffect, maxDuration, amplifier, potionEffectsFound);
        amplifier.set(Math.min(amplifier.get(), recipe.getMaxLevelCap()));
        return IncenseCandleRecipe.createTaggedIncenseCandle(chosenEffect, maxDuration, amplifier, potionStack.m_41720_() instanceof SplashPotionItem ? 1 : 0, potionStack.m_41720_() instanceof LingeringPotionItem ? 1 : 0, recipe.m_8043_().m_41613_());
    }
}

