/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.google.common.collect.Sets;
import com.hollingsworth.arsnouveau.api.event.EffectResolveEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.common.entity.AnimBlockSummon;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectBlink;
import com.hollingsworth.arsnouveau.common.spell.method.MethodOrbit;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.common.spell.method.MethodUnderfoot;
import com.telepathicgrunt.the_bumblezone.entities.EntityTeleportationBackend;
import com.telepathicgrunt.the_bumblezone.entities.EntityTeleportationHookup;
import com.telepathicgrunt.the_bumblezone.modcompat.ArsElementalCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.ForgeRegistries;

public class ArsNouveauCompat {
    private static final ResourceLocation SPELL_PROJ_RL = new ResourceLocation("ars_nouveau", "spell_proj");
    private static final ResourceLocation SPELL_FOLLOW_PROJ_RL = new ResourceLocation("ars_nouveau", "follow_proj");
    protected static final Set<AbstractCastMethod> ALLOWED_CAST_METHODS = Sets.newHashSet((Object[])new AbstractCastMethod[]{MethodProjectile.INSTANCE, MethodOrbit.INSTANCE, MethodTouch.INSTANCE, MethodUnderfoot.INSTANCE});

    public static void setupCompat() {
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        Consumer<EffectResolveEvent.Post> handler = ArsNouveauCompat::isArsSpellProjectile;
        forgeBus.addListener(handler);
        ModChecker.arsNouveauPresent = true;
    }

    private static void isArsSpellProjectile(EffectResolveEvent.Post event) {
        LivingEntity livingEntity = event.shooter;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.resolveEffect == EffectBlink.INSTANCE && ALLOWED_CAST_METHODS.contains(event.spell.getCastMethod())) {
                if (event.spell.getCastMethod() == MethodTouch.INSTANCE || event.spell.getCastMethod() == MethodUnderfoot.INSTANCE) {
                    ItemStack stack = player.m_21205_();
                    if (event.rayTraceResult instanceof BlockHitResult && stack.m_204117_(BzTags.TELEPORT_ITEM_RIGHT_CLICKED_BEEHIVE) || stack.m_204117_(BzTags.TELEPORT_ITEM_RIGHT_CLICKED_BEEHIVE_CROUCHING) && player.m_6144_()) {
                        BlockHitResult blockHitResult = (BlockHitResult)event.rayTraceResult;
                        EntityTeleportationHookup.runItemUseOn(player, blockHitResult.m_82425_(), player.m_9236_().m_8055_(blockHitResult.m_82425_()), stack);
                    }
                    return;
                }
                if (event.spell.getCastMethod() == MethodProjectile.INSTANCE && !((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(SPELL_PROJ_RL)).m_204039_(BzTags.TELEPORT_PROJECTILES)) {
                    return;
                }
                if (event.spell.getCastMethod() == MethodOrbit.INSTANCE && !((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(SPELL_FOLLOW_PROJ_RL)).m_204039_(BzTags.TELEPORT_PROJECTILES)) {
                    return;
                }
                if (ModChecker.arsElementalPresent && ArsElementalCompat.isArsElementalSpellDisallowed(event)) {
                    return;
                }
                if (event.rayTraceResult instanceof BlockHitResult) {
                    EntityTeleportationHookup.runTeleportProjectileImpact(event.rayTraceResult, (Entity)event.shooter, null);
                } else {
                    HitResult hitResult = event.rayTraceResult;
                    if (hitResult instanceof EntityHitResult) {
                        EntityHitResult entityHitResult = (EntityHitResult)hitResult;
                        EntityTeleportationHookup.runEntityHitCheck((HitResult)entityHitResult, (Entity)event.shooter, null);
                    }
                }
            }
        }
    }

    public static boolean isArsSpellProjectile(Projectile projectile) {
        ResourceLocation projectileRL = ForgeRegistries.ENTITY_TYPES.getKey((Object)projectile.m_6095_());
        if (ModChecker.arsElementalPresent && ArsElementalCompat.isArsElementalSpellProjectile(projectileRL)) {
            return true;
        }
        return projectileRL.equals((Object)SPELL_PROJ_RL) || projectileRL.equals((Object)SPELL_FOLLOW_PROJ_RL);
    }

    public static boolean isArsSpellBook(ItemStack stack) {
        return stack.m_41720_() instanceof SpellBook;
    }

    public static boolean isArsWalkingBlock(Entity entity) {
        return entity instanceof AnimBlockSummon;
    }

    public static boolean isArsWalkingBlockAvalidBeeHive(Entity entity) {
        if (entity instanceof AnimBlockSummon) {
            AnimBlockSummon animBlockSummon = (AnimBlockSummon)entity;
            return EntityTeleportationBackend.isValidBeeHive(animBlockSummon.blockState);
        }
        return false;
    }
}

