/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.telepathicgrunt.the_bumblezone.modinit.BzRecipes;
import net.minecraft.core.IdMap;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;

public class NbtKeepingShapelessRecipe
extends ShapelessRecipe {
    private final Item itemToKeepNbtOf;

    public NbtKeepingShapelessRecipe(ResourceLocation resourceLocation, String string, ItemStack itemStack, NonNullList<Ingredient> nonNullList, Item itemToKeepNbtOf) {
        super(resourceLocation, string, itemStack, nonNullList);
        this.itemToKeepNbtOf = itemToKeepNbtOf;
    }

    public boolean m_5818_(CraftingContainer inv, Level level) {
        return super.m_5818_(inv, level);
    }

    public ItemStack m_5874_(CraftingContainer craftingContainer) {
        ItemStack resultItem = super.m_8043_().m_41777_();
        for (int i = 0; i < craftingContainer.m_6643_(); ++i) {
            ItemStack input = craftingContainer.m_8020_(i);
            if (!input.m_150930_(this.itemToKeepNbtOf) || !input.m_41782_()) continue;
            resultItem.m_41751_(input.m_41783_());
            break;
        }
        return resultItem;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)BzRecipes.NBT_KEEPING_SHAPELESS_RECIPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<NbtKeepingShapelessRecipe> {
        public NbtKeepingShapelessRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            String string = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"group", (String)"");
            NonNullList<Ingredient> nonNullList = Serializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)jsonObject, (String)"ingredients"));
            if (nonNullList.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonNullList.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe");
            }
            ItemStack itemStack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result"));
            Item item = ShapedRecipe.m_151278_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"keep_nbt_of"));
            return new NbtKeepingShapelessRecipe(resourceLocation, string, itemStack, nonNullList, item);
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray jsonArray) {
            NonNullList nonNullList = NonNullList.m_122779_();
            for (int i = 0; i < jsonArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonArray.get(i));
                if (ingredient.m_43947_()) continue;
                nonNullList.add((Object)ingredient);
            }
            return nonNullList;
        }

        public JsonObject toJson(NbtKeepingShapelessRecipe recipe) {
            JsonObject json = new JsonObject();
            json.addProperty("type", Registry.f_122865_.m_7981_((Object)((RecipeSerializer)BzRecipes.NBT_KEEPING_SHAPELESS_RECIPE.get())).toString());
            json.addProperty("group", recipe.m_6076_());
            JsonArray ingredients = new JsonArray();
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredients.add(ingredient.m_43942_());
            }
            json.add("ingredients", (JsonElement)ingredients);
            JsonObject result = new JsonObject();
            result.addProperty("item", Registry.f_122827_.m_7981_((Object)recipe.m_8043_().m_41720_()).toString());
            result.addProperty("count", (Number)recipe.m_8043_().m_41613_());
            json.add("result", (JsonElement)result);
            JsonObject itemNbtToKeep = new JsonObject();
            itemNbtToKeep.addProperty("item", Registry.f_122827_.m_7981_((Object)recipe.itemToKeepNbtOf).toString());
            json.add("keep_nbt_of", (JsonElement)itemNbtToKeep);
            return json;
        }

        public NbtKeepingShapelessRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf friendlyByteBuf) {
            String string = friendlyByteBuf.m_130277_();
            int i = friendlyByteBuf.m_130242_();
            NonNullList nonNullList = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            nonNullList.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)friendlyByteBuf));
            ItemStack itemStack = friendlyByteBuf.m_130267_();
            Item item = (Item)friendlyByteBuf.m_236816_((IdMap)Registry.f_122827_);
            return new NbtKeepingShapelessRecipe(resourceLocation, string, itemStack, (NonNullList<Ingredient>)nonNullList, item);
        }

        public void toNetwork(FriendlyByteBuf friendlyByteBuf, NbtKeepingShapelessRecipe shapelessRecipe) {
            friendlyByteBuf.m_130070_(shapelessRecipe.m_6076_());
            friendlyByteBuf.m_130130_(shapelessRecipe.m_7527_().size());
            for (Ingredient ingredient : shapelessRecipe.m_7527_()) {
                ingredient.m_43923_(friendlyByteBuf);
            }
            friendlyByteBuf.m_130055_(shapelessRecipe.m_8043_());
            friendlyByteBuf.m_236818_((IdMap)Registry.f_122827_, (Object)shapelessRecipe.itemToKeepNbtOf);
        }
    }
}

