/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.items.HoneyCrystalShieldBehavior;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.living.LivingAttackEvent;

public class HoneyCrystalShield
extends ShieldItem {
    private static final int[] shieldDurabilityBoostPerLevel = new int[]{0, 20, 45, 75, 110, 150, 195, 245, 316, 632};
    private static final int maxShieldLevel = shieldDurabilityBoostPerLevel.length - 1;

    public HoneyCrystalShield(Item.Properties properties) {
        super(properties.m_41503_(40));
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_204117_(BzTags.HONEY_CRYSTAL_SHIELD_REPAIR_ITEMS);
    }

    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.OFFHAND;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction == ToolActions.SHIELD_BLOCK && stack.m_150930_((Item)this);
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41782_()) {
            int shieldLevel = Math.max(Math.min(stack.m_41784_().m_128451_("ShieldLevel"), maxShieldLevel), 0);
            tooltip.add((Component)Component.m_237115_((String)"item.the_bumblezone.honey_crystal_shield.level_tooltip").m_130946_(": " + (shieldLevel + 1)));
        }
    }

    public int getMaxDamage(ItemStack stack) {
        if (stack.m_41782_()) {
            this.upgradeLegacyShield(stack);
            int shieldLevel = Math.max(Math.min(stack.m_41784_().m_128451_("ShieldLevel"), maxShieldLevel), 0);
            if (shieldLevel != 0) {
                return stack.m_41720_().m_41462_() + shieldDurabilityBoostPerLevel[shieldLevel];
            }
        }
        return stack.m_41720_().m_41462_();
    }

    private void upgradeLegacyShield(ItemStack stack) {
        if (stack.m_41782_() && !stack.m_41783_().m_128441_("ShieldLevel")) {
            int repairCost = stack.m_41784_().m_128451_("RepairCost");
            if (repairCost >= 32) {
                stack.m_41784_().m_128405_("ShieldLevel", maxShieldLevel);
            } else if (repairCost >= 16) {
                stack.m_41784_().m_128405_("ShieldLevel", maxShieldLevel - 1);
            } else if (repairCost >= 5) {
                stack.m_41784_().m_128405_("ShieldLevel", maxShieldLevel / 2);
            }
        }
    }

    public void setDamage(ItemStack stack, int damage) {
        int newDamage = damage;
        int oldDamage = this.getDamage(stack);
        int damageCaused = oldDamage - damage;
        int shieldLevel = stack.m_41784_().m_128451_("ShieldLevel");
        if (damageCaused < 0) {
            int reducedDamage = -1 * Math.min(-1, damageCaused + shieldLevel / 4);
            newDamage = Math.max(0, this.getDamage(stack) + reducedDamage);
        } else if (damageCaused > stack.m_41776_() / 5) {
            stack.m_41784_().m_128405_("ShieldLevel", Math.min(maxShieldLevel, shieldLevel + 1));
        }
        stack.m_41784_().m_128405_("Damage", Math.max(0, newDamage));
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44962_) {
            return false;
        }
        return enchantment.f_44672_.m_7454_(stack.m_41720_());
    }

    public int m_142158_(ItemStack itemStack) {
        return Math.round(13.0f - (float)itemStack.m_41773_() * 13.0f / (float)itemStack.m_41776_());
    }

    public int m_142159_(ItemStack itemStack) {
        float f = Math.max(0.0f, ((float)itemStack.m_41776_() - (float)itemStack.m_41773_()) / (float)itemStack.m_41776_());
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public static void playerAttackedBehavior(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            HoneyCrystalShieldBehavior.slowPhysicalAttackers(event.getSource(), player);
            if (HoneyCrystalShieldBehavior.damageShieldFromExplosionAndFire(event.getSource(), player)) {
                event.setCanceled(true);
            }
        }
    }
}

