/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.mojang.serialization.DynamicOps;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.mixin.world.ChunkGeneratorAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.ThreadExecutor;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.apache.logging.log4j.Logger;

public class HoneyCompass
extends Item
implements Vanishable {
    public static final String TAG_TARGET_POS = "TargetPos";
    public static final String TAG_TARGET_DIMENSION = "TargetDimension";
    public static final String TAG_TYPE = "CompassType";
    public static final String TAG_LOADING = "IsLoading";
    public static final String TAG_FAILED = "IsFailed";
    public static final String TAG_STRUCTURE_TAG = "TargetStructureTag";
    public static final String TAG_TARGET_BLOCK = "TargetBlock";
    public static final String TAG_CUSTOM_NAME_TYPE = "CustomName";
    public static final String TAG_CUSTOM_DESCRIPTION_TYPE = "CustomDescription";
    public static final String TAG_LOCKED = "Locked";

    public HoneyCompass(Item.Properties properties) {
        super(properties);
    }

    public boolean m_5812_(ItemStack itemStack) {
        return HoneyCompass.getBooleanTag(itemStack.m_41783_(), TAG_LOCKED) || super.m_5812_(itemStack);
    }

    public String m_5671_(ItemStack itemStack) {
        if (HoneyCompass.getBooleanTag(itemStack.m_41783_(), TAG_LOADING)) {
            return "item.the_bumblezone.honey_compass_structure_loading";
        }
        if (HoneyCompass.getBooleanTag(itemStack.m_41783_(), TAG_FAILED)) {
            return "item.the_bumblezone.honey_compass_structure_failed";
        }
        if (HoneyCompass.hasTagSafe(itemStack.m_41783_(), TAG_CUSTOM_NAME_TYPE)) {
            return itemStack.m_41783_().m_128461_(TAG_CUSTOM_NAME_TYPE);
        }
        if (HoneyCompass.isStructureCompass(itemStack)) {
            return "item.the_bumblezone.honey_compass_structure";
        }
        if (HoneyCompass.isBlockCompass(itemStack)) {
            return "item.the_bumblezone.honey_compass_block";
        }
        return super.m_5671_(itemStack);
    }

    public Component m_7626_(ItemStack itemStack) {
        this.correctOldNbt(itemStack);
        if (HoneyCompass.isBlockCompass(itemStack)) {
            Block block;
            String blockString = HoneyCompass.getStoredBlock(itemStack);
            if (blockString != null && (block = (Block)Registry.f_122824_.m_7745_(new ResourceLocation(blockString))) != Blocks.f_50016_) {
                return Component.m_237110_((String)this.m_5671_(itemStack), (Object[])new Object[]{block.m_49954_()});
            }
            return Component.m_237110_((String)this.m_5671_(itemStack), (Object[])new Object[]{Component.m_237115_((String)"item.the_bumblezone.honey_compass_unknown_block")});
        }
        return Component.m_237115_((String)this.m_5671_(itemStack));
    }

    public void correctOldNbt(ItemStack itemStack) {
        CompoundTag tag;
        if (itemStack.m_41782_() && (tag = itemStack.m_41783_()).m_128441_("IsThrone")) {
            boolean isThrone = tag.m_128471_("IsThrone");
            if (isThrone) {
                tag.m_128379_(TAG_LOCKED, true);
                tag.m_128359_(TAG_TYPE, "structure");
                tag.m_128359_(TAG_CUSTOM_NAME_TYPE, "item.the_bumblezone.honey_compass_throne_structure");
                tag.m_128359_(TAG_CUSTOM_DESCRIPTION_TYPE, "item.the_bumblezone.honey_compass_throne_description");
            }
            tag.m_128473_("IsThrone");
        }
    }

    public void m_7373_(ItemStack itemStack, Level level, List<Component> components, TooltipFlag tooltipFlag) {
        if (HoneyCompass.getBooleanTag(itemStack.m_41783_(), TAG_FAILED)) {
            components.add((Component)Component.m_237115_((String)"item.the_bumblezone.honey_compass_structure_failed_description"));
            return;
        }
        if (HoneyCompass.hasTagSafe(itemStack.m_41783_(), TAG_CUSTOM_DESCRIPTION_TYPE)) {
            components.add((Component)Component.m_237115_((String)itemStack.m_41783_().m_128461_(TAG_CUSTOM_DESCRIPTION_TYPE)));
            return;
        }
        if (HoneyCompass.isBlockCompass(itemStack)) {
            components.add((Component)Component.m_237115_((String)"item.the_bumblezone.honey_compass_block_description1"));
            components.add((Component)Component.m_237115_((String)"item.the_bumblezone.honey_compass_block_description2"));
            components.add((Component)Component.m_237115_((String)"item.the_bumblezone.honey_compass_block_description3"));
            components.add((Component)Component.m_237115_((String)"item.the_bumblezone.honey_compass_block_description4"));
        } else if (HoneyCompass.isStructureCompass(itemStack)) {
            components.add((Component)Component.m_237115_((String)"item.the_bumblezone.honey_compass_structure_description1"));
            components.add((Component)Component.m_237115_((String)"item.the_bumblezone.honey_compass_structure_description2"));
            components.add((Component)Component.m_237115_((String)"item.the_bumblezone.honey_compass_structure_description3"));
        } else {
            components.add((Component)Component.m_237115_((String)"item.the_bumblezone.honey_compass_description1"));
            components.add((Component)Component.m_237115_((String)"item.the_bumblezone.honey_compass_description2"));
            components.add((Component)Component.m_237115_((String)"item.the_bumblezone.honey_compass_description3"));
            components.add((Component)Component.m_237115_((String)"item.the_bumblezone.honey_compass_description4"));
        }
    }

    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int i, boolean bl) {
        if (!level.f_46443_) {
            if (!HoneyCompass.getBooleanTag(itemStack.m_41783_(), TAG_FAILED) && !HoneyCompass.getBooleanTag(itemStack.m_41783_(), TAG_LOADING) && HoneyCompass.hasTagSafe(itemStack.m_41783_(), TAG_STRUCTURE_TAG) && !HoneyCompass.hasTagSafe(itemStack.m_41783_(), TAG_TARGET_POS)) {
                itemStack.m_41784_().m_128379_(TAG_FAILED, true);
            }
            if (HoneyCompass.getBooleanTag(itemStack.m_41783_(), TAG_LOADING) && !ThreadExecutor.isRunningASearch() && !ThreadExecutor.hasQueuedSearch()) {
                itemStack.m_41784_().m_128379_(TAG_LOADING, false);
                itemStack.m_41784_().m_128379_(TAG_FAILED, true);
            }
            if (HoneyCompass.isBlockCompass(itemStack)) {
                CompoundTag compoundTag = itemStack.m_41784_();
                if (compoundTag.m_128441_(TAG_TARGET_POS) && compoundTag.m_128441_(TAG_TARGET_BLOCK) && compoundTag.m_128441_(TAG_TARGET_DIMENSION)) {
                    Optional optional = Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)compoundTag.m_128423_(TAG_TARGET_DIMENSION)).result();
                    if (optional.isPresent() && ((ResourceKey)optional.get()).equals((Object)level.m_46472_())) {
                        BlockPos blockPos = NbtUtils.m_129239_((CompoundTag)compoundTag.m_128469_(TAG_TARGET_POS));
                        if (!level.m_46739_(blockPos)) {
                            compoundTag.m_128473_(TAG_TARGET_POS);
                            compoundTag.m_128473_(TAG_TARGET_DIMENSION);
                            compoundTag.m_128473_(TAG_TARGET_BLOCK);
                            compoundTag.m_128473_(TAG_TYPE);
                            return;
                        }
                        ChunkAccess chunk = level.m_6522_(blockPos.m_123341_() >> 4, blockPos.m_123343_() >> 4, ChunkStatus.f_62326_, false);
                        if (chunk != null && !Registry.f_122824_.m_7981_((Object)chunk.m_8055_(blockPos).m_60734_()).toString().equals(compoundTag.m_128461_(TAG_TARGET_BLOCK))) {
                            compoundTag.m_128473_(TAG_TARGET_POS);
                            compoundTag.m_128473_(TAG_TARGET_DIMENSION);
                            compoundTag.m_128473_(TAG_TARGET_BLOCK);
                            compoundTag.m_128473_(TAG_TYPE);
                        }
                    }
                } else {
                    compoundTag.m_128473_(TAG_TARGET_POS);
                    compoundTag.m_128473_(TAG_TARGET_DIMENSION);
                    compoundTag.m_128473_(TAG_TARGET_BLOCK);
                    compoundTag.m_128473_(TAG_TYPE);
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        BlockPos playerPos = player.m_20183_();
        if (HoneyCompass.getBooleanTag(itemStack.m_41783_(), TAG_FAILED) && HoneyCompass.hasTagSafe(itemStack.m_41783_(), TAG_STRUCTURE_TAG)) {
            ServerLevel serverLevel;
            if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).m_7654_().m_129910_().m_5961_().m_224677_()) {
                boolean structureExists;
                TagKey structureTagKey = TagKey.m_203882_((ResourceKey)Registry.f_235725_, (ResourceLocation)new ResourceLocation(itemStack.m_41784_().m_128461_(TAG_STRUCTURE_TAG)));
                Optional optional = serverLevel.m_5962_().m_175515_(Registry.f_235725_).m_203431_(BzTags.HONEY_COMPASS_DEFAULT_LOCATING);
                Set<Structure> structureSets = ((ChunkGeneratorAccessor)serverLevel.m_7726_().m_8481_()).getPlacementsForStructure().keySet();
                boolean bl = structureExists = optional.isPresent() && ((HolderSet.Named)optional.get()).m_203614_().anyMatch(structureHolder -> structureSets.contains(structureHolder.get()));
                if (structureExists) {
                    itemStack.m_41784_().m_128379_(TAG_LOADING, true);
                    itemStack.m_41784_().m_128379_(TAG_FAILED, false);
                    ThreadExecutor.locate((ServerLevel)level, (TagKey<Structure>)structureTagKey, playerPos, 100, false).thenOnServerThread(foundPos -> this.setCompassData((ServerLevel)level, (ServerPlayer)player, interactionHand, itemStack, (BlockPos)foundPos));
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"item.the_bumblezone.honey_compass_structure_wrong_dimension"), true);
                    return InteractionResultHolder.m_19098_((Object)itemStack);
                }
            }
            return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
        }
        if (itemStack.m_41782_() && HoneyCompass.getBooleanTag(itemStack.m_41784_(), TAG_LOADING)) {
            if (ThreadExecutor.isRunningASearch() || ThreadExecutor.hasQueuedSearch()) {
                return InteractionResultHolder.m_19100_((Object)itemStack);
            }
            itemStack.m_41784_().m_128379_(TAG_LOADING, false);
        }
        if (HoneyCompass.getBooleanTag(itemStack.m_41783_(), TAG_LOCKED)) {
            return super.m_7203_(level, player, interactionHand);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!HoneyCompass.isStructureCompass(itemStack)) {
                boolean structureExists;
                Optional optional = serverLevel.m_5962_().m_175515_(Registry.f_235725_).m_203431_(BzTags.HONEY_COMPASS_DEFAULT_LOCATING);
                Set<Structure> structureSets = ((ChunkGeneratorAccessor)serverLevel.m_7726_().m_8481_()).getPlacementsForStructure().keySet();
                boolean bl = structureExists = optional.isPresent() && ((HolderSet.Named)optional.get()).m_203614_().anyMatch(structureHolder -> structureSets.contains(structureHolder.get()));
                if (!structureExists) {
                    player.m_5661_((Component)Component.m_237115_((String)"item.the_bumblezone.honey_compass_structure_wrong_dimension"), true);
                    return InteractionResultHolder.m_19098_((Object)itemStack);
                }
                itemStack.m_41784_().m_128379_(TAG_LOADING, true);
                ThreadExecutor.locate((ServerLevel)level, BzTags.HONEY_COMPASS_DEFAULT_LOCATING, playerPos, 100, false).thenOnServerThread(foundPos -> this.setCompassData((ServerLevel)level, (ServerPlayer)player, interactionHand, itemStack, (BlockPos)foundPos));
                return InteractionResultHolder.m_19090_((Object)itemStack);
            }
        }
        return super.m_7203_(level, player, interactionHand);
    }

    private void setCompassData(ServerLevel serverLevel, ServerPlayer serverPlayer, InteractionHand interactionHand, ItemStack itemStack, BlockPos structurePos) {
        boolean singleCompass;
        itemStack.m_41784_().m_128379_(TAG_LOADING, false);
        serverLevel.m_5594_(null, serverPlayer.m_20183_(), (SoundEvent)BzSounds.HONEY_COMPASS_STRUCTURE_LOCK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        serverPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
        if (structurePos == null) {
            serverPlayer.m_6674_(interactionHand);
            serverPlayer.m_5661_((Component)Component.m_237115_((String)"item.the_bumblezone.honey_compass_structure_failed"), false);
            return;
        }
        BzCriterias.HONEY_COMPASS_USE_TRIGGER.trigger(serverPlayer);
        boolean bl = singleCompass = !serverPlayer.m_150110_().f_35937_ && itemStack.m_41613_() == 1;
        if (singleCompass) {
            HoneyCompass.addStructureTags((ResourceKey<Level>)serverLevel.m_46472_(), structurePos, itemStack.m_41784_());
        } else {
            ItemStack newCompass = new ItemStack((ItemLike)BzItems.HONEY_COMPASS.get(), 1);
            CompoundTag newCompoundTag = itemStack.m_41782_() ? itemStack.m_41783_().m_6426_() : new CompoundTag();
            newCompass.m_41751_(newCompoundTag);
            if (!serverPlayer.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            HoneyCompass.addStructureTags((ResourceKey<Level>)serverLevel.m_46472_(), structurePos, newCompoundTag);
            if (!serverPlayer.m_150109_().m_36054_(newCompass)) {
                serverPlayer.m_36176_(newCompass, false);
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext useOnContext) {
        BlockPos blockPos = useOnContext.m_8083_();
        Level level = useOnContext.m_43725_();
        Player player = useOnContext.m_43723_();
        ItemStack handCompass = useOnContext.m_43722_();
        BlockState targetBlock = level.m_8055_(blockPos);
        if (handCompass.m_41782_() && HoneyCompass.getBooleanTag(handCompass.m_41784_(), TAG_LOADING)) {
            if (ThreadExecutor.isRunningASearch() || ThreadExecutor.hasQueuedSearch()) {
                return InteractionResult.FAIL;
            }
            handCompass.m_41784_().m_128379_(TAG_LOADING, false);
        }
        if (HoneyCompass.getBooleanTag(handCompass.m_41783_(), TAG_LOCKED)) {
            return super.m_6225_(useOnContext);
        }
        if (player != null && HoneyCompass.isValidBeeHive(targetBlock)) {
            level.m_5594_(null, blockPos, (SoundEvent)BzSounds.HONEY_COMPASS_BLOCK_LOCK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                BzCriterias.HONEY_COMPASS_USE_TRIGGER.trigger(serverPlayer);
            }
            if (!level.m_5776_()) {
                boolean singleCompass;
                boolean bl = singleCompass = !player.m_150110_().f_35937_ && handCompass.m_41613_() == 1;
                if (singleCompass) {
                    HoneyCompass.addBlockTags((ResourceKey<Level>)level.m_46472_(), blockPos, handCompass.m_41784_(), targetBlock.m_60734_());
                } else {
                    ItemStack newCompass = new ItemStack((ItemLike)BzItems.HONEY_COMPASS.get(), 1);
                    CompoundTag newCompoundTag = handCompass.m_41782_() ? handCompass.m_41783_().m_6426_() : new CompoundTag();
                    newCompass.m_41751_(newCompoundTag);
                    if (!player.m_150110_().f_35937_) {
                        handCompass.m_41774_(1);
                    }
                    HoneyCompass.addBlockTags((ResourceKey<Level>)level.m_46472_(), blockPos, newCompoundTag, targetBlock.m_60734_());
                    if (!player.m_150109_().m_36054_(newCompass)) {
                        player.m_36176_(newCompass, false);
                    }
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6225_(useOnContext);
    }

    public static boolean isValidBeeHive(BlockState block) {
        if (block.m_204336_(BzTags.FORCED_ALLOWED_POSITION_TRACKING_BLOCKS)) {
            return true;
        }
        if (block.m_204336_(BzTags.DISALLOWED_POSITION_TRACKING_BLOCKS)) {
            return false;
        }
        return block.m_204336_(BlockTags.f_13072_) || block.m_60734_() instanceof BeehiveBlock;
    }

    public static boolean getBooleanTag(CompoundTag compoundTag, String tagName) {
        if (compoundTag == null || !compoundTag.m_128441_(tagName)) {
            return false;
        }
        return compoundTag.m_128471_(tagName);
    }

    public static boolean hasTagSafe(CompoundTag compoundTag, String tagName) {
        return compoundTag != null && compoundTag.m_128441_(tagName);
    }

    public static void setStructureTags(CompoundTag compoundTag, TagKey<Structure> structureTagKey) {
        compoundTag.m_128359_(TAG_STRUCTURE_TAG, structureTagKey.f_203868_().toString());
    }

    public static void addStructureTags(ResourceKey<Level> resourceKey, BlockPos blockPos, CompoundTag compoundTag) {
        compoundTag.m_128365_(TAG_TARGET_POS, (Tag)NbtUtils.m_129224_((BlockPos)blockPos));
        Level.f_46427_.encodeStart((DynamicOps)NbtOps.f_128958_, resourceKey).resultOrPartial(arg_0 -> ((Logger)Bumblezone.LOGGER).error(arg_0)).ifPresent(tag -> compoundTag.m_128365_(TAG_TARGET_DIMENSION, tag));
        compoundTag.m_128359_(TAG_TYPE, "structure");
        compoundTag.m_128473_(TAG_TARGET_BLOCK);
        compoundTag.m_128473_(TAG_LOADING);
        compoundTag.m_128473_(TAG_FAILED);
        compoundTag.m_128473_(TAG_STRUCTURE_TAG);
    }

    public static void addBlockTags(ResourceKey<Level> resourceKey, BlockPos blockPos, CompoundTag compoundTag, Block block) {
        compoundTag.m_128365_(TAG_TARGET_POS, (Tag)NbtUtils.m_129224_((BlockPos)blockPos));
        Level.f_46427_.encodeStart((DynamicOps)NbtOps.f_128958_, resourceKey).resultOrPartial(arg_0 -> ((Logger)Bumblezone.LOGGER).error(arg_0)).ifPresent(tag -> compoundTag.m_128365_(TAG_TARGET_DIMENSION, tag));
        compoundTag.m_128359_(TAG_TYPE, "block");
        compoundTag.m_128359_(TAG_TARGET_BLOCK, Registry.f_122824_.m_7981_((Object)block).toString());
        compoundTag.m_128473_(TAG_LOADING);
        compoundTag.m_128473_(TAG_FAILED);
        compoundTag.m_128473_(TAG_STRUCTURE_TAG);
    }

    public static boolean isBlockCompass(ItemStack compassItem) {
        if (compassItem.m_41782_()) {
            CompoundTag tag = compassItem.m_41783_();
            return tag != null && tag.m_128441_(TAG_TYPE) && tag.m_128461_(TAG_TYPE).equals("block");
        }
        return false;
    }

    public static String getStoredBlock(ItemStack compassItem) {
        CompoundTag tag;
        if (compassItem.m_41782_() && (tag = compassItem.m_41783_()) != null && tag.m_128441_(TAG_TARGET_BLOCK)) {
            return tag.m_128461_(TAG_TARGET_BLOCK);
        }
        return null;
    }

    public static boolean isStructureCompass(ItemStack compassItem) {
        if (compassItem.m_41782_()) {
            CompoundTag tag = compassItem.m_41783_();
            return tag != null && tag.m_128441_(TAG_TYPE) && tag.m_128461_(TAG_TYPE).equals("structure");
        }
        return false;
    }
}

