/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.queentrades;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.WeightedTradeResult;
import com.telepathicgrunt.the_bumblezone.mixin.util.WeightedRandomListAccessor;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.MainTradeRowInput;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.RandomizeTradeRowInput;
import com.telepathicgrunt.the_bumblezone.packets.QueenMainTradesSyncPacket;
import com.telepathicgrunt.the_bumblezone.packets.QueenRandomizerTradesSyncPacket;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class QueensTradeManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().disableHtmlEscaping().excludeFieldsWithoutExposeAnnotation().create();
    public static final QueensTradeManager QUEENS_TRADE_MANAGER = new QueensTradeManager();
    private final List<TradeCollection> rawTrades = new ArrayList<TradeCollection>();
    public Object2ObjectOpenHashMap<Item, WeightedRandomList<WeightedTradeResult>> queenTrades = new Object2ObjectOpenHashMap();
    public List<RandomizeTradeRowInput> recipeViewerRandomizerTrades = new ArrayList<RandomizeTradeRowInput>();
    public List<Pair<MainTradeRowInput, WeightedRandomList<WeightedTradeResult>>> recipeViewerMainTrades = new ArrayList<Pair<MainTradeRowInput, WeightedRandomList<WeightedTradeResult>>>();

    public QueensTradeManager() {
        super(GSON, "bz_bee_queen_trades");
    }

    protected void apply(Map<ResourceLocation, JsonElement> loader, ResourceManager manager, ProfilerFiller profiler) {
        this.rawTrades.clear();
        loader.forEach((fileIdentifier, jsonElement) -> {
            try {
                DataResult mapDataResult = TradeCollection.CODEC.parse((DynamicOps)JsonOps.INSTANCE, jsonElement);
                mapDataResult.resultOrPartial(s -> {}).ifPresent(this.rawTrades::add);
            }
            catch (Exception e) {
                Bumblezone.LOGGER.error("Bumblezone Error: Couldn't parse bee queen trades file {}", fileIdentifier, (Object)e);
            }
        });
    }

    public void resolveQueenTrades(TagsUpdatedEvent event) {
        if (this.rawTrades.isEmpty()) {
            return;
        }
        ArrayList<RandomizeTradeRowInput> tempRecipeViewerRandomizerTrades = new ArrayList<RandomizeTradeRowInput>();
        ArrayList<TradeWantEntry> tempRecipeViewerMainTagTrades = new ArrayList<TradeWantEntry>();
        ArrayList<Pair<MainTradeRowInput, WeightedRandomList<WeightedTradeResult>>> tempRecipeViewerMainTrades = new ArrayList<Pair<MainTradeRowInput, WeightedRandomList<WeightedTradeResult>>>();
        Object2ObjectOpenHashMap tempQueenTradesFirstPass = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap tempQueenTrades = new Object2ObjectOpenHashMap();
        for (TradeCollection entry : this.rawTrades) {
            if (entry.randomizerTrade()) {
                if (entry.randomizerItems().isEmpty()) continue;
                for (RawTradeInputEntry rawTradeRandomizeEntry : entry.randomizerItems().get()) {
                    TradeWantEntry tradeRandomizeEntry = QueensTradeManager.getInputTradeEntry(rawTradeRandomizeEntry);
                    if (tradeRandomizeEntry == null || tradeRandomizeEntry.wantItems().m_203632_() == 0) continue;
                    tempRecipeViewerRandomizerTrades.add(new RandomizeTradeRowInput(tradeRandomizeEntry.tagKey()));
                    QueensTradeManager.populateRandomizedQueenTrades((Object2ObjectOpenHashMap<Item, Pair<WeightedRandomList<WeightedTradeResult>, TagKey<Item>>>)tempQueenTradesFirstPass, tradeRandomizeEntry);
                }
                continue;
            }
            if (entry.wantItems().isEmpty() || entry.resultItems().isEmpty()) continue;
            for (RawTradeInputEntry rawTradeWantEntry : entry.wantItems().get()) {
                List<TradeResultEntry> tradeResultEntry;
                TradeWantEntry tradeWantEntry = QueensTradeManager.getInputTradeEntry(rawTradeWantEntry);
                if (tradeWantEntry == null || tradeWantEntry.wantItems().m_203632_() == 0 || (tradeResultEntry = this.getOutputTradeEntry(entry.resultItems().get())).size() == 0) continue;
                if (tradeWantEntry.tagKey.isPresent()) {
                    tempRecipeViewerMainTagTrades.add(tradeWantEntry);
                }
                QueensTradeManager.populateMainQueenTrades((Object2ObjectOpenHashMap<Item, Pair<WeightedRandomList<WeightedTradeResult>, TagKey<Item>>>)tempQueenTradesFirstPass, tradeResultEntry, tradeWantEntry);
            }
        }
        tempRecipeViewerRandomizerTrades.removeIf(randomizerTrade -> {
            Set wantSet = randomizerTrade.getWantItems().m_203614_().map(Holder::m_203334_).collect(Collectors.toUnmodifiableSet());
            for (Item item : wantSet) {
                if (!tempQueenTradesFirstPass.containsKey((Object)item)) {
                    return true;
                }
                List tradeResults = ((WeightedRandomList)((Pair)tempQueenTradesFirstPass.get((Object)item)).getFirst()).m_146338_();
                if (!tradeResults.stream().anyMatch(r -> r.getItems().stream().anyMatch(t -> !wantSet.contains(t)))) continue;
                for (Item item2 : wantSet) {
                    tempQueenTradesFirstPass.put((Object)item2, (Object)Pair.of((Object)((WeightedRandomList)((Pair)tempQueenTradesFirstPass.get((Object)item2)).getFirst()), null));
                }
                return true;
            }
            for (Item item : wantSet) {
                Pair pair = (Pair)tempQueenTradesFirstPass.remove((Object)item);
                tempQueenTrades.put((Object)item, (Object)((WeightedRandomList)pair.getFirst()));
            }
            return false;
        });
        HashSet<TagKey> collectedTag = new HashSet<TagKey>();
        for (Object2ObjectMap.Entry pairEntry : tempQueenTradesFirstPass.object2ObjectEntrySet()) {
            ((WeightedRandomList)((Pair)pairEntry.getValue()).getFirst()).m_146338_().forEach(e -> e.setTotalWeight(((WeightedRandomListAccessor)((Pair)pairEntry.getValue()).getFirst()).getTotalWeight()));
            if (((Pair)pairEntry.getValue()).getSecond() == null || !collectedTag.contains(((Pair)pairEntry.getValue()).getSecond())) {
                tempRecipeViewerMainTrades.add((Pair<MainTradeRowInput, WeightedRandomList<WeightedTradeResult>>)Pair.of((Object)new MainTradeRowInput(Optional.ofNullable((TagKey)((Pair)pairEntry.getValue()).getSecond()), (Item)pairEntry.getKey()), (Object)((WeightedRandomList)((Pair)pairEntry.getValue()).getFirst())));
                if (((Pair)pairEntry.getValue()).getSecond() != null) {
                    collectedTag.add((TagKey)((Pair)pairEntry.getValue()).getSecond());
                }
            }
            tempQueenTrades.put((Object)((Item)pairEntry.getKey()), (Object)((WeightedRandomList)((Pair)pairEntry.getValue()).getFirst()));
        }
        this.queenTrades = tempQueenTrades;
        this.recipeViewerRandomizerTrades = tempRecipeViewerRandomizerTrades;
        this.recipeViewerMainTrades = tempRecipeViewerMainTrades;
        this.rawTrades.clear();
        this.recipeViewerMainTrades.sort(Comparator.comparing(item -> Registry.f_122827_.m_7981_((Object)((MainTradeRowInput)item.getFirst()).item())));
    }

    private static TradeWantEntry getInputTradeEntry(RawTradeInputEntry rawTradeInputEntry) {
        if (rawTradeInputEntry.entry.startsWith("#")) {
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(rawTradeInputEntry.entry.replace("#", "")));
            Optional tag = Registry.f_122827_.m_203431_(tagKey);
            if (tag.isEmpty() && rawTradeInputEntry.required) {
                Bumblezone.LOGGER.error("Trade input entry is set to required but " + rawTradeInputEntry.entry + " tag does not exist.");
            } else if (tag.isPresent()) {
                return new TradeWantEntry(Optional.of(tagKey), (HolderSet<Item>)((HolderSet)tag.get()));
            }
        } else {
            Optional item = Registry.f_122827_.m_203636_(ResourceKey.m_135785_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(rawTradeInputEntry.entry)));
            if (item.isEmpty() && rawTradeInputEntry.required) {
                Bumblezone.LOGGER.error("Trade input entry is set to required but " + rawTradeInputEntry.entry + " item does not exist.");
            } else if (item.isPresent()) {
                return new TradeWantEntry(Optional.empty(), (HolderSet<Item>)HolderSet.m_205809_((Holder[])new Holder[]{(Holder)item.get()}));
            }
        }
        return null;
    }

    private List<TradeResultEntry> getOutputTradeEntry(List<RawTradeOutputEntry> rawTradeOutputEntries) {
        ArrayList<TradeResultEntry> tradeResultEntries = new ArrayList<TradeResultEntry>();
        for (RawTradeOutputEntry rawTradeOutputEntry : rawTradeOutputEntries) {
            if (rawTradeOutputEntry.entry.startsWith("#")) {
                TagKey tagKey = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(rawTradeOutputEntry.entry.replace("#", "")));
                Optional tag = Registry.f_122827_.m_203431_(tagKey);
                if (tag.isEmpty() && rawTradeOutputEntry.required) {
                    Bumblezone.LOGGER.error("Trade result entry is set to required but " + rawTradeOutputEntry.entry + " tag does not exist.");
                    continue;
                }
                tag.ifPresent(holders -> tradeResultEntries.add(new TradeResultEntry(Optional.of(tagKey), (HolderSet<Item>)holders, rawTradeOutputEntry.count(), rawTradeOutputEntry.xpReward(), rawTradeOutputEntry.weight)));
                continue;
            }
            Optional item = Registry.f_122827_.m_203636_(ResourceKey.m_135785_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(rawTradeOutputEntry.entry)));
            if (item.isEmpty() && rawTradeOutputEntry.required) {
                Bumblezone.LOGGER.error("Trade result entry is set to required but " + rawTradeOutputEntry.entry + " item does not exist.");
                continue;
            }
            item.ifPresent(itemHolder -> tradeResultEntries.add(new TradeResultEntry(Optional.empty(), (HolderSet<Item>)HolderSet.m_205809_((Holder[])new Holder[]{itemHolder}), rawTradeOutputEntry.count(), rawTradeOutputEntry.xpReward(), rawTradeOutputEntry.weight)));
        }
        return tradeResultEntries;
    }

    private static void populateMainQueenTrades(Object2ObjectOpenHashMap<Item, Pair<WeightedRandomList<WeightedTradeResult>, TagKey<Item>>> tempQueenTrades, List<TradeResultEntry> tradeResultEntries, TradeWantEntry tradeWantEntry) {
        List<Item> wantItems = tradeWantEntry.wantItems().m_203614_().map(Holder::m_203334_).toList();
        for (Item item : wantItems) {
            ArrayList<WeightedTradeResult> existingTrades = new ArrayList<WeightedTradeResult>();
            TagKey key = tradeWantEntry.tagKey.orElse(null);
            boolean needsSorting = false;
            if (tempQueenTrades.containsKey((Object)item)) {
                existingTrades.addAll(((WeightedRandomList)((Pair)tempQueenTrades.get((Object)item)).getFirst()).m_146338_());
                key = null;
                needsSorting = true;
            }
            for (TradeResultEntry tradeResultEntry : tradeResultEntries) {
                List<Item> resultItems = tradeResultEntry.resultItems().m_203614_().map(Holder::m_203334_).toList();
                existingTrades.add(new WeightedTradeResult(tradeResultEntry.tagKey, Optional.of(resultItems), tradeResultEntry.count(), tradeResultEntry.xpReward(), tradeResultEntry.weight()));
            }
            if (needsSorting) {
                existingTrades.sort((a, b) -> b.weight - a.weight);
            }
            tempQueenTrades.put((Object)item, (Object)Pair.of((Object)WeightedRandomList.m_146328_(existingTrades), (Object)key));
        }
    }

    private static void populateRandomizedQueenTrades(Object2ObjectOpenHashMap<Item, Pair<WeightedRandomList<WeightedTradeResult>, TagKey<Item>>> tempQueenTrades, TradeWantEntry tradeRandomizeEntry) {
        List<Item> items = tradeRandomizeEntry.wantItems().m_203614_().map(Holder::m_203334_).toList();
        for (Item item : items) {
            if (tempQueenTrades.containsKey((Object)item)) {
                ArrayList<WeightedTradeResult> existingTrades = new ArrayList<WeightedTradeResult>(((WeightedRandomList)((Pair)tempQueenTrades.get((Object)item)).getFirst()).m_146338_());
                existingTrades.add(new WeightedTradeResult(tradeRandomizeEntry.tagKey(), Optional.of(items), 1, 0, 1));
                tempQueenTrades.put((Object)item, (Object)Pair.of((Object)WeightedRandomList.m_146328_(existingTrades), null));
                continue;
            }
            tempQueenTrades.put((Object)item, (Object)Pair.of((Object)WeightedRandomList.m_146330_((WeightedEntry[])new WeightedTradeResult[]{new WeightedTradeResult(tradeRandomizeEntry.tagKey(), Optional.of(items), 1, 0, 1)}), (Object)tradeRandomizeEntry.tagKey.orElse(null)));
        }
    }

    public static void syncRecipeViewerDataToClient(OnDatapackSyncEvent event) {
        if (FMLEnvironment.dist.isDedicatedServer()) {
            if (event.getPlayer() != null) {
                QueenRandomizerTradesSyncPacket.sendToClient(event.getPlayer(), QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerRandomizerTrades);
                QueenMainTradesSyncPacket.sendToClient(event.getPlayer(), QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerMainTrades);
            } else {
                event.getPlayerList().m_11314_().forEach(player -> QueenRandomizerTradesSyncPacket.sendToClient(player, QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerRandomizerTrades));
                event.getPlayerList().m_11314_().forEach(player -> QueenMainTradesSyncPacket.sendToClient(player, QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerMainTrades));
            }
        }
    }

    public record TradeCollection(Optional<List<RawTradeInputEntry>> randomizerItems, Optional<List<RawTradeInputEntry>> wantItems, Optional<List<RawTradeOutputEntry>> resultItems, boolean randomizerTrade) {
        public static final Codec<TradeCollection> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RawTradeInputEntry.CODEC.listOf().optionalFieldOf("randomizes").forGetter(e -> e.randomizerItems), (App)RawTradeInputEntry.CODEC.listOf().optionalFieldOf("wants").forGetter(e -> e.wantItems), (App)RawTradeOutputEntry.CODEC.listOf().optionalFieldOf("possible_rewards").forGetter(e -> e.resultItems), (App)Codec.BOOL.fieldOf("is_color_randomizer_trade").orElse((Object)false).forGetter(e -> e.randomizerTrade)).apply((Applicative)instance, instance.stable(TradeCollection::new)));
    }

    public record RawTradeInputEntry(String entry, boolean required) {
        public static final Codec<RawTradeInputEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(e -> e.entry), (App)Codec.BOOL.fieldOf("required").forGetter(e -> e.required)).apply((Applicative)instance, instance.stable(RawTradeInputEntry::new)));
    }

    public record TradeWantEntry(Optional<TagKey<Item>> tagKey, HolderSet<Item> wantItems) {
        public static final Codec<TradeWantEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TagKey.m_203877_((ResourceKey)Registry.f_122904_).optionalFieldOf("tagkey").forGetter(e -> e.tagKey), (App)RegistryCodecs.m_206279_((ResourceKey)Registry.f_122904_, (Codec)Registry.f_122827_.m_194605_()).fieldOf("wantItems").forGetter(e -> e.wantItems)).apply((Applicative)instance, instance.stable(TradeWantEntry::new)));
    }

    public record RawTradeOutputEntry(String entry, boolean required, int count, int xpReward, int weight) {
        public static final Codec<RawTradeOutputEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(e -> e.entry), (App)Codec.BOOL.fieldOf("required").forGetter(e -> e.required), (App)Codec.intRange((int)1, (int)64).fieldOf("count").forGetter(e -> e.count), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("xp_reward").forGetter(e -> e.xpReward), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("weight").forGetter(e -> e.weight)).apply((Applicative)instance, instance.stable(RawTradeOutputEntry::new)));
    }

    public record TradeResultEntry(Optional<TagKey<Item>> tagKey, HolderSet<Item> resultItems, int count, int xpReward, int weight) {
        public static final Codec<TradeResultEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TagKey.m_203877_((ResourceKey)Registry.f_122904_).optionalFieldOf("tagkey").forGetter(e -> e.tagKey), (App)RegistryCodecs.m_206279_((ResourceKey)Registry.f_122904_, (Codec)Registry.f_122827_.m_194605_()).fieldOf("wantItems").forGetter(e -> e.resultItems), (App)Codec.intRange((int)1, (int)64).fieldOf("count").forGetter(e -> e.count), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("xp_reward").forGetter(e -> e.xpReward), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("weight").forGetter(e -> e.weight)).apply((Applicative)instance, instance.stable(TradeResultEntry::new)));
    }
}

