/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities;

import com.google.common.primitives.Doubles;
import com.telepathicgrunt.the_bumblezone.capabilities.BzCapabilities;
import com.telepathicgrunt.the_bumblezone.capabilities.EntityPositionAndDimension;
import com.telepathicgrunt.the_bumblezone.configs.BzDimensionConfigs;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ProductiveBeesCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.BzPlacingUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityTeleportationBackend {
    public static Vec3 destPostFromOutOfBoundsTeleport(Entity entity, ServerLevel destination) {
        Entity player = entity.m_20197_().stream().filter(e -> e instanceof Player).findFirst().orElse(null);
        if (player != null) {
            entity = player;
        }
        LazyOptional capOptional = entity.getCapability(BzCapabilities.ENTITY_POS_AND_DIM_CAPABILITY);
        if (((Boolean)BzDimensionConfigs.forceBumblezoneOriginMobToOverworldCenter.get()).booleanValue() && capOptional.isPresent() && ((EntityPositionAndDimension)capOptional.orElseThrow(RuntimeException::new)).getNonBZPos() == null) {
            destination.m_46865_(BlockPos.f_121853_);
            int heightMapY = destination.m_6924_(Heightmap.Types.MOTION_BLOCKING, 0, 0);
            if (heightMapY > destination.m_141937_() && heightMapY < destination.m_151558_()) {
                return new Vec3(0.0, (double)heightMapY + 0.5, 0.0);
            }
            return new Vec3(0.0, (double)((float)(destination.m_141937_() + destination.m_151558_()) / 2.0f), 0.0);
        }
        Vec3 entitySavedPastPos = null;
        if (capOptional.isPresent()) {
            EntityPositionAndDimension capability = (EntityPositionAndDimension)capOptional.orElseThrow(RuntimeException::new);
            entitySavedPastPos = capability.getNonBZPos();
        }
        BlockPos finalSpawnPos = entity.m_20183_();
        if (entitySavedPastPos != null) {
            finalSpawnPos = new BlockPos(entitySavedPastPos);
        }
        return new Vec3((double)finalSpawnPos.m_123341_() + 0.5, (double)(finalSpawnPos.m_123342_() + 1), (double)finalSpawnPos.m_123343_() + 0.5);
    }

    public static Vec3 getBzCoordinate(Entity entity, ServerLevel originalWorld, ServerLevel bumblezoneWorld) {
        int heightCheck;
        double coordinateScale = originalWorld.m_6042_().f_63859_() / bumblezoneWorld.m_6042_().f_63859_();
        BlockPos blockpos = new BlockPos(Doubles.constrainToRange((double)(entity.m_20182_().m_7096_() * coordinateScale), (double)-2.9999936E7, (double)2.9999936E7), Doubles.constrainToRange((double)entity.m_20182_().m_7098_(), (double)45.0, (double)200.0), Doubles.constrainToRange((double)(entity.m_20182_().m_7094_() * coordinateScale), (double)-2.9999936E7, (double)2.9999936E7));
        Object validBlockPos = EntityTeleportationBackend.validPlayerSpawnLocation((Level)bumblezoneWorld, blockpos, 32);
        if (validBlockPos == null) {
            validBlockPos = new BlockPos(blockpos.m_123341_(), BzPlacingUtils.topOfSurfaceBelowHeightThroughWater((LevelAccessor)bumblezoneWorld, blockpos.m_123342_(), 0, blockpos) + 1, blockpos.m_123343_());
            if (validBlockPos.m_123342_() == 0) {
                validBlockPos = blockpos;
            } else if (bumblezoneWorld.m_8055_(validBlockPos).m_60767_() == Material.f_76305_ && bumblezoneWorld.m_8055_(validBlockPos.m_7494_()).m_60767_() == Material.f_76305_) {
                BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(validBlockPos.m_123341_(), validBlockPos.m_123342_(), validBlockPos.m_123343_());
                while (mutable.m_123342_() < 255 && !bumblezoneWorld.m_46859_((BlockPos)mutable) || bumblezoneWorld.m_8055_((BlockPos)mutable).m_60767_() == Material.f_76305_) {
                    mutable.m_122173_(Direction.UP);
                }
                validBlockPos = !bumblezoneWorld.m_8055_((BlockPos)mutable).m_60795_() ? blockpos : mutable;
            } else if (!bumblezoneWorld.m_46859_(validBlockPos) && bumblezoneWorld.m_8055_(validBlockPos).m_60767_() != Material.f_76305_ && !bumblezoneWorld.m_8055_(validBlockPos.m_7494_()).m_60795_()) {
                validBlockPos = blockpos;
            }
        }
        for (heightCheck = 0; heightCheck <= validBlockPos.m_123342_() && bumblezoneWorld.m_8055_(validBlockPos.m_6625_(heightCheck)).m_60795_(); ++heightCheck) {
        }
        if (heightCheck >= validBlockPos.m_123342_()) {
            bumblezoneWorld.m_46597_(validBlockPos.m_123342_() == 0 ? validBlockPos : validBlockPos.m_7495_(), Blocks.f_50720_.m_49966_());
        }
        return new Vec3((double)validBlockPos.m_123341_() + 0.5, (double)validBlockPos.m_123342_(), (double)validBlockPos.m_123343_() + 0.5);
    }

    private static BlockPos validPlayerSpawnLocation(Level world, BlockPos position, int maximumRange) {
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos(position.m_123341_(), position.m_123342_(), position.m_123343_());
        ChunkAccess chunk = null;
        for (int range = 0; range <= maximumRange; ++range) {
            int radius = range * range;
            int outerRadius = (range + 1) * (range + 1);
            for (int y = -range; y <= range; y += 4) {
                for (int x = -range; x <= range; x += 4) {
                    for (int z = -range; z <= range; z += 4) {
                        boolean isCurrentPosAir;
                        int distanceSq = x * x + z * z + y * y;
                        if (distanceSq < radius || distanceSq >= outerRadius) continue;
                        currentPos.m_122190_((Vec3i)position.m_7918_(x, y, z));
                        if (currentPos.m_123342_() > 250 || currentPos.m_123342_() < 45 || !(isCurrentPosAir = (chunk = EntityTeleportationBackend.getChunkForSpot(world, chunk, (BlockPos)currentPos)).m_8055_((BlockPos)currentPos).m_60795_())) continue;
                        boolean isBelowSolid = chunk.m_8055_(currentPos.m_7495_()).m_60815_();
                        if (isBelowSolid) {
                            if (!chunk.m_8055_(currentPos.m_6630_(2)).m_60795_()) continue;
                            return currentPos;
                        }
                        while (!isBelowSolid && currentPos.m_123342_() >= 45) {
                            currentPos.m_122173_(Direction.DOWN);
                            BlockState belowState = chunk.m_8055_(currentPos.m_7495_());
                            isBelowSolid = belowState.m_60815_() || !belowState.m_60819_().m_76178_();
                        }
                        if (!isBelowSolid) continue;
                        return currentPos;
                    }
                }
            }
        }
        return null;
    }

    private static ChunkAccess getChunkForSpot(Level world, ChunkAccess chunkAccess, BlockPos blockPos) {
        if (chunkAccess == null || chunkAccess.m_7697_().f_45578_ != blockPos.m_123341_() >> 4 || chunkAccess.m_7697_().f_45579_ != blockPos.m_123343_() >> 4) {
            return world.m_46865_(blockPos);
        }
        return chunkAccess;
    }

    public static boolean isValidBeeHive(BlockState blockState) {
        if (blockState.m_204336_(BzTags.FORCED_ALLOWED_TELEPORTABLE_BLOCK)) {
            return true;
        }
        if (blockState.m_204336_(BzTags.DISALLOWED_TELEPORTABLE_BEEHIVE)) {
            return false;
        }
        if ((blockState.m_204336_(BlockTags.f_13072_) || blockState.m_60734_() instanceof BeehiveBlock) && (ForgeRegistries.BLOCKS.getKey((Object)blockState.m_60734_()).m_135827_().equals("minecraft") || ((Boolean)BzDimensionConfigs.allowTeleportationWithModdedBeehives.get()).booleanValue())) {
            return true;
        }
        return (Boolean)BzDimensionConfigs.allowTeleportationWithModdedBeehives.get() != false && ModChecker.productiveBeesPresent && ProductiveBeesCompat.PBIsExpandedBeehiveBlock(blockState);
    }
}

