/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client;

import com.telepathicgrunt.the_bumblezone.client.BeehemothControls;
import com.telepathicgrunt.the_bumblezone.client.bakedmodel.EmptyHoneycombBroodBlockModel;
import com.telepathicgrunt.the_bumblezone.client.bakedmodel.PorousHoneycombBlockModel;
import com.telepathicgrunt.the_bumblezone.client.items.HoneyCompassItemProperty;
import com.telepathicgrunt.the_bumblezone.client.items.IncenseCandleColoring;
import com.telepathicgrunt.the_bumblezone.client.particles.HoneyParticle;
import com.telepathicgrunt.the_bumblezone.client.particles.PollenPuffParticle;
import com.telepathicgrunt.the_bumblezone.client.particles.RoyalJellyParticle;
import com.telepathicgrunt.the_bumblezone.client.particles.SparkleParticle;
import com.telepathicgrunt.the_bumblezone.client.rendering.DimensionTeleportingScreen;
import com.telepathicgrunt.the_bumblezone.client.rendering.beearmor.BeeArmorModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.beehemoth.BeehemothModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.beehemoth.BeehemothRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.beequeen.BeeQueenModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.beequeen.BeeQueenRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.beestinger.BeeStingerModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.beestinger.BeeStingerRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.honeycrystalshard.HoneyCrystalShardModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.honeycrystalshard.HoneyCrystalShardRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.honeyslime.HoneySlimeRendering;
import com.telepathicgrunt.the_bumblezone.client.rendering.pileofpollen.PileOfPollenRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.stingerspear.StingerSpearModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.stingerspear.StingerSpearRenderer;
import com.telepathicgrunt.the_bumblezone.items.BeeCannon;
import com.telepathicgrunt.the_bumblezone.items.CrystalCannon;
import com.telepathicgrunt.the_bumblezone.items.StinglessBeeHelmet;
import com.telepathicgrunt.the_bumblezone.modinit.BzDimension;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzMenuTypes;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.screens.CrystallineFlowerScreen;
import com.telepathicgrunt.the_bumblezone.screens.StrictChestScreen;
import com.telepathicgrunt.the_bumblezone.world.dimension.BzSkyProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class BumblezoneClient {
    public static void subscribeClientEvents() {
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(BumblezoneClient::onClientSetup);
        modEventBus.addListener(BumblezoneClient::onParticleSetup);
        modEventBus.addListener(BumblezoneClient::registerEntityRenderers);
        modEventBus.addListener(BumblezoneClient::registerEntityModels);
        modEventBus.addListener(BumblezoneClient::registerKeyBinding);
        modEventBus.addListener(BumblezoneClient::registerDimensionSpecialEffects);
        modEventBus.addListener(IncenseCandleColoring::registerBlockColors);
        modEventBus.addListener(IncenseCandleColoring::registerItemColors);
        modEventBus.addListener(PorousHoneycombBlockModel::registerModelLoaders);
        modEventBus.addListener(EmptyHoneycombBroodBlockModel::registerModelLoaders);
        forgeBus.addListener(event -> {
            if (event.phase == TickEvent.Phase.END) {
                StinglessBeeHelmet.decrementHighlightingCounter((Player)Minecraft.m_91087_().f_91074_);
            }
        });
        forgeBus.addListener(PileOfPollenRenderer::pileOfPollenOverlay);
        forgeBus.addListener(BeehemothControls::keyInput);
        forgeBus.addListener(BumblezoneClient::onScreenRendering);
    }

    public static void registerKeyBinding(RegisterKeyMappingsEvent event) {
        event.register(BeehemothControls.KEY_BIND_BEEHEMOTH_UP);
        event.register(BeehemothControls.KEY_BIND_BEEHEMOTH_DOWN);
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            BumblezoneClient.registerRenderLayers();
            BumblezoneClient.registerItemProperties();
            BumblezoneClient.registerScreens();
        });
    }

    private static void registerScreens() {
        MenuScreens.m_96206_((MenuType)((MenuType)BzMenuTypes.STRICT_9x1.get()), StrictChestScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)BzMenuTypes.STRICT_9x2.get()), StrictChestScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)BzMenuTypes.STRICT_9x3.get()), StrictChestScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)BzMenuTypes.STRICT_9x4.get()), StrictChestScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)BzMenuTypes.STRICT_9x5.get()), StrictChestScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)BzMenuTypes.STRICT_9x6.get()), StrictChestScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)BzMenuTypes.CRYSTALLINE_FLOWER.get()), CrystallineFlowerScreen::new);
    }

    private static void registerItemProperties() {
        ItemProperties.register((Item)((Item)BzItems.HONEY_CRYSTAL_SHIELD.get()), (ResourceLocation)new ResourceLocation("blocking"), (itemStack, world, livingEntity, integer) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)BzItems.STINGER_SPEAR.get()), (ResourceLocation)new ResourceLocation("throwing"), (itemStack, world, livingEntity, integer) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)BzItems.HONEY_COMPASS.get()), (ResourceLocation)new ResourceLocation("angle"), (ItemPropertyFunction)HoneyCompassItemProperty.getClampedItemPropertyFunction());
        ItemProperties.register((Item)((Item)BzItems.BEE_CANNON.get()), (ResourceLocation)new ResourceLocation("primed"), (itemStack, world, livingEntity, int1) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)BzItems.CRYSTAL_CANNON.get()), (ResourceLocation)new ResourceLocation("primed"), (itemStack, world, livingEntity, int1) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)BzItems.BEE_CANNON.get()), (ResourceLocation)new ResourceLocation("bee_count"), (itemStack, world, livingEntity, int1) -> (float)BeeCannon.getNumberOfBees(itemStack) / 10.0f);
        ItemProperties.register((Item)((Item)BzItems.CRYSTAL_CANNON.get()), (ResourceLocation)new ResourceLocation("crystal_count"), (itemStack, world, livingEntity, int1) -> (float)CrystalCannon.getNumberOfCrystals(itemStack) / 10.0f);
        ItemProperties.register((Item)((Item)BzItems.CRYSTAL_CANNON.get()), (ResourceLocation)new ResourceLocation("crystal_count"), (itemStack, world, livingEntity, int1) -> (float)CrystalCannon.getNumberOfCrystals(itemStack) / 10.0f);
        ItemProperties.register((Item)((Item)BzItems.HONEYCOMB_BROOD.get()), (ResourceLocation)new ResourceLocation("is_creative_tab_icon"), (itemStack, world, livingEntity, integer) -> itemStack.m_41782_() && itemStack.m_41783_().m_128471_("isCreativeTabIcon") ? 1.0f : 0.0f);
    }

    private static void registerRenderLayers() {
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)BzFluids.SUGAR_WATER_FLUID.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)BzFluids.SUGAR_WATER_FLUID_FLOWING.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)BzFluids.HONEY_FLUID.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)BzFluids.HONEY_FLUID_FLOWING.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)BzFluids.ROYAL_JELLY_FLUID.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)BzFluids.ROYAL_JELLY_FLUID_FLOWING.get()), (RenderType)RenderType.m_110466_());
    }

    public static void registerEntityModels(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BeehemothModel.LAYER_LOCATION, BeehemothModel::createBodyLayer);
        event.registerLayerDefinition(BeeQueenModel.LAYER_LOCATION, BeeQueenModel::createBodyLayer);
        event.registerLayerDefinition(StingerSpearModel.LAYER_LOCATION, StingerSpearModel::createLayer);
        event.registerLayerDefinition(BeeStingerModel.LAYER_LOCATION, BeeStingerModel::createLayer);
        event.registerLayerDefinition(HoneyCrystalShardModel.LAYER_LOCATION, HoneyCrystalShardModel::createLayer);
        event.registerLayerDefinition(BeeArmorModel.VARIANT_1_LAYER_LOCATION, BeeArmorModel::createVariant1);
        event.registerLayerDefinition(BeeArmorModel.VARIANT_2_LAYER_LOCATION, BeeArmorModel::createVariant2);
    }

    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        EntityRenderers.m_174036_((EntityType)((EntityType)BzEntities.HONEY_SLIME.get()), HoneySlimeRendering::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BzEntities.BEEHEMOTH.get()), BeehemothRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BzEntities.BEE_QUEEN.get()), BeeQueenRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BzEntities.POLLEN_PUFF_ENTITY.get()), ThrownItemRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BzEntities.THROWN_STINGER_SPEAR_ENTITY.get()), StingerSpearRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BzEntities.BEE_STINGER_ENTITY.get()), BeeStingerRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BzEntities.HONEY_CRYSTAL_SHARD.get()), HoneyCrystalShardRenderer::new);
    }

    public static void onParticleSetup(RegisterParticleProvidersEvent event) {
        event.register((ParticleType)BzParticles.POLLEN_PARTICLE.get(), PollenPuffParticle.Factory::new);
        event.register((ParticleType)BzParticles.SPARKLE_PARTICLE.get(), SparkleParticle.Factory::new);
        event.register((ParticleType)BzParticles.HONEY_PARTICLE.get(), HoneyParticle.Factory::new);
        event.register((ParticleType)BzParticles.ROYAL_JELLY_PARTICLE.get(), RoyalJellyParticle.Factory::new);
    }

    public static void registerDimensionSpecialEffects(RegisterDimensionSpecialEffectsEvent event) {
        event.register(new ResourceLocation("the_bumblezone", "sky_property"), (DimensionSpecialEffects)new BzSkyProperty());
    }

    public static void onScreenRendering(ScreenEvent.Render.Pre event) {
        Screen screen = event.getScreen();
        if (screen instanceof ReceivingLevelScreen) {
            ReceivingLevelScreen receivingLevelScreen = (ReceivingLevelScreen)screen;
            if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.f_19853_.m_46472_() == BzDimension.BZ_WORLD_KEY) {
                DimensionTeleportingScreen.renderScreenAndText(receivingLevelScreen, event.getPoseStack());
                event.setCanceled(true);
            }
        }
    }
}

