/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.capabilities;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.capabilities.BzCapabilities;
import com.telepathicgrunt.the_bumblezone.configs.BzDimensionConfigs;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.apache.logging.log4j.Level;

public class EntityPositionAndDimension
implements INBTSerializable<CompoundTag> {
    private ResourceLocation nonBZDimension = new ResourceLocation("minecraft", "overworld");
    private Vec3 nonBZPosition = null;

    public void setNonBZDim(ResourceLocation incomingDim) {
        if (incomingDim.equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
            this.nonBZDimension = new ResourceLocation((String)BzDimensionConfigs.defaultDimension.get());
            Bumblezone.LOGGER.log(Level.ERROR, "Error: The non-bz dimension passed in to be stored was bz dimension. Please contact mod creator to let them know of this issue.");
        } else {
            this.nonBZDimension = incomingDim;
        }
    }

    public ResourceLocation getNonBZDim() {
        return this.nonBZDimension;
    }

    public void setNonBZPos(Vec3 incomingPos) {
        this.nonBZPosition = incomingPos;
    }

    public Vec3 getNonBZPos() {
        return this.nonBZPosition;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.getNonBZDim() != null) {
            nbt.m_128359_("PreviousDimensionNamespace", this.getNonBZDim().m_135827_());
            nbt.m_128359_("PreviousDimensionPath", this.getNonBZDim().m_135815_());
            if (this.getNonBZPos() != null) {
                nbt.m_128347_("NonBZ_X", this.getNonBZPos().f_82479_);
                nbt.m_128347_("NonBZ_Y", this.getNonBZPos().f_82480_);
                nbt.m_128347_("NonBZ_Z", this.getNonBZPos().f_82481_);
            }
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbtTag) {
        String namespace = nbtTag.m_128461_("PreviousDimensionNamespace");
        String path = nbtTag.m_128461_("PreviousDimensionPath");
        ResourceLocation storedDimension = path.trim().isEmpty() ? new ResourceLocation("minecraft", "overworld") : new ResourceLocation(namespace, path);
        Vec3 storedPositionNonBZ = null;
        if (nbtTag.m_128441_("NonBZ_X") && nbtTag.m_128441_("NonBZ_Y") && nbtTag.m_128441_("NonBZ_Z")) {
            storedPositionNonBZ = new Vec3((double)nbtTag.m_128457_("NonBZ_X"), (double)nbtTag.m_128457_("NonBZ_Y"), (double)nbtTag.m_128457_("NonBZ_Z"));
        }
        this.setNonBZDim(storedDimension.m_135815_().isEmpty() ? new ResourceLocation("minecraft", "overworld") : storedDimension);
        this.setNonBZPos(storedPositionNonBZ);
    }

    public static void resetValueOnRespawn(PlayerEvent.Clone event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayerNew = (ServerPlayer)player;
            player = event.getOriginal();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayerOld = (ServerPlayer)player;
                serverPlayerOld.reviveCaps();
                serverPlayerNew.getCapability(BzCapabilities.ENTITY_POS_AND_DIM_CAPABILITY).ifPresent(capabilityNew -> serverPlayerOld.getCapability(BzCapabilities.ENTITY_POS_AND_DIM_CAPABILITY).ifPresent(capabilityOld -> capabilityNew.deserializeNBT(capabilityOld.serializeNBT())));
                serverPlayerOld.invalidateCaps();
            }
        }
    }
}

