/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.capabilities;

import com.telepathicgrunt.the_bumblezone.capabilities.BzCapabilities;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.entities.mobs.HoneySlimeEntity;
import com.telepathicgrunt.the_bumblezone.items.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.mixin.entities.PlayerAdvancementsAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityMisc
implements INBTSerializable<CompoundTag> {
    public boolean isBeeEssenced = false;
    public boolean receivedEssencePrize = false;
    public long tradeResetPrimedTime = -1000L;
    public int craftedBeehives = 0;
    public int beesBred = 0;
    public int flowersSpawned = 0;
    public int honeyBottleDrank = 0;
    public int beeStingersFired = 0;
    public int beeSaved = 0;
    public int pollenPuffHits = 0;
    public int honeySlimeBred = 0;
    public int beesFed = 0;
    public int queenBeeTrade = 0;
    public Map<ResourceLocation, Integer> mobsKilledTracker = new Object2IntOpenHashMap();

    public void resetAllTrackerStats() {
        this.receivedEssencePrize = false;
        this.tradeResetPrimedTime = -1000L;
        this.craftedBeehives = 0;
        this.beesBred = 0;
        this.flowersSpawned = 0;
        this.honeyBottleDrank = 0;
        this.beeStingersFired = 0;
        this.beeSaved = 0;
        this.pollenPuffHits = 0;
        this.honeySlimeBred = 0;
        this.beesFed = 0;
        this.queenBeeTrade = 0;
        this.mobsKilledTracker.clear();
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("is_bee_essenced", this.isBeeEssenced);
        nbt.m_128379_("received_essence_prize", this.receivedEssencePrize);
        nbt.m_128356_("trade_reset_primed_time", this.tradeResetPrimedTime);
        nbt.m_128405_("crafted_beehives", this.craftedBeehives);
        nbt.m_128405_("bees_bred", this.beesBred);
        nbt.m_128405_("flowers_spawned", this.flowersSpawned);
        nbt.m_128405_("honey_bottle_drank", this.honeyBottleDrank);
        nbt.m_128405_("bee_stingers_fired", this.beeStingersFired);
        nbt.m_128405_("bee_saved", this.beeSaved);
        nbt.m_128405_("pollen_puff_hits", this.pollenPuffHits);
        nbt.m_128405_("honey_slime_bred", this.honeySlimeBred);
        nbt.m_128405_("bees_fed", this.beesFed);
        nbt.m_128405_("queen_bee_trade", this.queenBeeTrade);
        ListTag mapList = new ListTag();
        for (Map.Entry<ResourceLocation, Integer> entry : this.mobsKilledTracker.entrySet()) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128359_("id", entry.getKey().toString());
            compoundTag.m_128405_("count", entry.getValue().intValue());
            mapList.add((Object)compoundTag);
        }
        nbt.m_128365_("mobs_killed_tracker", (Tag)mapList);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbtTag) {
        this.isBeeEssenced = nbtTag.m_128471_("is_bee_essenced");
        this.receivedEssencePrize = nbtTag.m_128471_("received_essence_prize");
        this.tradeResetPrimedTime = nbtTag.m_128454_("trade_reset_primed_time");
        this.craftedBeehives = nbtTag.m_128451_("crafted_beehives");
        this.beesBred = nbtTag.m_128451_("bees_bred");
        this.flowersSpawned = nbtTag.m_128451_("flowers_spawned");
        this.honeyBottleDrank = nbtTag.m_128451_("honey_bottle_drank");
        this.beeStingersFired = nbtTag.m_128451_("bee_stingers_fired");
        this.beeSaved = nbtTag.m_128451_("bee_saved");
        this.pollenPuffHits = nbtTag.m_128451_("pollen_puff_hits");
        this.honeySlimeBred = nbtTag.m_128451_("honey_slime_bred");
        this.beesFed = nbtTag.m_128451_("bees_fed");
        this.queenBeeTrade = nbtTag.m_128451_("queen_bee_trade");
        ListTag mapList = nbtTag.m_128437_("mobs_killed_tracker", 10);
        for (int i = 0; i < mapList.size(); ++i) {
            CompoundTag compoundTag = mapList.m_128728_(i);
            this.mobsKilledTracker.put(new ResourceLocation(compoundTag.m_128461_("id")), compoundTag.m_128451_("count"));
        }
    }

    public static void resetValueOnRespawn(PlayerEvent.Clone event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayerNew = (ServerPlayer)player;
            player = event.getOriginal();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayerOld = (ServerPlayer)player;
                serverPlayerOld.reviveCaps();
                serverPlayerNew.getCapability(BzCapabilities.ENTITY_MISC).ifPresent(capabilityNew -> serverPlayerOld.getCapability(BzCapabilities.ENTITY_MISC).ifPresent(capabilityOld -> capabilityNew.deserializeNBT(capabilityOld.serializeNBT())));
                if (!event.isWasDeath()) {
                    serverPlayerNew.getCapability(BzCapabilities.ENTITY_POS_AND_DIM_CAPABILITY).ifPresent(capabilityNew -> serverPlayerOld.getCapability(BzCapabilities.ENTITY_POS_AND_DIM_CAPABILITY).ifPresent(capabilityOld -> capabilityNew.deserializeNBT(capabilityOld.serializeNBT())));
                    serverPlayerNew.getCapability(BzCapabilities.NEUROTOXINS_MISS_COUNTER_CAPABILITY).ifPresent(capabilityNew -> serverPlayerOld.getCapability(BzCapabilities.NEUROTOXINS_MISS_COUNTER_CAPABILITY).ifPresent(capabilityOld -> capabilityNew.deserializeNBT(capabilityOld.serializeNBT())));
                    serverPlayerNew.getCapability(BzCapabilities.ORIGINAL_FLYING_SPEED_CAPABILITY).ifPresent(capabilityNew -> serverPlayerOld.getCapability(BzCapabilities.ORIGINAL_FLYING_SPEED_CAPABILITY).ifPresent(capabilityOld -> capabilityNew.deserializeNBT(capabilityOld.serializeNBT())));
                }
                if (((Boolean)BzGeneralConfigs.keepEssenceOfTheBeesOnRespawning.get()).booleanValue() || !event.isWasDeath()) {
                    EssenceOfTheBees.setEssence(serverPlayerNew, EssenceOfTheBees.hasEssence(serverPlayerOld));
                } else {
                    EssenceOfTheBees.setEssence(serverPlayerNew, false);
                    MutableComponent message = Component.m_237115_((String)"system.the_bumblezone.lost_bee_essence").m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.RED);
                    serverPlayerNew.m_5661_((Component)message, true);
                }
                serverPlayerOld.invalidateCaps();
            }
        }
    }

    public static void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        ItemStack createdItem = event.getCrafting();
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            BlockItem blockItem;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            player = createdItem.m_41720_();
            if (player instanceof BlockItem && (blockItem = (BlockItem)player).m_40614_() instanceof BeehiveBlock && EntityMisc.rootAdvancementDone(serverPlayer)) {
                serverPlayer.getCapability(BzCapabilities.ENTITY_MISC).ifPresent(capability -> {
                    int currentlyCraftedCount = capability.craftedBeehives + 1;
                    BzCriterias.BEEHIVE_CRAFTED_TRIGGER.trigger(serverPlayer, currentlyCraftedCount);
                    capability.craftedBeehives = currentlyCraftedCount;
                });
            }
        }
    }

    public static void onBeeBreed(BabyEntitySpawnEvent event) {
        ServerPlayer serverPlayer;
        Player player;
        if (!event.isCanceled() && event.getChild() instanceof Bee && (player = event.getCausedByPlayer()) instanceof ServerPlayer && EntityMisc.rootAdvancementDone(serverPlayer = (ServerPlayer)player)) {
            serverPlayer.getCapability(BzCapabilities.ENTITY_MISC).ifPresent(capability -> {
                int currentlyBredBees = capability.beesBred + 1;
                BzCriterias.BEE_BREEDING_TRIGGER.trigger(serverPlayer, currentlyBredBees);
                capability.beesBred = currentlyBredBees;
            });
        }
    }

    public static void onFlowerSpawned(Player player) {
        ServerPlayer serverPlayer;
        if (player instanceof ServerPlayer && EntityMisc.rootAdvancementDone(serverPlayer = (ServerPlayer)player)) {
            serverPlayer.getCapability(BzCapabilities.ENTITY_MISC).ifPresent(capability -> {
                int currentlySpawnedFlowers = capability.flowersSpawned + 1;
                BzCriterias.POLLEN_PUFF_SPAWN_FLOWERS_TRIGGER.trigger(serverPlayer, currentlySpawnedFlowers);
                capability.flowersSpawned = currentlySpawnedFlowers;
            });
        }
    }

    public static void onEntityKilled(LivingDeathEvent event) {
        ServerPlayer serverPlayer;
        Entity entity;
        DamageSource damageSource = event.getSource();
        if (!event.isCanceled() && event.getEntity() != null && damageSource != null && (entity = damageSource.m_7639_()) instanceof ServerPlayer && EntityMisc.rootAdvancementDone(serverPlayer = (ServerPlayer)entity)) {
            serverPlayer.getCapability(BzCapabilities.ENTITY_MISC).ifPresent(capability -> {
                ResourceLocation killedEntity = ForgeRegistries.ENTITY_TYPES.getKey((Object)event.getEntity().m_6095_());
                int killedCount = capability.mobsKilledTracker.getOrDefault(killedEntity, 0);
                BzCriterias.KILLED_COUNTER_TRIGGER.trigger(serverPlayer, killedEntity, ++killedCount);
                capability.mobsKilledTracker.put(killedEntity, killedCount);
            });
        }
    }

    public static void onHoneyBottleDrank(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            if (event.getItem().m_204117_(BzTags.HONEY_DRUNK_TRIGGER_ITEMS) && EntityMisc.rootAdvancementDone(serverPlayer)) {
                serverPlayer.getCapability(BzCapabilities.ENTITY_MISC).ifPresent(capability -> {
                    int currentlyDrankHoneyBottles = capability.honeyBottleDrank + 1;
                    BzCriterias.HONEY_BOTTLE_DRANK_TRIGGER.trigger(serverPlayer, currentlyDrankHoneyBottles);
                    capability.honeyBottleDrank = currentlyDrankHoneyBottles;
                });
            }
        }
    }

    public static void onBeeStingerFired(Player player) {
        ServerPlayer serverPlayer;
        if (player instanceof ServerPlayer && EntityMisc.rootAdvancementDone(serverPlayer = (ServerPlayer)player)) {
            serverPlayer.getCapability(BzCapabilities.ENTITY_MISC).ifPresent(capability -> {
                int currentBeeStingersFired = capability.beeStingersFired + 1;
                BzCriterias.BEE_STINGER_SHOOTER_TRIGGER.trigger(serverPlayer, currentBeeStingersFired);
                capability.beeStingersFired = currentBeeStingersFired;
            });
        }
    }

    public static void onBeesSaved(Player player) {
        ServerPlayer serverPlayer;
        if (player instanceof ServerPlayer && EntityMisc.rootAdvancementDone(serverPlayer = (ServerPlayer)player)) {
            serverPlayer.getCapability(BzCapabilities.ENTITY_MISC).ifPresent(capability -> {
                int currentBeesSaved = capability.beeSaved + 1;
                BzCriterias.BEE_SAVED_BY_STINGER_TRIGGER.trigger(serverPlayer, currentBeesSaved);
                capability.beeSaved = currentBeesSaved;
            });
        }
    }

    public static void onPollenHit(Player player) {
        ServerPlayer serverPlayer;
        if (player instanceof ServerPlayer && EntityMisc.rootAdvancementDone(serverPlayer = (ServerPlayer)player)) {
            serverPlayer.getCapability(BzCapabilities.ENTITY_MISC).ifPresent(capability -> {
                int currentPollenPuffHits = capability.pollenPuffHits + 1;
                BzCriterias.POLLEN_PUFF_HIT_TRIGGER.trigger(serverPlayer, currentPollenPuffHits);
                capability.pollenPuffHits = currentPollenPuffHits;
            });
        }
    }

    public static void onHoneySlimeBred(BabyEntitySpawnEvent event) {
        ServerPlayer serverPlayer;
        Player player;
        if (!event.isCanceled() && event.getChild() instanceof HoneySlimeEntity && (player = event.getCausedByPlayer()) instanceof ServerPlayer && EntityMisc.rootAdvancementDone(serverPlayer = (ServerPlayer)player)) {
            serverPlayer.getCapability(BzCapabilities.ENTITY_MISC).ifPresent(capability -> {
                int currentlyHoneySlimeBred = capability.honeySlimeBred + 1;
                BzCriterias.HONEY_SLIME_BRED_TRIGGER.trigger(serverPlayer, currentlyHoneySlimeBred);
                capability.honeySlimeBred = currentlyHoneySlimeBred;
            });
        }
    }

    public static void onBeesFed(Player player) {
        ServerPlayer serverPlayer;
        if (player instanceof ServerPlayer && EntityMisc.rootAdvancementDone(serverPlayer = (ServerPlayer)player)) {
            serverPlayer.getCapability(BzCapabilities.ENTITY_MISC).ifPresent(capability -> {
                int currentBeesFed = capability.beesFed + 1;
                BzCriterias.BEE_FED_TRIGGER.trigger(serverPlayer, currentBeesFed);
                capability.beesFed = currentBeesFed;
            });
        }
    }

    public static void onQueenBeeTrade(Player player) {
        ServerPlayer serverPlayer;
        if (player instanceof ServerPlayer && EntityMisc.rootAdvancementDone(serverPlayer = (ServerPlayer)player)) {
            serverPlayer.getCapability(BzCapabilities.ENTITY_MISC).ifPresent(capability -> {
                int currentTrades = capability.queenBeeTrade + 1;
                BzCriterias.BEE_QUEEN_TRADING_TRIGGER.trigger(serverPlayer, currentTrades);
                capability.queenBeeTrade = currentTrades;
            });
        }
    }

    public static void onQueenBeeTrade(Player player, int tradedItems) {
        ServerPlayer serverPlayer;
        if (player instanceof ServerPlayer && EntityMisc.rootAdvancementDone(serverPlayer = (ServerPlayer)player)) {
            serverPlayer.getCapability(BzCapabilities.ENTITY_MISC).ifPresent(capability -> {
                int currentTrades = capability.queenBeeTrade + tradedItems;
                BzCriterias.BEE_QUEEN_TRADING_TRIGGER.trigger(serverPlayer, currentTrades);
                capability.queenBeeTrade = currentTrades;
            });
        }
    }

    public static boolean rootAdvancementDone(ServerPlayer serverPlayer) {
        Advancement advancement = serverPlayer.f_8924_.m_129889_().m_136041_(BzCriterias.QUEENS_DESIRE_ROOT_ADVANCEMENT);
        Map<Advancement, AdvancementProgress> advancementsProgressMap = ((PlayerAdvancementsAccessor)serverPlayer.m_8960_()).getAdvancements();
        return advancement != null && advancementsProgressMap.containsKey(advancement) && advancementsProgressMap.get(advancement).m_8193_();
    }
}

