/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class StringCurtain
extends Block {
    public static final BooleanProperty ATTACHED = BooleanProperty.m_61465_((String)"attached");
    public static final BooleanProperty CENTER = BooleanProperty.m_61465_((String)"center");
    public static final BooleanProperty IS_END = BooleanProperty.m_61465_((String)"is_end");
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.f_61374_;
    protected final Map<Pair<Direction, Boolean>, VoxelShape> collisionShapeByMap = this.makeShapes();

    public StringCurtain() {
        this(BlockBehaviour.Properties.m_60944_((Material)Material.f_76299_, (MaterialColor)MaterialColor.f_76401_).m_60955_().m_60953_(blockState -> 1).m_60918_(SoundType.f_56745_).m_60978_(0.3f));
    }

    public StringCurtain(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)CENTER, (Comparable)Boolean.valueOf(true))).m_61124_((Property)IS_END, (Comparable)Boolean.valueOf(true))).m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{ATTACHED, CENTER, IS_END, HORIZONTAL_FACING});
    }

    protected Map<Pair<Direction, Boolean>, VoxelShape> makeShapes() {
        Object2ObjectArrayMap shapeMap = new Object2ObjectArrayMap();
        shapeMap.put(Pair.of((Object)Direction.NORTH, (Object)false), Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0));
        shapeMap.put(Pair.of((Object)Direction.SOUTH, (Object)false), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0));
        shapeMap.put(Pair.of((Object)Direction.WEST, (Object)false), Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
        shapeMap.put(Pair.of((Object)Direction.EAST, (Object)false), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0));
        VoxelShape temp = Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
        shapeMap.put(Pair.of((Object)Direction.NORTH, (Object)true), temp);
        shapeMap.put(Pair.of((Object)Direction.SOUTH, (Object)true), temp);
        temp = Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);
        shapeMap.put(Pair.of((Object)Direction.WEST, (Object)true), temp);
        shapeMap.put(Pair.of((Object)Direction.EAST, (Object)true), temp);
        return shapeMap;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return this.collisionShapeByMap.get(Pair.of((Object)((Direction)blockState.m_61143_((Property)HORIZONTAL_FACING)), (Object)((Boolean)blockState.m_61143_((Property)CENTER))));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (context instanceof EntityCollisionContext) {
            EntityCollisionContext ctx = (EntityCollisionContext)context;
            Entity entity = ctx.m_193113_();
            if (entity == null) {
                return this.m_5940_(state, worldIn, pos, context);
            }
            if ((entity instanceof Bee || entity.m_6095_().m_204039_(BzTags.STRING_CURTAIN_BLOCKS_PATHFINDING_FOR_NON_BEE_MOB)) && !entity.m_6095_().m_204039_(BzTags.STRING_CURTAIN_FORCE_ALLOW_PATHFINDING) && state.m_204336_(BzTags.STRING_CURTAINS)) {
                return this.m_5940_(state, worldIn, pos, context);
            }
        }
        return Shapes.m_83040_();
    }

    public void m_7892_(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        if ((entity instanceof Bee || entity.m_6095_().m_204039_(BzTags.STRING_CURTAIN_BLOCKS_PATHFINDING_FOR_NON_BEE_MOB)) && !entity.m_6095_().m_204039_(BzTags.STRING_CURTAIN_FORCE_ALLOW_PATHFINDING) && !entity.m_217005_() && !entity.m_20159_() && entity.m_6094_() && blockState.m_204336_(BzTags.STRING_CURTAINS)) {
            Vec3 centerPos = blockState.m_60808_((BlockGetter)level, blockPos).m_83215_().m_82399_().m_82520_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
            Vec3 beeCenter = entity.m_20182_();
            double speedSlowdown = 1.4f;
            double forcePushSpeed = 0.03f;
            if (((Direction)blockState.m_61143_((Property)HORIZONTAL_FACING)).m_122434_() == Direction.Axis.X) {
                if (centerPos.m_7096_() > beeCenter.m_7096_()) {
                    if (entity.m_20184_().m_7096_() > 0.0) {
                        entity.m_20334_(entity.m_20184_().m_7096_() / speedSlowdown, entity.m_20184_().m_7098_(), entity.m_20184_().m_7094_());
                    }
                    entity.m_5997_(-forcePushSpeed, 0.0, 0.0);
                } else {
                    if (entity.m_20184_().m_7096_() < 0.0) {
                        entity.m_20334_(entity.m_20184_().m_7096_() / speedSlowdown, entity.m_20184_().m_7098_(), entity.m_20184_().m_7094_());
                    }
                    entity.m_5997_(forcePushSpeed, 0.0, 0.0);
                }
            } else if (((Direction)blockState.m_61143_((Property)HORIZONTAL_FACING)).m_122434_() == Direction.Axis.Z) {
                if (centerPos.m_7094_() > beeCenter.m_7094_()) {
                    if (entity.m_20184_().m_7094_() > 0.0) {
                        entity.m_20334_(entity.m_20184_().m_7096_(), entity.m_20184_().m_7098_(), entity.m_20184_().m_7094_() / speedSlowdown);
                    }
                    entity.m_5997_(0.0, 0.0, -forcePushSpeed);
                } else {
                    if (entity.m_20184_().m_7094_() < 0.0) {
                        entity.m_20334_(entity.m_20184_().m_7096_(), entity.m_20184_().m_7098_(), entity.m_20184_().m_7094_() / speedSlowdown);
                    }
                    entity.m_5997_(0.0, 0.0, forcePushSpeed);
                }
            }
        }
        super.m_7892_(blockState, level, blockPos, entity);
    }

    public BlockState m_5573_(BlockPlaceContext placeContext) {
        BlockPos blockpos;
        Level level = placeContext.m_43725_();
        BlockState clickedBlock = level.m_8055_(blockpos = placeContext.m_8083_().m_121945_(placeContext.m_43719_().m_122424_()));
        if (!clickedBlock.m_60783_((BlockGetter)level, blockpos, placeContext.m_43719_())) {
            return null;
        }
        BlockState belowState = level.m_8055_(placeContext.m_8083_().m_7495_());
        if (placeContext.m_43719_().m_122434_() != Direction.Axis.Y) {
            return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)CENTER, (Comparable)Boolean.valueOf(false))).m_61124_((Property)IS_END, (Comparable)Boolean.valueOf(!belowState.m_204336_(BzTags.STRING_CURTAINS)))).m_61124_((Property)HORIZONTAL_FACING, (Comparable)placeContext.m_43719_());
        }
        if (placeContext.m_43719_() == Direction.DOWN) {
            return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)CENTER, (Comparable)Boolean.valueOf(true))).m_61124_((Property)IS_END, (Comparable)Boolean.valueOf(!belowState.m_204336_(BzTags.STRING_CURTAINS)))).m_61124_((Property)HORIZONTAL_FACING, (Comparable)placeContext.m_8125_());
        }
        return null;
    }

    public boolean m_7898_(BlockState blockstate, LevelReader world, BlockPos pos) {
        if (!blockstate.m_204336_(BzTags.STRING_CURTAINS)) {
            return false;
        }
        if (((Boolean)blockstate.m_61143_((Property)CENTER)).booleanValue() || !((Boolean)blockstate.m_61143_((Property)ATTACHED)).booleanValue()) {
            BlockState aboveState = world.m_8055_(pos.m_7494_());
            return aboveState.m_204336_(BzTags.STRING_CURTAINS) && (Boolean)blockstate.m_61143_((Property)ATTACHED) == false || aboveState.m_60783_((BlockGetter)world, pos.m_7494_(), Direction.DOWN) && (Boolean)blockstate.m_61143_((Property)ATTACHED) != false;
        }
        Direction facing = (Direction)blockstate.m_61143_((Property)HORIZONTAL_FACING);
        BlockState sideState = world.m_8055_(pos.m_121945_(facing.m_122424_()));
        BlockState aboveState = world.m_8055_(pos.m_7494_());
        return sideState.m_60783_((BlockGetter)world, pos.m_121945_(facing.m_122424_()), facing) || aboveState.m_60783_((BlockGetter)world, pos.m_7494_(), Direction.DOWN);
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        StringCurtain.blockUpdateCurtainChainUpward(level, blockPos);
        super.m_6810_(blockState, level, blockPos, blockState2, bl);
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos blockPos2, boolean bl) {
        if (!level.f_46443_) {
            BlockState belowState;
            boolean belowCurtain;
            if (!blockState.m_60710_((LevelReader)level, blockPos)) {
                level.m_46961_(blockPos, true);
            }
            if ((belowCurtain = (belowState = level.m_8055_(blockPos.m_7495_())).m_204336_(BzTags.STRING_CURTAINS)) == (Boolean)blockState.m_61143_((Property)IS_END)) {
                boolean showEnds = !belowCurtain || belowState.m_61143_((Property)CENTER) != blockState.m_61143_((Property)CENTER) || belowState.m_61143_((Property)HORIZONTAL_FACING) != blockState.m_61143_((Property)HORIZONTAL_FACING);
                level.m_7731_(blockPos, (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ATTACHED, (Comparable)((Boolean)blockState.m_61143_((Property)ATTACHED)))).m_61124_((Property)CENTER, (Comparable)((Boolean)blockState.m_61143_((Property)CENTER)))).m_61124_((Property)IS_END, (Comparable)Boolean.valueOf(showEnds))).m_61124_((Property)HORIZONTAL_FACING, (Comparable)((Direction)blockState.m_61143_((Property)HORIZONTAL_FACING))), 3);
            }
        }
    }

    public InteractionResult m_6227_(BlockState blockstate, Level world, BlockPos position, Player playerEntity, InteractionHand playerHand, BlockHitResult raytraceResult) {
        ItemStack itemstack = playerEntity.m_21120_(playerHand);
        if (blockstate.m_204336_(BzTags.STRING_CURTAINS)) {
            if (itemstack.m_204117_(BzTags.STRING_CURTAINS_CURTAIN_EXTENDING_ITEMS) && GeneralUtils.isPermissionAllowedAtSpot(world, (Entity)playerEntity, position, true)) {
                boolean success = StringCurtain.extendCurtainIfPossible(blockstate, world, position);
                if (success) {
                    if (!itemstack.m_41619_()) {
                        playerEntity.m_36246_(Stats.f_12982_.m_12902_((Object)itemstack.m_41720_()));
                    }
                    if (!playerEntity.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    if (playerEntity instanceof ServerPlayer) {
                        BzCriterias.EXTEND_STRING_CURTAIN_TRIGGER.trigger((ServerPlayer)playerEntity);
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (itemstack.m_204117_(BzTags.STRING_CURTAINS_ITEMS)) {
                playerEntity.m_5661_((Component)Component.m_237115_((String)"block.the_bumblezone.string_curtain.extending_clarification").m_130940_(ChatFormatting.WHITE), true);
                return InteractionResult.FAIL;
            }
        }
        return super.m_6227_(blockstate, world, position, playerEntity, playerHand, raytraceResult);
    }

    public static void onBlockInteractEvent(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        InteractionHand interactionHand = event.getHand();
        if (player != null && player.m_21120_(interactionHand).m_204117_(BzTags.STRING_CURTAINS_CURTAIN_EXTENDING_ITEMS)) {
            InteractionResult interactionResult;
            BlockHitResult hitResult = event.getHitVec();
            BlockState clickedState = event.getLevel().m_8055_(hitResult.m_82425_());
            if (clickedState.m_204336_(BzTags.STRING_CURTAINS)) {
                return;
            }
            BlockPos pos = hitResult.m_82425_().m_121945_(hitResult.m_82434_()).m_7494_();
            BlockState aboveState = event.getLevel().m_8055_(pos);
            if (aboveState.m_204336_(BzTags.STRING_CURTAINS) && (interactionResult = aboveState.m_60664_(event.getLevel(), player, interactionHand, new BlockHitResult(hitResult.m_82450_().m_82520_(0.0, 1.0, 0.0), hitResult.m_82434_(), pos, hitResult.m_82436_()))) != InteractionResult.PASS) {
                event.setCanceled(true);
                event.setCancellationResult(interactionResult);
            }
        }
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 20;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 60;
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return true;
    }

    public static boolean extendCurtainIfPossible(BlockState blockstate, Level world, BlockPos position) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)position);
        BlockState belowState = world.m_8055_((BlockPos)mutableBlockPos.m_122173_(Direction.DOWN));
        while (belowState.m_204336_(BzTags.STRING_CURTAINS) && world.m_46739_((BlockPos)mutableBlockPos)) {
            belowState = world.m_8055_((BlockPos)mutableBlockPos.m_122173_(Direction.DOWN));
        }
        if (world.m_46739_((BlockPos)mutableBlockPos) && belowState.m_60795_()) {
            world.m_7731_((BlockPos)mutableBlockPos, (BlockState)((BlockState)((BlockState)blockstate.m_60734_().m_49966_().m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CENTER, (Comparable)((Boolean)blockstate.m_61143_((Property)CENTER)))).m_61124_((Property)HORIZONTAL_FACING, (Comparable)((Direction)blockstate.m_61143_((Property)HORIZONTAL_FACING))), 3);
            StringCurtain.blockUpdateCurtainChainUpward(world, (BlockPos)mutableBlockPos);
            return true;
        }
        return false;
    }

    private static void blockUpdateCurtainChainUpward(Level world, BlockPos position) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)position);
        BlockState aboveState = world.m_8055_((BlockPos)mutableBlockPos.m_122173_(Direction.UP));
        while (aboveState.m_204336_(BzTags.STRING_CURTAINS) && world.m_46739_((BlockPos)mutableBlockPos)) {
            world.m_6289_((BlockPos)mutableBlockPos, aboveState.m_60734_());
            mutableBlockPos.m_122173_(Direction.UP);
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)HORIZONTAL_FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)HORIZONTAL_FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)HORIZONTAL_FACING)));
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        int comparatorPower;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        BlockState currentState = level.m_8055_((BlockPos)mutableBlockPos.m_122173_(Direction.DOWN));
        for (comparatorPower = 0; currentState.m_204336_(BzTags.STRING_CURTAINS) && comparatorPower < 15; ++comparatorPower) {
            currentState = level.m_8055_((BlockPos)mutableBlockPos.m_122173_(Direction.DOWN));
        }
        return comparatorPower;
    }

    public PushReaction m_5537_(BlockState pState) {
        return PushReaction.DESTROY;
    }
}

