/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.telepathicgrunt.the_bumblezone.blocks.SuperCandle;
import com.telepathicgrunt.the_bumblezone.blocks.SuperCandleWick;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.IncenseCandleBlockEntity;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlockEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class IncenseCandleBase
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
SuperCandle {
    public static final BooleanProperty LIT = AbstractCandleBlock.f_151895_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape AABB = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);

    public IncenseCandleBase() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76310_, (MaterialColor)MaterialColor.f_76400_).m_60955_().m_60978_(0.1f).m_60918_(SoundType.f_154653_).m_60953_(blockState -> (Boolean)blockState.m_61143_((Property)LIT) != false ? 15 : 0));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.FALSE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT, WATERLOGGED});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        SuperCandle.placeWickIfPossible((LevelAccessor)level, pos, false);
        super.m_6402_(level, pos, state, placer, stack);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean flag = fluidstate.m_205070_(FluidTags.f_13131_) && fluidstate.m_76170_();
        return (BlockState)super.m_5573_(context).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return Block.m_49863_((LevelReader)level, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
    }

    public void m_6861_(BlockState blockstate, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        SuperCandle.placeWickIfPossible((LevelAccessor)world, pos, false);
        super.m_6861_(blockstate, world, pos, block, fromPos, notify);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public boolean m_6044_(BlockGetter world, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) == false && fluid.m_205067_(FluidTags.f_13131_) && fluid.m_76145_().m_76170_();
    }

    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() && fluidState.m_205070_(FluidTags.f_13131_) && fluidState.m_76170_()) {
            BlockState blockstate = (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.TRUE);
            if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                SuperCandleWick.extinguish(null, level.m_8055_(pos.m_7494_()), level, pos.m_7494_());
                level.m_7731_(pos, (BlockState)blockstate.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
            } else {
                level.m_7731_(pos, blockstate, 3);
            }
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
            return true;
        }
        return false;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        if (!level.m_5776_() && oldState.m_60713_((Block)BzBlocks.INCENSE_BASE_CANDLE.get()) && state.m_60713_((Block)BzBlocks.INCENSE_BASE_CANDLE.get())) {
            if (((Boolean)oldState.m_61143_((Property)LIT)).booleanValue() && !((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof IncenseCandleBlockEntity) {
                    IncenseCandleBlockEntity incenseCandleBlockEntity = (IncenseCandleBlockEntity)blockEntity;
                    incenseCandleBlockEntity.resetCurrentDuration();
                    incenseCandleBlockEntity.resetInstantStartTime();
                }
            } else if (!((Boolean)oldState.m_61143_((Property)LIT)).booleanValue() && ((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                this.resetTimingFields(level, pos);
            }
        }
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (player.m_150110_().f_35938_) {
            ItemStack handItem = player.m_21120_(interactionHand);
            if (handItem.m_41619_() && ((Boolean)blockState.m_61143_((Property)LIT)).booleanValue()) {
                SuperCandleWick.extinguish(player, level.m_8055_(blockPos.m_7494_()), (LevelAccessor)level, blockPos.m_7494_());
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (!((Boolean)blockState.m_61143_((Property)LIT)).booleanValue()) {
                if (handItem.m_204117_(BzTags.INFINITE_CANDLE_LIGHTING_ITEMS)) {
                    this.lightCandle(level, blockPos, player);
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                if (handItem.m_204117_(BzTags.DAMAGEABLE_CANDLE_LIGHTING_ITEMS)) {
                    boolean successfulLit = this.lightCandle(level, blockPos, player);
                    if (successfulLit && player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        if (!player.m_150110_().f_35937_) {
                            handItem.m_220157_(1, level.m_213780_(), serverPlayer);
                        }
                    }
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                if (handItem.m_204117_(BzTags.CONSUMABLE_CANDLE_LIGHTING_ITEMS)) {
                    boolean successfulLit = this.lightCandle(level, blockPos, player);
                    if (successfulLit && !player.m_150110_().f_35937_) {
                        handItem.m_41774_(1);
                    }
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
            }
        }
        return InteractionResult.PASS;
    }

    private boolean lightCandle(Level level, BlockPos blockPos, Player player) {
        boolean litWick = SuperCandleWick.setLit((LevelAccessor)level, level.m_8055_(blockPos.m_7494_()), blockPos.m_7494_(), true);
        if (litWick && player instanceof ServerPlayer) {
            SuperCandleWick candleWick;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Block block = level.m_8055_(blockPos.m_7494_()).m_60734_();
            if (block instanceof SuperCandleWick && (candleWick = (SuperCandleWick)block).isSoul()) {
                BzCriterias.LIGHT_SOUL_INCENSE_CANDLE_TRIGGER.trigger(serverPlayer);
            }
        }
        return litWick;
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        Entity entity;
        boolean litWick;
        if (projectile.m_6060_() && SuperCandle.canBeLit(level, state, hit.m_82425_()) && (litWick = SuperCandleWick.setLit((LevelAccessor)level, level.m_8055_(hit.m_82425_().m_7494_()), hit.m_82425_().m_7494_(), true)) && (entity = projectile.m_37282_()) instanceof ServerPlayer) {
            IncenseCandleBlockEntity incenseCandleBlockEntity;
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            BlockEntity blockEntity = level.m_7702_(hit.m_82425_());
            if (blockEntity instanceof IncenseCandleBlockEntity && (incenseCandleBlockEntity = (IncenseCandleBlockEntity)blockEntity).getMobEffect() != null && incenseCandleBlockEntity.getMobEffect().m_8093_() && !incenseCandleBlockEntity.getMobEffect().m_19486_()) {
                BzCriterias.PROJECTILE_LIGHT_INSTANT_INCENSE_CANDLE_TRIGGER.trigger(serverPlayer);
            }
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (player != null && player.m_150110_().f_35937_) {
            super.m_5707_(level, pos, state, player);
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IncenseCandleBlockEntity) {
            IncenseCandleBlockEntity incenseCandleBlockEntity = (IncenseCandleBlockEntity)blockEntity;
            ItemStack itemStack = ((Item)BzItems.INCENSE_CANDLE.get()).m_7968_();
            incenseCandleBlockEntity.m_187476_(itemStack);
            ItemEntity itementity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemStack);
            itementity.m_32060_();
            level.m_7967_((Entity)itementity);
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BzBlockEntities.INCENSE_CANDLE.get()).m_155264_(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return IncenseCandleBase.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)BzBlockEntities.INCENSE_CANDLE.get()), (BlockEntityTicker)(level.f_46443_ ? (a, b, c, d) -> {} : IncenseCandleBlockEntity::serverTick));
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        return blockState.m_204336_(BzTags.CANDLES) && (Boolean)blockState.m_61143_((Property)LIT) != false ? 5 : 0;
    }

    private void resetTimingFields(Level level, BlockPos blockPos) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof IncenseCandleBlockEntity) {
            IncenseCandleBlockEntity incenseCandleBlockEntity = (IncenseCandleBlockEntity)blockEntity;
            incenseCandleBlockEntity.resetCurrentDuration();
            incenseCandleBlockEntity.setInstantStartTime(Math.max(level.m_46467_() - 1L, 0L));
        }
    }

    public static int getItemColor(ItemStack itemStack) {
        CompoundTag blockEntityTag;
        CompoundTag tag;
        if (itemStack.m_41782_() && (tag = itemStack.m_41783_()) != null && tag.m_128441_("BlockEntityTag") && (blockEntityTag = tag.m_128469_("BlockEntityTag")).m_128441_(IncenseCandleBlockEntity.COLOR_TAG)) {
            return blockEntityTag.m_128451_(IncenseCandleBlockEntity.COLOR_TAG);
        }
        return 0xFFFFFF;
    }

    public static int getBlockColor(BlockAndTintGetter world, BlockPos pos, int tintIndex) {
        BlockEntity blockEntity;
        if (world != null && (blockEntity = world.m_7702_(pos)) instanceof IncenseCandleBlockEntity) {
            IncenseCandleBlockEntity incenseCandleBlockEntity = (IncenseCandleBlockEntity)blockEntity;
            int currentColor = incenseCandleBlockEntity.getColor();
            if (tintIndex == 1) {
                int red = Math.max(currentColor >> 16 & 0xFF, 40);
                int green = Math.max(currentColor >> 8 & 0xFF, 10);
                int blue = Math.max(currentColor & 0xFF, 5);
                currentColor = (Math.min(red + 60, 255) << 16) + (Math.min(green + 30, 255) << 8) + Math.min(blue + 25, 255);
            }
            return currentColor;
        }
        return tintIndex;
    }

    public void m_214162_(BlockState blockState, Level world, BlockPos position, RandomSource random) {
        IncenseCandleBlockEntity incenseCandleBlockEntity;
        BlockEntity blockEntity;
        if (blockState.m_61138_((Property)LIT) && ((Boolean)blockState.m_61143_((Property)LIT)).booleanValue() && (blockEntity = world.m_7702_(position)) instanceof IncenseCandleBlockEntity && (incenseCandleBlockEntity = (IncenseCandleBlockEntity)blockEntity).getMobEffect() != null) {
            int color = incenseCandleBlockEntity.getColor();
            Vec3 colorRGB = IncenseCandleBlockEntity.convertIntegerColorToRGB(color);
            for (int i = 0; i < random.m_188503_(3); ++i) {
                this.spawnAmbientEffectParticles(world, random, position, colorRGB.m_7096_(), colorRGB.m_7098_(), colorRGB.m_7094_());
            }
        }
        super.m_214162_(blockState, world, position, random);
    }

    private void spawnAmbientEffectParticles(Level world, RandomSource random, BlockPos position, double red, double green, double blue) {
        world.m_7106_((ParticleOptions)ParticleTypes.f_123770_, (double)position.m_123341_() + 0.4 + random.m_188500_() * 0.2, (double)position.m_123342_() + 0.7 + random.m_188500_() * 0.2, (double)position.m_123343_() + 0.4 + random.m_188500_() * 0.2, red, green, blue);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return !state.m_61138_((Property)LIT) || (Boolean)state.m_61143_((Property)LIT) == false;
    }

    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, Mob mob) {
        if (state.m_61138_((Property)LIT) && ((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            return BlockPathTypes.DAMAGE_FIRE;
        }
        return null;
    }

    public static void multiPotionCandleCrafted(PlayerEvent.ItemCraftedEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (event.getCrafting().m_150930_((Item)BzItems.INCENSE_CANDLE.get())) {
                int containerSize = event.getInventory().m_6643_();
                int potionsUsed = 0;
                for (int i = 0; i < containerSize; ++i) {
                    if (!event.getInventory().m_8020_(i).m_150930_(Items.f_42589_)) continue;
                    ++potionsUsed;
                }
                if (potionsUsed >= 2) {
                    BzCriterias.CRAFT_MULTI_POTION_INCENSE_CANDLE_TRIGGER.trigger(serverPlayer);
                }
            }
        }
    }
}

