/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.blocks.ProperFacingBlock;
import com.telepathicgrunt.the_bumblezone.configs.BzBeeAggressionConfigs;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.effects.WrathOfTheHiveEffect;
import com.telepathicgrunt.the_bumblezone.items.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class HoneycombBrood
extends ProperFacingBlock {
    private static final ResourceLocation HONEY_TREAT = new ResourceLocation("productivebees:honey_treat");
    public static final IntegerProperty STAGE = BlockStateProperties.f_61407_;

    public HoneycombBrood() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76313_, (MaterialColor)MaterialColor.f_76413_).m_60977_().m_60913_(0.5f, 0.5f).m_60918_(SoundType.f_56753_).m_60956_(0.8f));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52588_, (Comparable)Direction.SOUTH)).m_61124_((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52588_, STAGE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)context.m_43719_().m_122424_());
    }

    public InteractionResult m_6227_(BlockState thisBlockState, Level world, BlockPos position, Player playerEntity, InteractionHand playerHand, BlockHitResult raytraceResult) {
        ItemStack itemstack = playerEntity.m_21120_(playerHand);
        RandomSource random = playerEntity.m_217043_();
        if (itemstack.m_41720_() == Items.f_42590_) {
            ServerPlayer serverPlayer;
            GeneralUtils.givePlayerItem(playerEntity, playerHand, new ItemStack((ItemLike)Items.f_42787_), false, true);
            int stage = (Integer)thisBlockState.m_61143_((Property)STAGE);
            HoneycombBrood.spawnBroodMob(world, random, thisBlockState, position, stage);
            world.m_7731_(position, (BlockState)((Block)BzBlocks.EMPTY_HONEYCOMB_BROOD.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)((Direction)thisBlockState.m_61143_((Property)BlockStateProperties.f_61372_))), 3);
            if ((playerEntity.f_19853_.m_46472_().m_135782_().equals((Object)Bumblezone.MOD_DIMENSION_ID) || ((Boolean)BzBeeAggressionConfigs.allowWrathOfTheHiveOutsideBumblezone.get()).booleanValue()) && !playerEntity.m_7500_() && !playerEntity.m_5833_() && ((Boolean)BzBeeAggressionConfigs.aggressiveBees.get()).booleanValue() && world.m_46791_() != Difficulty.PEACEFUL && playerEntity instanceof ServerPlayer && !EssenceOfTheBees.hasEssence(serverPlayer = (ServerPlayer)playerEntity)) {
                if (playerEntity.m_21023_((MobEffect)BzEffects.PROTECTION_OF_THE_HIVE.get())) {
                    playerEntity.m_21195_((MobEffect)BzEffects.PROTECTION_OF_THE_HIVE.get());
                } else {
                    playerEntity.m_7292_(new MobEffectInstance((MobEffect)BzEffects.WRATH_OF_THE_HIVE.get(), ((Integer)BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts.get()).intValue(), 2, false, ((Boolean)BzBeeAggressionConfigs.showWrathOfTheHiveParticles.get()).booleanValue(), true));
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)BzModCompatibilityConfigs.allowHoneyTreatCompat.get()).booleanValue() && Registry.f_122827_.m_7981_((Object)itemstack.m_41720_()).equals((Object)HONEY_TREAT)) {
            if (!world.m_5776_()) {
                int stage = (Integer)thisBlockState.m_61143_((Property)STAGE);
                if (stage == 3) {
                    HoneycombBrood.spawnBroodMob(world, random, thisBlockState, position, stage);
                } else {
                    int stageIncrease = random.m_188501_() < 0.2f ? 2 : 1;
                    world.m_46597_(position, (BlockState)thisBlockState.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(Math.min(3, stage + stageIncrease))));
                }
                if (random.m_188501_() < 0.3f) {
                    HoneycombBrood.applyProtection(playerEntity, itemstack);
                }
            }
            world.m_6263_(playerEntity, playerEntity.m_20185_(), playerEntity.m_20186_(), playerEntity.m_20189_(), SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
            GeneralUtils.givePlayerItem(playerEntity, playerHand, ItemStack.f_41583_, true, true);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_204117_(BzTags.BEE_FEEDING_ITEMS)) {
            if (!world.m_5776_()) {
                boolean successfulGrowth = false;
                if (itemstack.m_41720_() == BzItems.SUGAR_WATER_BOTTLE.get()) {
                    if (random.m_188501_() < 0.3f) {
                        successfulGrowth = true;
                    }
                } else {
                    successfulGrowth = true;
                }
                if (successfulGrowth && random.m_188501_() < 0.3f) {
                    HoneycombBrood.applyProtection(playerEntity, itemstack);
                }
                if (successfulGrowth) {
                    int stage = (Integer)thisBlockState.m_61143_((Property)STAGE);
                    if (stage == 3) {
                        HoneycombBrood.spawnBroodMob(world, random, thisBlockState, position, stage);
                    } else {
                        int newStage = stage + 1;
                        if (itemstack.m_204117_(BzTags.HONEY_BUCKETS) || itemstack.m_204117_(BzTags.ROYAL_JELLY_BUCKETS)) {
                            newStage = 3;
                            if (!world.m_5776_()) {
                                Direction facing = ((Direction)thisBlockState.m_61143_((Property)f_52588_)).m_122424_();
                                Vec3 centerFacePos = new Vec3((double)position.m_123341_() + Math.max(-0.2, facing.m_122429_() == 0 ? 0.5 : (double)facing.m_122429_() * 1.2), (double)position.m_123342_() + Math.max(-0.2, facing.m_122430_() == 0 ? 0.5 : (double)facing.m_122430_() * 1.2), (double)position.m_123343_() + Math.max(-0.2, facing.m_122431_() == 0 ? 0.5 : (double)facing.m_122431_() * 1.2));
                                ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123750_, centerFacePos.m_7096_(), centerFacePos.m_7098_(), centerFacePos.m_7094_(), 3, (double)random.m_188501_() * 0.5 - 0.25, (double)(random.m_188501_() * 0.2f + 0.2f), (double)random.m_188501_() * 0.5 - 0.25, (double)random.m_188501_() * 0.4 + (double)0.2f);
                            }
                            if (playerEntity instanceof ServerPlayer) {
                                BzCriterias.HONEY_BUCKET_BROOD_TRIGGER.trigger((ServerPlayer)playerEntity);
                            }
                        }
                        world.m_46597_(position, (BlockState)thisBlockState.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(newStage)));
                    }
                }
            }
            world.m_6263_(playerEntity, playerEntity.m_20185_(), playerEntity.m_20186_(), playerEntity.m_20189_(), SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
            GeneralUtils.givePlayerItem(playerEntity, playerHand, ItemStack.f_41583_, true, true);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(thisBlockState, world, position, playerEntity, playerHand, raytraceResult);
    }

    private static void applyProtection(Player playerEntity, ItemStack itemstack) {
        playerEntity.m_7292_(new MobEffectInstance((MobEffect)BzEffects.PROTECTION_OF_THE_HIVE.get(), ((Integer)BzBeeAggressionConfigs.howLongProtectionOfTheHiveLasts.get()).intValue(), 1, false, false, true));
        if (playerEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerEntity;
            BzCriterias.GETTING_PROTECTION_TRIGGER.trigger(serverPlayer);
        }
        if (playerEntity.m_21023_((MobEffect)BzEffects.WRATH_OF_THE_HIVE.get())) {
            playerEntity.m_21195_((MobEffect)BzEffects.WRATH_OF_THE_HIVE.get());
            WrathOfTheHiveEffect.calmTheBees(playerEntity.f_19853_, (LivingEntity)playerEntity);
        }
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos position, RandomSource random) {
        int stage;
        super.m_213897_(state, world, position, random);
        if (!world.m_46832_(position, position)) {
            return;
        }
        List nearbyEntities = null;
        if (world.m_46791_() == Difficulty.PEACEFUL) {
            nearbyEntities = world.m_6443_(LivingEntity.class, new AABB(position).m_82400_((double)WrathOfTheHiveEffect.NEARBY_WRATH_EFFECT_RADIUS), entity -> entity.m_21023_((MobEffect)BzEffects.WRATH_OF_THE_HIVE.get()));
        }
        if ((stage = ((Integer)state.m_61143_((Property)STAGE)).intValue()) < 3) {
            if (nearbyEntities != null && !nearbyEntities.isEmpty() || (world.m_46472_().m_135782_().equals((Object)Bumblezone.MOD_DIMENSION_ID) ? random.m_188503_(10) == 0 : random.m_188503_(22) == 0)) {
                world.m_7731_(position, (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(stage + 1)), 2);
            }
        } else if ((Integer)BzGeneralConfigs.broodBlocksBeeSpawnCapacity.get() != 0) {
            int livingEntitiesNearby;
            boolean playerCloseEnough = false;
            for (Player player : world.m_6907_()) {
                if (position.m_123333_((Vec3i)player.m_20183_()) >= 40) continue;
                playerCloseEnough = true;
            }
            if (playerCloseEnough && (livingEntitiesNearby = world.m_45976_(LivingEntity.class, new AABB(position.m_7918_(-48, -48, -48), position.m_7918_(48, 48, 48))).size()) < (Integer)BzGeneralConfigs.broodBlocksBeeSpawnCapacity.get()) {
                HoneycombBrood.spawnBroodMob((Level)world, random, state, position, stage);
            }
        }
    }

    public void m_5707_(Level world, BlockPos position, BlockState state, Player playerEntity) {
        BlockState blockState;
        int stage;
        ListTag listOfEnchants = playerEntity.m_21205_().m_41785_();
        if (listOfEnchants.stream().noneMatch(enchant -> enchant.m_7916_().contains("minecraft:silk_touch")) && (stage = ((Integer)(blockState = world.m_8055_(position)).m_61143_((Property)STAGE)).intValue()) == 3) {
            HoneycombBrood.spawnBroodMob(world, playerEntity.m_217043_(), blockState, position, stage);
        }
        super.m_5707_(world, position, state, playerEntity);
    }

    private static void spawnBroodMob(Level world, RandomSource random, BlockState state, BlockPos position, int stage) {
        BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)position);
        blockpos.m_122173_(((Direction)state.m_61143_((Property)f_52588_)).m_122424_());
        BlockState frontState = world.m_8055_((BlockPos)blockpos);
        if (stage == 3 && frontState.m_60819_().m_76178_() && !frontState.m_60838_((BlockGetter)world, position)) {
            Mob beeMob = (Mob)EntityType.f_20550_.m_20615_(world);
            beeMob.m_6863_(true);
            HoneycombBrood.spawnMob(world, blockpos, beeMob, beeMob);
            if (random.m_188501_() < 0.1f) {
                Mob honeySlimeMob = (Mob)((EntityType)BzEntities.HONEY_SLIME.get()).m_20615_(world);
                honeySlimeMob.m_6863_(true);
                HoneycombBrood.spawnMob(world, blockpos, beeMob, honeySlimeMob);
            }
            world.m_46597_(position, (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(0)));
        }
    }

    private static void spawnMob(Level world, BlockPos.MutableBlockPos blockpos, Mob beeMob, Mob entity) {
        if (entity == null || world.m_5776_()) {
            return;
        }
        entity.m_7678_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.5, (double)blockpos.m_123343_() + 0.5, beeMob.m_217043_().m_188501_() * 360.0f, 0.0f);
        entity.m_6518_((ServerLevelAccessor)world, world.m_6436_(new BlockPos(beeMob.m_20182_())), MobSpawnType.TRIGGERED, null, null);
        if (ForgeHooks.canEntitySpawn((Mob)entity, (LevelAccessor)world, (double)entity.m_20182_().m_7096_(), (double)entity.m_20182_().m_7098_(), (double)entity.m_20182_().m_7094_(), null, (MobSpawnType)MobSpawnType.SPAWNER) != -1) {
            world.m_7967_((Entity)entity);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return (Integer)blockState.m_61143_((Property)STAGE) + 1;
    }

    public void m_214162_(BlockState blockState, Level world, BlockPos position, RandomSource random) {
        for (int i = 0; i < random.m_188503_(2); ++i) {
            this.spawnHoneyParticles(world, random, position, blockState);
        }
        int stage = (Integer)blockState.m_61143_((Property)STAGE);
        float soundVolume = 0.05f + (float)stage * 0.1f;
        if (random.m_188503_(20) == 0) {
            world.m_7785_((double)position.m_123341_() + 0.5, (double)position.m_123342_() + 0.5, (double)position.m_123343_() + 0.5, SoundEvents.f_11691_, SoundSource.BLOCKS, soundVolume, 1.0f, true);
        }
    }

    private void spawnHoneyParticles(Level world, RandomSource random, BlockPos position, BlockState blockState) {
        VoxelShape currentBlockShape;
        double yEndHeight;
        if (blockState.m_60819_().m_76178_() && random.m_188501_() < 0.08f && (yEndHeight = (currentBlockShape = blockState.m_60812_((BlockGetter)world, position)).m_83297_(Direction.Axis.Y)) >= 1.0 && !blockState.m_204336_(BlockTags.f_13049_)) {
            double yStartHeight = currentBlockShape.m_83288_(Direction.Axis.Y);
            if (yStartHeight > 0.0) {
                this.addHoneyParticle(world, random, position, currentBlockShape, (double)position.m_123342_() + yStartHeight - 0.05);
            } else {
                BlockPos belowBlockpos = position.m_7495_();
                BlockState belowBlockstate = world.m_8055_(belowBlockpos);
                VoxelShape belowBlockShape = belowBlockstate.m_60812_((BlockGetter)world, belowBlockpos);
                double yEndHeight2 = belowBlockShape.m_83297_(Direction.Axis.Y);
                if ((yEndHeight2 < 1.0 || !belowBlockstate.m_60804_((BlockGetter)world, belowBlockpos)) && belowBlockstate.m_60819_().m_76178_()) {
                    this.addHoneyParticle(world, random, position, currentBlockShape, (double)position.m_123342_() - 0.05);
                }
            }
        }
    }

    private void addHoneyParticle(Level world, RandomSource random, BlockPos blockPos, VoxelShape blockShape, double height) {
        this.addHoneyParticle(world, random, (double)blockPos.m_123341_() + blockShape.m_83288_(Direction.Axis.X), (double)blockPos.m_123341_() + blockShape.m_83297_(Direction.Axis.X), (double)blockPos.m_123343_() + blockShape.m_83288_(Direction.Axis.Z), (double)blockPos.m_123343_() + blockShape.m_83297_(Direction.Axis.Z), height);
    }

    private void addHoneyParticle(Level world, RandomSource random, double xMin, double xMax, double zMax, double zMin, double yHeight) {
        world.m_7106_((ParticleOptions)ParticleTypes.f_123779_, Mth.m_14139_((double)random.m_188500_(), (double)xMin, (double)xMax), yHeight, Mth.m_14139_((double)random.m_188500_(), (double)zMax, (double)zMin), 0.0, 0.0, 0.0);
    }
}

