/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.telepathicgrunt.the_bumblezone.entities.mobs.BeehemothEntity;
import com.telepathicgrunt.the_bumblezone.entities.mobs.HoneySlimeEntity;
import com.telepathicgrunt.the_bumblezone.items.HoneyBeeLeggings;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class HoneyWeb
extends Block {
    public static final BooleanProperty NORTHSOUTH = BooleanProperty.m_61465_((String)"northsouth");
    public static final BooleanProperty EASTWEST = BooleanProperty.m_61465_((String)"eastwest");
    public static final BooleanProperty UPDOWN = BooleanProperty.m_61465_((String)"updown");
    protected final VoxelShape[] collisionShapeByIndex;
    protected final VoxelShape[] shapeByIndex;
    private final Object2IntMap<BlockState> stateToIndex = new Object2IntOpenHashMap();
    public static final Map<Direction.Axis, BooleanProperty> AXIS_TO_PROP = ImmutableMap.copyOf((Map)((Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.Axis.class), map -> {
        map.put(Direction.Axis.X, NORTHSOUTH);
        map.put(Direction.Axis.Z, EASTWEST);
        map.put(Direction.Axis.Y, UPDOWN);
    })));

    public HoneyWeb() {
        this(BlockBehaviour.Properties.m_60944_((Material)Material.f_76311_, (MaterialColor)MaterialColor.f_76413_).m_60955_().m_60910_().m_60999_().m_60978_(4.0f));
    }

    public HoneyWeb(BlockBehaviour.Properties properties) {
        super(properties);
        this.collisionShapeByIndex = this.makeShapes();
        this.shapeByIndex = this.makeShapes();
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTHSOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EASTWEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UPDOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{NORTHSOUTH, EASTWEST, UPDOWN});
    }

    protected VoxelShape[] makeShapes() {
        VoxelShape voxelshape1 = Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);
        VoxelShape voxelshape2 = Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
        VoxelShape voxelshape3 = Block.m_49796_((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
        return new VoxelShape[]{Shapes.m_83040_(), voxelshape1, voxelshape2, Shapes.m_83110_((VoxelShape)voxelshape1, (VoxelShape)voxelshape2), voxelshape3, Shapes.m_83110_((VoxelShape)voxelshape1, (VoxelShape)voxelshape3), Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape3), Shapes.m_83110_((VoxelShape)Shapes.m_83110_((VoxelShape)voxelshape1, (VoxelShape)voxelshape2), (VoxelShape)voxelshape3)};
    }

    protected int getAABBIndex(BlockState blockState) {
        return this.stateToIndex.computeIfAbsent((Object)blockState, a -> {
            int bitFlag = 0;
            if (((Boolean)blockState.m_61143_((Property)NORTHSOUTH)).booleanValue()) {
                bitFlag |= 1;
            }
            if (((Boolean)blockState.m_61143_((Property)EASTWEST)).booleanValue()) {
                bitFlag |= 2;
            }
            if (((Boolean)blockState.m_61143_((Property)UPDOWN)).booleanValue()) {
                bitFlag |= 4;
            }
            return bitFlag;
        });
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return this.shapeByIndex[this.getAABBIndex(blockState)];
    }

    public void m_7892_(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        Player player;
        if (entity instanceof Bee || entity instanceof BeehemothEntity || entity instanceof HoneySlimeEntity) {
            return;
        }
        if (!(entity instanceof Player) || !(player = (Player)entity).m_7500_()) {
            ItemStack beeLeggings = HoneyBeeLeggings.getEntityBeeLegging(entity);
            VoxelShape shape = this.shapeByIndex[this.getAABBIndex(blockState)];
            if (Shapes.m_83157_((VoxelShape)(shape = shape.m_83216_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_())), (VoxelShape)Shapes.m_83064_((AABB)entity.m_20191_()), (BooleanOp)BooleanOp.f_82689_)) {
                if (entity instanceof Projectile) {
                    speedReduction = 0.015f;
                    Vec3 deltaMovement = entity.m_20184_();
                    double magnitude = deltaMovement.m_82553_();
                    if (magnitude != 0.0) {
                        entity.m_7601_(blockState, new Vec3(speedReduction /= magnitude, speedReduction, speedReduction));
                    }
                } else {
                    speedReduction = 0.1f;
                    if (!beeLeggings.m_41619_()) {
                        speedReduction = 0.9f;
                    } else {
                        Vec3 deltaMovement = entity.m_20184_();
                        double magnitude = deltaMovement.m_82553_();
                        if (magnitude != 0.0) {
                            speedReduction /= magnitude;
                        }
                    }
                    entity.m_7601_(blockState, new Vec3(speedReduction, speedReduction, speedReduction));
                }
                if (beeLeggings.m_41619_() && entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 1, false, false, true));
                }
            }
        }
        super.m_7892_(blockState, level, blockPos, entity);
    }

    public BlockState m_5573_(BlockPlaceContext placeContext) {
        BlockPos blockpos;
        Level level = placeContext.m_43725_();
        BlockState state = this.getStateForSpot((BlockGetter)level, blockpos = placeContext.m_8083_());
        if (!(((Boolean)state.m_61143_((Property)NORTHSOUTH)).booleanValue() || ((Boolean)state.m_61143_((Property)EASTWEST)).booleanValue() || ((Boolean)state.m_61143_((Property)UPDOWN)).booleanValue())) {
            if (placeContext.m_43719_().m_122434_() != Direction.Axis.Y) {
                state = (BlockState)this.m_49966_().m_61124_((Property)UPDOWN, (Comparable)Boolean.valueOf(true));
            } else {
                Direction.Axis horizontalFacing = Direction.Axis.Z;
                for (Direction direction : placeContext.m_6232_()) {
                    if (direction.m_122434_() == Direction.Axis.Y) continue;
                    horizontalFacing = direction.m_122434_();
                    break;
                }
                state = horizontalFacing == Direction.Axis.X ? (BlockState)((BlockState)this.m_49966_().m_61124_((Property)NORTHSOUTH, (Comparable)Boolean.valueOf(true))).m_61124_((Property)EASTWEST, (Comparable)Boolean.valueOf(false)) : (BlockState)((BlockState)this.m_49966_().m_61124_((Property)NORTHSOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EASTWEST, (Comparable)Boolean.valueOf(true));
            }
        }
        this.updateNeighboringStates(level, state, blockpos);
        return state;
    }

    public InteractionResult m_6227_(BlockState blockstate, Level world, BlockPos position, Player playerEntity, InteractionHand playerHand, BlockHitResult raytraceResult) {
        BucketItem bucketItem;
        ItemStack itemstack = playerEntity.m_21120_(playerHand);
        Item item = itemstack.m_41720_();
        if (item instanceof BucketItem && (bucketItem = (BucketItem)item).getFluid().m_205067_(FluidTags.f_13131_) || itemstack.m_41782_() && itemstack.m_41784_().m_128461_("Potion").contains("water") || itemstack.m_41720_() == Items.f_41903_ || itemstack.m_41720_() == BzItems.SUGAR_WATER_BOTTLE.get()) {
            if (!itemstack.m_41619_()) {
                playerEntity.m_36246_(Stats.f_12982_.m_12902_((Object)itemstack.m_41720_()));
            }
            if (itemstack.m_41720_() == Items.f_41903_ && playerEntity instanceof ServerPlayer) {
                BzCriterias.CLEANUP_HONEY_WEB_TRIGGER.trigger((ServerPlayer)playerEntity);
            }
            world.m_46961_(position, false);
            world.m_6263_(playerEntity, playerEntity.m_20185_(), playerEntity.m_20186_(), playerEntity.m_20189_(), (SoundEvent)BzSounds.WASHING_RESIDUES.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            if (world.m_5776_()) {
                for (int i = 0; i < 25; ++i) {
                    this.addParticle((ParticleOptions)ParticleTypes.f_123804_, world, playerEntity.m_217043_(), position, blockstate.m_60808_((BlockGetter)world, position));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(blockstate, world, position, playerEntity, playerHand, raytraceResult);
    }

    private void updateNeighboringStates(Level level, BlockState centerState, BlockPos blockpos) {
        for (Direction direction : Direction.values()) {
            BlockPos sidePos = blockpos.m_121945_(direction);
            BlockState neighboringBlockstate = level.m_8055_(sidePos);
            if (!(neighboringBlockstate.m_60734_() instanceof HoneyWeb)) continue;
            boolean changedState = false;
            if (direction.m_122434_() != Direction.Axis.X && ((Boolean)centerState.m_61143_((Property)NORTHSOUTH)).booleanValue() && !((Boolean)neighboringBlockstate.m_61143_((Property)NORTHSOUTH)).booleanValue()) {
                neighboringBlockstate = (BlockState)neighboringBlockstate.m_61124_((Property)NORTHSOUTH, (Comparable)Boolean.valueOf(true));
                changedState = true;
            }
            if (direction.m_122434_() != Direction.Axis.Z && ((Boolean)centerState.m_61143_((Property)EASTWEST)).booleanValue() && !((Boolean)neighboringBlockstate.m_61143_((Property)EASTWEST)).booleanValue()) {
                neighboringBlockstate = (BlockState)neighboringBlockstate.m_61124_((Property)EASTWEST, (Comparable)Boolean.valueOf(true));
                changedState = true;
            }
            if (direction.m_122434_() != Direction.Axis.Y && ((Boolean)centerState.m_61143_((Property)UPDOWN)).booleanValue() && !((Boolean)neighboringBlockstate.m_61143_((Property)UPDOWN)).booleanValue()) {
                neighboringBlockstate = (BlockState)neighboringBlockstate.m_61124_((Property)UPDOWN, (Comparable)Boolean.valueOf(true));
                changedState = true;
            }
            if (!changedState) continue;
            level.m_7731_(sidePos, neighboringBlockstate, 3);
        }
    }

    @NotNull
    private BlockState getStateForSpot(BlockGetter blockgetter, BlockPos blockpos) {
        BlockState currentBlockstate = this.m_49966_();
        for (Direction direction : Direction.values()) {
            BlockState neighboringBlockstate = blockgetter.m_8055_(blockpos.m_121945_(direction));
            if (!(neighboringBlockstate.m_60734_() instanceof HoneyWeb)) continue;
            if (direction.m_122434_() == Direction.Axis.Y) {
                if (((Boolean)neighboringBlockstate.m_61143_((Property)NORTHSOUTH)).booleanValue()) {
                    currentBlockstate = (BlockState)currentBlockstate.m_61124_((Property)NORTHSOUTH, (Comparable)Boolean.valueOf(true));
                }
                if (!((Boolean)neighboringBlockstate.m_61143_((Property)EASTWEST)).booleanValue()) continue;
                currentBlockstate = (BlockState)currentBlockstate.m_61124_((Property)EASTWEST, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if (direction.m_122434_() == Direction.Axis.X) {
                if (((Boolean)neighboringBlockstate.m_61143_((Property)UPDOWN)).booleanValue()) {
                    currentBlockstate = (BlockState)currentBlockstate.m_61124_((Property)UPDOWN, (Comparable)Boolean.valueOf(true));
                }
                if (!((Boolean)neighboringBlockstate.m_61143_((Property)EASTWEST)).booleanValue()) continue;
                currentBlockstate = (BlockState)currentBlockstate.m_61124_((Property)EASTWEST, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if (direction.m_122434_() != Direction.Axis.Z) continue;
            if (((Boolean)neighboringBlockstate.m_61143_((Property)UPDOWN)).booleanValue()) {
                currentBlockstate = (BlockState)currentBlockstate.m_61124_((Property)UPDOWN, (Comparable)Boolean.valueOf(true));
            }
            if (!((Boolean)neighboringBlockstate.m_61143_((Property)NORTHSOUTH)).booleanValue()) continue;
            currentBlockstate = (BlockState)currentBlockstate.m_61124_((Property)NORTHSOUTH, (Comparable)Boolean.valueOf(true));
        }
        return currentBlockstate;
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return switch (rotation) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)blockState.m_61124_((Property)NORTHSOUTH, (Comparable)((Boolean)blockState.m_61143_((Property)EASTWEST)))).m_61124_((Property)EASTWEST, (Comparable)((Boolean)blockState.m_61143_((Property)NORTHSOUTH)));
            default -> blockState;
        };
    }

    public void m_214162_(BlockState blockState, Level world, BlockPos position, RandomSource random) {
        for (int i = 0; i == random.m_188503_(50); ++i) {
            this.addParticle((ParticleOptions)ParticleTypes.f_123779_, world, random, position, blockState.m_60808_((BlockGetter)world, position));
        }
    }

    protected void addParticle(ParticleOptions particleType, Level world, RandomSource random, BlockPos blockPos, VoxelShape blockShape) {
        this.addParticle(particleType, world, random, (double)blockPos.m_123341_() + blockShape.m_83288_(Direction.Axis.X), (double)blockPos.m_123341_() + blockShape.m_83297_(Direction.Axis.X), (double)blockPos.m_123342_() + blockShape.m_83288_(Direction.Axis.Y), (double)blockPos.m_123342_() + blockShape.m_83297_(Direction.Axis.Y), (double)blockPos.m_123343_() + blockShape.m_83288_(Direction.Axis.Z), (double)blockPos.m_123343_() + blockShape.m_83297_(Direction.Axis.Z));
    }

    private void addParticle(ParticleOptions particleType, Level world, RandomSource random, double xMin, double xMax, double yMin, double yMax, double zMax, double zMin) {
        world.m_7106_(particleType, Mth.m_14139_((double)random.m_188500_(), (double)xMin, (double)xMax), Mth.m_14139_((double)random.m_188500_(), (double)yMin, (double)yMax), Mth.m_14139_((double)random.m_188500_(), (double)zMin, (double)zMax), 0.0, 0.0, 0.0);
    }
}

