/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.telepathicgrunt.the_bumblezone.blocks.blockentities.CrystallineFlowerBlockEntity;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.entities.BeeAggression;
import com.telepathicgrunt.the_bumblezone.mixin.entities.LivingEntityAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlockEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzDamageSources;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzStats;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.screens.CrystallineFlowerMenu;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;

public class CrystallineFlower
extends BaseEntityBlock {
    public static final BooleanProperty FLOWER = BooleanProperty.m_61465_((String)"flower");
    protected final VoxelShape shapeFlower = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    protected final VoxelShape shapeBody = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final Component CONTAINER_TITLE = Component.m_237115_((String)"the_bumblezone.container.crystalline_flower");
    private static final Component OCCUPIED_CRYSTALLINE_FLOWER_TEXT = Component.m_237115_((String)"system.the_bumblezone.occupied_crystalline_flower");

    public CrystallineFlower() {
        super(BlockBehaviour.Properties.m_60944_((Material)BzBlocks.YELLOW_CRYSTAL_PLANT, (MaterialColor)MaterialColor.f_76376_).m_60910_().m_60955_().m_60913_(0.4f, 0.01f).m_60953_(blockState -> (Boolean)blockState.m_61143_((Property)FLOWER) != false ? 7 : 0).m_60918_((SoundType)BzSounds.HONEY_CRYSTALS_TYPE));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FLOWER, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState blockstate, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return blockstate.m_61138_((Property)FLOWER) && (Boolean)blockstate.m_61143_((Property)FLOWER) != false ? this.shapeFlower : this.shapeBody;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[0]).m_61104_(new Property[]{FLOWER});
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)BzBlockEntities.CRYSTALLINE_FLOWER.get()).m_155264_(blockPos, blockState);
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        LivingEntity livingEntity;
        VoxelShape voxelShape = this.m_5940_(state, (BlockGetter)level, pos, null).m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        if (!Shapes.m_83157_((VoxelShape)voxelShape, (VoxelShape)Shapes.m_83064_((AABB)entity.m_20191_()), (BooleanOp)BooleanOp.f_82689_)) return;
        if (level.m_5776_()) {
            return;
        }
        if (entity instanceof LivingEntity && !BeeAggression.isBeelikeEntity((Entity)(livingEntity = (LivingEntity)entity))) {
            float fallDistance = entity.f_19789_;
            livingEntity.m_7601_(state, new Vec3((double)0.95f, 2.0, (double)0.95f));
            entity.f_19789_ = fallDistance;
            if (level.f_46443_) return;
            if (livingEntity.f_19790_ == livingEntity.m_20185_()) {
                if (livingEntity.f_19792_ == livingEntity.m_20189_()) return;
            }
            double xDiff = Math.abs(livingEntity.m_20185_() - livingEntity.f_19790_);
            double zDiff = Math.abs(livingEntity.m_20189_() - livingEntity.f_19792_);
            if (!(xDiff >= (double)0.001f)) {
                if (!(zDiff >= (double)0.001f)) return;
            }
            livingEntity.m_6469_(BzDamageSources.CRYSTALLINE_FLOWER, 1.5f);
            if (!livingEntity.m_21224_()) return;
            if (livingEntity.m_217046_()) return;
            if (((LivingEntityAccessor)livingEntity).callIsAlwaysExperienceDropper()) return;
            if (!livingEntity.m_6149_()) return;
            if (!level.m_46469_().m_46207_(GameRules.f_46135_)) return;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (!(blockEntity instanceof CrystallineFlowerBlockEntity)) return;
            CrystallineFlowerBlockEntity crystallineFlowerBlockEntity = (CrystallineFlowerBlockEntity)blockEntity;
            if (crystallineFlowerBlockEntity.isMaxTier()) return;
            int reward = ForgeEventFactory.getExperienceDrop((LivingEntity)livingEntity, null, (int)livingEntity.m_213860_());
            ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)level), (Vec3)livingEntity.m_20182_(), (int)reward);
            return;
        }
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            if (((Boolean)BzGeneralConfigs.crystallineFlowerConsumeItemEntities.get()).booleanValue()) {
                ItemStack stack = itemEntity.m_32055_();
                if (stack.m_204117_(BzTags.CAN_BE_ENCHANTED_ITEMS)) return;
                if (stack.m_204117_(BzTags.CANNOT_CONSUMED_ITEMS)) return;
                if (stack.m_150930_((Item)BzItems.HONEY_CRYSTAL_SHARDS.get())) {
                    return;
                }
                int bottomY = CrystallineFlower.flowerHeightBelow((LevelReader)level, pos);
                BlockPos bottomPos = pos.m_6625_(bottomY);
                BlockEntity blockEntity = level.m_7702_(bottomPos);
                if (!(blockEntity instanceof CrystallineFlowerBlockEntity)) return;
                CrystallineFlowerBlockEntity crystallineFlowerBlockEntity = (CrystallineFlowerBlockEntity)blockEntity;
                if (crystallineFlowerBlockEntity.isMaxTier()) return;
                int tiersToMax = 7 - crystallineFlowerBlockEntity.getXpTier();
                int topBlock = CrystallineFlower.flowerHeightAbove((LevelReader)level, crystallineFlowerBlockEntity.m_58899_());
                List<Boolean> obstructedAbove = CrystallineFlower.getObstructions(tiersToMax, level, crystallineFlowerBlockEntity.m_58899_().m_6630_(topBlock + 1));
                int xpPerCount = CrystallineFlower.getXPPerItem(stack);
                int itemCount = stack.m_41613_();
                int xpForStack = itemCount * xpPerCount;
                int xpToHighestAvailableTier = CrystallineFlower.getXpToHighestAvailableTier(crystallineFlowerBlockEntity, tiersToMax, obstructedAbove);
                int xpGranted = Math.min(xpToHighestAvailableTier, xpForStack);
                int consumedItemCount = (int)Math.ceil((float)xpGranted / (float)xpPerCount);
                if (consumedItemCount == 0) {
                    return;
                }
                crystallineFlowerBlockEntity.addXpAndTier(xpGranted);
                stack.m_41774_(consumedItemCount);
                if (consumedItemCount >= itemCount) {
                    itemEntity.m_146870_();
                }
                if (!(level instanceof ServerLevel)) return;
                ServerLevel serverLevel = (ServerLevel)level;
                this.spawnConsumeParticles((Level)serverLevel, itemEntity.m_20182_(), level.f_46441_, consumedItemCount / 3 + 5);
                return;
            }
        }
        if (!(entity instanceof ExperienceOrb)) return;
        ExperienceOrb experienceOrb = (ExperienceOrb)entity;
        if ((Boolean)BzGeneralConfigs.crystallineFlowerConsumeExperienceOrbEntities.get() == false) return;
        int bottomY = CrystallineFlower.flowerHeightBelow((LevelReader)level, pos);
        BlockPos bottomPos = pos.m_6625_(bottomY);
        BlockEntity blockEntity = level.m_7702_(bottomPos);
        if (!(blockEntity instanceof CrystallineFlowerBlockEntity)) return;
        CrystallineFlowerBlockEntity crystallineFlowerBlockEntity = (CrystallineFlowerBlockEntity)blockEntity;
        if (crystallineFlowerBlockEntity.isMaxTier()) return;
        int tiersToMax = 7 - crystallineFlowerBlockEntity.getXpTier();
        int topBlock = CrystallineFlower.flowerHeightAbove((LevelReader)level, crystallineFlowerBlockEntity.m_58899_());
        List<Boolean> obstructedAbove = CrystallineFlower.getObstructions(tiersToMax, level, crystallineFlowerBlockEntity.m_58899_().m_6630_(topBlock + 1));
        int xpToHighestAvailableTier = CrystallineFlower.getXpToHighestAvailableTier(crystallineFlowerBlockEntity, tiersToMax, obstructedAbove);
        int xpGranted = Math.min(xpToHighestAvailableTier, experienceOrb.f_20770_);
        crystallineFlowerBlockEntity.addXpAndTier(xpGranted);
        experienceOrb.f_20770_ -= xpGranted;
        if (experienceOrb.f_20770_ <= 0) {
            experienceOrb.m_146870_();
        }
        if (!(level instanceof ServerLevel)) return;
        ServerLevel serverLevel = (ServerLevel)level;
        this.spawnConsumeParticles((Level)serverLevel, experienceOrb.m_20182_(), level.f_46441_, 3);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CrystallineFlowerBlockEntity) {
            CrystallineFlowerBlockEntity crystallineFlowerBlockEntity = (CrystallineFlowerBlockEntity)blockEntity;
            if (level.m_6907_().stream().noneMatch(p -> {
                AbstractContainerMenu patt11718$temp = p.f_36096_;
                if (!(patt11718$temp instanceof CrystallineFlowerMenu)) return false;
                CrystallineFlowerMenu crystallineFlowerMenu = (CrystallineFlowerMenu)patt11718$temp;
                if (crystallineFlowerMenu.crystallineFlowerBlockEntity == null) return false;
                if (!crystallineFlowerMenu.crystallineFlowerBlockEntity.getGUID().equals(crystallineFlowerBlockEntity.getGUID())) return false;
                return true;
            })) {
                if (level.f_46443_) {
                    return InteractionResult.SUCCESS;
                }
                player.m_5893_(state.m_60750_(level, pos));
                player.m_36220_((ResourceLocation)BzStats.INTERACT_WITH_CRYSTALLINE_FLOWER_RL.get());
                return InteractionResult.CONSUME;
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_5661_(OCCUPIED_CRYSTALLINE_FLOWER_TEXT, true);
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CrystallineFlowerBlockEntity) {
            CrystallineFlowerBlockEntity crystallineFlowerBlockEntity = (CrystallineFlowerBlockEntity)blockEntity;
            crystallineFlowerBlockEntity.setPillar(crystallineFlowerBlockEntity.getXpTier());
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43725_().m_8055_(context.m_8083_().m_7495_()).m_60713_((Block)BzBlocks.CRYSTALLINE_FLOWER.get())) {
            return null;
        }
        BlockState defaultState = super.m_5573_(context);
        return defaultState == null ? null : (BlockState)defaultState.m_61124_((Property)FLOWER, (Comparable)Boolean.valueOf(CrystallineFlower.isFlowerSpot(context.m_43725_(), context.m_8083_())));
    }

    public void m_6861_(BlockState blockstate, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        if (this.m_7898_(blockstate, (LevelReader)level, pos)) {
            boolean flowerSpot = CrystallineFlower.isFlowerSpot(level, pos);
            if (flowerSpot != (Boolean)blockstate.m_61143_((Property)FLOWER)) {
                level.m_7731_(pos, (BlockState)blockstate.m_61124_((Property)FLOWER, (Comparable)Boolean.valueOf(flowerSpot)), 3);
            }
        } else {
            level.m_7740_(pos, blockstate.m_61138_((Property)FLOWER) && (Boolean)blockstate.m_61143_((Property)FLOWER) != false, null, 1);
        }
        super.m_6861_(blockstate, level, pos, block, fromPos, notify);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState belowState = level.m_8055_(pos.m_7495_());
        boolean isBelowValid = belowState.m_204336_(BzTags.CRYSTALLINE_FLOWER_CAN_SURVIVE_ON) && belowState.m_60783_((BlockGetter)level, pos, Direction.UP) || belowState.m_60713_((Block)BzBlocks.CRYSTALLINE_FLOWER.get());
        int flowerBlockAbove = CrystallineFlower.flowerHeightAbove(level, pos);
        int flowerBlockBelow = CrystallineFlower.flowerHeightBelow(level, pos);
        BlockEntity operatingBE = level.m_7702_(pos.m_6625_(flowerBlockBelow));
        if (operatingBE instanceof CrystallineFlowerBlockEntity) {
            CrystallineFlowerBlockEntity crystallineFlowerBlockEntity = (CrystallineFlowerBlockEntity)operatingBE;
            return isBelowValid && flowerBlockBelow + flowerBlockAbove + 1 == crystallineFlowerBlockEntity.getXpTier();
        }
        return isBelowValid && flowerBlockBelow + flowerBlockAbove + 1 <= 7;
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        if (state.m_61138_((Property)FLOWER) && ((Boolean)state.m_61143_((Property)FLOWER)).booleanValue()) {
            return super.m_7381_(state, builder);
        }
        return new ArrayList<ItemStack>();
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        int flowerBlockBelow = CrystallineFlower.flowerHeightBelow((LevelReader)level, pos);
        BlockPos bottomPos = pos.m_6625_(flowerBlockBelow);
        BlockEntity blockEntity = level.m_7702_(bottomPos);
        if (blockEntity instanceof CrystallineFlowerBlockEntity) {
            CrystallineFlowerBlockEntity crystallineFlowerBlockEntity = (CrystallineFlowerBlockEntity)blockEntity;
            return crystallineFlowerBlockEntity.getXpTier();
        }
        return 0;
    }

    public static boolean isFlowerSpot(Level level, BlockPos pos) {
        return !level.m_8055_(pos.m_7494_()).m_60713_((Block)BzBlocks.CRYSTALLINE_FLOWER.get());
    }

    public static boolean isBottomSpot(Level level, BlockPos pos) {
        return !level.m_8055_(pos.m_7495_()).m_60713_((Block)BzBlocks.CRYSTALLINE_FLOWER.get());
    }

    public static int flowerTotalHeight(LevelReader level, BlockPos pos) {
        return CrystallineFlower.flowerHeightBelow(level, pos) + CrystallineFlower.flowerHeightAbove(level, pos) + 1;
    }

    public static int flowerHeightBelow(LevelReader level, BlockPos pos) {
        int i = 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockState currentState = level.m_8055_((BlockPos)mutable.m_122190_((Vec3i)pos.m_7495_()));
        while (currentState.m_60713_((Block)BzBlocks.CRYSTALLINE_FLOWER.get()) && mutable.m_123342_() >= level.m_141937_()) {
            ++i;
            mutable.m_122173_(Direction.DOWN);
            currentState = level.m_8055_((BlockPos)mutable);
        }
        return i;
    }

    public static int flowerHeightAbove(LevelReader level, BlockPos pos) {
        int i = 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockState currentState = level.m_8055_((BlockPos)mutable.m_122190_((Vec3i)pos.m_7494_()));
        while (currentState.m_60713_((Block)BzBlocks.CRYSTALLINE_FLOWER.get()) && mutable.m_123342_() <= level.m_151558_()) {
            ++i;
            mutable.m_122173_(Direction.UP);
            currentState = level.m_8055_((BlockPos)mutable);
        }
        return i;
    }

    public static List<Boolean> getObstructions(int scanArea, Level level, BlockPos pos) {
        ArrayList<Boolean> obstructions = new ArrayList<Boolean>();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        mutable.m_122190_((Vec3i)pos);
        for (int i = 0; i < scanArea; ++i) {
            BlockState currentState = level.m_8055_((BlockPos)mutable);
            if (!currentState.m_60795_() && !currentState.m_60713_((Block)BzBlocks.CRYSTALLINE_FLOWER.get())) {
                obstructions.add(true);
            } else {
                obstructions.add(false);
            }
            mutable.m_122173_(Direction.UP);
        }
        return obstructions;
    }

    public static int getXPPerItem(ItemStack stack) {
        if (stack.m_204117_(BzTags.XP_2_WHEN_CONSUMED_ITEMS)) {
            return 2;
        }
        if (stack.m_204117_(BzTags.XP_5_WHEN_CONSUMED_ITEMS)) {
            return 5;
        }
        if (stack.m_204117_(BzTags.XP_25_WHEN_CONSUMED_ITEMS)) {
            return 25;
        }
        if (stack.m_204117_(BzTags.XP_100_WHEN_CONSUMED_ITEMS)) {
            return 100;
        }
        if (stack.m_204117_(BzTags.XP_1000_WHEN_CONSUMED_ITEMS)) {
            return 1000;
        }
        if (stack.m_204117_(BzTags.XP_MAXED_WHEN_CONSUMED_ITEMS)) {
            return Integer.MAX_VALUE;
        }
        return 1;
    }

    public static int getXpToHighestAvailableTier(CrystallineFlowerBlockEntity crystallineFlowerBlockEntity, int tiersToMax, List<Boolean> obstructedAbove) {
        int xpToHighestAvailableTier = 0;
        for (int i = 1; i <= tiersToMax; ++i) {
            int xpToDesiredTier = crystallineFlowerBlockEntity.getXpForNextTiers(i);
            if (i - 1 < obstructedAbove.size() && obstructedAbove.get(i - 1).booleanValue()) {
                xpToHighestAvailableTier = xpToDesiredTier - 1;
                break;
            }
            xpToHighestAvailableTier = xpToDesiredTier;
        }
        return xpToHighestAvailableTier;
    }

    public MenuProvider m_7246_(BlockState state, Level level, BlockPos pos) {
        int searchLevel = 0;
        int searchTreasure = 0;
        int flowerBlockBelow = CrystallineFlower.flowerHeightBelow((LevelReader)level, pos);
        BlockPos bottomPlant = pos.m_6625_(flowerBlockBelow);
        BlockEntity blockEntity = level.m_7702_(bottomPlant);
        if (blockEntity instanceof CrystallineFlowerBlockEntity) {
            CrystallineFlowerBlockEntity crystallineFlowerBlockEntity = (CrystallineFlowerBlockEntity)blockEntity;
            searchLevel = crystallineFlowerBlockEntity.getXpTier() * 2 + 1;
            if (crystallineFlowerBlockEntity.getXpTier() > 5) {
                searchTreasure = 1;
            }
        }
        int finalSearchTreasure = searchTreasure;
        int finalSearchLevel = searchLevel;
        CrystallineFlowerBlockEntity finalCrystallineFlowerBlockEntity = blockEntity instanceof CrystallineFlowerBlockEntity ? (CrystallineFlowerBlockEntity)blockEntity : null;
        return new SimpleMenuProvider((containerId, inventory, player) -> new CrystallineFlowerMenu(containerId, inventory, ContainerLevelAccess.m_39289_((Level)level, (BlockPos)pos.m_6625_(flowerBlockBelow)), finalSearchLevel, finalSearchTreasure, finalCrystallineFlowerBlockEntity), CONTAINER_TITLE);
    }

    public void m_5871_(ItemStack itemStack, BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        int tier;
        super.m_5871_(itemStack, level, tooltip, flag);
        CompoundTag compoundtag = BlockItem.m_186336_((ItemStack)itemStack);
        if (compoundtag != null && compoundtag.m_128441_(CrystallineFlowerBlockEntity.TIER_TAG) && (tier = compoundtag.m_128451_(CrystallineFlowerBlockEntity.TIER_TAG)) != 0) {
            int xp = compoundtag.m_128451_(CrystallineFlowerBlockEntity.XP_TAG);
            tooltip.add((Component)Component.m_237110_((String)"item.the_bumblezone.crystalline_flower_info_1", (Object[])new Object[]{tier}).m_130940_(ChatFormatting.LIGHT_PURPLE).m_130940_(ChatFormatting.ITALIC));
            tooltip.add((Component)Component.m_237110_((String)"item.the_bumblezone.crystalline_flower_info_2", (Object[])new Object[]{xp}).m_130940_(ChatFormatting.DARK_PURPLE).m_130940_(ChatFormatting.ITALIC));
        }
    }

    private void spawnConsumeParticles(Level world, Vec3 position, RandomSource random, int particleCount) {
        ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123748_, position.m_7096_(), position.m_7098_() + 0.5, position.m_7094_(), particleCount, random.m_188500_() / 8.0 + 0.2, random.m_188500_() / 8.0 + 0.2, random.m_188500_() / 8.0 + 0.2, 0.1);
    }

    public void m_214162_(BlockState blockState, Level world, BlockPos position, RandomSource random) {
        boolean flower = (Boolean)blockState.m_61143_((Property)FLOWER);
        float f = random.m_188501_();
        float f2 = flower ? 0.15f : 0.05f;
        if (f < f2) {
            this.spawnSparkleParticles(world, position, random, flower);
        }
        if (flower) {
            world.m_7106_((ParticleOptions)BzParticles.POLLEN_PARTICLE.get(), (double)position.m_123341_() + 0.5, (double)position.m_123342_() + 0.1, (double)position.m_123343_() + 0.5, random.m_188583_() * 0.005, random.m_188583_() * 0.005 + 0.005, random.m_188583_() * 0.005);
        }
    }

    private void spawnSparkleParticles(Level world, BlockPos position, RandomSource random, boolean flower) {
        double z;
        double y;
        double x;
        int min = flower ? 1 : 3;
        int max = flower ? 15 : 13;
        double minRatio = (double)min / 16.0;
        if (flower) {
            int chosenFace = random.m_188503_(3);
            boolean xB = random.m_188499_();
            boolean yB = random.m_188499_();
            boolean zB = random.m_188499_();
            x = random.m_188500_() + (double)(xB ? min : max) * (chosenFace != 0 ? random.m_188500_() * (1.0 - minRatio) : 1.0) + (double)(chosenFace != 0 ? min : 0);
            y = random.m_188500_() + (double)(yB ? 0 : 9) * (chosenFace != 1 ? random.m_188500_() : 1.0);
            z = random.m_188500_() + (double)(zB ? min : max) * (chosenFace != 2 ? random.m_188500_() * (1.0 - minRatio) : 1.0) + (double)(chosenFace != 2 ? min : 0);
        } else {
            int chosenFace = random.m_188503_(2);
            boolean xB = random.m_188499_();
            boolean zB = random.m_188499_();
            x = random.m_188500_() + (double)(xB ? min : max) * (chosenFace != 0 ? random.m_188500_() * (1.0 - minRatio) : 1.0) + (double)(chosenFace != 0 ? min : 0);
            y = random.m_188500_() * (double)(flower ? 9 : 16);
            z = random.m_188500_() + (double)(zB ? min : max) * (chosenFace != 1 ? random.m_188500_() * (1.0 - minRatio) : 1.0) + (double)(chosenFace != 1 ? min : 0);
        }
        world.m_7106_((ParticleOptions)BzParticles.SPARKLE_PARTICLE.get(), x / 16.0 + (double)position.m_123341_(), y / 16.0 + (double)position.m_123342_(), z / 16.0 + (double)position.m_123343_(), 0.0, 0.0, 0.0);
    }
}

