/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import immersive_armors.Main;
import immersive_armors.item.ExtendedArmorItem;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidArmorLayer.class}, priority=700)
public abstract class MixinArmorFeatureRenderer<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    @Unique
    float immersiveArmors$tickDelta;
    @Unique
    @Nullable
    ItemStack immersiveArmors$equippedStack;
    @Unique
    @Nullable
    T immersiveArmors$entity;

    @Shadow
    protected abstract A m_117078_(EquipmentSlot var1);

    public MixinArmorFeatureRenderer(RenderLayerParent<T, M> context) {
        super(context);
    }

    @ModifyVariable(method={"renderArmor"}, at=@At(value="STORE"), ordinal=0)
    ItemStack immersiveArmors$immersiveArmors$fetchItemStack(ItemStack itemStack) {
        this.immersiveArmors$equippedStack = itemStack;
        return itemStack;
    }

    @Inject(method={"renderArmorParts"}, at={@At(value="HEAD")}, cancellable=true)
    void immersiveArmors$injectRenderArmorParts(PoseStack matrices, MultiBufferSource vertexConsumers, int light, ArmorItem item, boolean usesSecondLayer, A model, boolean legs, float red, float green, float blue, String overlay, CallbackInfo ci) {
        if (!Main.FORGE && this.immersiveArmors$equippedStack != null && this.immersiveArmors$equippedStack.m_41720_() == item && item instanceof ExtendedArmorItem) {
            ExtendedArmorItem armorItem = (ExtendedArmorItem)item;
            this.renderPieces(matrices, vertexConsumers, light, armorItem);
            ci.cancel();
        }
    }

    @Inject(method={"renderArmor"}, at={@At(value="HEAD")}, cancellable=true)
    void immersiveArmors$injectRenderArmor(PoseStack matrices, MultiBufferSource vertexConsumers, T entity, EquipmentSlot armorSlot, int light, A model, CallbackInfo ci) {
        ItemStack itemStack;
        if (Main.FORGE && (itemStack = entity.m_6844_(armorSlot)).m_41720_() instanceof ExtendedArmorItem) {
            ci.cancel();
        }
    }

    @Inject(method={"render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/entity/LivingEntity;FFFFFF)V"}, at={@At(value="HEAD")})
    public void immersiveArmors$render(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, T entity, float f, float g, float tickDelta, float j, float k, float l, CallbackInfo ci) {
        this.immersiveArmors$tickDelta = tickDelta;
        this.immersiveArmors$entity = entity;
        if (Main.FORGE) {
            this.renderPieces(matrixStack, vertexConsumerProvider, i, EquipmentSlot.HEAD);
            this.renderPieces(matrixStack, vertexConsumerProvider, i, EquipmentSlot.CHEST);
            this.renderPieces(matrixStack, vertexConsumerProvider, i, EquipmentSlot.LEGS);
            this.renderPieces(matrixStack, vertexConsumerProvider, i, EquipmentSlot.FEET);
        }
    }

    private void renderPieces(PoseStack matrices, MultiBufferSource vertexConsumers, int light, EquipmentSlot armorSlot) {
        if (this.immersiveArmors$entity != null) {
            this.immersiveArmors$equippedStack = this.immersiveArmors$entity.m_6844_(armorSlot);
            Item item = this.immersiveArmors$equippedStack.m_41720_();
            if (item instanceof ExtendedArmorItem) {
                ExtendedArmorItem armorItem = (ExtendedArmorItem)item;
                this.renderPieces(matrices, vertexConsumers, light, armorItem);
            }
        }
    }

    private void renderPieces(PoseStack matrices, MultiBufferSource vertexConsumers, int light, ExtendedArmorItem item) {
        if (this.immersiveArmors$entity != null && this.immersiveArmors$equippedStack != null) {
            item.getMaterial().getPieces(item.m_40402_()).forEach(piece -> {
                A armorModel = this.m_117078_(item.m_40402_());
                ((HumanoidModel)this.m_117386_()).m_102872_(armorModel);
                piece.render(matrices, vertexConsumers, light, this.immersiveArmors$entity, this.immersiveArmors$equippedStack, this.immersiveArmors$tickDelta, item.m_40402_(), armorModel);
            });
        }
    }
}

