/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.util;

import com.github.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.github.klikli_dev.occultism.api.common.data.MachineReference;
import com.github.klikli_dev.occultism.api.common.data.WorkAreaSize;
import com.github.klikli_dev.occultism.common.entity.job.ManageMachineJob;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.util.EntityUtil;
import com.github.klikli_dev.occultism.util.TextUtil;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class ItemNBTUtil {
    public static final String SPIRIT_NAME_TAG = "spiritName";
    public static final String SPIRIT_UUID_TAG = "spiritUUID";
    public static final String SPIRIT_DEAD_TAG = "spiritDead";
    public static final String SPIRIT_DATA_TAG = "spiritData";
    public static final String ITEM_MODE_TAG = "itemMode";
    public static final String WORK_AREA_SIZE_TAG = "workAreaSize";
    public static final String WORK_AREA_POSITION_TAG = "workAreaPosition";
    public static final String DEPOSIT_POSITION_TAG = "depositPosition";
    public static final String DEPOSIT_ENTITY_UUID_TAG = "depositEntityUUID";
    public static final String DEPOSIT_ENTITY_NAME_TAG = "depositEntityName";
    public static final String DEPOSIT_FACING_TAG = "depositFacing";
    public static final String EXTRACT_POSITION_TAG = "extractPosition";
    public static final String EXTRACT_FACING_TAG = "extractFacing";
    public static final String STORAGE_CONTROLLER_POSITION_TAG = "storageControllerPosition";
    public static final String MANAGED_MACHINE = "managedMachine";

    public static void updateItemNBTFromEntity(ItemStack stack, SpiritEntity entity) {
        ItemNBTUtil.setWorkAreaPosition(stack, entity.getWorkAreaPosition());
        ItemNBTUtil.setDepositPosition(stack, entity.getDepositPosition());
        ItemNBTUtil.setDepositEntityUUID(stack, entity.getDepositEntityUUID());
        ItemNBTUtil.setDepositFacing(stack, entity.getDepositFacing());
        ItemNBTUtil.setExtractPosition(stack, entity.getExtractPosition());
        ItemNBTUtil.setExtractFacing(stack, entity.getExtractFacing());
        ItemNBTUtil.setWorkAreaSize(stack, entity.getWorkAreaSize());
        entity.getJob().filter(ManageMachineJob.class::isInstance).map(ManageMachineJob.class::cast).ifPresent(job -> {
            if (job.getStorageControllerPosition() != null) {
                ItemNBTUtil.setStorageControllerPosition(stack, job.getStorageControllerPosition());
            }
            if (job.getManagedMachine() != null) {
                ItemNBTUtil.setManagedMachine(stack, job.getManagedMachine());
            }
        });
    }

    public static void generateBoundSpiritName(ItemStack stack) {
        ItemNBTUtil.setBoundSpiritName(stack, TextUtil.generateName());
    }

    public static void setBoundSpiritName(ItemStack stack, String name) {
        stack.m_41784_().m_128359_(SPIRIT_NAME_TAG, name);
    }

    public static String getBoundSpiritName(ItemStack stack) {
        if (!stack.m_41784_().m_128441_(SPIRIT_NAME_TAG)) {
            ItemNBTUtil.generateBoundSpiritName(stack);
        }
        return stack.m_41783_().m_128461_(SPIRIT_NAME_TAG);
    }

    public static int getItemMode(ItemStack stack) {
        CompoundTag compound = stack.m_41783_();
        if (!stack.m_41784_().m_128441_(ITEM_MODE_TAG)) {
            ItemNBTUtil.setItemMode(stack, 0);
        }
        return stack.m_41783_().m_128451_(ITEM_MODE_TAG);
    }

    public static void setItemMode(ItemStack stack, int mode) {
        stack.m_41784_().m_128405_(ITEM_MODE_TAG, mode);
    }

    public static GlobalBlockPos getStorageControllerPosition(ItemStack stack) {
        if (!stack.m_41784_().m_128441_(STORAGE_CONTROLLER_POSITION_TAG)) {
            return null;
        }
        return GlobalBlockPos.from(stack.m_41783_().m_128469_(STORAGE_CONTROLLER_POSITION_TAG));
    }

    public static void setStorageControllerPosition(ItemStack stack, GlobalBlockPos position) {
        if (position != null) {
            stack.m_41700_(STORAGE_CONTROLLER_POSITION_TAG, (Tag)position.serializeNBT());
        }
    }

    public static MachineReference getManagedMachine(ItemStack stack) {
        if (!stack.m_41784_().m_128441_(MANAGED_MACHINE)) {
            return null;
        }
        return MachineReference.from(stack.m_41783_().m_128469_(MANAGED_MACHINE));
    }

    public static void setManagedMachine(ItemStack stack, MachineReference position) {
        if (position != null) {
            stack.m_41700_(MANAGED_MACHINE, (Tag)position.serializeNBT());
        }
    }

    public static BlockPos getDepositPosition(ItemStack stack) {
        if (!stack.m_41784_().m_128441_(DEPOSIT_POSITION_TAG)) {
            return null;
        }
        return BlockPos.m_122022_((long)stack.m_41783_().m_128454_(DEPOSIT_POSITION_TAG));
    }

    public static void setDepositPosition(ItemStack stack, Optional<BlockPos> position) {
        if (position.isPresent()) {
            stack.m_41784_().m_128356_(DEPOSIT_POSITION_TAG, position.get().m_121878_());
        } else if (stack.m_41782_()) {
            stack.m_41783_().m_128473_(DEPOSIT_POSITION_TAG);
        }
    }

    public static UUID getDepositEntityUUID(ItemStack stack) {
        if (!stack.m_41784_().m_128441_(DEPOSIT_ENTITY_UUID_TAG)) {
            return null;
        }
        return stack.m_41783_().m_128342_(DEPOSIT_ENTITY_UUID_TAG);
    }

    public static void setDepositEntityUUID(ItemStack stack, Optional<UUID> uuid) {
        if (uuid.isPresent()) {
            stack.m_41784_().m_128362_(DEPOSIT_ENTITY_UUID_TAG, uuid.get());
        } else if (stack.m_41782_()) {
            stack.m_41783_().m_128473_(DEPOSIT_ENTITY_UUID_TAG);
        }
    }

    public static void setDepositEntityName(ItemStack stack, String string) {
        stack.m_41784_().m_128359_(DEPOSIT_ENTITY_NAME_TAG, string);
    }

    public static String getDepositEntityName(ItemStack stack) {
        if (!stack.m_41784_().m_128441_(DEPOSIT_ENTITY_NAME_TAG)) {
            return null;
        }
        return stack.m_41783_().m_128461_(DEPOSIT_ENTITY_NAME_TAG);
    }

    public static Direction getDepositFacing(ItemStack stack) {
        if (!stack.m_41784_().m_128441_(DEPOSIT_FACING_TAG)) {
            return null;
        }
        return Direction.values()[stack.m_41783_().m_128451_(DEPOSIT_FACING_TAG)];
    }

    public static void setDepositFacing(ItemStack stack, Direction facing) {
        stack.m_41784_().m_128405_(DEPOSIT_FACING_TAG, facing.ordinal());
    }

    public static BlockPos getExtractPosition(ItemStack stack) {
        if (!stack.m_41784_().m_128441_(EXTRACT_POSITION_TAG)) {
            return null;
        }
        return BlockPos.m_122022_((long)stack.m_41783_().m_128454_(EXTRACT_POSITION_TAG));
    }

    public static void setExtractPosition(ItemStack stack, Optional<BlockPos> position) {
        position.ifPresent(p -> stack.m_41784_().m_128356_(EXTRACT_POSITION_TAG, p.m_121878_()));
    }

    public static Direction getExtractFacing(ItemStack stack) {
        if (!stack.m_41784_().m_128441_(EXTRACT_FACING_TAG)) {
            return null;
        }
        return Direction.values()[stack.m_41783_().m_128451_(EXTRACT_FACING_TAG)];
    }

    public static void setExtractFacing(ItemStack stack, Direction facing) {
        stack.m_41784_().m_128405_(EXTRACT_FACING_TAG, facing.ordinal());
    }

    public static BlockPos getWorkAreaPosition(ItemStack stack) {
        if (!stack.m_41784_().m_128441_(WORK_AREA_POSITION_TAG)) {
            return null;
        }
        return BlockPos.m_122022_((long)stack.m_41783_().m_128454_(WORK_AREA_POSITION_TAG));
    }

    public static void setWorkAreaPosition(ItemStack stack, Optional<BlockPos> position) {
        position.ifPresent(p -> stack.m_41784_().m_128356_(WORK_AREA_POSITION_TAG, p.m_121878_()));
    }

    public static WorkAreaSize getWorkAreaSize(ItemStack stack) {
        if (!stack.m_41784_().m_128441_(WORK_AREA_SIZE_TAG)) {
            ItemNBTUtil.setWorkAreaSize(stack, WorkAreaSize.SMALL);
        }
        return WorkAreaSize.get(stack.m_41783_().m_128451_(WORK_AREA_SIZE_TAG));
    }

    public static void setWorkAreaSize(ItemStack stack, WorkAreaSize workAreaSize) {
        stack.m_41784_().m_128405_(WORK_AREA_SIZE_TAG, workAreaSize.getValue());
    }

    public static UUID getSpiritEntityUUID(ItemStack stack) {
        if (!stack.m_41784_().m_128441_(SPIRIT_UUID_TAG)) {
            return null;
        }
        return stack.m_41783_().m_128469_(SPIRIT_UUID_TAG).m_128342_("");
    }

    public static void setSpiritEntityUUID(ItemStack stack, UUID id) {
        CompoundTag uuidCompound = new CompoundTag();
        uuidCompound.m_128362_("", id);
        stack.m_41700_(SPIRIT_UUID_TAG, (Tag)uuidCompound);
    }

    public static boolean getSpiritDead(ItemStack stack) {
        return stack.m_41784_().m_128471_(SPIRIT_DEAD_TAG);
    }

    public static CompoundTag getSpiritEntityData(ItemStack stack) {
        if (!stack.m_41784_().m_128441_(SPIRIT_DATA_TAG)) {
            return null;
        }
        return stack.m_41783_().m_128469_(SPIRIT_DATA_TAG);
    }

    public static void setSpiritEntityData(ItemStack stack, CompoundTag entityData) {
        stack.m_41784_().m_128365_(SPIRIT_DATA_TAG, (Tag)entityData);
    }

    public static Optional<SpiritEntity> getSpiritEntity(ItemStack itemStack) {
        return EntityUtil.getEntityByUuiDGlobal(ItemNBTUtil.getSpiritEntityUUID(itemStack)).map(e -> (SpiritEntity)e);
    }
}

