/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.network;

import com.github.klikli_dev.occultism.common.entity.familiar.BeholderFamiliarEntity;
import com.github.klikli_dev.occultism.network.MessageBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class MessageBeholderAttack
extends MessageBase {
    private int beholderId;
    private List<Integer> targetIds;

    public MessageBeholderAttack(int beholderId, List<Integer> targetIds) {
        this.beholderId = beholderId;
        this.targetIds = targetIds;
    }

    public MessageBeholderAttack(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.beholderId);
        buf.writeInt(this.targetIds.size());
        for (int id : this.targetIds) {
            buf.writeInt(id);
        }
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.beholderId = buf.readInt();
        this.targetIds = new ArrayList<Integer>();
        int length = buf.readInt();
        for (int i = 0; i < length; ++i) {
            this.targetIds.add(buf.readInt());
        }
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player, NetworkEvent.Context context) {
        Entity entity = minecraft.f_91073_.m_6815_(this.beholderId);
        if (entity instanceof BeholderFamiliarEntity) {
            BeholderFamiliarEntity beholder = (BeholderFamiliarEntity)entity;
            beholder.shootRay(this.targetIds);
        }
    }
}

