/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.datagen;

import com.github.klikli_dev.occultism.integration.modonomicon.pages.BookRitualRecipePageModel;
import com.github.klikli_dev.occultism.integration.modonomicon.pages.BookSpiritFireRecipePageModel;
import com.github.klikli_dev.occultism.integration.modonomicon.pages.BookSpiritTradeRecipePageModel;
import com.github.klikli_dev.occultism.registry.OccultismBlocks;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.modonomicon.api.ModonomiconAPI;
import com.klikli_dev.modonomicon.api.datagen.BookLangHelper;
import com.klikli_dev.modonomicon.api.datagen.BookProvider;
import com.klikli_dev.modonomicon.api.datagen.EntryLocationHelper;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryParentModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookAndConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookEntryReadConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookModLoadedConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookTrueConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookCraftingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookEntityPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookImagePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookMultiblockPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSmeltingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSpotlightPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.ForgeRegistries;

public class OccultismBookProvider
extends BookProvider {
    public static final String COLOR_PURPLE = "ad03fc";

    public OccultismBookProvider(DataGenerator generator, String modid, LanguageProvider lang) {
        super(generator, modid, lang);
    }

    protected void generate() {
        BookModel dictionaryOfSpirits = this.makeDictionaryOfSpirits();
        this.add(dictionaryOfSpirits);
    }

    private BookModel makeDictionaryOfSpirits() {
        BookLangHelper helper = ModonomiconAPI.get().getLangHelper(this.modid);
        helper.book("dictionary_of_spirits");
        int sortNum = 1;
        BookCategoryModel gettingStartedCategory = this.makeGettingStartedCategory(helper).withSortNumber(sortNum++);
        BookCategoryModel spiritsCategory = this.makeSpiritsSubcategory(helper).withSortNumber(sortNum++);
        BookCategoryModel storageCategory = this.makeStorageCategory(helper).withSortNumber(sortNum++);
        BookCategoryModel ritualsCategory = this.makeRitualsCategory(helper).withSortNumber(sortNum++);
        BookCategoryModel summoningRitualsCategory = this.makeSummoningRitualsSubcategory(helper).withSortNumber(sortNum++);
        BookCategoryModel possessionRitualsCategory = this.makePossessionRitualsSubcategory(helper).withSortNumber(sortNum++);
        BookCategoryModel craftingRitualsCategory = this.makeCraftingRitualsSubcategory(helper).withSortNumber(sortNum++);
        BookCategoryModel familiarRitualsCategory = this.makeFamiliarRitualsSubcategory(helper).withSortNumber(sortNum++);
        BookCategoryModel pentaclesCategory = this.makePentaclesCategory(helper).withSortNumber(sortNum++);
        BookEntryReadConditionModel introReadCondition = BookEntryReadConditionModel.builder().withEntry(this.modLoc("getting_started/intro")).build();
        storageCategory.withCondition((BookConditionModel)introReadCondition);
        ritualsCategory.withCondition((BookConditionModel)introReadCondition);
        pentaclesCategory.withCondition((BookConditionModel)introReadCondition);
        BookModel demoBook = BookModel.create((ResourceLocation)this.modLoc("dictionary_of_spirits"), (String)helper.bookName()).withModel(this.modLoc("dictionary_of_spirits_icon")).withTooltip(helper.bookTooltip()).withCategories(new BookCategoryModel[]{gettingStartedCategory, spiritsCategory, pentaclesCategory, ritualsCategory, summoningRitualsCategory, possessionRitualsCategory, craftingRitualsCategory, familiarRitualsCategory, storageCategory}).withCraftingTexture(this.modLoc("textures/gui/book/crafting_textures.png")).withGenerateBookItem(false).withCustomBookItem(this.modLoc("dictionary_of_spirits")).withAutoAddReadConditions(true);
        return demoBook;
    }

    private BookCategoryModel makeGettingStartedCategory(BookLangHelper helper) {
        helper.category("getting_started");
        EntryLocationHelper entryHelper = ModonomiconAPI.get().getEntryLocationHelper();
        entryHelper.setMap(new String[]{"__________t___B___________P___D___", "__________________________________", "______i___r___\u00e7_b_____g_I_O_l_M___", "__________________________________", "______d___f_c_____R___a_s_________", "__________________________________", "______e_h_____\u1ea1_______m___________", "__________________________________", "________________C___p_S___w_x_y_z_"});
        BookEntryModel.Builder introEntry = this.makeIntroEntry(helper, entryHelper, 'i');
        BookEntryModel.Builder demonsDreamEntry = this.makeDemonsDreamEntry(helper, entryHelper, 'd');
        demonsDreamEntry.withParent(BookEntryParentModel.builder().withEntryId(introEntry.id).build());
        BookEntryModel.Builder spiritFireEntry = this.makeSpiritFireEntry(helper, entryHelper, 'f');
        spiritFireEntry.withParent(BookEntryParentModel.builder().withEntryId(demonsDreamEntry.id).build());
        BookEntryModel.Builder healingSpiritsEntry = this.makeHealingSpiritsEntry(helper, entryHelper, 'h');
        healingSpiritsEntry.withParent(BookEntryParentModel.builder().withEntryId(demonsDreamEntry.id).build());
        BookEntryModel.Builder thirdEyeEntry = this.makeThirdEyeEntry(helper, entryHelper, 'e');
        thirdEyeEntry.withParent(BookEntryParentModel.builder().withEntryId(demonsDreamEntry.id).build());
        BookEntryModel.Builder divinationRodEntry = this.makeDivinationRodEntry(helper, entryHelper, 'r');
        divinationRodEntry.withParent(BookEntryParentModel.builder().withEntryId(spiritFireEntry.id).build());
        BookEntryModel.Builder theurgyDivinationRodEntry = this.makeTheurgyDivinationRodsEntry(helper, entryHelper, 't');
        theurgyDivinationRodEntry.withParent(BookEntryParentModel.builder().withEntryId(divinationRodEntry.id).build()).withCondition((BookConditionModel)BookAndConditionModel.builder().withChildren(new BookConditionModel[]{BookEntryReadConditionModel.builder().withEntry(divinationRodEntry.id).build(), BookModLoadedConditionModel.builder().withModId("theurgy").build()}).build()).hideWhileLocked(true);
        BookEntryModel.Builder candleEntry = this.makeCandleEntry(helper, entryHelper, 'c');
        candleEntry.withParent(BookEntryParentModel.builder().withEntryId(spiritFireEntry.id).build());
        BookEntryModel.Builder ritualPrepChalkEntry = this.makeRitualPrepChalkEntry(helper, entryHelper, '\u00e7');
        ritualPrepChalkEntry.withParent(BookEntryParentModel.builder().withEntryId(candleEntry.id).build());
        BookEntryModel.Builder brushEntry = this.makeBrushEntry(helper, entryHelper, 'B');
        brushEntry.withParent(BookEntryParentModel.builder().withEntryId(ritualPrepChalkEntry.id).build());
        BookEntryModel.Builder ritualPrepBowlEntry = this.makeRitualPrepBowlEntry(helper, entryHelper, 'b');
        ritualPrepBowlEntry.withParent(BookEntryParentModel.builder().withEntryId(ritualPrepChalkEntry.id).build());
        BookEntryModel.Builder booksOfBinding = this.makeBooksOfBindingEntry(helper, entryHelper, '\u1ea1');
        booksOfBinding.withParent(BookEntryParentModel.builder().withEntryId(candleEntry.id).build());
        BookEntryModel.Builder booksOfCalling = this.makeBooksOfCallingEntry(helper, entryHelper, 'C');
        booksOfCalling.withParent(BookEntryParentModel.builder().withEntryId(booksOfBinding.id).build());
        BookEntryModel.Builder ritualEntry = this.makeRitualEntry(helper, entryHelper, 'R');
        ritualEntry.withParent(BookEntryParentModel.builder().withEntryId(ritualPrepBowlEntry.id).build()).withParent(BookEntryParentModel.builder().withEntryId(booksOfBinding.id).build());
        BookEntryModel.Builder advancedChalksEntry = this.makeChalksEntry(helper, entryHelper, 'a');
        advancedChalksEntry.withParent(BookEntryParentModel.builder().withEntryId(ritualEntry.id).build());
        BookEntryModel.Builder moreRitualsEntry = this.makeMoreRitualsEntry(helper, entryHelper, 'm');
        moreRitualsEntry.withParent(BookEntryParentModel.builder().withEntryId(advancedChalksEntry.id).build());
        BookEntryModel.Builder greyParticlesEntry = this.makeGreyParticlesEntry(helper, entryHelper, 'p');
        greyParticlesEntry.withParent(BookEntryParentModel.builder().withEntryId(ritualEntry.id).build());
        BookEntryModel.Builder spiritsSubcategory = this.makeSpiritsSubcategoryEntry(helper, entryHelper, 'S');
        spiritsSubcategory.withParent(BookEntryParentModel.builder().withEntryId(greyParticlesEntry.id).build());
        BookEntryModel.Builder otherworldGoggles = this.makeOtherworldGogglesEntry(helper, entryHelper, 'g');
        otherworldGoggles.withParent(BookEntryParentModel.builder().withEntryId(advancedChalksEntry.id).build());
        BookEntryModel.Builder infusedPickaxe = this.makeInfusedPickaxeEntry(helper, entryHelper, 'I');
        infusedPickaxe.withParent(BookEntryParentModel.builder().withEntryId(otherworldGoggles.id).build());
        BookEntryModel.Builder iesnium = this.makeIesniumEntry(helper, entryHelper, 'O');
        iesnium.withParent(BookEntryParentModel.builder().withEntryId(infusedPickaxe.id).build());
        BookEntryModel.Builder iesniumPickaxe = this.makeIesniumPickaxeEntry(helper, entryHelper, 'P');
        iesniumPickaxe.withParent(BookEntryParentModel.builder().withEntryId(iesnium.id).build());
        BookEntryModel.Builder magicLampsEntry = this.makeMagicLampsEntry(helper, entryHelper, 'l');
        magicLampsEntry.withParent(BookEntryParentModel.builder().withEntryId(iesnium.id).build());
        BookEntryModel.Builder spiritMinersEntry = this.makeSpiritMinersEntry(helper, entryHelper, 'M');
        spiritMinersEntry.withParent(BookEntryParentModel.builder().withEntryId(magicLampsEntry.id).build());
        BookEntryModel.Builder mineshaftEntry = this.makeMineshaftEntry(helper, entryHelper, 'D');
        mineshaftEntry.withParent(BookEntryParentModel.builder().withEntryId(spiritMinersEntry.id).build());
        BookEntryModel.Builder storageEntry = this.makeStorageEntry(helper, entryHelper, 's');
        storageEntry.withParent(BookEntryParentModel.builder().withEntryId(advancedChalksEntry.id).build());
        BookEntryModel.Builder possessionRitualsEntry = this.makePossessionRitualsEntry(helper, entryHelper, 'w');
        possessionRitualsEntry.withParent(BookEntryParentModel.builder().withEntryId(moreRitualsEntry.id).build());
        BookEntryModel.Builder familiarRitualsEntry = this.makeFamiliarRitualsEntry(helper, entryHelper, 'x');
        familiarRitualsEntry.withParent(BookEntryParentModel.builder().withEntryId(moreRitualsEntry.id).build());
        BookEntryModel.Builder summoningRitualsEntry = this.makeSummoningRitualsEntry(helper, entryHelper, 'y');
        summoningRitualsEntry.withParent(BookEntryParentModel.builder().withEntryId(moreRitualsEntry.id).build());
        BookEntryModel.Builder craftingRitualsEntry = this.makeCraftingRitualsEntry(helper, entryHelper, 'z');
        craftingRitualsEntry.withParent(BookEntryParentModel.builder().withEntryId(moreRitualsEntry.id).build());
        return BookCategoryModel.create((ResourceLocation)this.modLoc(helper.category), (String)helper.categoryName()).withIcon(OccultismItems.DICTIONARY_OF_SPIRITS_ICON.getId().toString()).withEntries(new BookEntryModel[]{introEntry.build(), demonsDreamEntry.build(), spiritFireEntry.build(), thirdEyeEntry.build(), healingSpiritsEntry.build(), divinationRodEntry.build(), theurgyDivinationRodEntry.build(), candleEntry.build(), ritualPrepChalkEntry.build(), ritualPrepBowlEntry.build(), booksOfBinding.build(), ritualEntry.build(), brushEntry.build(), moreRitualsEntry.build(), greyParticlesEntry.build(), booksOfCalling.build(), spiritsSubcategory.build(), advancedChalksEntry.build(), otherworldGoggles.build(), infusedPickaxe.build(), iesnium.build(), iesniumPickaxe.build(), magicLampsEntry.build(), spiritMinersEntry.build(), mineshaftEntry.build(), storageEntry.build(), possessionRitualsEntry.build(), familiarRitualsEntry.build(), summoningRitualsEntry.build(), craftingRitualsEntry.build()});
    }

    private BookEntryModel.Builder makeIntroEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("intro");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("help");
        BookTextPageModel help = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon(OccultismItems.DICTIONARY_OF_SPIRITS_ICON.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withEntryBackground(0, 1).withPages(new BookPageModel[]{intro, help});
    }

    private BookEntryModel.Builder makeDemonsDreamEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("demons_dream");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("intro2");
        BookTextPageModel intro2 = BookTextPageModel.builder().withText(helper.pageText()).build();
        helper.page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.DATURA.get()})).withText(helper.pageText()).build();
        helper.page("harvest_effect");
        BookTextPageModel harvestEffect = BookTextPageModel.builder().withText(helper.pageText()).build();
        helper.page("datura_screenshot");
        BookImagePageModel datureScreenshot = BookImagePageModel.builder().withImages(new ResourceLocation[]{this.modLoc("textures/gui/book/datura_effect.png")}).build();
        helper.page("note_on_spirit_fire");
        BookTextPageModel spiritFire = BookTextPageModel.builder().withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon(OccultismItems.DATURA.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, intro2, spotlight, harvestEffect, datureScreenshot, spiritFire});
    }

    private BookEntryModel.Builder makeSpiritFireEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("spirit_fire");
        helper.page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.SPIRIT_FIRE.get()})).withText(helper.pageText()).build();
        helper.page("spirit_fire_screenshot");
        BookImagePageModel spiritFireScreenshot = BookImagePageModel.builder().withImages(new ResourceLocation[]{this.modLoc("textures/gui/book/spiritfire_instructions.png")}).withText(helper.pageText()).build();
        helper.page("main_uses");
        BookTextPageModel mainUses = BookTextPageModel.builder().withText(helper.pageText()).build();
        helper.page("otherstone_recipe");
        BookSpiritFireRecipePageModel otherstoneRecipe = ((BookSpiritFireRecipePageModel.Builder)((BookSpiritFireRecipePageModel.Builder)BookSpiritFireRecipePageModel.builder().withRecipeId1(this.modLoc("spirit_fire/otherstone"))).withText(helper.pageText())).build();
        helper.page("otherworld_sapling_natural_recipe");
        BookSpiritFireRecipePageModel otherworldSaplingNaturalRecipe = ((BookSpiritFireRecipePageModel.Builder)((BookSpiritFireRecipePageModel.Builder)BookSpiritFireRecipePageModel.builder().withRecipeId1(this.modLoc("spirit_fire/otherworld_sapling_natural"))).withText(helper.pageText())).build();
        helper.page("otherworld_ashes_recipe");
        BookSpiritFireRecipePageModel otherworldAshesRecipe = ((BookSpiritFireRecipePageModel.Builder)((BookSpiritFireRecipePageModel.Builder)BookSpiritFireRecipePageModel.builder().withRecipeId1(this.modLoc("spirit_fire/otherworld_ashes"))).withText(helper.pageText())).build();
        helper.page("gem_recipe");
        BookSpiritFireRecipePageModel gemRecipe = ((BookSpiritFireRecipePageModel.Builder)((BookSpiritFireRecipePageModel.Builder)BookSpiritFireRecipePageModel.builder().withRecipeId1(this.modLoc("spirit_fire/spirit_attuned_gem"))).withText(helper.pageText())).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon(OccultismItems.SPIRIT_FIRE.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, spiritFireScreenshot, mainUses, otherstoneRecipe, otherworldSaplingNaturalRecipe, otherworldAshesRecipe, gemRecipe});
    }

    private BookEntryModel.Builder makeHealingSpiritsEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("healing_spirits");
        helper.page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.DATURA.get()})).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon(ForgeRegistries.ITEMS.getKey((Object)Items.f_42736_).toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight});
    }

    private BookEntryModel.Builder makeThirdEyeEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("third_eye");
        helper.page("about");
        BookTextPageModel about = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("how_to_obtain");
        BookTextPageModel howToObtain = BookTextPageModel.builder().withText(helper.pageText()).build();
        helper.page("otherworld_goggles");
        BookSpotlightPageModel otherworldGoggles = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.OTHERWORLD_GOGGLES.get()})).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon(this.modLoc("textures/mob_effect/third_eye.png").toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{about, howToObtain, otherworldGoggles});
    }

    private BookEntryModel.Builder makeDivinationRodEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("divination_rod");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("otherstone_recipe");
        BookSpiritFireRecipePageModel otherstoneRecipe = ((BookSpiritFireRecipePageModel.Builder)BookSpiritFireRecipePageModel.builder().withRecipeId1(this.modLoc("spirit_fire/otherstone"))).build();
        helper.page("otherworld_sapling_natural_recipe");
        BookSpiritFireRecipePageModel otherworldSaplingNaturalRecipe = ((BookSpiritFireRecipePageModel.Builder)((BookSpiritFireRecipePageModel.Builder)BookSpiritFireRecipePageModel.builder().withRecipeId1(this.modLoc("spirit_fire/otherworld_sapling_natural"))).withText(helper.pageText())).build();
        helper.page("divination_rod");
        BookSpotlightPageModel divinationRod = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.DIVINATION_ROD.get()})).withText(helper.pageText()).withAnchor("divination_instructions").build();
        helper.page("spirit_attuned_gem_recipe");
        BookSpiritFireRecipePageModel spiritAttunedGemRecipe = ((BookSpiritFireRecipePageModel.Builder)BookSpiritFireRecipePageModel.builder().withRecipeId1(this.modLoc("spirit_fire/spirit_attuned_gem"))).build();
        helper.page("divination_rod_recipe");
        BookCraftingRecipePageModel divinationRodRecipe = ((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(this.modLoc("crafting/divination_rod"))).build();
        helper.page("about_divination_rod");
        BookTextPageModel aboutDivinationRod = BookTextPageModel.builder().withText(helper.pageText()).build();
        helper.page("how_to_use");
        BookTextPageModel howToUse = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("how_to_use2");
        BookTextPageModel howToUse2 = BookTextPageModel.builder().withText(helper.pageText()).build();
        helper.page("how_to_use3");
        BookTextPageModel howToUse3 = BookTextPageModel.builder().withText(helper.pageText()).build();
        helper.page("divination_rod_screenshots");
        BookImagePageModel divinationRodScreenshots = BookImagePageModel.builder().withImages(new ResourceLocation[]{this.modLoc("textures/gui/book/rod_far.png"), this.modLoc("textures/gui/book/rod_mid.png"), this.modLoc("textures/gui/book/rod_near.png")}).withText(helper.pageText()).build();
        helper.page("otherworld_groves");
        BookTextPageModel otherworldGroves = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("otherworld_groves_2");
        BookTextPageModel otherworldGroves2 = BookTextPageModel.builder().withText(helper.pageText()).build();
        helper.page("otherworld_trees");
        BookTextPageModel otherworldTrees = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("otherworld_trees_2");
        BookTextPageModel otherworldTrees2 = BookTextPageModel.builder().withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon(OccultismItems.DIVINATION_ROD.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, otherstoneRecipe, otherworldSaplingNaturalRecipe, divinationRod, spiritAttunedGemRecipe, divinationRodRecipe, aboutDivinationRod, howToUse, howToUse2, howToUse3, divinationRodScreenshots, otherworldGroves, otherworldGroves2, otherworldTrees, otherworldTrees2});
    }

    private BookEntryModel.Builder makeTheurgyDivinationRodsEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("theurgy_divination_rod");
        this.lang.add(helper.entryName(), "More Divination Rods");
        this.lang.add(helper.entryDescription(), "Finding other ores and resources.");
        helper.page("intro");
        BookSpotlightPageModel intro = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.DIVINATION_ROD_T1.get()})).withText(helper.pageText()).build();
        this.lang.add(helper.pageText(), "While the [](item://occultism:divination_rod) is a great tool for finding [#](%1$s)Otherworld Materials[#](), it would be useful to have a way to find *all other* ores and resources as well.\n\\\n\\\nThis is where the Theurgy Divination Rod comes in.\n".formatted(COLOR_PURPLE));
        helper.page("recipe_rod");
        BookCraftingRecipePageModel recipeRod = ((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1("theurgy:crafting/shaped/divination_rod_t1")).build();
        helper.page("more_info");
        BookTextPageModel moreInfo = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        this.lang.add(helper.pageTitle(), "More Information");
        this.lang.add(helper.pageText(), "To find out more about the Theurgy Divination Rod, check out *\"The Hermetica\"*, the Guidebook for Theurgy.\n[This Entry](entry://theurgy:the_hermetica/getting_started/divination_rod) has more information about the Theurgy Divination Rod.\n");
        helper.page("recipe_hermetica");
        BookCraftingRecipePageModel recipeHermetica = ((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1("theurgy:crafting/shapeless/the_hermetica")).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon((ItemLike)ItemRegistry.DIVINATION_ROD_T1.get()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, recipeRod, moreInfo, recipeHermetica});
    }

    private BookEntryModel.Builder makeCandleEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("candle");
        helper.page("intro");
        BookSpotlightPageModel intro = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.CANDLE_WHITE.get()})).withText(helper.pageText()).build();
        helper.page("tallow");
        BookSpotlightPageModel tallow = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.TALLOW.get()})).withText(helper.pageText()).build();
        helper.page("cleaver_recipe");
        BookCraftingRecipePageModel cleaverRecipe = ((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(this.modLoc("crafting/butcher_knife"))).build();
        helper.page("candle_recipe");
        BookCraftingRecipePageModel candleRecipe = ((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(this.modLoc("crafting/candle"))).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon(OccultismBlocks.CANDLE_WHITE.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, tallow, cleaverRecipe, candleRecipe});
    }

    private BookEntryModel.Builder makeRitualPrepChalkEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("ritual_prep_chalk");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("white_chalk");
        BookSpotlightPageModel whiteChalkSpotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.CHALK_WHITE.get()})).withText(helper.pageText()).withAnchor("white_chalk").build();
        helper.page("burnt_otherstone_recipe");
        BookSmeltingRecipePageModel burntOtherstoneRecipe = ((BookSmeltingRecipePageModel.Builder)BookSmeltingRecipePageModel.builder().withRecipeId1(this.modLoc("smelting/burnt_otherstone"))).build();
        helper.page("otherworld_ashes_recipe");
        BookSpiritFireRecipePageModel otherworldAshesRecipe = ((BookSpiritFireRecipePageModel.Builder)BookSpiritFireRecipePageModel.builder().withRecipeId1(this.modLoc("spirit_fire/otherworld_ashes"))).build();
        helper.page("impure_white_chalk_recipe");
        BookCraftingRecipePageModel impureWhiteChalkRecipe = ((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(this.modLoc("crafting/chalk_white_impure"))).build();
        helper.page("white_chalk_recipe");
        BookSpiritFireRecipePageModel whiteChalkRecipe = ((BookSpiritFireRecipePageModel.Builder)BookSpiritFireRecipePageModel.builder().withRecipeId1(this.modLoc("spirit_fire/chalk_white"))).build();
        helper.page("usage");
        BookTextPageModel usage = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon(OccultismItems.CHALK_WHITE.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, whiteChalkSpotlight, burntOtherstoneRecipe, otherworldAshesRecipe, impureWhiteChalkRecipe, whiteChalkRecipe, usage});
    }

    private BookEntryModel.Builder makeRitualPrepBowlEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("ritual_prep_bowl");
        helper.page("sacrificial_bowl");
        BookSpotlightPageModel sacrificialBowlSpotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.SACRIFICIAL_BOWL.get()})).withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("sacrificial_bowl_recipe");
        BookCraftingRecipePageModel sacrificialBowlRecipe = ((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(this.modLoc("crafting/sacrificial_bowl"))).build();
        helper.page("golden_sacrificial_bowl");
        BookSpotlightPageModel goldenSacrificialBowlSpotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.GOLDEN_SACRIFICIAL_BOWL.get()})).withText(helper.pageText()).build();
        helper.page("golden_sacrificial_bowl_recipe");
        BookCraftingRecipePageModel goldenSacrificialBowlRecipe = ((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(this.modLoc("crafting/golden_sacrificial_bowl"))).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon(OccultismBlocks.GOLDEN_SACRIFICIAL_BOWL.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{sacrificialBowlSpotlight, sacrificialBowlRecipe, goldenSacrificialBowlSpotlight, goldenSacrificialBowlRecipe});
    }

    private BookEntryModel.Builder makeBooksOfBindingEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("books_of_binding");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("intro2");
        BookTextPageModel intro2 = BookTextPageModel.builder().withText(helper.pageText()).build();
        helper.page("purified_ink_recipe");
        BookSpiritFireRecipePageModel purifiedInkRecipe = ((BookSpiritFireRecipePageModel.Builder)((BookSpiritFireRecipePageModel.Builder)BookSpiritFireRecipePageModel.builder().withRecipeId1(this.modLoc("spirit_fire/purified_ink"))).withText(helper.pageText())).build();
        helper.page("book_of_binding_foliot_recipe");
        BookCraftingRecipePageModel bookOfBindingFoliotRecipe = ((BookCraftingRecipePageModel.Builder)((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(this.modLoc("crafting/book_of_binding_foliot"))).withText(helper.pageText())).build();
        helper.page("book_of_binding_bound_foliot_recipe");
        BookCraftingRecipePageModel bookOfBindingBoundFoliotRecipe = ((BookCraftingRecipePageModel.Builder)((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(this.modLoc("crafting/book_of_binding_bound_foliot"))).withText(helper.pageText())).build();
        helper.page("book_of_binding_djinni_recipe");
        BookCraftingRecipePageModel bookOfBindingDjinniRecipe = ((BookCraftingRecipePageModel.Builder)((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(this.modLoc("crafting/book_of_binding_djinni"))).withRecipeId2(this.modLoc("crafting/book_of_binding_bound_djinni"))).build();
        helper.page("book_of_binding_afrit_recipe");
        BookCraftingRecipePageModel bookOfBindingAfritRecipe = ((BookCraftingRecipePageModel.Builder)((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(this.modLoc("crafting/book_of_binding_afrit"))).withRecipeId2(this.modLoc("crafting/book_of_binding_bound_afrit"))).build();
        helper.page("book_of_binding_marid_recipe");
        BookCraftingRecipePageModel bookOfBindingMaritRecipe = ((BookCraftingRecipePageModel.Builder)((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(this.modLoc("crafting/book_of_binding_marid"))).withRecipeId2(this.modLoc("crafting/book_of_binding_bound_marid"))).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon(OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, intro2, purifiedInkRecipe, bookOfBindingFoliotRecipe, bookOfBindingBoundFoliotRecipe, bookOfBindingDjinniRecipe, bookOfBindingAfritRecipe, bookOfBindingMaritRecipe});
    }

    private BookEntryModel.Builder makeBooksOfCallingEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("books_of_calling");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("usage");
        BookTextPageModel usage = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("obtaining");
        BookTextPageModel obtaining = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("obtaining2");
        BookTextPageModel obtaining2 = BookTextPageModel.builder().withText(helper.pageText()).build();
        helper.page("storage");
        BookTextPageModel storage = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon(OccultismItems.BOOK_OF_CALLING_DJINNI_MANAGE_MACHINE.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, usage, obtaining, obtaining2, storage});
    }

    private BookEntryModel.Builder makeRitualEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("first_ritual");
        this.lang.add(helper.entryName(), "First Ritual");
        this.lang.add(helper.entryDescription(), "We're actually getting started now!");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        this.lang.add(helper.pageTitle(), "The Ritual (tm)");
        this.lang.add(helper.pageText(), "These pages will walk the gentle reader through the process of the [first ritual](entry://summoning_rituals/summon_crusher_t1) step by step.\n\\\nWe **start** by placing the [](item://occultism:golden_sacrificial_bowl) and drawing the appropriate pentacle, [Aviar's Circle](entry://pentacles/summon_foliot) as seen on the left around it.\n".formatted(COLOR_PURPLE));
        helper.page("multiblock");
        BookMultiblockPageModel multiblock = BookMultiblockPageModel.builder().withMultiblockId(this.modLoc("summon_foliot")).withText(helper.pageText()).build();
        this.lang.add(helper.pageText(), "Only the color and location of the chalk marks is relevant, not the glyph/sign.\n".formatted(COLOR_PURPLE));
        helper.page("bowl_text");
        BookTextPageModel bowlText = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        this.lang.add(helper.pageTitle(), "Sacrificial Bowls");
        this.lang.add(helper.pageText(), "Next, place *at least* 4 [Sacrificial Bowls](item://occultism:sacrificial_bowl) close to the pentacle.\n\\\n\\\nThey must be placed **anywhere** within 8 blocks of the central [](item://occultism:golden_sacrificial_bowl). **The exact location does not matter.**\n".formatted(COLOR_PURPLE));
        helper.page("bowl_placement");
        BookImagePageModel bowlPlacementImage = BookImagePageModel.builder().withImages(new ResourceLocation[]{this.modLoc("textures/gui/book/bowl_placement.png")}).withBorder(true).withText(helper.pageText()).build();
        this.lang.add(helper.pageText(), "Possible locations for the sacrificial bowls.\n".formatted(COLOR_PURPLE));
        helper.page("ritual_text");
        BookTextPageModel ritualText = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        this.lang.add(helper.pageTitle(), "Placing Ingredients");
        this.lang.add(helper.pageText(), "Now it is time to place the ingredients you see on the next page in the (regular, not golden) sacrificial bowls. The ingredients will be consumed from the bowls as the ritual progresses.\n".formatted(COLOR_PURPLE));
        helper.page("ritual_recipe");
        BookRitualRecipePageModel ritualRecipe = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/summon_foliot_crusher"))).build();
        helper.page("pentacle_link_hint");
        BookTextPageModel pentacleLinkHint = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        this.lang.add(helper.pageTitle(), "A Note about Ritual Recipes");
        this.lang.add(helper.pageText(), "Ritual recipe pages, such as the previous pageshow not only the ingredients, but also the pentacle that you need to draw with chalk in order to use the ritual.\n\\\n\\\n**To show the pentacle, click the blue link** at the center top of the ritual page. You can then even preview it in-world.\n".formatted(COLOR_PURPLE));
        helper.page("start_ritual");
        BookTextPageModel startRitualText = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        this.lang.add(helper.pageTitle(), "Let there be ... spirits!");
        this.lang.add(helper.pageText(), "Finally, [#](%1$s)right-click[#]() the [](item://occultism:golden_sacrificial_bowl) with the **bound** book of binding you created before and wait until the crusher spawns.\n\\\n\\\nNow all that remains is to drop appropriate ores near the crusher and wait for it to turn it into dust.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon(OccultismItems.PENTACLE.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, multiblock, bowlText, bowlPlacementImage, ritualText, ritualRecipe, pentacleLinkHint, startRitualText});
    }

    private BookEntryModel.Builder makeBrushEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("brush");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("brushRecipe");
        BookCraftingRecipePageModel brushRecipe = ((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(this.modLoc("crafting/brush"))).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon(OccultismItems.BRUSH.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, brushRecipe});
    }

    private BookEntryModel.Builder makeMoreRitualsEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("more_rituals");
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon("occultism:textures/gui/book/robe.png").withLocation(entryHelper.get(Character.valueOf(icon))).withEntryBackground(1, 1).withCategoryToOpen(this.modLoc("rituals"));
    }

    private BookEntryModel.Builder makeGreyParticlesEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("grey_particles");
        helper.page("text");
        BookTextPageModel text = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon(ForgeRegistries.ITEMS.getKey((Object)Items.f_42490_).toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{text});
    }

    private BookEntryModel.Builder makeSpiritsSubcategoryEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("spirits");
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("occultism:textures/gui/book/spirits.png").withCategoryToOpen(this.modLoc("spirits")).withEntryBackground(1, 1).withLocation(entryHelper.get(Character.valueOf(icon)));
    }

    private BookEntryModel.Builder makeChalksEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("chalks");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("impure_gold_chalk_recipe");
        BookCraftingRecipePageModel impureGoldChalkRecipe = ((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(this.modLoc("crafting/chalk_gold_impure"))).build();
        helper.page("gold_chalk_recipe");
        BookSpiritFireRecipePageModel goldChalkRecipe = ((BookSpiritFireRecipePageModel.Builder)BookSpiritFireRecipePageModel.builder().withRecipeId1(this.modLoc("spirit_fire/chalk_gold"))).build();
        helper.page("impure_purple_chalk_recipe");
        BookCraftingRecipePageModel impurePurpleChalkRecipe = ((BookCraftingRecipePageModel.Builder)((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(this.modLoc("crafting/chalk_purple_impure"))).withText(helper.pageText())).build();
        helper.page("purple_chalk_recipe");
        BookSpiritFireRecipePageModel purpleChalkRecipe = ((BookSpiritFireRecipePageModel.Builder)BookSpiritFireRecipePageModel.builder().withRecipeId1(this.modLoc("spirit_fire/chalk_purple"))).build();
        helper.page("impure_red_chalk_recipe");
        BookCraftingRecipePageModel impureRedChalkRecipe = ((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(this.modLoc("crafting/chalk_red_impure"))).build();
        helper.page("red_chalk_recipe");
        BookSpiritFireRecipePageModel redChalkRecipe = ((BookSpiritFireRecipePageModel.Builder)BookSpiritFireRecipePageModel.builder().withRecipeId1(this.modLoc("spirit_fire/chalk_red"))).build();
        helper.page("afrit_essence");
        BookSpotlightPageModel afritEssenceSpotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.AFRIT_ESSENCE.get()})).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon(OccultismItems.CHALK_GOLD.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, impureGoldChalkRecipe, goldChalkRecipe, impurePurpleChalkRecipe, purpleChalkRecipe, impureRedChalkRecipe, redChalkRecipe, afritEssenceSpotlight});
    }

    private BookEntryModel.Builder makeOtherworldGogglesEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("otherworld_goggles");
        helper.page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.OTHERWORLD_GOGGLES.get()})).withText(helper.pageText()).build();
        helper.page("crafting");
        BookTextPageModel crafting = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon(OccultismItems.OTHERWORLD_GOGGLES.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, crafting});
    }

    private BookEntryModel.Builder makeInfusedPickaxeEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("infused_pickaxe");
        helper.page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.INFUSED_PICKAXE.get()})).withText(helper.pageText()).build();
        helper.page("gem_recipe");
        BookSpiritFireRecipePageModel gemRecipe = ((BookSpiritFireRecipePageModel.Builder)((BookSpiritFireRecipePageModel.Builder)BookSpiritFireRecipePageModel.builder().withRecipeId1(this.modLoc("spirit_fire/spirit_attuned_gem"))).withText(helper.pageText())).build();
        helper.page("head_recipe");
        BookCraftingRecipePageModel headRecipe = ((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(this.modLoc("crafting/spirit_attuned_pickaxe_head"))).build();
        helper.page("crafting");
        BookTextPageModel crafting = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon(OccultismItems.INFUSED_PICKAXE.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, gemRecipe, headRecipe, crafting});
    }

    private BookEntryModel.Builder makeIesniumEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("iesnium");
        helper.page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.IESNIUM_ORE.get()})).withText(helper.pageText()).build();
        helper.page("where");
        BookTextPageModel where = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("how");
        BookTextPageModel how = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("processing");
        BookTextPageModel processing = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("uses");
        BookTextPageModel uses = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon(OccultismBlocks.IESNIUM_ORE.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, where, how, processing, uses});
    }

    private BookEntryModel.Builder makeIesniumPickaxeEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("iesnium_pickaxe");
        helper.page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.IESNIUM_PICKAXE.get()})).withText(helper.pageText()).build();
        helper.page("crafting");
        BookCraftingRecipePageModel crafting = ((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(this.modLoc("crafting/iesnium_pickaxe"))).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon(OccultismItems.IESNIUM_PICKAXE.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, crafting});
    }

    private BookEntryModel.Builder makeMagicLampsEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("magic_lamps");
        helper.page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()})).withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("crafting");
        BookCraftingRecipePageModel crafting = ((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(this.modLoc("crafting/magic_lamp_empty"))).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon(OccultismItems.MAGIC_LAMP_EMPTY.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, crafting});
    }

    private BookEntryModel.Builder makeSpiritMinersEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("spirit_miners");
        helper.page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MINER_FOLIOT_UNSPECIALIZED.get()})).withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("crafting");
        BookTextPageModel crafting = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon(OccultismItems.MINER_FOLIOT_UNSPECIALIZED.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, crafting});
    }

    private BookEntryModel.Builder makeMineshaftEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("mineshaft");
        helper.page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.DIMENSIONAL_MINESHAFT.get()})).withText(helper.pageText()).build();
        helper.page("crafting");
        BookTextPageModel crafting = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon(OccultismBlocks.DIMENSIONAL_MINESHAFT.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, crafting});
    }

    private BookEntryModel.Builder makeStorageEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("storage");
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon(OccultismBlocks.STORAGE_CONTROLLER.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withEntryBackground(1, 1).withCategoryToOpen(this.modLoc("storage"));
    }

    private BookEntryModel.Builder makePossessionRitualsEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("possession_rituals");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("more");
        BookTextPageModel more = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon("occultism:textures/gui/book/possession.png").withLocation(entryHelper.get(Character.valueOf(icon))).withEntryBackground(1, 1).withPages(new BookPageModel[]{intro, more});
    }

    private BookEntryModel.Builder makeFamiliarRitualsEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("familiar_rituals");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("more");
        BookTextPageModel more = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon("occultism:textures/gui/book/parrot.png").withLocation(entryHelper.get(Character.valueOf(icon))).withEntryBackground(1, 1).withPages(new BookPageModel[]{intro, more});
    }

    private BookEntryModel.Builder makeSummoningRitualsEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("summoning_rituals");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("more");
        BookTextPageModel more = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon("occultism:textures/gui/book/summoning.png").withLocation(entryHelper.get(Character.valueOf(icon))).withEntryBackground(1, 1).withPages(new BookPageModel[]{intro, more});
    }

    private BookEntryModel.Builder makeCraftingRitualsEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("crafting_rituals");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("more");
        BookTextPageModel more = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon("occultism:textures/gui/book/infusion.png").withLocation(entryHelper.get(Character.valueOf(icon))).withEntryBackground(1, 1).withPages(new BookPageModel[]{intro, more});
    }

    private BookCategoryModel makeSpiritsSubcategory(BookLangHelper helper) {
        helper.category("spirits");
        EntryLocationHelper entryHelper = ModonomiconAPI.get().getEntryLocationHelper();
        entryHelper.setMap(new String[]{"___________________________", "___________________________", "___<_0_n_u_w_______________", "___________________________", "_____d_____________________", "___________________________", "___________________________"});
        BookEntryModel.Builder overview = this.makeSpiritsOverviewEntry(helper, entryHelper, '0');
        BookEntryModel.Builder returnToGettingStarted = this.makeReturnToGettingStartedEntry(helper, entryHelper, '<');
        returnToGettingStarted.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        returnToGettingStarted.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        BookEntryModel.Builder essenceDecay = this.makeEssenceDecayEntry(helper, entryHelper, 'd');
        essenceDecay.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder trueNames = this.makeTrueNamesEntry(helper, entryHelper, 'n');
        trueNames.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder unboundSpirits = this.makeUnboundSpiritsEntry(helper, entryHelper, 'u');
        unboundSpirits.withParent(BookEntryParentModel.builder().withEntryId(trueNames.id).build());
        BookEntryModel.Builder wildHunt = this.makeWildHuntEntry(helper, entryHelper, 'w');
        wildHunt.withParent(BookEntryParentModel.builder().withEntryId(unboundSpirits.id).build());
        return BookCategoryModel.create((ResourceLocation)this.modLoc(helper.category), (String)helper.categoryName()).withIcon("occultism:textures/gui/book/spirits.png").withShowCategoryButton(false).withEntries(new BookEntryModel[]{overview.build(), returnToGettingStarted.build(), trueNames.build(), essenceDecay.build(), unboundSpirits.build(), wildHunt.build()});
    }

    private BookEntryModel.Builder makeReturnToGettingStartedEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("return_to_getting_started");
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.DICTIONARY_OF_SPIRITS_ICON.getId().toString()).withCategoryToOpen(this.modLoc("getting_started")).withEntryBackground(1, 2).withLocation(entryHelper.get(Character.valueOf(icon)));
    }

    private BookEntryModel.Builder makeSpiritsOverviewEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("overview");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("shapes");
        BookTextPageModel shapes = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("tiers");
        BookTextPageModel tiers = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("foliot");
        BookTextPageModel foliot = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("djinni");
        BookTextPageModel djinni = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("afrit");
        BookTextPageModel afrit = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("marid");
        BookTextPageModel marid = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("greater_spirits");
        BookTextPageModel greaterSpirits = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon("occultism:textures/gui/book/spirits.png").withLocation(entryHelper.get(Character.valueOf(icon))).withEntryBackground(0, 1).withPages(new BookPageModel[]{intro, shapes, tiers, foliot, djinni, afrit, marid, greaterSpirits});
    }

    private BookEntryModel.Builder makeEssenceDecayEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("essence_decay");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("countermeasures");
        BookTextPageModel countermeasures = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("affected_spirits");
        BookTextPageModel affectedSpirits = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon(ForgeRegistries.ITEMS.getKey((Object)Items.f_42583_).toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, countermeasures, affectedSpirits});
    }

    private BookEntryModel.Builder makeTrueNamesEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("true_names");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("finding_names");
        BookTextPageModel findingNames = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("using_names");
        BookTextPageModel usingNames = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon(ForgeRegistries.ITEMS.getKey((Object)Items.f_42614_).toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, findingNames, usingNames});
    }

    private BookEntryModel.Builder makeUnboundSpiritsEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("unbound_spirits");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("unbound");
        BookTextPageModel unbound = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("unbound2");
        BookTextPageModel unbound2 = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("essence");
        BookTextPageModel essence = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon("occultism:textures/gui/book/unbound_spirits.png").withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, unbound, unbound2, essence});
    }

    private BookEntryModel.Builder makeWildHuntEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("wild_hunt");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("wither_skull");
        BookTextPageModel witherSkull = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon("occultism:textures/gui/book/wild_hunt.png").withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, witherSkull});
    }

    private BookCategoryModel makePentaclesCategory(BookLangHelper helper) {
        helper.category("pentacles");
        EntryLocationHelper entryHelper = ModonomiconAPI.get().getEntryLocationHelper();
        entryHelper.setMap(new String[]{"____________________", "__p_a_b_c_d_e_f_____", "____________________", "__o___g_h_i_________", "____________________", "__u_j_k_l_m_________", "____________________"});
        BookEntryModel.Builder overview = this.makePentaclesOverviewEntry(helper, entryHelper, 'o');
        BookEntryModel.Builder paraphernalia = this.makeParaphernaliaEntry(helper, entryHelper, 'p');
        paraphernalia.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder chalkUses = this.makeChalkUsesEntry(helper, entryHelper, 'u');
        chalkUses.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder summonFoliot = this.makeSummonFoliotEntry(helper, entryHelper, 'a');
        summonFoliot.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder summonDjinni = this.makeSummonDjinniEntry(helper, entryHelper, 'b');
        summonDjinni.withParent(BookEntryParentModel.builder().withEntryId(summonFoliot.id).build());
        BookEntryModel.Builder summonWildAfrit = this.makeSummonWildAfritEntry(helper, entryHelper, 'c');
        summonWildAfrit.withParent(BookEntryParentModel.builder().withEntryId(summonDjinni.id).build());
        BookEntryModel.Builder summonAfrit = this.makeSummonAfritEntry(helper, entryHelper, 'd');
        summonAfrit.withParent(BookEntryParentModel.builder().withEntryId(summonWildAfrit.id).build());
        BookEntryModel.Builder summonMarid = this.makeSummonMaridEntry(helper, entryHelper, 'e');
        summonMarid.withParent(BookEntryParentModel.builder().withEntryId(summonAfrit.id).build());
        BookEntryModel.Builder summonWildGreaterSpirit = this.makeSummonWildGreaterSpiritEntry(helper, entryHelper, 'f');
        summonWildGreaterSpirit.withParent(BookEntryParentModel.builder().withEntryId(summonMarid.id).build());
        BookEntryModel.Builder possessFoliot = this.makePossessFoliotEntry(helper, entryHelper, 'g');
        possessFoliot.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder possessDjinni = this.makePossessDjinniEntry(helper, entryHelper, 'h');
        possessDjinni.withParent(BookEntryParentModel.builder().withEntryId(possessFoliot.id).build());
        BookEntryModel.Builder possessAfrit = this.makePossessAfritEntry(helper, entryHelper, 'i');
        possessAfrit.withParent(BookEntryParentModel.builder().withEntryId(possessDjinni.id).build());
        BookEntryModel.Builder craftFoliot = this.makeCraftFoliotEntry(helper, entryHelper, 'j');
        craftFoliot.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder craftDjinni = this.makeCraftDjinniEntry(helper, entryHelper, 'k');
        craftDjinni.withParent(BookEntryParentModel.builder().withEntryId(craftFoliot.id).build());
        BookEntryModel.Builder craftAfrit = this.makeCraftAfritEntry(helper, entryHelper, 'l');
        craftAfrit.withParent(BookEntryParentModel.builder().withEntryId(craftDjinni.id).build());
        BookEntryModel.Builder craftMarid = this.makeCraftMaridEntry(helper, entryHelper, 'm');
        craftMarid.withParent(BookEntryParentModel.builder().withEntryId(craftAfrit.id).build());
        overview.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        paraphernalia.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        chalkUses.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        summonFoliot.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        summonDjinni.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        summonWildAfrit.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        summonAfrit.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        summonMarid.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        summonWildGreaterSpirit.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        possessFoliot.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        possessDjinni.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        possessAfrit.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        craftFoliot.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        craftDjinni.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        craftAfrit.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        craftMarid.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        return BookCategoryModel.create((ResourceLocation)this.modLoc(helper.category), (String)helper.categoryName()).withIcon(OccultismItems.PENTACLE.getId().toString()).withEntries(new BookEntryModel[]{overview.build(), paraphernalia.build(), chalkUses.build(), summonFoliot.build(), summonDjinni.build(), summonWildAfrit.build(), summonAfrit.build(), summonMarid.build(), summonWildGreaterSpirit.build(), possessFoliot.build(), possessDjinni.build(), possessAfrit.build(), craftFoliot.build(), craftDjinni.build(), craftAfrit.build(), craftMarid.build()});
    }

    private BookEntryModel.Builder makePentaclesOverviewEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("pentacles_overview");
        helper.page("intro1");
        BookTextPageModel intro1 = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("intro2");
        BookTextPageModel intro2 = BookTextPageModel.builder().withText(helper.pageText()).build();
        helper.page("intro3");
        BookTextPageModel intro3 = BookTextPageModel.builder().withText(helper.pageText()).build();
        helper.page("intro4");
        BookTextPageModel intro4 = BookTextPageModel.builder().withText(helper.pageText()).build();
        helper.page("bowl_placement");
        BookImagePageModel bowlPlacementImage = BookImagePageModel.builder().withImages(new ResourceLocation[]{this.modLoc("textures/gui/book/bowl_placement.png")}).withBorder(true).build();
        helper.page("bowl_text");
        BookTextPageModel bowlText = BookTextPageModel.builder().withText(helper.pageText()).build();
        helper.page("summoning_pentacles");
        BookTextPageModel summoningPentacles = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("infusion_pentacles");
        BookTextPageModel infusionPentacles = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("possession_pentacles");
        BookTextPageModel possessionPentacles = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withEntryBackground(0, 1).withPages(new BookPageModel[]{intro1, intro2, intro3, intro4, bowlPlacementImage, bowlText, summoningPentacles, infusionPentacles, possessionPentacles});
    }

    private BookEntryModel.Builder makeParaphernaliaEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("paraphernalia");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("candle");
        BookSpotlightPageModel candle = BookSpotlightPageModel.builder().withText(helper.pageText()).withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.CANDLE_WHITE.get()})).build();
        helper.page("crystal");
        BookSpotlightPageModel crystal = BookSpotlightPageModel.builder().withText(helper.pageText()).withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.get()})).build();
        helper.page("gem_recipe");
        BookSpiritFireRecipePageModel gemRecipe = ((BookSpiritFireRecipePageModel.Builder)BookSpiritFireRecipePageModel.builder().withRecipeId1(this.modLoc("spirit_fire/spirit_attuned_gem"))).build();
        helper.page("crystal_recipe");
        BookCraftingRecipePageModel crystalRecipe = ((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(this.modLoc("crafting/spirit_attuned_crystal"))).build();
        helper.page("skeleton_skull");
        BookSpotlightPageModel skeletonSkull = BookSpotlightPageModel.builder().withText(helper.pageText()).withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50310_})).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50310_).toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, candle, crystal, gemRecipe, crystalRecipe, skeletonSkull});
    }

    private BookEntryModel.Builder makeChalkUsesEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("chalk_uses");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("intro2");
        BookTextPageModel intro2 = BookTextPageModel.builder().withText(helper.pageText()).build();
        helper.page("white_chalk");
        BookSpotlightPageModel whiteChalk = BookSpotlightPageModel.builder().withText(helper.pageText()).withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.CHALK_WHITE.get()})).build();
        helper.page("white_chalk_uses");
        BookTextPageModel whiteChalkUses = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("white_chalk_uses2");
        BookTextPageModel whiteChalkUses2 = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("golden_chalk");
        BookSpotlightPageModel goldChalk = BookSpotlightPageModel.builder().withText(helper.pageText()).withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.CHALK_GOLD.get()})).build();
        helper.page("golden_chalk_uses");
        BookTextPageModel goldChalkUses = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("purple_chalk");
        BookSpotlightPageModel purpleChalk = BookSpotlightPageModel.builder().withText(helper.pageText()).withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.CHALK_PURPLE.get()})).build();
        helper.page("purple_chalk_uses");
        BookTextPageModel purpleChalkUses = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("red_chalk");
        BookSpotlightPageModel redChalk = BookSpotlightPageModel.builder().withText(helper.pageText()).withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.CHALK_RED.get()})).build();
        helper.page("red_chalk_uses");
        BookTextPageModel redChalkUses = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.CHALK_PURPLE.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, intro2, whiteChalk, whiteChalkUses, whiteChalkUses2, goldChalk, goldChalkUses, purpleChalk, purpleChalkUses, redChalk, redChalkUses});
    }

    private BookEntryModel.Builder makeSummonFoliotEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("summon_foliot");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("multiblock");
        BookMultiblockPageModel multiblock = BookMultiblockPageModel.builder().withMultiblockId(this.modLoc("summon_foliot")).build();
        helper.page("uses");
        BookTextPageModel uses = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.PENTACLE.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, multiblock, uses});
    }

    private BookEntryModel.Builder makePossessFoliotEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("possess_foliot");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("multiblock");
        BookMultiblockPageModel multiblock = BookMultiblockPageModel.builder().withMultiblockId(this.modLoc("possess_foliot")).build();
        helper.page("uses");
        BookTextPageModel uses = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.PENTACLE.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, multiblock, uses});
    }

    private BookEntryModel.Builder makeCraftFoliotEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("craft_foliot");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("multiblock");
        BookMultiblockPageModel multiblock = BookMultiblockPageModel.builder().withMultiblockId(this.modLoc("craft_foliot")).build();
        helper.page("uses");
        BookTextPageModel uses = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.PENTACLE.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, multiblock, uses});
    }

    private BookEntryModel.Builder makeSummonDjinniEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("summon_djinni");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("multiblock");
        BookMultiblockPageModel multiblock = BookMultiblockPageModel.builder().withMultiblockId(this.modLoc("summon_djinni")).build();
        helper.page("uses");
        BookTextPageModel uses = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.PENTACLE.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, multiblock, uses});
    }

    private BookEntryModel.Builder makePossessDjinniEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("possess_djinni");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("multiblock");
        BookMultiblockPageModel multiblock = BookMultiblockPageModel.builder().withMultiblockId(this.modLoc("possess_djinni")).build();
        helper.page("uses");
        BookTextPageModel uses = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("uses2");
        BookTextPageModel uses2 = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.PENTACLE.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, multiblock, uses, uses2});
    }

    private BookEntryModel.Builder makeCraftDjinniEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("craft_djinni");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("multiblock");
        BookMultiblockPageModel multiblock = BookMultiblockPageModel.builder().withMultiblockId(this.modLoc("craft_djinni")).build();
        helper.page("uses");
        BookTextPageModel uses = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.PENTACLE.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, multiblock, uses});
    }

    private BookEntryModel.Builder makeSummonAfritEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("summon_afrit");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("multiblock");
        BookMultiblockPageModel multiblock = BookMultiblockPageModel.builder().withMultiblockId(this.modLoc("summon_afrit")).build();
        helper.page("uses");
        BookTextPageModel uses = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.PENTACLE.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, multiblock, uses});
    }

    private BookEntryModel.Builder makeSummonWildAfritEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("summon_wild_afrit");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("multiblock");
        BookMultiblockPageModel multiblock = BookMultiblockPageModel.builder().withMultiblockId(this.modLoc("summon_wild_afrit")).build();
        helper.page("uses");
        BookTextPageModel uses = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.PENTACLE.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, multiblock, uses});
    }

    private BookEntryModel.Builder makePossessAfritEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("possess_afrit");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("multiblock");
        BookMultiblockPageModel multiblock = BookMultiblockPageModel.builder().withMultiblockId(this.modLoc("possess_afrit")).build();
        helper.page("uses");
        BookTextPageModel uses = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.PENTACLE.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, multiblock, uses});
    }

    private BookEntryModel.Builder makeCraftAfritEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("craft_afrit");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("multiblock");
        BookMultiblockPageModel multiblock = BookMultiblockPageModel.builder().withMultiblockId(this.modLoc("craft_afrit")).build();
        helper.page("uses");
        BookTextPageModel uses = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.PENTACLE.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, multiblock, uses});
    }

    private BookEntryModel.Builder makeSummonMaridEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("summon_marid");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("multiblock");
        BookMultiblockPageModel multiblock = BookMultiblockPageModel.builder().withMultiblockId(this.modLoc("summon_marid")).build();
        helper.page("uses");
        BookTextPageModel uses = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.PENTACLE.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, multiblock, uses});
    }

    private BookEntryModel.Builder makeCraftMaridEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("craft_marid");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("multiblock");
        BookMultiblockPageModel multiblock = BookMultiblockPageModel.builder().withMultiblockId(this.modLoc("craft_marid")).build();
        helper.page("uses");
        BookTextPageModel uses = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.PENTACLE.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, multiblock, uses});
    }

    private BookEntryModel.Builder makeSummonWildGreaterSpiritEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("summon_wild_greater_spirit");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("multiblock");
        BookMultiblockPageModel multiblock = BookMultiblockPageModel.builder().withMultiblockId(this.modLoc("summon_wild_greater_spirit")).build();
        helper.page("uses");
        BookTextPageModel uses = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.PENTACLE.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, multiblock, uses});
    }

    private BookCategoryModel makeRitualsCategory(BookLangHelper helper) {
        helper.category("rituals");
        EntryLocationHelper entryHelper = ModonomiconAPI.get().getEntryLocationHelper();
        entryHelper.setMap(new String[]{"___________________", "______________p_s__", "___________________", "________o_i_k______", "___________________", "______________c_f__", "___________________"});
        BookEntryModel.Builder ritualOverview = this.makeRitualOverviewEntry(helper, entryHelper, 'o');
        BookEntryModel.Builder itemUse = this.makeItemUseEntry(helper, entryHelper, 'i');
        itemUse.withParent(BookEntryParentModel.builder().withEntryId(ritualOverview.id).build());
        BookEntryModel.Builder sacrifice = this.makeSacrificeEntry(helper, entryHelper, 'k');
        sacrifice.withParent(BookEntryParentModel.builder().withEntryId(itemUse.id).build());
        BookEntryModel.Builder summoning = this.makeSummoningRitualsSubcategoryEntry(helper, entryHelper, 's');
        summoning.withParent(BookEntryParentModel.builder().withEntryId(sacrifice.id).build());
        BookEntryModel.Builder possession = this.makePossessionRitualsSubcategoryEntry(helper, entryHelper, 'p');
        possession.withParent(BookEntryParentModel.builder().withEntryId(sacrifice.id).build());
        BookEntryModel.Builder crafting = this.makeCraftingRitualsSubcategoryEntry(helper, entryHelper, 'c');
        crafting.withParent(BookEntryParentModel.builder().withEntryId(sacrifice.id).build());
        BookEntryModel.Builder familiars = this.makeFamiliarRitualsSubcategoryEntry(helper, entryHelper, 'f');
        familiars.withParent(BookEntryParentModel.builder().withEntryId(sacrifice.id).build());
        itemUse.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        sacrifice.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        summoning.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        possession.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        crafting.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        familiars.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        return BookCategoryModel.create((ResourceLocation)this.modLoc(helper.category), (String)helper.categoryName()).withIcon("occultism:textures/gui/book/robe.png").withEntries(new BookEntryModel[]{ritualOverview.build(), itemUse.build(), sacrifice.build(), summoning.build(), possession.build(), crafting.build(), familiars.build()});
    }

    private BookEntryModel.Builder makeRitualOverviewEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("overview");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("steps");
        BookTextPageModel steps = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("additional_requirements");
        BookTextPageModel additional_requirements = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("occultism:textures/gui/book/robe.png").withLocation(entryHelper.get(Character.valueOf(icon))).withEntryBackground(0, 1).withPages(new BookPageModel[]{intro, steps, additional_requirements});
    }

    private BookEntryModel.Builder makeSacrificeEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("sacrifice");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(ForgeRegistries.ITEMS.getKey((Object)Items.f_42383_).toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro});
    }

    private BookEntryModel.Builder makeItemUseEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("item_use");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(ForgeRegistries.ITEMS.getKey((Object)Items.f_42409_).toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro});
    }

    private BookEntryModel.Builder makeSummoningRitualsSubcategoryEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("summoning_rituals");
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("occultism:textures/gui/book/summoning.png").withCategoryToOpen(this.modLoc("summoning_rituals")).withEntryBackground(1, 1).withLocation(entryHelper.get(Character.valueOf(icon)));
    }

    private BookEntryModel.Builder makePossessionRitualsSubcategoryEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("possession_rituals");
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("occultism:textures/gui/book/possession.png").withCategoryToOpen(this.modLoc("possession_rituals")).withEntryBackground(1, 1).withLocation(entryHelper.get(Character.valueOf(icon)));
    }

    private BookEntryModel.Builder makeCraftingRitualsSubcategoryEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("crafting_rituals");
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("occultism:textures/gui/book/infusion.png").withCategoryToOpen(this.modLoc("crafting_rituals")).withEntryBackground(1, 1).withLocation(entryHelper.get(Character.valueOf(icon)));
    }

    private BookEntryModel.Builder makeFamiliarRitualsSubcategoryEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("familiar_rituals");
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("occultism:textures/gui/book/parrot.png").withCategoryToOpen(this.modLoc("familiar_rituals")).withEntryBackground(1, 1).withLocation(entryHelper.get(Character.valueOf(icon)));
    }

    private BookEntryModel.Builder makeReturnToRitualsEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("return_to_rituals");
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("occultism:textures/gui/book/robe.png").withCategoryToOpen(this.modLoc("rituals")).withEntryBackground(1, 2).withLocation(entryHelper.get(Character.valueOf(icon)));
    }

    private BookCategoryModel makeSummoningRitualsSubcategory(BookLangHelper helper) {
        helper.category("summoning_rituals");
        EntryLocationHelper entryHelper = ModonomiconAPI.get().getEntryLocationHelper();
        entryHelper.setMap(new String[]{"___________b___l______", "______________________", "_________c_d_h_k______", "______________________", "___r_o________________", "______________________", "_________1_e_i_a_m___", "______________________", "_________2_f_j________", "______________________", "_________3_g__________", "______________________", "_________4____________"});
        BookEntryModel.Builder overview = this.makeSummoningRitualsOverviewEntry(helper, entryHelper, 'o');
        BookEntryModel.Builder returnToRituals = this.makeReturnToRitualsEntry(helper, entryHelper, 'r');
        returnToRituals.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        returnToRituals.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        BookEntryModel.Builder summonT1Crusher = this.makeSummonCrusherT1Entry(helper, entryHelper, '1');
        summonT1Crusher.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder summonT2Crusher = this.makeSummonCrusherT2Entry(helper, entryHelper, '2');
        summonT2Crusher.withParent(BookEntryParentModel.builder().withEntryId(summonT1Crusher.id).build());
        BookEntryModel.Builder summonT3Crusher = this.makeSummonCrusherT3Entry(helper, entryHelper, '3');
        summonT3Crusher.withParent(BookEntryParentModel.builder().withEntryId(summonT2Crusher.id).build());
        BookEntryModel.Builder summonT4Crusher = this.makeSummonCrusherT4Entry(helper, entryHelper, '4');
        summonT4Crusher.withParent(BookEntryParentModel.builder().withEntryId(summonT3Crusher.id).build());
        BookEntryModel.Builder summonLumberjack = this.makeSummonLumberjackEntry(helper, entryHelper, 'c');
        summonLumberjack.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder summonTransportItems = this.makeSummonTransportItemsEntry(helper, entryHelper, 'd');
        summonTransportItems.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder summonCleaner = this.makeSummonCleanerEntry(helper, entryHelper, 'b');
        summonCleaner.withParent(BookEntryParentModel.builder().withEntryId(summonTransportItems.id).build());
        BookEntryModel.Builder summonManageMachine = this.makeSummonManageMachineEntry(helper, entryHelper, 'h');
        summonManageMachine.withParent(BookEntryParentModel.builder().withEntryId(summonTransportItems.id).build());
        BookEntryModel.Builder tradeSpirits = this.makeTradeSpiritsEntry(helper, entryHelper, 'e');
        tradeSpirits.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder summonOtherworldSaplingTrader = this.makeSummonOtherworldSaplingTraderEntry(helper, entryHelper, 'f');
        summonOtherworldSaplingTrader.withParent(BookEntryParentModel.builder().withEntryId(tradeSpirits.id).build());
        BookEntryModel.Builder summonOtherstoneTrader = this.makeSummonOtherstoneTraderEntry(helper, entryHelper, 'g');
        summonOtherstoneTrader.withParent(BookEntryParentModel.builder().withEntryId(summonOtherworldSaplingTrader.id).build());
        BookEntryModel.Builder summonWildParrot = this.makeSummonWildParrotEntry(helper, entryHelper, 'i');
        summonWildParrot.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder summonWildOtherworldBird = this.makeSummonWildOtherworldBirdEntry(helper, entryHelper, 'j');
        summonWildOtherworldBird.withParent(BookEntryParentModel.builder().withEntryId(summonWildParrot.id).build());
        BookEntryModel.Builder weatherMagic = this.makeWeatherMagicEntry(helper, entryHelper, 'k');
        weatherMagic.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder timeMagic = this.makeTimeMagicEntry(helper, entryHelper, 'l');
        timeMagic.withParent(BookEntryParentModel.builder().withEntryId(weatherMagic.id).build());
        BookEntryModel.Builder afritEssence = this.makeAfritEssenceEntry(helper, entryHelper, 'a');
        afritEssence.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder witherSkull = this.makeWitherSkullEntry(helper, entryHelper, 'm');
        witherSkull.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        overview.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        summonT1Crusher.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        summonT2Crusher.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        summonT3Crusher.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        summonT4Crusher.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        summonLumberjack.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        summonTransportItems.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        summonCleaner.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        summonManageMachine.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        tradeSpirits.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        summonOtherworldSaplingTrader.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        summonOtherstoneTrader.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        summonWildParrot.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        summonWildOtherworldBird.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        weatherMagic.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        timeMagic.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        afritEssence.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        witherSkull.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        return BookCategoryModel.create((ResourceLocation)this.modLoc(helper.category), (String)helper.categoryName()).withIcon("occultism:textures/gui/book/summoning.png").withShowCategoryButton(false).withEntries(new BookEntryModel[]{overview.build(), returnToRituals.build(), afritEssence.build(), summonCleaner.build(), summonT1Crusher.build(), summonT2Crusher.build(), summonT3Crusher.build(), summonT4Crusher.build(), summonLumberjack.build(), summonManageMachine.build(), summonTransportItems.build(), tradeSpirits.build(), summonOtherstoneTrader.build(), summonOtherworldSaplingTrader.build(), summonWildOtherworldBird.build(), summonWildParrot.build(), timeMagic.build(), weatherMagic.build(), witherSkull.build(), afritEssence.build()});
    }

    private BookEntryModel.Builder makeSummoningRitualsOverviewEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("overview");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("occultism:textures/gui/book/summoning.png").withLocation(entryHelper.get(Character.valueOf(icon))).withEntryBackground(0, 1).withPages(new BookPageModel[]{intro});
    }

    private BookEntryModel.Builder makeAfritEssenceEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("afrit_essence");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/summon_wild_afrit"))).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.AFRIT_ESSENCE.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, ritual});
    }

    private BookEntryModel.Builder makeSummonCrusherT1Entry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("summon_crusher_t1");
        this.lang.add(helper.entryName(), "Summon Foliot Crusher");
        helper.page("about_crushers");
        BookTextPageModel aboutCrushers = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        this.lang.add(helper.pageTitle(), "Crusher Spirits");
        this.lang.add(helper.pageText(), "Crusher spirits are summoned to crush ores into dusts, effectively multiplying the metal output. They will pick up appropriate ores and drop the resulting dusts into the world. A purple particle effect and a crushing sound indicate the crusher is at work.\n");
        helper.page("automation");
        BookTextPageModel automation = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        this.lang.add(helper.pageTitle(), "Automation");
        this.lang.add(helper.pageText(), "To ease automation, try summoning a [Transporter Spirit](entry://occultism:dictionary_of_spirits/summoning_rituals/summon_transport_items)\nto place items from chests in the crusher's inventory, and a [Janitor Spirit](entry://occultism:dictionary_of_spirits/summoning_rituals/summon_cleaner) to collect the processed items.\n");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        this.lang.add(helper.pageTitle(), "Foliot Crusher");
        this.lang.add(helper.pageText(), "The foliot crusher is the most basic crusher spirit.\n\\\n\\\nIt will crush **one** ore into **two** corresponding dusts.\n");
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/summon_foliot_crusher"))).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.COPPER_DUST.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{aboutCrushers, automation, intro, ritual});
    }

    private BookEntryModel.Builder makeSummonCrusherT2Entry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("summon_crusher_t2");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/summon_djinni_crusher"))).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.IRON_DUST.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, ritual});
    }

    private BookEntryModel.Builder makeSummonCrusherT3Entry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("summon_crusher_t3");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/summon_afrit_crusher"))).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.SILVER_DUST.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, ritual});
    }

    private BookEntryModel.Builder makeSummonCrusherT4Entry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("summon_crusher_t4");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/summon_marid_crusher"))).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.GOLD_DUST.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, ritual});
    }

    private BookEntryModel.Builder makeSummonLumberjackEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("summon_lumberjack");
        this.lang.add(helper.entryName(), "Summon Foliot Lumberjack");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        this.lang.add(helper.pageTitle(), "Foliot Lumberjack");
        this.lang.add(helper.pageText(), "The lumberjack will harvest trees in it's working area. If a deposit location is set it will collect the dropped items into the specified chest, and re-plant saplings.\n");
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/summon_foliot_lumberjack"))).build();
        helper.page("book_of_calling");
        BookCraftingRecipePageModel bookOfCalling = ((BookCraftingRecipePageModel.Builder)((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(this.modLoc("crafting/book_of_calling_foliot_lumberjack"))).withText(helper.pageText())).build();
        this.lang.add(helper.pageText(), "If you lose the book of calling, you can craft a new one.\n[#](%1$s)Shift-right-click[#]() the spirit with the crafted book to assign it.\n".formatted(COLOR_PURPLE));
        helper.page("usage");
        BookTextPageModel usage = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        this.lang.add(helper.pageTitle(), "Usage");
        this.lang.add(helper.pageText(), "Use the book of calling to set the work area and deposit location of the lumberjack.\n\\\n\\\nSee [Books of Calling](entry://getting_started/books_of_calling) for more information.\n");
        helper.page("usage2");
        BookTextPageModel usage2 = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        this.lang.add(helper.pageTitle(), "Lazy Lumberjack?");
        this.lang.add(helper.pageText(), "The spirit might pause for a few minutes after clearing his work area, even if trees have regrown since. This is a performance-saving measure and not a bug, he will continue on his own.\n\\\n\\\nSet the work area again to make him continue work immediately.\n");
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.BRUSH.getId().toString()).withIcon(ForgeRegistries.ITEMS.getKey((Object)Items.f_42386_).toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, ritual, bookOfCalling, usage, usage2});
    }

    private BookEntryModel.Builder makeSummonTransportItemsEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("summon_transport_items");
        this.lang.add(helper.entryName(), "Summon Foliot Transporter");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        this.lang.add(helper.pageTitle(), "Foliot Transporter");
        this.lang.add(helper.pageText(), "The transporter is useful in that you don't need a train of hoppers transporting stuff, and can use any inventory to take from and deposit.\n\\\n\\\nTo make it take from an inventory simply sneak and interact with it's book of calling on the inventory you want.\n");
        helper.page("intro2");
        BookTextPageModel intro2 = BookTextPageModel.builder().withText(helper.pageText()).build();
        this.lang.add(helper.pageText(), "You can also dictate which inventory it deposits to in the same way.\n\\\nThe transporter will move all items it can access from one inventory to another, including machines. It can also deposit into the inventories of other spirits. By setting the extract and insert side they can be used to automate various transport tasks.\n");
        helper.page("spirit_inventories");
        BookTextPageModel spirit_inventories = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        this.lang.add(helper.pageTitle(), "Spirit Inventories");
        this.lang.add(helper.pageText(), "The Transporter can also interact with the inventories of other spirits. This is especially useful to automatically supply a [Crusher spirit](entry://summoning_rituals/summon_crusher_t1) with items to crush.\n");
        helper.page("item_filters");
        BookTextPageModel itemFilters = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        this.lang.add(helper.pageTitle(), "Item Filters");
        this.lang.add(helper.pageText(), "By default the Transporter is in \"Blacklist\" mode and will not move anything. Shift-click the transporter to open the config UI. You can then add items to the filter list to make it move only those items, or set it to \"Whitelist\" to move everything *except* the filtered items. You can also enter a tag in the text field below to filter by tag.\n");
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/summon_foliot_transport_items"))).build();
        helper.page("book_of_calling");
        BookCraftingRecipePageModel bookOfCalling = ((BookCraftingRecipePageModel.Builder)((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(this.modLoc("crafting/book_of_calling_foliot_transport_items"))).withText(helper.pageText())).build();
        this.lang.add(helper.pageText(), "If you lose the book of calling, you can craft a new one.\n[#](%1$s)Shift-right-click[#]() the spirit with the crafted book to assign it.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(ForgeRegistries.ITEMS.getKey((Object)Items.f_42449_).toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, intro2, spirit_inventories, itemFilters, ritual, bookOfCalling});
    }

    private BookEntryModel.Builder makeSummonCleanerEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("summon_cleaner");
        this.lang.add(helper.entryName(), "Summon Foliot Janitor");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        this.lang.add(helper.pageTitle(), "Foliot Janitor");
        this.lang.add(helper.pageText(), "The janitor will pick up dropped items and deposit them into a target inventory. You can configure an allow/block list to specify which items to pick up or ignore. **Warning**: By default it is set to \"allow\" mode, so it will only pick up items you specify in the allow list.\nYou can use tags to handle whole groups of items.\n");
        helper.page("intro2");
        BookTextPageModel intro2 = BookTextPageModel.builder().withText(helper.pageText()).build();
        this.lang.add(helper.pageText(), "To bind the janitor to an inventory simply sneak and interact with the janitor book of calling on that inventory. You can also interact with a block while holding the janitor book of calling to have it deposit items there. You can also have it wander around a select area by pulling up that interface. To configure an allow/block list sneak and interact with the janitor.\n");
        helper.page("tip");
        BookTextPageModel tip = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        this.lang.add(helper.pageTitle(), "Pro tip");
        this.lang.add(helper.pageText(), "The Janitor will pick up crushed items from a [Crusher spirit](entry://summoning_rituals/summon_crusher_t1) and deposit them into a chest.\n\\\n\\\nCombine that with a [Transporter Spirit](entry://summoning_rituals/summon_transport_items) to automate the whole process.\n");
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/summon_foliot_cleaner"))).build();
        helper.page("book_of_calling");
        BookCraftingRecipePageModel bookOfCalling = ((BookCraftingRecipePageModel.Builder)((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(this.modLoc("crafting/book_of_calling_foliot_cleaner"))).withText(helper.pageText())).build();
        this.lang.add(helper.pageText(), "If you lose the book of calling, you can craft a new one.\n[#](%1$s)Shift-right-click[#]() the spirit with the crafted book to assign it.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.BRUSH.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, intro2, tip, ritual, bookOfCalling});
    }

    private BookEntryModel.Builder makeSummonManageMachineEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("summon_manage_machine");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("tutorial");
        BookTextPageModel tutorial = BookTextPageModel.builder().withText(helper.pageText()).build();
        helper.page("tutorial2");
        BookTextPageModel tutorial2 = BookTextPageModel.builder().withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/summon_djinni_manage_machine"))).build();
        helper.page("book_of_calling");
        BookCraftingRecipePageModel bookOfCalling = ((BookCraftingRecipePageModel.Builder)((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(this.modLoc("crafting/book_of_calling_djinni_manage_machine"))).withText(helper.pageText())).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(ForgeRegistries.ITEMS.getKey((Object)Items.f_41966_).toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, tutorial, tutorial2, ritual, bookOfCalling});
    }

    private BookEntryModel.Builder makeTradeSpiritsEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("trade_spirits");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("intro2");
        BookTextPageModel intro2 = BookTextPageModel.builder().withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("occultism:textures/gui/book/cash.png").withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, intro2});
    }

    private BookEntryModel.Builder makeSummonOtherstoneTraderEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("summon_otherstone_trader");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("trade");
        BookSpiritTradeRecipePageModel trade = ((BookSpiritTradeRecipePageModel.Builder)BookSpiritTradeRecipePageModel.builder().withRecipeId1(this.modLoc("spirit_trade/stone_to_otherstone"))).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/summon_foliot_otherstone_trader"))).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismBlocks.OTHERSTONE.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, trade, ritual});
    }

    private BookEntryModel.Builder makeSummonOtherworldSaplingTraderEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("summon_otherworld_sapling_trader");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("trade");
        BookSpiritTradeRecipePageModel trade = ((BookSpiritTradeRecipePageModel.Builder)BookSpiritTradeRecipePageModel.builder().withRecipeId1(this.modLoc("spirit_trade/otherworld_sapling"))).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/summon_foliot_sapling_trader"))).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismBlocks.OTHERWORLD_SAPLING.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, trade, ritual});
    }

    private BookEntryModel.Builder makeSummonWildParrotEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("summon_wild_parrot");
        helper.page("entity");
        BookEntityPageModel entity = BookEntityPageModel.builder().withEntityId("minecraft:parrot").withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/summon_wild_parrot"))).build();
        helper.page("description");
        BookTextPageModel description = BookTextPageModel.builder().withText(helper.pageText()).build();
        helper.page("description2");
        BookTextPageModel description2 = BookTextPageModel.builder().withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("occultism:textures/gui/book/parrot.png").withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description, description2});
    }

    private BookEntryModel.Builder makeSummonWildOtherworldBirdEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("summon_wild_otherworld_bird");
        helper.page("entity");
        BookEntityPageModel entity = BookEntityPageModel.builder().withEntityId("occultism:otherworld_bird").withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/summon_wild_otherworld_bird"))).build();
        helper.page("description");
        BookTextPageModel description = BookTextPageModel.builder().withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("occultism:textures/gui/book/otherworld_bird.png").withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description});
    }

    private BookEntryModel.Builder makeWeatherMagicEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("weather_magic");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("ritual_clear");
        BookRitualRecipePageModel ritualClear = ((BookRitualRecipePageModel.Builder)((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/summon_djinni_clear_weather"))).withAnchor("clear")).build();
        helper.page("ritual_rain");
        BookRitualRecipePageModel ritualRain = ((BookRitualRecipePageModel.Builder)((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/summon_afrit_rain_weather"))).withAnchor("rain")).build();
        helper.page("ritual_thunder");
        BookRitualRecipePageModel ritualThunder = ((BookRitualRecipePageModel.Builder)((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/summon_afrit_thunder_weather"))).withAnchor("thunder")).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(ForgeRegistries.ITEMS.getKey((Object)Items.f_42405_).toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, ritualClear, ritualRain, ritualThunder});
    }

    private BookEntryModel.Builder makeTimeMagicEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("time_magic");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("ritual_day");
        BookRitualRecipePageModel ritualDay = ((BookRitualRecipePageModel.Builder)((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/summon_djinni_day_time"))).withAnchor("day")).build();
        helper.page("ritual_night");
        BookRitualRecipePageModel ritualNight = ((BookRitualRecipePageModel.Builder)((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/summon_djinni_night_time"))).withAnchor("night")).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(ForgeRegistries.ITEMS.getKey((Object)Items.f_42524_).toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, ritualDay, ritualNight});
    }

    private BookEntryModel.Builder makeWitherSkullEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("wither_skull");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/summon_wild_hunt"))).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(ForgeRegistries.ITEMS.getKey((Object)Items.f_42679_).toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, ritual});
    }

    private BookCategoryModel makeCraftingRitualsSubcategory(BookLangHelper helper) {
        helper.category("crafting_rituals");
        EntryLocationHelper entryHelper = ModonomiconAPI.get().getEntryLocationHelper();
        entryHelper.setMap(new String[]{"___________________________", "_______b_e_x_p_q___________", "___________________________", "_______d_h_c_______________", "___________________________", "___9_0_____________________", "___________________________", "_______f_z_a__g____________", "___________________________", "___________n_m_o___________", "___________________________", "___________i_j_k_l_________", "___________________________"});
        BookEntryModel.Builder overview = this.makeCraftingRitualsOverviewEntry(helper, entryHelper, '0');
        BookEntryModel.Builder returnToRituals = this.makeReturnToRitualsEntry(helper, entryHelper, '9');
        returnToRituals.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        returnToRituals.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        BookEntryModel.Builder craftInfusedPickaxe = this.makeCraftInfusedPickaxeEntry(helper, entryHelper, 'd');
        craftInfusedPickaxe.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder craftDimensionalMineshaft = this.makeCraftDimensionalMineshaftEntry(helper, entryHelper, 'b');
        craftDimensionalMineshaft.withParent(BookEntryParentModel.builder().withEntryId(craftInfusedPickaxe.id).build());
        BookEntryModel.Builder craftFoliotMiner = this.makeCraftFoliotMinerEntry(helper, entryHelper, 'e');
        craftFoliotMiner.withParent(BookEntryParentModel.builder().withEntryId(craftDimensionalMineshaft.id).build());
        BookEntryModel.Builder craftDjinniMiner = this.makeCraftDjinniMinerEntry(helper, entryHelper, 'x');
        craftDjinniMiner.withParent(BookEntryParentModel.builder().withEntryId(craftFoliotMiner.id).build());
        BookEntryModel.Builder craftAfritMiner = this.makeCraftAfritMinerEntry(helper, entryHelper, 'p');
        craftAfritMiner.withParent(BookEntryParentModel.builder().withEntryId(craftDjinniMiner.id).build());
        BookEntryModel.Builder craftMaridMiner = this.makeCraftMaridMinerEntry(helper, entryHelper, 'q');
        craftMaridMiner.withParent(BookEntryParentModel.builder().withEntryId(craftAfritMiner.id).build());
        BookEntryModel.Builder craftStorageSystem = this.makeCraftStorageSystemEntry(helper, entryHelper, 'z');
        craftStorageSystem.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder craftDimensionalMatrix = this.makeCraftDimensionalMatrixEntry(helper, entryHelper, 'a');
        craftDimensionalMatrix.withParent(BookEntryParentModel.builder().withEntryId(craftStorageSystem.id).build());
        BookEntryModel.Builder craftStorageControllerBase = this.makeCraftStorageControllerBaseEntry(helper, entryHelper, 'n');
        craftStorageControllerBase.withParent(BookEntryParentModel.builder().withEntryId(craftDimensionalMatrix.id).build());
        BookEntryModel.Builder craftStabilizerTier1 = this.makeCraftStabilizerTier1Entry(helper, entryHelper, 'i');
        craftStabilizerTier1.withParent(BookEntryParentModel.builder().withEntryId(craftStorageControllerBase.id).build());
        BookEntryModel.Builder craftStabilizerTier2 = this.makeCraftStabilizerTier2Entry(helper, entryHelper, 'j');
        craftStabilizerTier2.withParent(BookEntryParentModel.builder().withEntryId(craftStabilizerTier1.id).build());
        BookEntryModel.Builder craftStabilizerTier3 = this.makeCraftStabilizerTier3Entry(helper, entryHelper, 'k');
        craftStabilizerTier3.withParent(BookEntryParentModel.builder().withEntryId(craftStabilizerTier2.id).build());
        BookEntryModel.Builder craftStabilizerTier4 = this.makeCraftStabilizerTier4Entry(helper, entryHelper, 'l');
        craftStabilizerTier4.withParent(BookEntryParentModel.builder().withEntryId(craftStabilizerTier3.id).build());
        BookEntryModel.Builder craftStableWormhole = this.makeCraftStableWormholeEntry(helper, entryHelper, 'm');
        craftStableWormhole.withParent(BookEntryParentModel.builder().withEntryId(craftStorageControllerBase.id).build());
        BookEntryModel.Builder craftStorageRemote = this.makeCraftStorageRemoteEntry(helper, entryHelper, 'o');
        craftStorageRemote.withParent(BookEntryParentModel.builder().withEntryId(craftStableWormhole.id).build());
        BookEntryModel.Builder craftOtherworldGoggles = this.makeCraftOtherworldGogglesEntry(helper, entryHelper, 'f');
        craftOtherworldGoggles.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder craftSatchel = this.makeCraftSatchelEntry(helper, entryHelper, 'g');
        craftSatchel.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder craftSoulGem = this.makeCraftSoulGemEntry(helper, entryHelper, 'h');
        craftSoulGem.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder craftFamiliarRing = this.makeCraftFamiliarRingEntry(helper, entryHelper, 'c');
        craftFamiliarRing.withParent(BookEntryParentModel.builder().withEntryId(craftSoulGem.id).build());
        overview.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        craftInfusedPickaxe.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        craftDimensionalMineshaft.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        craftFoliotMiner.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        craftDjinniMiner.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        craftAfritMiner.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        craftMaridMiner.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        craftStorageSystem.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        craftDimensionalMatrix.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        craftStorageControllerBase.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        craftStabilizerTier1.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        craftStabilizerTier2.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        craftStabilizerTier3.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        craftStabilizerTier4.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        craftStableWormhole.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        craftStorageRemote.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        craftOtherworldGoggles.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        craftSatchel.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        craftSoulGem.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        craftFamiliarRing.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        return BookCategoryModel.create((ResourceLocation)this.modLoc(helper.category), (String)helper.categoryName()).withIcon("occultism:textures/gui/book/infusion.png").withShowCategoryButton(false).withEntries(new BookEntryModel[]{overview.build(), returnToRituals.build(), craftStorageSystem.build(), craftDimensionalMatrix.build(), craftDimensionalMineshaft.build(), craftInfusedPickaxe.build(), craftFoliotMiner.build(), craftDjinniMiner.build(), craftAfritMiner.build(), craftMaridMiner.build(), craftOtherworldGoggles.build(), craftSatchel.build(), craftSoulGem.build(), craftFamiliarRing.build(), craftStabilizerTier1.build(), craftStabilizerTier2.build(), craftStabilizerTier3.build(), craftStabilizerTier4.build(), craftStableWormhole.build(), craftStorageControllerBase.build(), craftStorageRemote.build()});
    }

    private BookEntryModel.Builder makeCraftingRitualsOverviewEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("overview");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("occultism:textures/gui/book/infusion.png").withLocation(entryHelper.get(Character.valueOf(icon))).withEntryBackground(0, 1).withPages(new BookPageModel[]{intro});
    }

    private BookEntryModel.Builder makeCraftStorageSystemEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("craft_storage_system");
        helper.page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_CONTROLLER.get()})).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("minecraft:chest").withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight});
    }

    private BookEntryModel.Builder makeCraftDimensionalMatrixEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("craft_dimensional_matrix");
        helper.page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.DIMENSIONAL_MATRIX.get()})).withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/craft_dimensional_matrix"))).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.DIMENSIONAL_MATRIX.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel.Builder makeCraftDimensionalMineshaftEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("craft_dimensional_mineshaft");
        helper.page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.DIMENSIONAL_MINESHAFT.get()})).withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/craft_dimensional_mineshaft"))).build();
        helper.page("description");
        BookTextPageModel description = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismBlocks.DIMENSIONAL_MINESHAFT.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual, description});
    }

    private BookEntryModel.Builder makeCraftInfusedPickaxeEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("craft_infused_pickaxe");
        helper.page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.INFUSED_PICKAXE.get()})).withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/craft_infused_pickaxe"))).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.INFUSED_PICKAXE.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel.Builder makeCraftStorageControllerBaseEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("craft_storage_controller_base");
        helper.page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_CONTROLLER_BASE.get()})).withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/craft_storage_controller_base"))).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismBlocks.STORAGE_CONTROLLER_BASE.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel.Builder makeCraftStabilizerTier1Entry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("craft_stabilizer_tier1");
        helper.page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER1.get()})).withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/craft_stabilizer_tier1"))).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismBlocks.STORAGE_STABILIZER_TIER1.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel.Builder makeCraftStabilizerTier2Entry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("craft_stabilizer_tier2");
        helper.page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER2.get()})).withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/craft_stabilizer_tier2"))).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismBlocks.STORAGE_STABILIZER_TIER2.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel.Builder makeCraftStabilizerTier3Entry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("craft_stabilizer_tier3");
        helper.page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER3.get()})).withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/craft_stabilizer_tier3"))).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismBlocks.STORAGE_STABILIZER_TIER3.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel.Builder makeCraftStabilizerTier4Entry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("craft_stabilizer_tier4");
        helper.page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER4.get()})).withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/craft_stabilizer_tier4"))).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismBlocks.STORAGE_STABILIZER_TIER4.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel.Builder makeCraftStableWormholeEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("craft_stable_wormhole");
        helper.page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STABLE_WORMHOLE.get()})).withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/craft_stable_wormhole"))).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismBlocks.STABLE_WORMHOLE.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel.Builder makeCraftStorageRemoteEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("craft_storage_remote");
        helper.page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.STORAGE_REMOTE.get()})).withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/craft_storage_remote"))).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.STORAGE_REMOTE.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel.Builder makeCraftFoliotMinerEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("craft_foliot_miner");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("magic_lamp");
        BookTextPageModel lamp = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("magic_lamp_recipe");
        BookCraftingRecipePageModel lampRecipe = ((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(this.modLoc("crafting/magic_lamp_empty"))).build();
        helper.page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MINER_FOLIOT_UNSPECIALIZED.get()})).withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/craft_miner_foliot_unspecialized"))).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.MINER_FOLIOT_UNSPECIALIZED.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, lamp, lampRecipe, spotlight, ritual});
    }

    private BookEntryModel.Builder makeCraftDjinniMinerEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("craft_djinni_miner");
        helper.page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MINER_DJINNI_ORES.get()})).withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/craft_miner_djinni_ores"))).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.MINER_DJINNI_ORES.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel.Builder makeCraftAfritMinerEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("craft_afrit_miner");
        helper.page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MINER_AFRIT_DEEPS.get()})).withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/craft_miner_afrit_deeps"))).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.MINER_AFRIT_DEEPS.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel.Builder makeCraftMaridMinerEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("craft_marid_miner");
        helper.page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MINER_MARID_MASTER.get()})).withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/craft_miner_marid_master"))).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.MINER_MARID_MASTER.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel.Builder makeCraftSatchelEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("craft_satchel");
        helper.page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.SATCHEL.get()})).withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/craft_satchel"))).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.SATCHEL.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel.Builder makeCraftSoulGemEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("craft_soul_gem");
        helper.page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.SOUL_GEM_ITEM.get()})).withText(helper.pageText()).build();
        helper.page("usage");
        BookTextPageModel usage = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/craft_soul_gem"))).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.SOUL_GEM_ITEM.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, usage, ritual});
    }

    private BookEntryModel.Builder makeCraftFamiliarRingEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("craft_familiar_ring");
        helper.page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.FAMILIAR_RING.get()})).withText(helper.pageText()).build();
        helper.page("usage");
        BookTextPageModel usage = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/craft_familiar_ring"))).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.FAMILIAR_RING.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, usage, ritual});
    }

    private BookEntryModel.Builder makeCraftOtherworldGogglesEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("craft_otherworld_goggles");
        helper.page("goggles_spotlight");
        BookSpotlightPageModel gogglesSpotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.OTHERWORLD_GOGGLES.get()})).withText(helper.pageText()).build();
        helper.page("goggles_more");
        BookTextPageModel gogglesMore = BookTextPageModel.builder().withText(helper.pageText()).build();
        helper.page("lenses_spotlight");
        BookSpotlightPageModel lensesSpotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.LENSES.get()})).withText(helper.pageText()).build();
        helper.page("lenses_more");
        BookTextPageModel lensesMore = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("lenses_recipe");
        BookCraftingRecipePageModel lensesRecipe = ((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(this.modLoc("crafting/lenses"))).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/craft_infused_lenses"))).build();
        helper.page("goggles_recipe");
        BookCraftingRecipePageModel gogglesRecipe = ((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(this.modLoc("crafting/goggles"))).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismItems.OTHERWORLD_GOGGLES.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{gogglesSpotlight, gogglesMore, lensesSpotlight, lensesMore, lensesRecipe, ritual, gogglesRecipe});
    }

    private BookCategoryModel makePossessionRitualsSubcategory(BookLangHelper helper) {
        helper.category("possession_rituals");
        EntryLocationHelper entryHelper = ModonomiconAPI.get().getEntryLocationHelper();
        entryHelper.setMap(new String[]{"___________________________", "___________________________", "___________________________", "_______D_E_A_______________", "___r_o_____________________", "_______F_G_H_______________", "___________________________", "___________________________", "___________________________"});
        BookEntryModel.Builder overview = this.makePossessionRitualsOverviewEntry(helper, entryHelper, 'o');
        BookEntryModel.Builder returnToRituals = this.makeReturnToRitualsEntry(helper, entryHelper, 'r');
        returnToRituals.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        returnToRituals.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        BookEntryModel.Builder possessEndermite = this.makePossessEndermiteEntry(helper, entryHelper, 'D');
        possessEndermite.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder possessEnderman = this.makePossessEndermanEntry(helper, entryHelper, 'E');
        possessEnderman.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder possessGhast = this.makePossessGhastEntry(helper, entryHelper, 'F');
        possessGhast.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder possessSkeleton = this.makePossessSkeletonEntry(helper, entryHelper, 'G');
        possessSkeleton.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        helper.category("summoning_rituals");
        BookEntryModel.Builder possessWitherSkeleton = this.makeWitherSkullEntry(helper, entryHelper, 'H');
        possessWitherSkeleton.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder afritEssence = this.makeAfritEssenceEntry(helper, entryHelper, 'A');
        afritEssence.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        helper.category("possession_rituals");
        overview.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        possessEnderman.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        possessEndermite.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        possessGhast.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        possessSkeleton.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        possessWitherSkeleton.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        afritEssence.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        return BookCategoryModel.create((ResourceLocation)this.modLoc(helper.category), (String)helper.categoryName()).withIcon("occultism:textures/gui/book/possession.png").withShowCategoryButton(false).withEntries(new BookEntryModel[]{overview.build(), returnToRituals.build(), possessEnderman.build(), possessEndermite.build(), possessGhast.build(), possessSkeleton.build(), possessWitherSkeleton.build(), afritEssence.build()});
    }

    private BookEntryModel.Builder makePossessionRitualsOverviewEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("overview");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("occultism:textures/gui/book/possession.png").withLocation(entryHelper.get(Character.valueOf(icon))).withEntryBackground(0, 1).withPages(new BookPageModel[]{intro});
    }

    private BookEntryModel.Builder makePossessEndermanEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("possess_enderman");
        helper.page("entity");
        BookEntityPageModel entity = BookEntityPageModel.builder().withEntityId("occultism:possessed_enderman").withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/possess_enderman"))).build();
        helper.page("description");
        BookTextPageModel description = BookTextPageModel.builder().withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(ForgeRegistries.ITEMS.getKey((Object)Items.f_42584_).toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description});
    }

    private BookEntryModel.Builder makePossessEndermiteEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("possess_endermite");
        helper.page("entity");
        BookEntityPageModel entity = BookEntityPageModel.builder().withEntityId("occultism:possessed_endermite").withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/possess_endermite"))).build();
        helper.page("description");
        BookTextPageModel description = BookTextPageModel.builder().withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50259_).toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description});
    }

    private BookEntryModel.Builder makePossessGhastEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("possess_ghast");
        this.lang.add(helper.entryName(), "Possessed Ghast");
        helper.page("entity");
        BookEntityPageModel entity = BookEntityPageModel.builder().withEntityId("occultism:possessed_ghast").withScale(0.5f).withText(helper.pageText()).build();
        this.lang.add(helper.pageText(), "**Drops**: 1-3x [](item://minecraft:ghast_tear)\n");
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/possess_ghast"))).build();
        helper.page("description");
        BookTextPageModel description = BookTextPageModel.builder().withText(helper.pageText()).build();
        this.lang.add(helper.pageText(), "In this ritual a [#](%1$s)Ghast[#]() is spawned using the life energy of a [#](%1$s)Cow[#]() and immediately possessed by the summoned [#](%1$s)Djinni[#](). The [#](%1$s)Possessed Ghast[#]() will always drop at least one [](item://minecraft:ghast_tear) when killed.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(ForgeRegistries.ITEMS.getKey((Object)Items.f_42586_).toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description});
    }

    private BookEntryModel.Builder makePossessSkeletonEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("possess_skeleton");
        helper.page("entity");
        BookEntityPageModel entity = BookEntityPageModel.builder().withEntityId("occultism:possessed_skeleton").withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/possess_skeleton"))).build();
        helper.page("description");
        BookTextPageModel description = BookTextPageModel.builder().withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(ForgeRegistries.ITEMS.getKey((Object)Items.f_42678_).toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description});
    }

    private BookCategoryModel makeFamiliarRitualsSubcategory(BookLangHelper helper) {
        helper.category("familiar_rituals");
        EntryLocationHelper entryHelper = ModonomiconAPI.get().getEntryLocationHelper();
        entryHelper.setMap(new String[]{"________R_T_V_X____________", "___________________________", "_______Q_S_U_W_____________", "___________________________", "___r_o_________Y___________", "___________________________", "_______I_K_M_O_____________", "___________________________", "________J_L_N_P____________"});
        BookEntryModel.Builder overview = this.makeFamiliarsRitualsOverviewEntry(helper, entryHelper, 'o');
        BookEntryModel.Builder returnToRituals = this.makeReturnToRitualsEntry(helper, entryHelper, 'r');
        returnToRituals.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        returnToRituals.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        BookEntryModel.Builder familiarBat = this.makeFamiliarBatEntry(helper, entryHelper, 'I');
        familiarBat.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder familiarBeaver = this.makeFamiliarBeaverEntry(helper, entryHelper, 'J');
        familiarBeaver.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder familiarBeholder = this.makeFamiliarBeholderEntry(helper, entryHelper, 'K');
        familiarBeholder.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder familiarBlacksmith = this.makeFamiliarBlacksmithEntry(helper, entryHelper, 'L');
        familiarBlacksmith.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder familiarChimera = this.makeFamiliarChimeraEntry(helper, entryHelper, 'M');
        familiarChimera.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder familiarCthulhu = this.makeFamiliarCthulhuEntry(helper, entryHelper, 'N');
        familiarCthulhu.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder familiarDeer = this.makeFamiliarDeerEntry(helper, entryHelper, 'O');
        familiarDeer.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder familiarDevil = this.makeFamiliarDevilEntry(helper, entryHelper, 'P');
        familiarDevil.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder familiarDragon = this.makeFamiliarDragonEntry(helper, entryHelper, 'Q');
        familiarDragon.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder familiarFairy = this.makeFamiliarFairyEntry(helper, entryHelper, 'R');
        familiarFairy.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder familiarGreedy = this.makeFamiliarGreedyEntry(helper, entryHelper, 'S');
        familiarGreedy.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder familiarGuardian = this.makeFamiliarGuardianEntry(helper, entryHelper, 'T');
        familiarGuardian.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder familiarHeadlessRatman = this.makeFamiliarHeadlessRatmanEntry(helper, entryHelper, 'U');
        familiarHeadlessRatman.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder familiarMummy = this.makeFamiliarMummyEntry(helper, entryHelper, 'V');
        familiarMummy.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder familiarOtherworldBird = this.makeFamiliarOtherworldBirdEntry(helper, entryHelper, 'W');
        familiarOtherworldBird.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder familiarParrot = this.makeFamiliarParrotEntry(helper, entryHelper, 'X');
        familiarParrot.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder familiarShubNiggurath = this.makeFamiliarShubNiggurathEntry(helper, entryHelper, 'Y');
        familiarShubNiggurath.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        overview.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        familiarBat.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        familiarBeaver.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        familiarBeholder.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        familiarBlacksmith.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        familiarChimera.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        familiarCthulhu.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        familiarDeer.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        familiarDevil.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        familiarDragon.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        familiarFairy.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        familiarGreedy.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        familiarGuardian.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        familiarHeadlessRatman.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        familiarMummy.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        familiarOtherworldBird.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        familiarParrot.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        familiarShubNiggurath.withCondition((BookConditionModel)BookTrueConditionModel.builder().build());
        return BookCategoryModel.create((ResourceLocation)this.modLoc(helper.category), (String)helper.categoryName()).withIcon("occultism:textures/gui/book/parrot.png").withShowCategoryButton(false).withEntries(new BookEntryModel[]{overview.build(), returnToRituals.build(), familiarBat.build(), familiarBeaver.build(), familiarBeholder.build(), familiarBlacksmith.build(), familiarChimera.build(), familiarCthulhu.build(), familiarDeer.build(), familiarDevil.build(), familiarDragon.build(), familiarFairy.build(), familiarGreedy.build(), familiarGuardian.build(), familiarHeadlessRatman.build(), familiarMummy.build(), familiarOtherworldBird.build(), familiarParrot.build(), familiarShubNiggurath.build()});
    }

    private BookEntryModel.Builder makeFamiliarsRitualsOverviewEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("overview");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("ring");
        BookTextPageModel ring = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("trading");
        BookTextPageModel trading = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("occultism:textures/gui/book/parrot.png").withLocation(entryHelper.get(Character.valueOf(icon))).withEntryBackground(0, 1).withPages(new BookPageModel[]{intro, ring, trading});
    }

    private BookEntryModel.Builder makeFamiliarBatEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("familiar_bat");
        helper.page("entity");
        BookEntityPageModel entity = BookEntityPageModel.builder().withEntityId("occultism:bat_familiar").withText(helper.pageText()).withScale(0.7f).withOffset(0.3f).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/familiar_bat"))).build();
        helper.page("description");
        BookTextPageModel description = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("occultism:textures/gui/book/bat_familiar.png").withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description});
    }

    private BookEntryModel.Builder makeFamiliarBeaverEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("familiar_beaver");
        helper.page("entity");
        BookEntityPageModel entity = BookEntityPageModel.builder().withEntityId("occultism:beaver_familiar").withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/familiar_beaver"))).build();
        helper.page("description");
        BookTextPageModel description = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("occultism:textures/gui/book/familiar_beaver.png").withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description});
    }

    private BookEntryModel.Builder makeFamiliarBeholderEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("familiar_beholder");
        helper.page("entity");
        BookEntityPageModel entity = BookEntityPageModel.builder().withEntityId("occultism:beholder_familiar").withText(helper.pageText()).withScale(0.7f).withOffset(0.3f).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/familiar_beholder"))).build();
        helper.page("description");
        BookTextPageModel description = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("occultism:textures/gui/book/familiar_beholder.png").withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description});
    }

    private BookEntryModel.Builder makeFamiliarBlacksmithEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("familiar_blacksmith");
        helper.page("entity");
        BookEntityPageModel entity = BookEntityPageModel.builder().withEntityId("occultism:blacksmith_familiar").withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/familiar_blacksmith"))).build();
        helper.page("description");
        BookTextPageModel description = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("description2");
        BookTextPageModel description2 = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("occultism:textures/gui/book/familiar_blacksmith.png").withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description, description2});
    }

    private BookEntryModel.Builder makeFamiliarChimeraEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("familiar_chimera");
        helper.page("entity");
        BookEntityPageModel entity = BookEntityPageModel.builder().withEntityId("occultism:chimera_familiar").withText(helper.pageText()).withScale(0.7f).withOffset(0.3f).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/familiar_chimera"))).build();
        helper.page("description");
        BookTextPageModel description = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("description2");
        BookTextPageModel description2 = BookTextPageModel.builder().withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("occultism:textures/gui/book/familiar_chimera.png").withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description, description2});
    }

    private BookEntryModel.Builder makeFamiliarCthulhuEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("familiar_cthulhu");
        helper.page("entity");
        BookEntityPageModel entity = BookEntityPageModel.builder().withEntityId("occultism:cthulhu_familiar").withText(helper.pageText()).withScale(0.5f).withOffset(0.3f).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/familiar_cthulhu"))).build();
        helper.page("description");
        BookTextPageModel description = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("occultism:textures/gui/book/familiar_cthulhu.png").withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description});
    }

    private BookEntryModel.Builder makeFamiliarDeerEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("familiar_deer");
        helper.page("entity");
        BookEntityPageModel entity = BookEntityPageModel.builder().withEntityId("occultism:deer_familiar").withText(helper.pageText()).withScale(0.7f).withOffset(0.3f).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/familiar_deer"))).build();
        helper.page("description");
        BookTextPageModel description = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("occultism:textures/gui/book/familiar_deer.png").withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description});
    }

    private BookEntryModel.Builder makeFamiliarDevilEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("familiar_devil");
        helper.page("entity");
        BookEntityPageModel entity = BookEntityPageModel.builder().withEntityId("occultism:devil_familiar").withText(helper.pageText()).withScale(0.5f).withOffset(0.3f).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/familiar_devil"))).build();
        helper.page("description");
        BookTextPageModel description = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("occultism:textures/gui/book/familiar_devil.png").withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description});
    }

    private BookEntryModel.Builder makeFamiliarDragonEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("familiar_dragon");
        helper.page("entity");
        BookEntityPageModel entity = BookEntityPageModel.builder().withEntityId("occultism:dragon_familiar").withText(helper.pageText()).withScale(0.7f).withOffset(0.3f).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/familiar_dragon"))).build();
        helper.page("description");
        BookTextPageModel description = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("occultism:textures/gui/book/familiar_dragon.png").withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description});
    }

    private BookEntryModel.Builder makeFamiliarFairyEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("familiar_fairy");
        helper.page("entity");
        BookEntityPageModel entity = BookEntityPageModel.builder().withEntityId("occultism:fairy_familiar").withText(helper.pageText()).withScale(0.8f).withOffset(0.3f).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/familiar_fairy"))).build();
        helper.page("description");
        BookTextPageModel description = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("occultism:textures/gui/book/familiar_fairy.png").withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description});
    }

    private BookEntryModel.Builder makeFamiliarGreedyEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("familiar_greedy");
        helper.page("entity");
        BookEntityPageModel entity = BookEntityPageModel.builder().withEntityId("occultism:greedy_familiar").withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/familiar_greedy"))).build();
        helper.page("description");
        BookTextPageModel description = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("occultism:textures/gui/book/familiar_greedy.png").withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description});
    }

    private BookEntryModel.Builder makeFamiliarGuardianEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("familiar_guardian");
        helper.page("entity");
        BookEntityPageModel entity = BookEntityPageModel.builder().withEntityId("occultism:guardian_familiar{for_book:true}").withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/familiar_guardian"))).build();
        helper.page("description");
        BookTextPageModel description = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("description2");
        BookTextPageModel description2 = BookTextPageModel.builder().withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("occultism:textures/gui/book/familiar_guardian.png").withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description, description2});
    }

    private BookEntryModel.Builder makeFamiliarHeadlessRatmanEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("familiar_headless");
        helper.page("entity");
        BookEntityPageModel entity = BookEntityPageModel.builder().withEntityId("occultism:headless_familiar").withScale(0.7f).withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/familiar_headless"))).build();
        helper.page("description");
        BookTextPageModel description = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("occultism:textures/gui/book/familiar_headless_ratman.png").withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description});
    }

    private BookEntryModel.Builder makeFamiliarMummyEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("familiar_mummy");
        helper.page("entity");
        BookEntityPageModel entity = BookEntityPageModel.builder().withEntityId("occultism:mummy_familiar").withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/familiar_mummy"))).build();
        helper.page("description");
        BookTextPageModel description = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("occultism:textures/gui/book/familiar_mummy.png").withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description});
    }

    private BookEntryModel.Builder makeFamiliarOtherworldBirdEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("familiar_otherworld_bird");
        helper.page("entity");
        BookEntityPageModel entity = BookEntityPageModel.builder().withEntityId("occultism:otherworld_bird").withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/familiar_otherworld_bird"))).build();
        helper.page("description");
        BookTextPageModel description = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("description2");
        BookTextPageModel description2 = BookTextPageModel.builder().withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("occultism:textures/gui/book/otherworld_bird.png").withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description, description2});
    }

    private BookEntryModel.Builder makeFamiliarParrotEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("familiar_parrot");
        helper.page("entity");
        BookEntityPageModel entity = BookEntityPageModel.builder().withEntityId("minecraft:parrot").withText(helper.pageText()).build();
        helper.page("ritual");
        BookRitualRecipePageModel ritual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/familiar_parrot"))).build();
        helper.page("description");
        BookTextPageModel description = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("description2");
        BookTextPageModel description2 = BookTextPageModel.builder().withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("occultism:textures/gui/book/parrot.png").withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description, description2});
    }

    private BookEntryModel.Builder makeFamiliarShubNiggurathEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("familiar_shub_niggurath");
        helper.page("entity");
        BookEntityPageModel entity = BookEntityPageModel.builder().withEntityId("occultism:shub_niggurath_familiar").withText(helper.pageText()).build();
        helper.page("ritual");
        BookTextPageModel ritual = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("description");
        BookTextPageModel description = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("occultism:textures/gui/book/familiar_shub_niggurath.png").withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description});
    }

    private BookCategoryModel makeStorageCategory(BookLangHelper helper) {
        helper.category("storage");
        EntryLocationHelper entryHelper = ModonomiconAPI.get().getEntryLocationHelper();
        entryHelper.setMap(new String[]{"___________________________", "_________w_r_______________", "___________________________", "_____0_c___s_1_2_3_4________", "___________________________", "_________d_________________", "___________________________"});
        BookEntryModel.Builder overview = this.makeStorageOverviewEntry(helper, entryHelper, '0');
        helper.category("storage");
        BookEntryModel.Builder storageController = this.makeStorageControllerEntry(helper, entryHelper, 'c');
        storageController.withParent(BookEntryParentModel.builder().withEntryId(overview.id).build());
        BookEntryModel.Builder storageStabilizer = this.makeStorageStabilizerEntry(helper, entryHelper, 's');
        storageStabilizer.withParent(BookEntryParentModel.builder().withEntryId(storageController.id).build());
        helper.category("crafting_rituals");
        BookEntryModel.Builder craftStabilizerTier1 = this.makeCraftStabilizerTier1Entry(helper, entryHelper, '1');
        craftStabilizerTier1.withParent(BookEntryParentModel.builder().withEntryId(storageStabilizer.id).build());
        BookEntryModel.Builder craftStabilizerTier2 = this.makeCraftStabilizerTier2Entry(helper, entryHelper, '2');
        craftStabilizerTier2.withParent(BookEntryParentModel.builder().withEntryId(new ResourceLocation(craftStabilizerTier1.id.m_135827_(), "storage/" + craftStabilizerTier1.id.m_135815_())).build());
        BookEntryModel.Builder craftStabilizerTier3 = this.makeCraftStabilizerTier3Entry(helper, entryHelper, '3');
        craftStabilizerTier3.withParent(BookEntryParentModel.builder().withEntryId(new ResourceLocation(craftStabilizerTier2.id.m_135827_(), "storage/" + craftStabilizerTier2.id.m_135815_())).build());
        BookEntryModel.Builder craftStabilizerTier4 = this.makeCraftStabilizerTier4Entry(helper, entryHelper, '4');
        craftStabilizerTier4.withParent(BookEntryParentModel.builder().withEntryId(new ResourceLocation(craftStabilizerTier3.id.m_135827_(), "storage/" + craftStabilizerTier3.id.m_135815_())).build());
        BookEntryModel.Builder craftStableWormhole = this.makeCraftStableWormholeEntry(helper, entryHelper, 'w');
        craftStableWormhole.withParent(BookEntryParentModel.builder().withEntryId(storageController.id).build());
        BookEntryModel.Builder craftStorageRemote = this.makeCraftStorageRemoteEntry(helper, entryHelper, 'r');
        craftStorageRemote.withParent(BookEntryParentModel.builder().withEntryId(new ResourceLocation(craftStableWormhole.id.m_135827_(), "storage/" + craftStableWormhole.id.m_135815_())).build());
        helper.category("summoning_rituals");
        BookEntryModel.Builder summonManageMachine = this.makeSummonManageMachineEntry(helper, entryHelper, 'd');
        summonManageMachine.withParent(BookEntryParentModel.builder().withEntryId(storageController.id).build());
        helper.category("storage");
        return BookCategoryModel.create((ResourceLocation)this.modLoc(helper.category), (String)helper.categoryName()).withIcon("minecraft:chest").withEntries(new BookEntryModel[]{overview.build(), storageController.build(), storageStabilizer.build(), craftStabilizerTier1.build(), craftStabilizerTier2.build(), craftStabilizerTier3.build(), craftStabilizerTier4.build(), craftStableWormhole.build(), craftStorageRemote.build(), summonManageMachine.build()});
    }

    private BookEntryModel.Builder makeStorageOverviewEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("overview");
        helper.page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("intro2");
        BookTextPageModel intro2 = BookTextPageModel.builder().withText(helper.pageText()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon("minecraft:chest").withLocation(entryHelper.get(Character.valueOf(icon))).withEntryBackground(0, 1).withPages(new BookPageModel[]{intro, intro2});
    }

    private BookEntryModel.Builder makeStorageControllerEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("storage_controller");
        helper.page("intro");
        BookSpotlightPageModel intro = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_CONTROLLER.get()})).withText(helper.pageText()).build();
        helper.page("usage");
        BookTextPageModel usage = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("safety");
        BookTextPageModel safety = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("size");
        BookTextPageModel size = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("unique_items");
        BookTextPageModel uniqueItems = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("config");
        BookTextPageModel config = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("mods");
        BookTextPageModel mods = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("matrix_ritual");
        BookRitualRecipePageModel matrixRitual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/craft_dimensional_matrix"))).build();
        helper.page("base_ritual");
        BookRitualRecipePageModel baseRitual = ((BookRitualRecipePageModel.Builder)BookRitualRecipePageModel.builder().withRecipeId1(this.modLoc("ritual/craft_storage_controller_base"))).build();
        helper.page("recipe");
        BookCraftingRecipePageModel recipe = ((BookCraftingRecipePageModel.Builder)((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(this.modLoc("crafting/storage_controller"))).withText(helper.pageText())).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismBlocks.STORAGE_CONTROLLER.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, usage, safety, size, uniqueItems, config, mods, matrixRitual, baseRitual, recipe});
    }

    private BookEntryModel.Builder makeStorageStabilizerEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char icon) {
        helper.entry("storage_stabilizer");
        helper.page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER1.get()})).withText(helper.pageText()).build();
        helper.page("upgrade");
        BookTextPageModel upgrade = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("build_instructions");
        BookTextPageModel buildInstructions = BookTextPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).build();
        helper.page("demo");
        BookMultiblockPageModel demo = BookMultiblockPageModel.builder().withMultiblockId(this.modLoc("storage_stabilizer_demo")).withMultiblockName(helper.pageTitle()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withIcon(OccultismBlocks.STORAGE_CONTROLLER.getId().toString()).withLocation(entryHelper.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, upgrade, buildInstructions, demo});
    }
}

