/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.gui.storage;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.api.client.gui.IStorageControllerGui;
import com.github.klikli_dev.occultism.api.client.gui.IStorageControllerGuiContainer;
import com.github.klikli_dev.occultism.api.common.container.IStorageControllerContainer;
import com.github.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.github.klikli_dev.occultism.api.common.data.MachineReference;
import com.github.klikli_dev.occultism.api.common.data.SortDirection;
import com.github.klikli_dev.occultism.api.common.data.SortType;
import com.github.klikli_dev.occultism.api.common.data.StorageControllerGuiMode;
import com.github.klikli_dev.occultism.client.gui.controls.ItemSlotWidget;
import com.github.klikli_dev.occultism.client.gui.controls.LabelWidget;
import com.github.klikli_dev.occultism.client.gui.controls.MachineSlotWidget;
import com.github.klikli_dev.occultism.client.gui.controls.SizedImageButton;
import com.github.klikli_dev.occultism.common.container.storage.StorageControllerContainerBase;
import com.github.klikli_dev.occultism.integration.jei.JeiAccess;
import com.github.klikli_dev.occultism.integration.jei.JeiSettings;
import com.github.klikli_dev.occultism.network.MessageClearCraftingMatrix;
import com.github.klikli_dev.occultism.network.MessageInsertMouseHeldItem;
import com.github.klikli_dev.occultism.network.MessageRequestOrder;
import com.github.klikli_dev.occultism.network.MessageRequestStacks;
import com.github.klikli_dev.occultism.network.MessageSortItems;
import com.github.klikli_dev.occultism.network.MessageTakeItem;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import com.github.klikli_dev.occultism.util.TextUtil;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public abstract class StorageControllerGuiBase<T extends StorageControllerContainerBase>
extends AbstractContainerScreen<T>
implements IStorageControllerGui,
IStorageControllerGuiContainer,
ContainerListener {
    public static final int ORDER_AREA_OFFSET = 48;
    protected static final ResourceLocation BACKGROUND = new ResourceLocation("occultism", "textures/gui/storage_controller_droparea.png");
    protected static final ResourceLocation BUTTONS = new ResourceLocation("occultism", "textures/gui/buttons.png");
    protected static final String TRANSLATION_KEY_BASE = "gui.occultism.storage_controller";
    public List<ItemStack> stacks;
    public List<MachineReference> linkedMachines;
    public IStorageControllerContainer storageControllerContainer;
    public int usedSlots;
    public int maxSlots;
    public StorageControllerGuiMode guiMode = StorageControllerGuiMode.INVENTORY;
    protected ItemStack stackUnderMouse = ItemStack.f_41583_;
    protected EditBox searchBar;
    protected List<ItemSlotWidget> itemSlots = new ArrayList<ItemSlotWidget>();
    protected List<MachineSlotWidget> machineSlots = new ArrayList<MachineSlotWidget>();
    protected Button clearTextButton;
    protected Button clearRecipeButton;
    protected Button sortTypeButton;
    protected Button sortDirectionButton;
    protected Button jeiSyncButton;
    protected Button autocraftingModeButton;
    protected Button inventoryModeButton;
    protected LabelWidget storageSpaceLabel;
    protected int rows;
    protected int columns;
    protected int currentPage;
    protected int totalPages;
    protected boolean forceFocus;
    protected long lastClick;

    public StorageControllerGuiBase(T container, Inventory playerInventory, Component name) {
        super(container, playerInventory, name);
        this.storageControllerContainer = container;
        this.storageControllerContainer.getOrderSlot().m_19164_((ContainerListener)this);
        this.f_97726_ = 224;
        this.f_97727_ = 256;
        this.rows = 4;
        this.columns = 9;
        this.currentPage = 1;
        this.totalPages = 1;
        this.stacks = new ArrayList<ItemStack>();
        this.linkedMachines = new ArrayList<MachineReference>();
        this.lastClick = System.currentTimeMillis();
        OccultismPackets.sendToServer(new MessageRequestStacks());
    }

    protected abstract boolean isGuiValid();

    protected abstract BlockPos getEntityPosition();

    public abstract SortDirection getSortDirection();

    public abstract void setSortDirection(SortDirection var1);

    public abstract SortType getSortType();

    public abstract void setSortType(SortType var1);

    @Override
    public Font getFontRenderer() {
        return this.f_96547_;
    }

    @Override
    public void drawGradientRect(PoseStack poseStack, int left, int top, int right, int bottom, int startColor, int endColor) {
        super.m_93179_(poseStack, left, top, right, bottom, startColor, endColor);
    }

    @Override
    public boolean isPointInRegionController(int rectX, int rectY, int rectWidth, int rectHeight, double pointX, double pointY) {
        return this.m_6774_(rectX, rectY, rectWidth, rectHeight, pointX, pointY);
    }

    @Override
    public void renderToolTip(PoseStack poseStack, ItemStack stack, int x, int y) {
        super.m_6057_(poseStack, stack, x, y);
    }

    @Override
    public void renderToolTip(PoseStack poseStack, MachineReference machine, int x, int y) {
        ArrayList<Object> tooltip = new ArrayList<Object>();
        tooltip.add(machine.getInsertItemStack().m_41611_());
        if (machine.customName != null) {
            tooltip.add(Component.m_237113_((String)(ChatFormatting.GRAY.toString() + ChatFormatting.BOLD + machine.customName + ChatFormatting.RESET)));
        }
        if (this.f_96541_.f_91074_.f_19853_.m_46472_() != machine.insertGlobalPos.getDimensionKey()) {
            tooltip.add(Component.m_237115_((String)(ChatFormatting.GRAY.toString() + ChatFormatting.ITALIC + machine.insertGlobalPos.getDimensionKey().m_135782_() + ChatFormatting.RESET)));
        }
        this.m_96597_(poseStack, tooltip, x, y);
    }

    @Override
    public void setStacks(List<ItemStack> stacks) {
        this.stacks = stacks;
    }

    @Override
    public void setUsedSlots(int slots) {
        this.usedSlots = slots;
    }

    @Override
    public void markDirty() {
        this.m_7856_();
    }

    @Override
    public void setMaxSlots(int slots) {
        this.maxSlots = slots;
    }

    @Override
    public void setLinkedMachines(List<MachineReference> machines) {
        this.linkedMachines = machines;
    }

    public void m_7856_() {
        super.m_7856_();
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2 - 48;
        this.f_97736_ = Math.max(0, (this.f_96544_ - this.f_97727_) / 2);
        this.m_169413_();
        int searchBarLeft = 57;
        int searchBarTop = 7;
        boolean focus = false;
        String searchBarText = "";
        if (this.searchBar != null) {
            searchBarText = this.searchBar.m_94155_();
            if (this.searchBar.m_93696_()) {
                focus = true;
            }
        }
        Objects.requireNonNull(this.f_96547_);
        this.searchBar = new EditBox(this.f_96547_, this.f_97735_ + searchBarLeft, this.f_97736_ + searchBarTop, 90, 9, (Component)Component.m_237113_((String)"search"));
        this.searchBar.m_94199_(30);
        this.searchBar.m_94182_(false);
        this.searchBar.m_94194_(true);
        this.searchBar.m_94202_(0xFFFFFF);
        this.searchBar.m_94178_(focus);
        this.searchBar.m_94144_(searchBarText);
        if (JeiSettings.isJeiLoaded() && JeiSettings.isJeiSearchSynced()) {
            this.searchBar.m_94144_(JeiAccess.getFilterText());
        }
        int storageSpaceInfoLabelLeft = 186;
        int storageSpaceInfoLabelTop = 115;
        this.storageSpaceLabel = new LabelWidget(this.f_97735_ + storageSpaceInfoLabelLeft, this.f_97736_ + storageSpaceInfoLabelTop, true, -1, 2, 0x404040);
        this.storageSpaceLabel.addLine(I18n.m_118938_((String)"gui.occultism.storage_controller.space_info_label", (Object[])new Object[]{this.usedSlots, this.maxSlots}), false);
        this.m_142416_((GuiEventListener)this.storageSpaceLabel);
        this.initButtons();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.m_7025_(poseStack, mouseX, mouseY);
        if (!this.isGuiValid()) {
            this.f_96541_.f_91074_.m_6915_();
            return;
        }
        try {
            this.drawTooltips(poseStack, mouseX, mouseY);
        }
        catch (Throwable e) {
            Occultism.LOGGER.error("Error drawing tooltip.", e);
        }
        if (!this.isGuiValid()) {
            return;
        }
        if (this.forceFocus) {
            this.searchBar.m_94178_(true);
            if (this.searchBar.m_93696_()) {
                this.forceFocus = false;
            }
        }
    }

    protected void m_7027_(PoseStack pPoseStack, int pMouseX, int pMouseY) {
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        if (!this.isGuiValid()) {
            return;
        }
        this.drawBackgroundTexture(poseStack);
        switch (this.guiMode) {
            case INVENTORY: {
                this.drawItems(poseStack, partialTicks, mouseX, mouseY);
                break;
            }
            case AUTOCRAFTING: {
                this.drawMachines(poseStack, partialTicks, mouseX, mouseY);
            }
        }
        this.searchBar.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        block6: {
            block7: {
                ItemStack stackCarriedByMouse;
                block8: {
                    block5: {
                        super.m_6375_(mouseX, mouseY, mouseButton);
                        this.searchBar.m_94178_(false);
                        if (!this.isPointInSearchbar(mouseX, mouseY)) break block5;
                        this.searchBar.m_94178_(true);
                        if (mouseButton != 1) break block6;
                        this.clearSearch();
                        break block6;
                    }
                    if (this.guiMode != StorageControllerGuiMode.INVENTORY) break block7;
                    stackCarriedByMouse = this.f_96541_.f_91074_.f_36096_.m_142621_();
                    if (this.stackUnderMouse.m_41619_() || mouseButton != 0 && mouseButton != 1 || !stackCarriedByMouse.m_41619_() || !this.canClick()) break block8;
                    OccultismPackets.sendToServer(new MessageTakeItem(this.stackUnderMouse, mouseButton, Screen.m_96638_(), Screen.m_96637_()));
                    this.lastClick = System.currentTimeMillis();
                    break block6;
                }
                if (stackCarriedByMouse.m_41619_() || !this.isPointInItemArea(mouseX, mouseY) || !this.canClick()) break block6;
                OccultismPackets.sendToServer(new MessageInsertMouseHeldItem(mouseButton));
                this.lastClick = System.currentTimeMillis();
                break block6;
            }
            if (this.guiMode == StorageControllerGuiMode.AUTOCRAFTING) {
                for (MachineSlotWidget slot : this.machineSlots) {
                    if (!slot.isMouseOverSlot(mouseX, mouseY)) continue;
                    if (mouseButton != 0) break;
                    ItemStack orderStack = this.storageControllerContainer.getOrderSlot().m_8020_(0);
                    if (Screen.m_96638_()) {
                        long time = System.currentTimeMillis() + 5000L;
                        Occultism.SELECTED_BLOCK_RENDERER.selectBlock(slot.getMachine().insertGlobalPos.getPos(), time, Color.GREEN);
                        Occultism.SELECTED_BLOCK_RENDERER.selectBlock(slot.getMachine().extractGlobalPos.getPos(), time, Color.YELLOW);
                        break;
                    }
                    if (orderStack.m_41619_()) break;
                    GlobalBlockPos storageControllerPos = this.storageControllerContainer.getStorageControllerGlobalBlockPos();
                    if (storageControllerPos != null) {
                        OccultismPackets.sendToServer(new MessageRequestOrder(storageControllerPos, slot.getMachine().insertGlobalPos, orderStack));
                    } else {
                        Occultism.LOGGER.warn("Linked Storage Controller Position null.");
                    }
                    this.guiMode = StorageControllerGuiMode.INVENTORY;
                    break;
                }
            }
        }
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int p_keyPressed_3_) {
        InputConstants.Key mouseKey;
        if (this.searchBar.m_93696_() && this.searchBar.m_7933_(keyCode, scanCode, p_keyPressed_3_)) {
            if (JeiSettings.isJeiLoaded() && JeiSettings.isJeiSearchSynced()) {
                JeiAccess.setFilterText(this.searchBar.m_94155_());
            }
            return true;
        }
        if (this.searchBar.m_93696_() && this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, p_keyPressed_3_);
    }

    public boolean m_6913_() {
        return true;
    }

    public void m_5757_(Container inventory) {
        if (inventory == this.storageControllerContainer.getOrderSlot() && !inventory.m_8020_(0).m_41619_()) {
            this.guiMode = StorageControllerGuiMode.AUTOCRAFTING;
            this.m_7856_();
        }
    }

    public boolean m_6050_(double x, double y, double mouseButton) {
        super.m_6050_(x, y, mouseButton);
        if (this.isPointInItemArea(x, y)) {
            if (mouseButton > 0.0 && this.currentPage > 1) {
                --this.currentPage;
            }
            if (mouseButton < 0.0 && this.currentPage < this.totalPages) {
                ++this.currentPage;
            }
        }
        return true;
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        if (this.searchBar.m_93696_() && this.searchBar.m_5534_(typedChar, keyCode)) {
            OccultismPackets.sendToServer(new MessageRequestStacks());
            if (JeiSettings.isJeiLoaded() && JeiSettings.isJeiSearchSynced()) {
                JeiAccess.setFilterText(this.searchBar.m_94155_());
            }
        }
        return false;
    }

    public void initButtons() {
        int controlButtonSize = 12;
        int clearRecipeButtonLeft = 141;
        int clearRecipeButtonTop = 112;
        this.clearRecipeButton = new SizedImageButton(this.f_97735_ + clearRecipeButtonLeft, this.f_97736_ + clearRecipeButtonTop, controlButtonSize, controlButtonSize, 0, 196, 28, 28, 28, 256, 256, BUTTONS, button -> {
            OccultismPackets.sendToServer(new MessageClearCraftingMatrix());
            OccultismPackets.sendToServer(new MessageRequestStacks());
            this.m_7856_();
        });
        this.m_142416_((GuiEventListener)this.clearRecipeButton);
        int controlButtonTop = 5;
        int clearTextButtonLeft = 147;
        this.clearTextButton = new SizedImageButton(this.f_97735_ + clearTextButtonLeft, this.f_97736_ + controlButtonTop, controlButtonSize, controlButtonSize, 0, 196, 28, 28, 28, 256, 256, BUTTONS, button -> {
            this.clearSearch();
            this.forceFocus = true;
            this.m_7856_();
        });
        this.m_142416_((GuiEventListener)this.clearTextButton);
        int sortTypeOffset = this.getSortType().getValue() * 28;
        this.sortTypeButton = new SizedImageButton(this.f_97735_ + clearTextButtonLeft + controlButtonSize + 3, this.f_97736_ + controlButtonTop, controlButtonSize, controlButtonSize, 0, sortTypeOffset, 28, 28, 28, 256, 256, BUTTONS, button -> {
            this.setSortType(this.getSortType().next());
            OccultismPackets.sendToServer(new MessageSortItems(this.getEntityPosition(), this.getSortDirection(), this.getSortType()));
            this.m_7856_();
        });
        this.m_142416_((GuiEventListener)this.sortTypeButton);
        int sortDirectionOffset = 84 + (1 - this.getSortDirection().getValue()) * 28;
        this.sortDirectionButton = new SizedImageButton(this.f_97735_ + clearTextButtonLeft + controlButtonSize + 3 + controlButtonSize + 3, this.f_97736_ + controlButtonTop, controlButtonSize, controlButtonSize, 0, sortDirectionOffset, 28, 28, 28, 256, 256, BUTTONS, button -> {
            this.setSortDirection(this.getSortDirection().next());
            OccultismPackets.sendToServer(new MessageSortItems(this.getEntityPosition(), this.getSortDirection(), this.getSortType()));
            this.m_7856_();
        });
        this.m_142416_((GuiEventListener)this.sortDirectionButton);
        int jeiSyncOffset = 140 + (JeiSettings.isJeiSearchSynced() ? 0 : 1) * 28;
        this.jeiSyncButton = new SizedImageButton(this.f_97735_ + clearTextButtonLeft + controlButtonSize + 3 + controlButtonSize + 3 + controlButtonSize + 3, this.f_97736_ + controlButtonTop, controlButtonSize, controlButtonSize, 0, jeiSyncOffset, 28, 28, 28, 256, 256, BUTTONS, button -> {
            JeiSettings.setJeiSearchSync(!JeiSettings.isJeiSearchSynced());
            this.m_7856_();
        });
        if (JeiSettings.isJeiLoaded()) {
            this.m_142416_((GuiEventListener)this.jeiSyncButton);
        }
        int guiModeButtonTop = 112;
        int guiModeButtonLeft = 27;
        int guiModeButtonHeight = 29;
        int guiModeButtonWidth = 24;
        switch (this.guiMode) {
            case INVENTORY: {
                this.inventoryModeButton = new SizedImageButton(this.f_97735_ + guiModeButtonLeft, this.f_97736_ + 112, guiModeButtonWidth, guiModeButtonHeight, 160, 0, 0, guiModeButtonWidth * 2, guiModeButtonHeight * 2, 256, 256, BUTTONS, button -> {
                    this.guiMode = StorageControllerGuiMode.INVENTORY;
                    this.m_7856_();
                });
                this.autocraftingModeButton = new SizedImageButton(this.f_97735_ + guiModeButtonLeft, this.f_97736_ + guiModeButtonTop + guiModeButtonHeight, guiModeButtonWidth, guiModeButtonHeight, 160, 174, 0, guiModeButtonWidth * 2, guiModeButtonHeight * 2, 256, 256, BUTTONS, button -> {
                    this.guiMode = StorageControllerGuiMode.AUTOCRAFTING;
                    this.m_7856_();
                });
                break;
            }
            case AUTOCRAFTING: {
                this.inventoryModeButton = new SizedImageButton(this.f_97735_ + guiModeButtonLeft, this.f_97736_ + 112, guiModeButtonWidth, guiModeButtonHeight, 160, 58, 0, guiModeButtonWidth * 2, guiModeButtonHeight * 2, 256, 256, BUTTONS, button -> {
                    this.guiMode = StorageControllerGuiMode.INVENTORY;
                    this.m_7856_();
                });
                this.autocraftingModeButton = new SizedImageButton(this.f_97735_ + guiModeButtonLeft, this.f_97736_ + guiModeButtonTop + guiModeButtonHeight, guiModeButtonWidth, guiModeButtonHeight, 160, 116, 0, guiModeButtonWidth * 2, guiModeButtonHeight * 2, 256, 256, BUTTONS, button -> {
                    this.guiMode = StorageControllerGuiMode.AUTOCRAFTING;
                    this.m_7856_();
                });
            }
        }
        this.m_142416_((GuiEventListener)this.inventoryModeButton);
        this.m_142416_((GuiEventListener)this.autocraftingModeButton);
    }

    protected void drawItems(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        List<ItemStack> stacksToDisplay = this.applySearchToItems();
        this.sortItemStacks(stacksToDisplay);
        this.buildPage(stacksToDisplay);
        this.buildItemSlots(stacksToDisplay);
        this.drawItemSlots(poseStack, mouseX, mouseY);
    }

    protected void drawMachines(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        List<MachineReference> machinesToDisplay = this.applySearchToMachines();
        this.sortMachines(machinesToDisplay);
        this.buildPage(machinesToDisplay);
        this.buildMachineSlots(machinesToDisplay);
        this.drawMachineSlots(poseStack, mouseX, mouseY);
    }

    protected boolean canClick() {
        return System.currentTimeMillis() > this.lastClick + 100L;
    }

    protected boolean isPointInSearchbar(double mouseX, double mouseY) {
        int n = this.searchBar.f_93620_ - this.f_97735_;
        int n2 = this.searchBar.f_93621_ - this.f_97736_;
        int n3 = this.searchBar.m_5711_() - 5;
        Objects.requireNonNull(this.f_96547_);
        return this.m_6774_(n, n2, n3, 9 + 6, mouseX, mouseY);
    }

    protected boolean isPointInItemArea(double mouseX, double mouseY) {
        int itemAreaHeight = 82;
        int itemAreaWidth = 160;
        int itemAreaTop = 24;
        int itemAreaLeft = 56;
        return mouseX > (double)(this.f_97735_ + itemAreaLeft) && mouseX < (double)(this.f_97735_ + itemAreaWidth + itemAreaLeft) && mouseY > (double)(this.f_97736_ + itemAreaTop) && mouseY < (double)(this.f_97736_ + itemAreaTop + itemAreaHeight);
    }

    protected void drawTooltips(PoseStack poseStack, int mouseX, int mouseY) {
        switch (this.guiMode) {
            case INVENTORY: {
                for (ItemSlotWidget s : this.itemSlots) {
                    if (s == null || !s.isMouseOverSlot(mouseX, mouseY)) continue;
                    s.drawTooltip(poseStack, mouseX, mouseY);
                }
                break;
            }
            case AUTOCRAFTING: {
                for (MachineSlotWidget s : this.machineSlots) {
                    if (s == null || !s.isMouseOverSlot(mouseX, mouseY)) continue;
                    s.drawTooltip(poseStack, mouseX, mouseY);
                }
                break;
            }
        }
        if (this.isPointInSearchbar(mouseX, mouseY)) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            if (!Screen.m_96638_()) {
                tooltip.add(Component.m_237115_((String)"gui.occultism.storage_controller.shift"));
            } else {
                switch (this.guiMode) {
                    case INVENTORY: {
                        tooltip.add(Component.m_237115_((String)"gui.occultism.storage_controller.search.tooltip@"));
                        tooltip.add(Component.m_237115_((String)"gui.occultism.storage_controller.search.tooltip#"));
                        tooltip.add(Component.m_237115_((String)"gui.occultism.storage_controller.search.tooltip$"));
                        break;
                    }
                    case AUTOCRAFTING: {
                        tooltip.add(Component.m_237115_((String)"gui.occultism.storage_controller.search.machines.tooltip@"));
                    }
                }
                tooltip.add(Component.m_237115_((String)"gui.occultism.storage_controller.search.tooltip_rightclick"));
            }
            this.m_96597_(poseStack, tooltip, mouseX, mouseY);
        }
        if (this.clearTextButton != null && this.clearTextButton.m_5953_((double)mouseX, (double)mouseY)) {
            this.m_96597_(poseStack, Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"gui.occultism.storage_controller.search.tooltip_clear")}), mouseX, mouseY);
        }
        if (this.sortTypeButton != null && this.sortTypeButton.m_5953_((double)mouseX, (double)mouseY)) {
            Object translationKey = "";
            switch (this.guiMode) {
                case INVENTORY: {
                    translationKey = "gui.occultism.storage_controller.search.tooltip_sort_type_" + this.getSortType().m_7912_();
                    break;
                }
                case AUTOCRAFTING: {
                    translationKey = "gui.occultism.storage_controller.search.machines.tooltip_sort_type_" + this.getSortType().m_7912_();
                }
            }
            this.m_96602_(poseStack, (Component)Component.m_237115_((String)translationKey), mouseX, mouseY);
        }
        if (this.sortDirectionButton != null && this.sortDirectionButton.m_5953_((double)mouseX, (double)mouseY)) {
            this.m_96602_(poseStack, (Component)Component.m_237115_((String)("gui.occultism.storage_controller.search.tooltip_sort_direction_" + this.getSortDirection().m_7912_())), mouseX, mouseY);
        }
        if (this.jeiSyncButton != null && this.jeiSyncButton.m_5953_((double)mouseX, (double)mouseY)) {
            this.m_96602_(poseStack, (Component)Component.m_237115_((String)("gui.occultism.storage_controller.search.tooltip_jei_" + (JeiSettings.isJeiSearchSynced() ? "on" : "off"))), mouseX, mouseY);
        }
    }

    protected void drawBackgroundTexture(PoseStack poseStack) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void drawItemSlots(PoseStack poseStack, int mouseX, int mouseY) {
        this.stackUnderMouse = ItemStack.f_41583_;
        for (ItemSlotWidget slot : this.itemSlots) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            slot.drawSlot(poseStack, mouseX, mouseY);
            if (!slot.isMouseOverSlot(mouseX, mouseY)) continue;
            this.stackUnderMouse = slot.getStack();
        }
    }

    protected void buildItemSlots(List<ItemStack> stacksToDisplay) {
        int itemAreaLeft = 56;
        int itemAreaTop = 24;
        this.itemSlots = new ArrayList<ItemSlotWidget>();
        int index = (this.currentPage - 1) * this.columns;
        for (int row = 0; row < this.rows && index < stacksToDisplay.size(); ++row) {
            for (int col = 0; col < this.columns && index < stacksToDisplay.size(); ++index, ++col) {
                this.itemSlots.add(new ItemSlotWidget(this, stacksToDisplay.get(index), this.f_97735_ + itemAreaLeft + col * 18, this.f_97736_ + itemAreaTop + row * 18, stacksToDisplay.get(index).m_41613_(), this.f_97735_, this.f_97736_, true));
            }
        }
    }

    protected void buildPage(List<?> objectsToDisplay) {
        this.totalPages = objectsToDisplay.size() / this.columns;
        if (objectsToDisplay.size() % this.columns != 0) {
            ++this.totalPages;
        }
        this.totalPages -= this.rows - 1;
        if (this.totalPages < 1) {
            this.totalPages = 1;
        }
        if (this.currentPage < 1) {
            this.currentPage = 1;
        }
        if (this.currentPage > this.totalPages) {
            this.currentPage = this.totalPages;
        }
    }

    protected void sortItemStacks(List<ItemStack> stacksToDisplay) {
        stacksToDisplay.sort(new Comparator<ItemStack>(){
            final int direction;
            {
                this.direction = StorageControllerGuiBase.this.getSortDirection().isDown() ? -1 : 1;
            }

            @Override
            public int compare(ItemStack a, ItemStack b) {
                switch (StorageControllerGuiBase.this.getSortType()) {
                    case AMOUNT: {
                        return Integer.compare(b.m_41613_(), a.m_41613_()) * this.direction;
                    }
                    case NAME: {
                        return a.m_41611_().getString().compareToIgnoreCase(b.m_41611_().getString()) * this.direction;
                    }
                    case MOD: {
                        return TextUtil.getModNameForGameObject(a.m_41720_()).compareToIgnoreCase(TextUtil.getModNameForGameObject(b.m_41720_())) * this.direction;
                    }
                }
                return 0;
            }
        });
    }

    protected List<ItemStack> applySearchToItems() {
        String searchText = this.searchBar.m_94155_();
        if (!searchText.equals("")) {
            ArrayList<ItemStack> stacksToDisplay = new ArrayList<ItemStack>();
            for (ItemStack stack : this.stacks) {
                if (!this.itemMatchesSearch(stack)) continue;
                stacksToDisplay.add(stack);
            }
            return stacksToDisplay;
        }
        return new ArrayList<ItemStack>(this.stacks);
    }

    protected List<MachineReference> applySearchToMachines() {
        String searchText = this.searchBar.m_94155_();
        if (!searchText.equals("")) {
            ArrayList<MachineReference> machinesToDisplay = new ArrayList<MachineReference>();
            for (MachineReference machine : this.linkedMachines) {
                if (!this.machineMatchesSearch(machine)) continue;
                machinesToDisplay.add(machine);
            }
            return machinesToDisplay;
        }
        return new ArrayList<MachineReference>(this.linkedMachines);
    }

    protected boolean itemMatchesSearch(ItemStack stack) {
        String searchText = this.searchBar.m_94155_();
        if (searchText.startsWith("@")) {
            String name = TextUtil.getModNameForGameObject(stack.m_41720_());
            return name.toLowerCase().contains(searchText.toLowerCase().substring(1));
        }
        if (searchText.startsWith("#")) {
            List tooltip = stack.m_41651_((Player)this.f_96541_.f_91074_, (TooltipFlag)TooltipFlag.Default.NORMAL).stream().map(Component::getString).collect(Collectors.toList());
            String tooltipString = Joiner.on((char)' ').join(tooltip).toLowerCase().trim();
            return tooltipString.toLowerCase().contains(searchText.toLowerCase().substring(1));
        }
        if (searchText.startsWith("$")) {
            StringBuilder tagStringBuilder = new StringBuilder();
            stack.m_204131_().forEach(tag -> tagStringBuilder.append(tag.f_203868_()).append(" "));
            return tagStringBuilder.toString().toLowerCase().contains(searchText.toLowerCase().substring(1));
        }
        return stack.m_41611_().getString().toLowerCase().contains(searchText.toLowerCase());
    }

    protected boolean machineMatchesSearch(MachineReference machine) {
        String searchText = this.searchBar.m_94155_();
        if (searchText.startsWith("@")) {
            String name = TextUtil.getModNameForGameObject(machine.getInsertItem());
            return name.toLowerCase().contains(searchText.toLowerCase().substring(1));
        }
        String customName = machine.customName == null ? "" : machine.customName.toLowerCase();
        return machine.getInsertItemStack().m_41611_().getString().toLowerCase().contains(searchText.toLowerCase()) || customName.contains(searchText.toLowerCase().substring(1));
    }

    protected void sortMachines(List<MachineReference> machinesToDisplay) {
        final BlockPos entityPosition = this.getEntityPosition();
        final ResourceKey dimensionKey = this.f_96541_.f_91074_.f_19853_.m_46472_();
        machinesToDisplay.sort(new Comparator<MachineReference>(){
            final int direction;
            {
                this.direction = StorageControllerGuiBase.this.getSortDirection().isDown() ? -1 : 1;
            }

            @Override
            public int compare(MachineReference a, MachineReference b) {
                switch (StorageControllerGuiBase.this.getSortType()) {
                    case AMOUNT: {
                        double distanceA = a.insertGlobalPos.getDimensionKey() == dimensionKey ? a.insertGlobalPos.getPos().m_123331_((Vec3i)entityPosition) : Double.MAX_VALUE;
                        double distanceB = b.insertGlobalPos.getDimensionKey() == dimensionKey ? b.insertGlobalPos.getPos().m_123331_((Vec3i)entityPosition) : Double.MAX_VALUE;
                        return Double.compare(distanceB, distanceA) * this.direction;
                    }
                    case NAME: {
                        return a.getInsertItemStack().m_41611_().getString().compareToIgnoreCase(b.getInsertItemStack().m_41611_().getString()) * this.direction;
                    }
                    case MOD: {
                        return TextUtil.getModNameForGameObject(a.getInsertItem()).compareToIgnoreCase(TextUtil.getModNameForGameObject(b.getInsertItem())) * this.direction;
                    }
                }
                return 0;
            }
        });
    }

    protected void buildMachineSlots(List<MachineReference> machinesToDisplay) {
        int itemAreaLeft = 56;
        int itemAreaTop = 24;
        this.machineSlots = new ArrayList<MachineSlotWidget>();
        int index = (this.currentPage - 1) * this.columns;
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.columns && index < machinesToDisplay.size(); ++index, ++col) {
                this.machineSlots.add(new MachineSlotWidget(this, machinesToDisplay.get(index), this.f_97735_ + itemAreaLeft + col * 18, this.f_97736_ + itemAreaTop + row * 18, this.f_97735_, this.f_97736_));
            }
        }
    }

    protected void drawMachineSlots(PoseStack poseStack, int mouseX, int mouseY) {
        for (MachineSlotWidget slot : this.machineSlots) {
            slot.drawSlot(poseStack, mouseX, mouseY);
        }
    }

    protected void clearSearch() {
        this.searchBar.m_94144_("");
        if (JeiSettings.isJeiLoaded() && JeiSettings.isJeiSearchSynced()) {
            JeiAccess.setFilterText("");
        }
    }
}

